/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fxg;

import com.adobe.fxg.util.FXGLocalizationUtil;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;

public class FXGException
extends RuntimeException {
    private static final long serialVersionUID = -7393979231178285695L;
    private Object[] arguments;
    private String message;
    private int lineNumber;
    private int columnNumber;

    public FXGException() {
        this.arguments = null;
        this.message = null;
        this.lineNumber = -1;
        this.columnNumber = -1;
    }

    public FXGException(Throwable cause) {
        super(cause);
        this.arguments = null;
        this.message = null;
        this.lineNumber = -1;
        this.columnNumber = -1;
    }

    public FXGException(String message, Throwable cause, Object ... arguments) {
        super(message, cause);
        this.arguments = arguments;
        message = null;
        this.lineNumber = -1;
        this.columnNumber = -1;
    }

    public FXGException(String message, Object ... arguments) {
        super(message);
        this.arguments = arguments;
        message = null;
        this.lineNumber = -1;
        this.columnNumber = -1;
    }

    public FXGException(int lineNumber, int columnNumber) {
        this.arguments = null;
        this.message = null;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    public FXGException(int lineNumber, int columnNumber, Throwable cause) {
        super(cause);
        this.arguments = null;
        this.message = null;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    public FXGException(int lineNumber, int columnNumber, String message, Throwable cause, Object ... arguments) {
        super(message, cause);
        this.arguments = arguments;
        message = null;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    public FXGException(int lineNumber, int columnNumber, String message, Object ... arguments) {
        super(message);
        this.arguments = arguments;
        message = null;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessage() {
        if (this.message != null) {
            return this.message;
        }
        Class<FXGException> clazz = FXGException.class;
        synchronized (FXGException.class) {
            FXGLocalizationUtil.setExceptionResourceBundle(null, null);
            this.message = this.getLocalizedMessage();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.message;
        }
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLocalizedMessage() {
        Class<FXGException> clazz = FXGException.class;
        synchronized (FXGException.class) {
            ResourceBundle resourceBundle = FXGLocalizationUtil.getExceptionResourceBundle();
            String paramMsg = super.getMessage();
            if (resourceBundle != null) {
                Enumeration<String> keys = resourceBundle.getKeys();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement();
                    if (!key.equals(paramMsg)) continue;
                    paramMsg = resourceBundle.getString(super.getMessage());
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return FXGLocalizationUtil.substituteArguments(paramMsg, this.arguments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLocalizedMessage(Locale locale) {
        Class<FXGException> clazz = FXGException.class;
        synchronized (FXGException.class) {
            FXGLocalizationUtil.setLocale(locale);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.getLocalizedMessage();
        }
    }
}

