/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.dom;

import com.adobe.fxg.FXGException;
import com.adobe.fxg.dom.FXGNode;
import com.adobe.internal.fxg.dom.CDATANode;
import com.adobe.internal.fxg.dom.DOMParserHelper;
import com.adobe.internal.fxg.dom.GraphicContentNode;
import com.adobe.internal.fxg.dom.TextNode;
import com.adobe.internal.fxg.dom.richtext.TextHelper;
import com.adobe.internal.fxg.dom.text.AbstractCharacterTextNode;
import com.adobe.internal.fxg.dom.text.BRNode;
import com.adobe.internal.fxg.dom.text.ParagraphNode;
import com.adobe.internal.fxg.dom.text.SpanNode;
import com.adobe.internal.fxg.dom.types.Kerning;
import com.adobe.internal.fxg.dom.types.LineBreak;
import com.adobe.internal.fxg.dom.types.WhiteSpaceCollapse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextGraphicNode
extends GraphicContentNode
implements TextNode {
    public double width = 0.0;
    public double height = 0.0;
    public double paddingLeft = 0.0;
    public double paddingRight = 0.0;
    public double paddingBottom = 0.0;
    public double paddingTop = 0.0;
    public String fontFamily = "Times New Roman";
    public double fontSize = 12.0;
    public String fontStyle = "normal";
    public String fontWeight = "normal";
    public double lineHeight = 120.0;
    public String textDecoration = "none";
    public WhiteSpaceCollapse whiteSpaceCollapse = WhiteSpaceCollapse.PRESERVE;
    public LineBreak lineBreak = LineBreak.TOFIT;
    public boolean lineThrough = false;
    public double tracking = 0.0;
    public Kerning kerning = Kerning.AUTO;
    public double textAlpha = 1.0;
    public int color = -16777216;
    public String textAlign = "left";
    public String textAlignLast = "left";
    public double textIndent = 0.0;
    public double marginLeft = 0.0;
    public double marginRight = 0.0;
    public double marginTop = 0.0;
    public double marginBottom = 0.0;
    public String direction = "ltr";
    public String blockProgression = "tb";
    private boolean contiguous = false;
    protected Map<String, String> textAttributes;
    protected List<TextNode> content;

    @Override
    public Map<String, String> getTextAttributes() {
        return this.textAttributes;
    }

    @Override
    public List<TextNode> getTextChildren() {
        return this.content;
    }

    public HashMap<String, TextNode> getTextProperties() {
        return null;
    }

    @Override
    public void addTextProperty(String propertyName, TextNode node) {
        this.addChild(node);
    }

    protected void rememberAttribute(String name, String value) {
        if (this.textAttributes == null) {
            this.textAttributes = new HashMap<String, String>(4);
        }
        this.textAttributes.put(name, value);
    }

    public void addContentChild(FXGNode child) {
        if (child instanceof ParagraphNode || child instanceof BRNode || child instanceof SpanNode || child instanceof CDATANode) {
            if (this.content == null) {
                this.content = new ArrayList<TextNode>();
                this.contiguous = true;
            }
            if (!this.contiguous) {
                throw new FXGException(child.getStartLine(), child.getStartColumn(), "InvalidTextGraphicContent", new Object[0]);
            }
            this.content.add((TextNode)child);
        }
    }

    @Override
    public void addChild(FXGNode child) {
        if (child instanceof CDATANode) {
            if (TextHelper.ignorableWhitespace(((CDATANode)child).content)) {
                return;
            }
            throw new FXGException(child.getStartLine(), child.getStartColumn(), "InvalidTextGraphicContent", new Object[0]);
        }
        super.addChild(child);
        this.contiguous = false;
    }

    @Override
    public String getNodeName() {
        return "TextGraphic";
    }

    @Override
    public void setAttribute(String name, String value) {
        if ("width".equals(name)) {
            this.width = DOMParserHelper.parseDouble(this, value, name);
        } else if ("height".equals(name)) {
            this.height = DOMParserHelper.parseDouble(this, value, name);
        } else if ("paddingLeft".equals(name)) {
            this.paddingLeft = DOMParserHelper.parseDouble(this, value, name);
        } else if ("paddingRight".equals(name)) {
            this.paddingRight = DOMParserHelper.parseDouble(this, value, name);
        } else if ("paddingBottom".equals(name)) {
            this.paddingBottom = DOMParserHelper.parseDouble(this, value, name);
        } else if ("paddingTop".equals(name)) {
            this.paddingTop = DOMParserHelper.parseDouble(this, value, name);
        } else if ("fontFamily".equals(name)) {
            this.fontFamily = value;
        } else if ("fontSize".equals(name)) {
            this.fontSize = DOMParserHelper.parseDouble(this, value, name);
        } else if ("fontStyle".equals(name)) {
            this.fontStyle = value;
        } else if ("fontWeight".equals(name)) {
            this.fontWeight = value;
        } else if ("lineHeight".equals(name)) {
            this.lineHeight = DOMParserHelper.parsePercent(this, value, name);
        } else if ("textDecoration".equals(name)) {
            this.textDecoration = value;
        } else if ("whiteSpaceCollapse".equals(name)) {
            this.whiteSpaceCollapse = AbstractCharacterTextNode.getWhiteSpaceCollapse(this, value);
        } else if ("lineBreak".equals(name)) {
            this.lineBreak = AbstractCharacterTextNode.getLineBreak(this, value);
        } else if ("tracking".equals(name)) {
            this.tracking = DOMParserHelper.parsePercent(this, value, name);
        } else if ("kerning".equals(name)) {
            this.kerning = AbstractCharacterTextNode.getKerning(this, value);
        } else if ("textAlpha".equals(name)) {
            this.textAlpha = DOMParserHelper.parseDouble(this, value, name, 0.0, 1.0, this.textAlpha);
        } else if ("color".equals(name)) {
            this.color = DOMParserHelper.parseRGB(this, value, name);
        } else if ("textAlign".equals(name)) {
            this.textAlign = value;
        } else if ("textAlignLast".equals(name)) {
            this.textAlignLast = value;
        } else if ("textIndent".equals(name)) {
            this.textIndent = DOMParserHelper.parseDouble(this, value, name);
        } else if ("marginLeft".equals(name)) {
            this.marginLeft = DOMParserHelper.parseDouble(this, value, name);
        } else if ("marginRight".equals(name)) {
            this.marginRight = DOMParserHelper.parseDouble(this, value, name);
        } else if ("marginTop".equals(name)) {
            this.marginTop = DOMParserHelper.parseDouble(this, value, name);
        } else if ("marginBottom".equals(name)) {
            this.marginBottom = DOMParserHelper.parseDouble(this, value, name);
        } else if ("direction".equals(name)) {
            this.direction = value;
        } else if ("blockProgression".equals(name)) {
            this.blockProgression = value;
        } else if ("x".equals(name)) {
            this.x = DOMParserHelper.parseDouble(this, value, name);
            this.translateSet = true;
        } else if ("y".equals(name)) {
            this.y = DOMParserHelper.parseDouble(this, value, name);
            this.translateSet = true;
        } else if ("rotation".equals(name)) {
            this.rotation = DOMParserHelper.parseDouble(this, value, name);
            this.rotationSet = true;
        } else if ("scaleX".equals(name)) {
            this.scaleX = DOMParserHelper.parseDouble(this, value, name);
            this.scaleSet = true;
        } else if ("scaleY".equals(name)) {
            this.scaleY = DOMParserHelper.parseDouble(this, value, name);
            this.scaleSet = true;
        } else if ("alpha".equals(name)) {
            this.alpha = DOMParserHelper.parseDouble(this, value, name, 0.0, 1.0, this.alpha);
            this.alphaSet = true;
        } else if ("blendMode".equals(name)) {
            this.blendMode = this.parseBlendMode(this, value, this.blendMode);
        } else if ("maskType".equals(name)) {
            this.maskType = DOMParserHelper.parseMaskType(this, value, name, this.maskType);
            this.maskTypeSet = true;
        } else if ("visible".equals(name)) {
            this.visible = DOMParserHelper.parseBoolean(this, value, name);
        } else if ("lineThrough".equals(name)) {
            this.lineThrough = DOMParserHelper.parseBoolean(this, value, name);
        } else if (!"id".equals(name)) {
            throw new FXGException(this.getStartLine(), this.getStartColumn(), "InvalidNodeAttribute", name, this.getNodeName());
        }
        this.rememberAttribute(name, value);
    }
}

