/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.rop.cst;

import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstUtf8;
import com.android.dx.rop.type.Type;

public final class CstNat
extends Constant {
    public static final CstNat PRIMITIVE_TYPE_NAT = new CstNat(new CstUtf8("TYPE"), new CstUtf8("Ljava/lang/Class;"));
    private final CstUtf8 name;
    private final CstUtf8 descriptor;

    public CstNat(CstUtf8 name, CstUtf8 descriptor) {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        if (descriptor == null) {
            throw new NullPointerException("descriptor == null");
        }
        this.name = name;
        this.descriptor = descriptor;
    }

    public boolean equals(Object other) {
        if (!(other instanceof CstNat)) {
            return false;
        }
        CstNat otherNat = (CstNat)other;
        return this.name.equals(otherNat.name) && this.descriptor.equals(otherNat.descriptor);
    }

    public int hashCode() {
        return this.name.hashCode() * 31 ^ this.descriptor.hashCode();
    }

    protected int compareTo0(Constant other) {
        CstNat otherNat = (CstNat)other;
        int cmp = this.name.compareTo(otherNat.name);
        if (cmp != 0) {
            return cmp;
        }
        return this.descriptor.compareTo(otherNat.descriptor);
    }

    public String toString() {
        return "nat{" + this.toHuman() + '}';
    }

    public String typeName() {
        return "nat";
    }

    public boolean isCategory2() {
        return false;
    }

    public CstUtf8 getName() {
        return this.name;
    }

    public CstUtf8 getDescriptor() {
        return this.descriptor;
    }

    public String toHuman() {
        return this.name.toHuman() + ':' + this.descriptor.toHuman();
    }

    public Type getFieldType() {
        return Type.intern(this.descriptor.getString());
    }

    public final boolean isInstanceInit() {
        return this.name.getString().equals("<init>");
    }

    public final boolean isClassInit() {
        return this.name.getString().equals("<clinit>");
    }
}

