/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Analysis;

import java.util.BitSet;
import java.util.EnumSet;
import java.util.List;
import org.jf.dexlib.ClassDataItem;
import org.jf.dexlib.Code.Analysis.AnalyzedInstruction;
import org.jf.dexlib.Code.Analysis.ClassPath;
import org.jf.dexlib.Code.Analysis.DeodexUtil;
import org.jf.dexlib.Code.Analysis.RegisterType;
import org.jf.dexlib.Code.Analysis.ValidationException;
import org.jf.dexlib.Code.FiveRegisterInstruction;
import org.jf.dexlib.Code.Format.ArrayDataPseudoInstruction;
import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Format.Instruction22c;
import org.jf.dexlib.Code.Format.Instruction22cs;
import org.jf.dexlib.Code.Format.Instruction35c;
import org.jf.dexlib.Code.Format.Instruction35ms;
import org.jf.dexlib.Code.Format.Instruction35s;
import org.jf.dexlib.Code.Format.Instruction3rc;
import org.jf.dexlib.Code.Format.Instruction3rms;
import org.jf.dexlib.Code.Format.UnresolvedOdexInstruction;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.InstructionWithReference;
import org.jf.dexlib.Code.LiteralInstruction;
import org.jf.dexlib.Code.MultiOffsetInstruction;
import org.jf.dexlib.Code.OffsetInstruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Code.RegisterRangeInstruction;
import org.jf.dexlib.Code.SingleRegisterInstruction;
import org.jf.dexlib.Code.ThreeRegisterInstruction;
import org.jf.dexlib.Code.TwoRegisterInstruction;
import org.jf.dexlib.CodeItem;
import org.jf.dexlib.FieldIdItem;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.MethodIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.TypeListItem;
import org.jf.dexlib.Util.AccessFlags;
import org.jf.dexlib.Util.ExceptionWithContext;
import org.jf.dexlib.Util.SparseArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodAnalyzer {
    private final ClassDataItem.EncodedMethod encodedMethod;
    private final DeodexUtil deodexUtil;
    private SparseArray<AnalyzedInstruction> instructions;
    private static final int NOT_ANALYZED = 0;
    private static final int ANALYZED = 1;
    private static final int VERIFIED = 2;
    private int analyzerState = 0;
    private BitSet analyzedInstructions;
    private ValidationException validationException = null;
    private AnalyzedInstruction startOfMethod;
    private static final EnumSet<RegisterType.Category> Primitive32BitCategories = EnumSet.of(RegisterType.Category.Null, new RegisterType.Category[]{RegisterType.Category.One, RegisterType.Category.Boolean, RegisterType.Category.Byte, RegisterType.Category.PosByte, RegisterType.Category.Short, RegisterType.Category.PosShort, RegisterType.Category.Char, RegisterType.Category.Integer, RegisterType.Category.Float});
    private static final EnumSet<RegisterType.Category> WideLowCategories = EnumSet.of(RegisterType.Category.LongLo, RegisterType.Category.DoubleLo);
    private static final EnumSet<RegisterType.Category> WideHighCategories = EnumSet.of(RegisterType.Category.LongHi, RegisterType.Category.DoubleHi);
    private static final EnumSet<RegisterType.Category> ReferenceCategories = EnumSet.of(RegisterType.Category.Null, RegisterType.Category.Reference);
    private static final EnumSet<RegisterType.Category> ReferenceOrUninitThisCategories = EnumSet.of(RegisterType.Category.Null, RegisterType.Category.UninitThis, RegisterType.Category.Reference);
    private static final EnumSet<RegisterType.Category> ReferenceOrUninitCategories = EnumSet.of(RegisterType.Category.Null, RegisterType.Category.UninitRef, RegisterType.Category.UninitThis, RegisterType.Category.Reference);
    private static final EnumSet<RegisterType.Category> ReferenceAndPrimitive32BitCategories = EnumSet.of(RegisterType.Category.Null, new RegisterType.Category[]{RegisterType.Category.One, RegisterType.Category.Boolean, RegisterType.Category.Byte, RegisterType.Category.PosByte, RegisterType.Category.Short, RegisterType.Category.PosShort, RegisterType.Category.Char, RegisterType.Category.Integer, RegisterType.Category.Float, RegisterType.Category.Reference});
    private static final EnumSet<RegisterType.Category> BooleanCategories = EnumSet.of(RegisterType.Category.Null, RegisterType.Category.One, RegisterType.Category.Boolean);
    private static final int INVOKE_VIRTUAL = 1;
    private static final int INVOKE_SUPER = 2;
    private static final int INVOKE_DIRECT = 4;
    private static final int INVOKE_INTERFACE = 8;
    private static final int INVOKE_STATIC = 16;

    public MethodAnalyzer(ClassDataItem.EncodedMethod encodedMethod, boolean deodex) {
        if (encodedMethod == null) {
            throw new IllegalArgumentException("encodedMethod cannot be null");
        }
        if (encodedMethod.codeItem == null || encodedMethod.codeItem.getInstructions().length == 0) {
            throw new IllegalArgumentException("The method has no code");
        }
        this.encodedMethod = encodedMethod;
        this.deodexUtil = deodex ? new DeodexUtil(encodedMethod.method.getDexFile()) : null;
        this.startOfMethod = new AnalyzedInstruction(null, -1, encodedMethod.codeItem.getRegisterCount()){

            public boolean setsRegister() {
                return false;
            }

            public boolean setsWideRegister() {
                return false;
            }

            public boolean setsRegister(int registerNumber) {
                return false;
            }

            public int getDestinationRegister() {
                assert (false);
                return -1;
            }
        };
        this.buildInstructionList();
        this.analyzedInstructions = new BitSet(this.instructions.size());
    }

    public boolean isAnalyzed() {
        return this.analyzerState >= 1;
    }

    public boolean isVerified() {
        return this.analyzerState == 2;
    }

    /*
     * Unable to fully structure code
     */
    public void analyze() {
        if (!MethodAnalyzer.$assertionsDisabled && this.encodedMethod == null) {
            throw new AssertionError();
        }
        if (!MethodAnalyzer.$assertionsDisabled && this.encodedMethod.codeItem == null) {
            throw new AssertionError();
        }
        if (this.analyzerState >= 1) {
            return;
        }
        codeItem = this.encodedMethod.codeItem;
        methodIdItem = this.encodedMethod.method;
        totalRegisters = codeItem.getRegisterCount();
        parameterRegisters = methodIdItem.getPrototype().getParameterRegisterCount();
        nonParameterRegisters = totalRegisters - parameterRegisters;
        for (AnalyzedInstruction instruction : this.instructions.getValues()) {
            instruction.dead = true;
        }
        if ((this.encodedMethod.accessFlags & AccessFlags.STATIC.getValue()) == 0) {
            --nonParameterRegisters;
            thisRegister = totalRegisters - parameterRegisters - 1;
            if ((this.encodedMethod.accessFlags & AccessFlags.CONSTRUCTOR.getValue()) != 0) {
                this.setPostRegisterTypeAndPropagateChanges(this.startOfMethod, thisRegister, RegisterType.getRegisterType(RegisterType.Category.UninitThis, ClassPath.getClassDef(methodIdItem.getContainingClass())));
            } else {
                this.setPostRegisterTypeAndPropagateChanges(this.startOfMethod, thisRegister, RegisterType.getRegisterType(RegisterType.Category.Reference, ClassPath.getClassDef(methodIdItem.getContainingClass())));
            }
        }
        if ((parameters = methodIdItem.getPrototype().getParameters()) != null) {
            parameterTypes = MethodAnalyzer.getParameterTypes(parameters, parameterRegisters);
            for (i = 0; i < parameterTypes.length; ++i) {
                registerType = parameterTypes[i];
                registerNum = totalRegisters - parameterRegisters + i;
                this.setPostRegisterTypeAndPropagateChanges(this.startOfMethod, registerNum, registerType);
            }
        }
        uninit = RegisterType.getRegisterType(RegisterType.Category.Uninit, null);
        for (i = 0; i < nonParameterRegisters; ++i) {
            this.setPostRegisterTypeAndPropagateChanges(this.startOfMethod, i, uninit);
        }
        instructionsToAnalyze = new BitSet(this.instructions.size());
        for (AnalyzedInstruction successor : this.startOfMethod.successors) {
            instructionsToAnalyze.set(successor.instructionIndex);
        }
        undeodexedInstructions = new BitSet(this.instructions.size());
        block11: while (true) {
            didSomething = false;
            while (!instructionsToAnalyze.isEmpty()) {
                i = instructionsToAnalyze.nextSetBit(0);
                while (i >= 0) {
                    block27: {
                        instructionsToAnalyze.clear(i);
                        if (!this.analyzedInstructions.get(i)) {
                            instructionToAnalyze = this.instructions.valueAt(i);
                            instructionToAnalyze.dead = false;
                            try {
                                if (instructionToAnalyze.originalInstruction.opcode.odexOnly()) {
                                    instructionToAnalyze.restoreOdexedInstruction();
                                }
                                if (!this.analyzeInstruction(instructionToAnalyze)) {
                                    undeodexedInstructions.set(i);
                                    break block27;
                                }
                                didSomething = true;
                                undeodexedInstructions.clear(i);
                            }
                            catch (ValidationException ex) {
                                this.validationException = ex;
                                codeAddress = this.getInstructionAddress(instructionToAnalyze);
                                ex.setCodeAddress(codeAddress);
                                ex.addContext(String.format("opcode: %s", new Object[]{instructionToAnalyze.instruction.opcode.name}));
                                ex.addContext(String.format("CodeAddress: %d", new Object[]{codeAddress}));
                                ex.addContext(String.format("Method: %s", new Object[]{this.encodedMethod.method.getMethodString()}));
                                break;
                            }
                            this.analyzedInstructions.set(instructionToAnalyze.getInstructionIndex());
                            for (AnalyzedInstruction successor : instructionToAnalyze.successors) {
                                instructionsToAnalyze.set(successor.getInstructionIndex());
                            }
                        }
                    }
                    i = instructionsToAnalyze.nextSetBit(i + 1);
                }
                if (this.validationException == null) continue;
            }
            if (!didSomething) break;
            if (undeodexedInstructions.isEmpty()) continue;
            i = undeodexedInstructions.nextSetBit(0);
            while (true) {
                if (i >= 0) ** break;
                continue block11;
                instructionsToAnalyze.set(i);
                i = undeodexedInstructions.nextSetBit(i + 1);
            }
            break;
        }
        block16: for (i = 0; i < this.instructions.size(); ++i) {
            instruction = this.instructions.valueAt(i);
            switch (2.$SwitchMap$org$jf$dexlib$Code$Format$Format[instruction.getInstruction().getFormat().ordinal()]) {
                case 1: {
                    objectRegisterNumber = ((Instruction22cs)instruction.instruction).getRegisterB();
                    break;
                }
                case 2: {
                    objectRegisterNumber = ((Instruction35ms)instruction.instruction).getRegisterD();
                    break;
                }
                case 3: {
                    objectRegisterNumber = ((Instruction3rms)instruction.instruction).getStartRegister();
                    break;
                }
                default: {
                    continue block16;
                }
            }
            instruction.setDeodexedInstruction(new UnresolvedOdexInstruction(instruction.instruction, objectRegisterNumber));
        }
        this.analyzerState = 1;
    }

    public void verify() {
        if (this.analyzerState < 1) {
            throw new ExceptionWithContext("You must call analyze() before calling verify().");
        }
        if (this.analyzerState == 2) {
            return;
        }
        BitSet instructionsToVerify = new BitSet(this.instructions.size());
        BitSet verifiedInstructions = new BitSet(this.instructions.size());
        for (AnalyzedInstruction successor : this.startOfMethod.successors) {
            instructionsToVerify.set(successor.instructionIndex);
        }
        while (!instructionsToVerify.isEmpty()) {
            int i = instructionsToVerify.nextSetBit(0);
            while (i >= 0) {
                instructionsToVerify.clear(i);
                if (!verifiedInstructions.get(i)) {
                    AnalyzedInstruction instructionToVerify = this.instructions.valueAt(i);
                    try {
                        this.verifyInstruction(instructionToVerify);
                    }
                    catch (ValidationException ex) {
                        this.validationException = ex;
                        int codeAddress = this.getInstructionAddress(instructionToVerify);
                        ex.setCodeAddress(codeAddress);
                        ex.addContext(String.format("opcode: %s", instructionToVerify.instruction.opcode.name));
                        ex.addContext(String.format("CodeAddress: %d", codeAddress));
                        ex.addContext(String.format("Method: %s", this.encodedMethod.method.getMethodString()));
                        break;
                    }
                    verifiedInstructions.set(instructionToVerify.getInstructionIndex());
                    for (AnalyzedInstruction successor : instructionToVerify.successors) {
                        instructionsToVerify.set(successor.getInstructionIndex());
                    }
                }
                i = instructionsToVerify.nextSetBit(i + 1);
            }
            if (this.validationException == null) continue;
        }
        this.analyzerState = 2;
    }

    private int getThisRegister() {
        assert ((this.encodedMethod.accessFlags & AccessFlags.STATIC.getValue()) == 0);
        CodeItem codeItem = this.encodedMethod.codeItem;
        assert (codeItem != null);
        MethodIdItem methodIdItem = this.encodedMethod.method;
        assert (methodIdItem != null);
        int totalRegisters = codeItem.getRegisterCount();
        if (totalRegisters == 0) {
            throw new ValidationException("A non-static method must have at least 1 register");
        }
        int parameterRegisters = methodIdItem.getPrototype().getParameterRegisterCount();
        return totalRegisters - parameterRegisters - 1;
    }

    private boolean isInstanceConstructor() {
        return (this.encodedMethod.accessFlags & AccessFlags.STATIC.getValue()) == 0 && (this.encodedMethod.accessFlags & AccessFlags.CONSTRUCTOR.getValue()) != 0;
    }

    private boolean isStaticConstructor() {
        return (this.encodedMethod.accessFlags & AccessFlags.STATIC.getValue()) != 0 && (this.encodedMethod.accessFlags & AccessFlags.CONSTRUCTOR.getValue()) != 0;
    }

    public AnalyzedInstruction getStartOfMethod() {
        return this.startOfMethod;
    }

    public List<AnalyzedInstruction> getInstructions() {
        return this.instructions.getValues();
    }

    public ClassDataItem.EncodedMethod getMethod() {
        return this.encodedMethod;
    }

    public ValidationException getValidationException() {
        return this.validationException;
    }

    private static RegisterType[] getParameterTypes(TypeListItem typeListItem, int parameterRegisterCount) {
        assert (typeListItem != null);
        assert (parameterRegisterCount == typeListItem.getRegisterCount());
        RegisterType[] registerTypes = new RegisterType[parameterRegisterCount];
        int registerNum = 0;
        for (TypeIdItem type : typeListItem.getTypes()) {
            if (type.getRegisterCount() == 2) {
                registerTypes[registerNum++] = RegisterType.getWideRegisterTypeForTypeIdItem(type, true);
                registerTypes[registerNum++] = RegisterType.getWideRegisterTypeForTypeIdItem(type, false);
                continue;
            }
            registerTypes[registerNum++] = RegisterType.getRegisterTypeForTypeIdItem(type);
        }
        return registerTypes;
    }

    public int getInstructionAddress(AnalyzedInstruction instruction) {
        return this.instructions.keyAt(instruction.instructionIndex);
    }

    private void setDestinationRegisterTypeAndPropagateChanges(AnalyzedInstruction analyzedInstruction, RegisterType registerType) {
        this.setPostRegisterTypeAndPropagateChanges(analyzedInstruction, analyzedInstruction.getDestinationRegister(), registerType);
    }

    private void setPostRegisterTypeAndPropagateChanges(AnalyzedInstruction analyzedInstruction, int registerNumber, RegisterType registerType) {
        BitSet changedInstructions = new BitSet(this.instructions.size());
        if (!analyzedInstruction.setPostRegisterType(registerNumber, registerType)) {
            return;
        }
        this.propagateRegisterToSuccessors(analyzedInstruction, registerNumber, changedInstructions);
        while (!changedInstructions.isEmpty()) {
            int instructionIndex = changedInstructions.nextSetBit(0);
            while (instructionIndex >= 0) {
                changedInstructions.clear(instructionIndex);
                this.propagateRegisterToSuccessors(this.instructions.valueAt(instructionIndex), registerNumber, changedInstructions);
                instructionIndex = changedInstructions.nextSetBit(instructionIndex + 1);
            }
        }
        if (registerType.category == RegisterType.Category.LongLo) {
            MethodAnalyzer.checkWidePair(registerNumber, analyzedInstruction);
            this.setPostRegisterTypeAndPropagateChanges(analyzedInstruction, registerNumber + 1, RegisterType.getRegisterType(RegisterType.Category.LongHi, null));
        } else if (registerType.category == RegisterType.Category.DoubleLo) {
            MethodAnalyzer.checkWidePair(registerNumber, analyzedInstruction);
            this.setPostRegisterTypeAndPropagateChanges(analyzedInstruction, registerNumber + 1, RegisterType.getRegisterType(RegisterType.Category.DoubleHi, null));
        }
    }

    private void propagateRegisterToSuccessors(AnalyzedInstruction instruction, int registerNumber, BitSet changedInstructions) {
        RegisterType postRegisterType = instruction.getPostInstructionRegisterType(registerNumber);
        for (AnalyzedInstruction successor : instruction.successors) {
            if (!successor.mergeRegister(registerNumber, postRegisterType, this.analyzedInstructions)) continue;
            changedInstructions.set(successor.instructionIndex);
        }
    }

    private void buildInstructionList() {
        assert (this.encodedMethod != null);
        assert (this.encodedMethod.codeItem != null);
        int registerCount = this.encodedMethod.codeItem.getRegisterCount();
        Instruction[] insns = this.encodedMethod.codeItem.getInstructions();
        this.instructions = new SparseArray(insns.length);
        int currentCodeAddress = 0;
        for (int i = 0; i < insns.length; ++i) {
            this.instructions.append(currentCodeAddress, new AnalyzedInstruction(insns[i], i, registerCount));
            assert (this.instructions.indexOfKey(currentCodeAddress) == i);
            currentCodeAddress += insns[i].getSize(currentCodeAddress);
        }
        CodeItem.TryItem[] tries = this.encodedMethod.codeItem.getTries();
        int triesIndex = 0;
        CodeItem.TryItem currentTry = null;
        AnalyzedInstruction[] currentExceptionHandlers = null;
        AnalyzedInstruction[][] exceptionHandlers = new AnalyzedInstruction[insns.length][];
        if (tries != null) {
            for (int i = 0; i < this.instructions.size(); ++i) {
                CodeItem.TryItem tryItem;
                AnalyzedInstruction instruction = this.instructions.valueAt(i);
                Opcode instructionOpcode = instruction.instruction.opcode;
                currentCodeAddress = this.getInstructionAddress(instruction);
                if (currentTry != null && currentTry.getStartCodeAddress() + currentTry.getTryLength() <= currentCodeAddress) {
                    currentTry = null;
                    ++triesIndex;
                }
                if (currentTry == null && triesIndex < tries.length && (tryItem = tries[triesIndex]).getStartCodeAddress() <= currentCodeAddress) {
                    assert (tryItem.getStartCodeAddress() + tryItem.getTryLength() > currentCodeAddress);
                    currentTry = tryItem;
                    currentExceptionHandlers = this.buildExceptionHandlerArray(tryItem);
                }
                if (currentTry == null || !instructionOpcode.canThrow()) continue;
                exceptionHandlers[i] = currentExceptionHandlers;
            }
        }
        assert (this.instructions.size() > 0);
        BitSet instructionsToProcess = new BitSet(insns.length);
        this.addPredecessorSuccessor(this.startOfMethod, this.instructions.valueAt(0), exceptionHandlers, instructionsToProcess);
        while (!instructionsToProcess.isEmpty()) {
            int currentInstructionIndex = instructionsToProcess.nextSetBit(0);
            instructionsToProcess.clear(currentInstructionIndex);
            AnalyzedInstruction instruction = this.instructions.valueAt(currentInstructionIndex);
            Opcode instructionOpcode = instruction.instruction.opcode;
            int instructionCodeAddress = this.getInstructionAddress(instruction);
            if (instruction.instruction.opcode.canContinue() && (instruction.instruction.opcode != Opcode.NOP || !instruction.instruction.getFormat().variableSizeFormat)) {
                if (currentInstructionIndex == this.instructions.size() - 1) {
                    throw new ValidationException("Execution can continue past the last instruction");
                }
                AnalyzedInstruction nextInstruction = this.instructions.valueAt(currentInstructionIndex + 1);
                this.addPredecessorSuccessor(instruction, nextInstruction, exceptionHandlers, instructionsToProcess);
            }
            if (!(instruction.instruction instanceof OffsetInstruction)) continue;
            OffsetInstruction offsetInstruction = (OffsetInstruction)((Object)instruction.instruction);
            if (instructionOpcode == Opcode.PACKED_SWITCH || instructionOpcode == Opcode.SPARSE_SWITCH) {
                MultiOffsetInstruction switchDataInstruction = (MultiOffsetInstruction)((Object)this.instructions.get((int)(instructionCodeAddress + offsetInstruction.getTargetAddressOffset())).instruction);
                for (int targetAddressOffset : switchDataInstruction.getTargets()) {
                    AnalyzedInstruction targetInstruction = this.instructions.get(instructionCodeAddress + targetAddressOffset);
                    this.addPredecessorSuccessor(instruction, targetInstruction, exceptionHandlers, instructionsToProcess);
                }
                continue;
            }
            int targetAddressOffset = offsetInstruction.getTargetAddressOffset();
            AnalyzedInstruction targetInstruction = this.instructions.get(instructionCodeAddress + targetAddressOffset);
            this.addPredecessorSuccessor(instruction, targetInstruction, exceptionHandlers, instructionsToProcess);
        }
    }

    private void addPredecessorSuccessor(AnalyzedInstruction predecessor, AnalyzedInstruction successor, AnalyzedInstruction[][] exceptionHandlers, BitSet instructionsToProcess) {
        this.addPredecessorSuccessor(predecessor, successor, exceptionHandlers, instructionsToProcess, false);
    }

    private void addPredecessorSuccessor(AnalyzedInstruction predecessor, AnalyzedInstruction successor, AnalyzedInstruction[][] exceptionHandlers, BitSet instructionsToProcess, boolean allowMoveException) {
        if (!allowMoveException && successor.instruction.opcode == Opcode.MOVE_EXCEPTION) {
            throw new ValidationException("Execution can pass from the " + predecessor.instruction.opcode.name + " instruction at code address 0x" + Integer.toHexString(this.getInstructionAddress(predecessor)) + " to the move-exception instruction at address 0x" + Integer.toHexString(this.getInstructionAddress(successor)));
        }
        if (!successor.addPredecessor(predecessor)) {
            return;
        }
        predecessor.addSuccessor(successor);
        instructionsToProcess.set(successor.getInstructionIndex());
        AnalyzedInstruction[] exceptionHandlersForSuccessor = exceptionHandlers[successor.instructionIndex];
        if (exceptionHandlersForSuccessor != null) {
            assert (successor.instruction.opcode.canThrow());
            for (AnalyzedInstruction exceptionHandler : exceptionHandlersForSuccessor) {
                this.addPredecessorSuccessor(predecessor, exceptionHandler, exceptionHandlers, instructionsToProcess, true);
            }
        }
    }

    private AnalyzedInstruction[] buildExceptionHandlerArray(CodeItem.TryItem tryItem) {
        int exceptionHandlerCount = tryItem.encodedCatchHandler.handlers.length;
        int catchAllHandler = tryItem.encodedCatchHandler.getCatchAllHandlerAddress();
        if (catchAllHandler != -1) {
            ++exceptionHandlerCount;
        }
        AnalyzedInstruction[] exceptionHandlers = new AnalyzedInstruction[exceptionHandlerCount];
        for (int i = 0; i < tryItem.encodedCatchHandler.handlers.length; ++i) {
            exceptionHandlers[i] = this.instructions.get(tryItem.encodedCatchHandler.handlers[i].getHandlerAddress());
        }
        if (catchAllHandler != -1) {
            exceptionHandlers[exceptionHandlers.length - 1] = this.instructions.get(catchAllHandler);
        }
        return exceptionHandlers;
    }

    private boolean analyzeInstruction(AnalyzedInstruction analyzedInstruction) {
        Instruction instruction = analyzedInstruction.instruction;
        switch (instruction.opcode) {
            case NOP: {
                return true;
            }
            case MOVE: 
            case MOVE_FROM16: 
            case MOVE_16: 
            case MOVE_WIDE: 
            case MOVE_WIDE_FROM16: 
            case MOVE_WIDE_16: 
            case MOVE_OBJECT: 
            case MOVE_OBJECT_FROM16: 
            case MOVE_OBJECT_16: {
                this.analyzeMove(analyzedInstruction);
                return true;
            }
            case MOVE_RESULT: 
            case MOVE_RESULT_WIDE: 
            case MOVE_RESULT_OBJECT: {
                this.analyzeMoveResult(analyzedInstruction);
                return true;
            }
            case MOVE_EXCEPTION: {
                this.analyzeMoveException(analyzedInstruction);
                return true;
            }
            case RETURN_VOID: 
            case RETURN: 
            case RETURN_WIDE: 
            case RETURN_OBJECT: {
                return true;
            }
            case CONST_4: 
            case CONST_16: 
            case CONST: {
                this.analyzeConst(analyzedInstruction);
                return true;
            }
            case CONST_HIGH16: {
                this.analyzeConstHigh16(analyzedInstruction);
                return true;
            }
            case CONST_WIDE_16: 
            case CONST_WIDE_32: 
            case CONST_WIDE: 
            case CONST_WIDE_HIGH16: {
                this.analyzeWideConst(analyzedInstruction);
                return true;
            }
            case CONST_STRING: 
            case CONST_STRING_JUMBO: {
                this.analyzeConstString(analyzedInstruction);
                return true;
            }
            case CONST_CLASS: {
                this.analyzeConstClass(analyzedInstruction);
                return true;
            }
            case MONITOR_ENTER: 
            case MONITOR_EXIT: {
                return true;
            }
            case CHECK_CAST: {
                this.analyzeCheckCast(analyzedInstruction);
                return true;
            }
            case INSTANCE_OF: {
                this.analyzeInstanceOf(analyzedInstruction);
                return true;
            }
            case ARRAY_LENGTH: {
                this.analyzeArrayLength(analyzedInstruction);
                return true;
            }
            case NEW_INSTANCE: {
                this.analyzeNewInstance(analyzedInstruction);
                return true;
            }
            case NEW_ARRAY: {
                this.analyzeNewArray(analyzedInstruction);
                return true;
            }
            case FILLED_NEW_ARRAY: 
            case FILLED_NEW_ARRAY_RANGE: {
                return true;
            }
            case FILL_ARRAY_DATA: {
                this.analyzeArrayDataOrSwitch(analyzedInstruction);
            }
            case THROW: 
            case GOTO: 
            case GOTO_16: 
            case GOTO_32: {
                return true;
            }
            case PACKED_SWITCH: 
            case SPARSE_SWITCH: {
                this.analyzeArrayDataOrSwitch(analyzedInstruction);
                return true;
            }
            case CMPL_FLOAT: 
            case CMPG_FLOAT: 
            case CMPL_DOUBLE: 
            case CMPG_DOUBLE: 
            case CMP_LONG: {
                this.analyzeFloatWideCmp(analyzedInstruction);
                return true;
            }
            case IF_EQ: 
            case IF_NE: 
            case IF_LT: 
            case IF_GE: 
            case IF_GT: 
            case IF_LE: 
            case IF_EQZ: 
            case IF_NEZ: 
            case IF_LTZ: 
            case IF_GEZ: 
            case IF_GTZ: 
            case IF_LEZ: {
                return true;
            }
            case AGET: {
                this.analyze32BitPrimitiveAget(analyzedInstruction, RegisterType.Category.Integer);
                return true;
            }
            case AGET_BOOLEAN: {
                this.analyze32BitPrimitiveAget(analyzedInstruction, RegisterType.Category.Boolean);
                return true;
            }
            case AGET_BYTE: {
                this.analyze32BitPrimitiveAget(analyzedInstruction, RegisterType.Category.Byte);
                return true;
            }
            case AGET_CHAR: {
                this.analyze32BitPrimitiveAget(analyzedInstruction, RegisterType.Category.Char);
                return true;
            }
            case AGET_SHORT: {
                this.analyze32BitPrimitiveAget(analyzedInstruction, RegisterType.Category.Short);
                return true;
            }
            case AGET_WIDE: {
                this.analyzeAgetWide(analyzedInstruction);
                return true;
            }
            case AGET_OBJECT: {
                this.analyzeAgetObject(analyzedInstruction);
                return true;
            }
            case APUT: 
            case APUT_BOOLEAN: 
            case APUT_BYTE: 
            case APUT_CHAR: 
            case APUT_SHORT: 
            case APUT_WIDE: 
            case APUT_OBJECT: {
                return true;
            }
            case IGET: {
                this.analyze32BitPrimitiveIget(analyzedInstruction, RegisterType.Category.Integer);
                return true;
            }
            case IGET_BOOLEAN: {
                this.analyze32BitPrimitiveIget(analyzedInstruction, RegisterType.Category.Boolean);
                return true;
            }
            case IGET_BYTE: {
                this.analyze32BitPrimitiveIget(analyzedInstruction, RegisterType.Category.Byte);
                return true;
            }
            case IGET_CHAR: {
                this.analyze32BitPrimitiveIget(analyzedInstruction, RegisterType.Category.Char);
                return true;
            }
            case IGET_SHORT: {
                this.analyze32BitPrimitiveIget(analyzedInstruction, RegisterType.Category.Short);
                return true;
            }
            case IGET_WIDE: 
            case IGET_OBJECT: {
                this.analyzeIgetWideObject(analyzedInstruction);
                return true;
            }
            case IPUT: 
            case IPUT_BOOLEAN: 
            case IPUT_BYTE: 
            case IPUT_CHAR: 
            case IPUT_SHORT: 
            case IPUT_WIDE: 
            case IPUT_OBJECT: {
                return true;
            }
            case SGET: {
                this.analyze32BitPrimitiveSget(analyzedInstruction, RegisterType.Category.Integer);
                return true;
            }
            case SGET_BOOLEAN: {
                this.analyze32BitPrimitiveSget(analyzedInstruction, RegisterType.Category.Boolean);
                return true;
            }
            case SGET_BYTE: {
                this.analyze32BitPrimitiveSget(analyzedInstruction, RegisterType.Category.Byte);
                return true;
            }
            case SGET_CHAR: {
                this.analyze32BitPrimitiveSget(analyzedInstruction, RegisterType.Category.Char);
                return true;
            }
            case SGET_SHORT: {
                this.analyze32BitPrimitiveSget(analyzedInstruction, RegisterType.Category.Short);
                return true;
            }
            case SGET_WIDE: 
            case SGET_OBJECT: {
                this.analyzeSgetWideObject(analyzedInstruction);
                return true;
            }
            case SPUT: 
            case SPUT_BOOLEAN: 
            case SPUT_BYTE: 
            case SPUT_CHAR: 
            case SPUT_SHORT: 
            case SPUT_WIDE: 
            case SPUT_OBJECT: {
                return true;
            }
            case INVOKE_VIRTUAL: 
            case INVOKE_SUPER: {
                return true;
            }
            case INVOKE_DIRECT: {
                this.analyzeInvokeDirect(analyzedInstruction);
                return true;
            }
            case INVOKE_STATIC: 
            case INVOKE_INTERFACE: 
            case INVOKE_VIRTUAL_RANGE: 
            case INVOKE_SUPER_RANGE: {
                return true;
            }
            case INVOKE_DIRECT_RANGE: {
                this.analyzeInvokeDirectRange(analyzedInstruction);
                return true;
            }
            case INVOKE_STATIC_RANGE: 
            case INVOKE_INTERFACE_RANGE: {
                return true;
            }
            case NEG_INT: 
            case NOT_INT: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.Category.Integer);
                return true;
            }
            case NEG_LONG: 
            case NOT_LONG: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.Category.LongLo);
                return true;
            }
            case NEG_FLOAT: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.Category.Float);
                return true;
            }
            case NEG_DOUBLE: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.Category.DoubleLo);
                return true;
            }
            case INT_TO_LONG: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.Category.LongLo);
                return true;
            }
            case INT_TO_FLOAT: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.Category.Float);
                return true;
            }
            case INT_TO_DOUBLE: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.Category.DoubleLo);
                return true;
            }
            case LONG_TO_INT: 
            case DOUBLE_TO_INT: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.Category.Integer);
                return true;
            }
            case LONG_TO_FLOAT: 
            case DOUBLE_TO_FLOAT: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.Category.Float);
                return true;
            }
            case LONG_TO_DOUBLE: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.Category.DoubleLo);
                return true;
            }
            case FLOAT_TO_INT: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.Category.Integer);
                return true;
            }
            case FLOAT_TO_LONG: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.Category.LongLo);
                return true;
            }
            case FLOAT_TO_DOUBLE: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.Category.DoubleLo);
                return true;
            }
            case DOUBLE_TO_LONG: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.Category.LongLo);
                return true;
            }
            case INT_TO_BYTE: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.Category.Byte);
                return true;
            }
            case INT_TO_CHAR: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.Category.Char);
                return true;
            }
            case INT_TO_SHORT: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.Category.Short);
                return true;
            }
            case ADD_INT: 
            case SUB_INT: 
            case MUL_INT: 
            case DIV_INT: 
            case REM_INT: 
            case SHL_INT: 
            case SHR_INT: 
            case USHR_INT: {
                this.analyzeBinaryOp(analyzedInstruction, RegisterType.Category.Integer, false);
                return true;
            }
            case AND_INT: 
            case OR_INT: 
            case XOR_INT: {
                this.analyzeBinaryOp(analyzedInstruction, RegisterType.Category.Integer, true);
                return true;
            }
            case ADD_LONG: 
            case SUB_LONG: 
            case MUL_LONG: 
            case DIV_LONG: 
            case REM_LONG: 
            case AND_LONG: 
            case OR_LONG: 
            case XOR_LONG: 
            case SHL_LONG: 
            case SHR_LONG: 
            case USHR_LONG: {
                this.analyzeBinaryOp(analyzedInstruction, RegisterType.Category.LongLo, false);
                return true;
            }
            case ADD_FLOAT: 
            case SUB_FLOAT: 
            case MUL_FLOAT: 
            case DIV_FLOAT: 
            case REM_FLOAT: {
                this.analyzeBinaryOp(analyzedInstruction, RegisterType.Category.Float, false);
                return true;
            }
            case ADD_DOUBLE: 
            case SUB_DOUBLE: 
            case MUL_DOUBLE: 
            case DIV_DOUBLE: 
            case REM_DOUBLE: {
                this.analyzeBinaryOp(analyzedInstruction, RegisterType.Category.DoubleLo, false);
                return true;
            }
            case ADD_INT_2ADDR: 
            case SUB_INT_2ADDR: 
            case MUL_INT_2ADDR: 
            case DIV_INT_2ADDR: 
            case REM_INT_2ADDR: 
            case SHL_INT_2ADDR: 
            case SHR_INT_2ADDR: 
            case USHR_INT_2ADDR: {
                this.analyzeBinary2AddrOp(analyzedInstruction, RegisterType.Category.Integer, false);
                return true;
            }
            case AND_INT_2ADDR: 
            case OR_INT_2ADDR: 
            case XOR_INT_2ADDR: {
                this.analyzeBinary2AddrOp(analyzedInstruction, RegisterType.Category.Integer, true);
                return true;
            }
            case ADD_LONG_2ADDR: 
            case SUB_LONG_2ADDR: 
            case MUL_LONG_2ADDR: 
            case DIV_LONG_2ADDR: 
            case REM_LONG_2ADDR: 
            case AND_LONG_2ADDR: 
            case OR_LONG_2ADDR: 
            case XOR_LONG_2ADDR: 
            case SHL_LONG_2ADDR: 
            case SHR_LONG_2ADDR: 
            case USHR_LONG_2ADDR: {
                this.analyzeBinary2AddrOp(analyzedInstruction, RegisterType.Category.LongLo, false);
                return true;
            }
            case ADD_FLOAT_2ADDR: 
            case SUB_FLOAT_2ADDR: 
            case MUL_FLOAT_2ADDR: 
            case DIV_FLOAT_2ADDR: 
            case REM_FLOAT_2ADDR: {
                this.analyzeBinary2AddrOp(analyzedInstruction, RegisterType.Category.Float, false);
                return true;
            }
            case ADD_DOUBLE_2ADDR: 
            case SUB_DOUBLE_2ADDR: 
            case MUL_DOUBLE_2ADDR: 
            case DIV_DOUBLE_2ADDR: 
            case REM_DOUBLE_2ADDR: {
                this.analyzeBinary2AddrOp(analyzedInstruction, RegisterType.Category.DoubleLo, false);
                return true;
            }
            case ADD_INT_LIT16: 
            case RSUB_INT: 
            case MUL_INT_LIT16: 
            case DIV_INT_LIT16: 
            case REM_INT_LIT16: {
                this.analyzeLiteralBinaryOp(analyzedInstruction, RegisterType.Category.Integer, false);
                return true;
            }
            case AND_INT_LIT16: 
            case OR_INT_LIT16: 
            case XOR_INT_LIT16: {
                this.analyzeLiteralBinaryOp(analyzedInstruction, RegisterType.Category.Integer, true);
                return true;
            }
            case ADD_INT_LIT8: 
            case RSUB_INT_LIT8: 
            case MUL_INT_LIT8: 
            case DIV_INT_LIT8: 
            case REM_INT_LIT8: 
            case SHL_INT_LIT8: {
                this.analyzeLiteralBinaryOp(analyzedInstruction, RegisterType.Category.Integer, false);
                return true;
            }
            case AND_INT_LIT8: 
            case OR_INT_LIT8: 
            case XOR_INT_LIT8: {
                this.analyzeLiteralBinaryOp(analyzedInstruction, RegisterType.Category.Integer, true);
                return true;
            }
            case SHR_INT_LIT8: {
                this.analyzeLiteralBinaryOp(analyzedInstruction, this.getDestTypeForLiteralShiftRight(analyzedInstruction, true), false);
                return true;
            }
            case USHR_INT_LIT8: {
                this.analyzeLiteralBinaryOp(analyzedInstruction, this.getDestTypeForLiteralShiftRight(analyzedInstruction, false), false);
                return true;
            }
            case EXECUTE_INLINE: {
                this.analyzeExecuteInline(analyzedInstruction);
                return true;
            }
            case EXECUTE_INLINE_RANGE: {
                this.analyzeExecuteInlineRange(analyzedInstruction);
                return true;
            }
            case INVOKE_DIRECT_EMPTY: {
                this.analyzeInvokeDirectEmpty(analyzedInstruction);
                return true;
            }
            case IGET_QUICK: 
            case IGET_WIDE_QUICK: 
            case IGET_OBJECT_QUICK: {
                return this.analyzeIputIgetQuick(analyzedInstruction, false);
            }
            case IPUT_QUICK: 
            case IPUT_WIDE_QUICK: 
            case IPUT_OBJECT_QUICK: {
                return this.analyzeIputIgetQuick(analyzedInstruction, true);
            }
            case INVOKE_VIRTUAL_QUICK: {
                return this.analyzeInvokeVirtualQuick(analyzedInstruction, false, false);
            }
            case INVOKE_SUPER_QUICK: {
                return this.analyzeInvokeVirtualQuick(analyzedInstruction, true, false);
            }
            case INVOKE_VIRTUAL_QUICK_RANGE: {
                return this.analyzeInvokeVirtualQuick(analyzedInstruction, false, true);
            }
            case INVOKE_SUPER_QUICK_RANGE: {
                return this.analyzeInvokeVirtualQuick(analyzedInstruction, true, true);
            }
        }
        assert (false);
        return true;
    }

    private void verifyInstruction(AnalyzedInstruction analyzedInstruction) {
        Instruction instruction = analyzedInstruction.instruction;
        switch (instruction.opcode) {
            case NOP: {
                return;
            }
            case MOVE: 
            case MOVE_FROM16: 
            case MOVE_16: {
                this.verifyMove(analyzedInstruction, Primitive32BitCategories);
                return;
            }
            case MOVE_WIDE: 
            case MOVE_WIDE_FROM16: 
            case MOVE_WIDE_16: {
                this.verifyMove(analyzedInstruction, WideLowCategories);
                return;
            }
            case MOVE_OBJECT: 
            case MOVE_OBJECT_FROM16: 
            case MOVE_OBJECT_16: {
                this.verifyMove(analyzedInstruction, ReferenceOrUninitCategories);
                return;
            }
            case MOVE_RESULT: {
                this.verifyMoveResult(analyzedInstruction, Primitive32BitCategories);
                return;
            }
            case MOVE_RESULT_WIDE: {
                this.verifyMoveResult(analyzedInstruction, WideLowCategories);
                return;
            }
            case MOVE_RESULT_OBJECT: {
                this.verifyMoveResult(analyzedInstruction, ReferenceCategories);
                return;
            }
            case MOVE_EXCEPTION: {
                this.verifyMoveException(analyzedInstruction);
                return;
            }
            case RETURN_VOID: {
                this.verifyReturnVoid(analyzedInstruction);
                return;
            }
            case RETURN: {
                this.verifyReturn(analyzedInstruction, Primitive32BitCategories);
                return;
            }
            case RETURN_WIDE: {
                this.verifyReturn(analyzedInstruction, WideLowCategories);
                return;
            }
            case RETURN_OBJECT: {
                this.verifyReturn(analyzedInstruction, ReferenceCategories);
                return;
            }
            case CONST_4: 
            case CONST_16: 
            case CONST: 
            case CONST_HIGH16: 
            case CONST_WIDE_16: 
            case CONST_WIDE_32: 
            case CONST_WIDE: 
            case CONST_WIDE_HIGH16: 
            case CONST_STRING: 
            case CONST_STRING_JUMBO: {
                return;
            }
            case CONST_CLASS: {
                this.verifyConstClass(analyzedInstruction);
                return;
            }
            case MONITOR_ENTER: 
            case MONITOR_EXIT: {
                this.verifyMonitor(analyzedInstruction);
                return;
            }
            case CHECK_CAST: {
                this.verifyCheckCast(analyzedInstruction);
                return;
            }
            case INSTANCE_OF: {
                this.verifyInstanceOf(analyzedInstruction);
                return;
            }
            case ARRAY_LENGTH: {
                this.verifyArrayLength(analyzedInstruction);
                return;
            }
            case NEW_INSTANCE: {
                this.verifyNewInstance(analyzedInstruction);
                return;
            }
            case NEW_ARRAY: {
                this.verifyNewArray(analyzedInstruction);
                return;
            }
            case FILLED_NEW_ARRAY: {
                this.verifyFilledNewArray(analyzedInstruction);
                return;
            }
            case FILLED_NEW_ARRAY_RANGE: {
                this.verifyFilledNewArrayRange(analyzedInstruction);
                return;
            }
            case FILL_ARRAY_DATA: {
                this.verifyFillArrayData(analyzedInstruction);
                return;
            }
            case THROW: {
                this.verifyThrow(analyzedInstruction);
                return;
            }
            case GOTO: 
            case GOTO_16: 
            case GOTO_32: {
                return;
            }
            case PACKED_SWITCH: {
                this.verifySwitch(analyzedInstruction, Format.PackedSwitchData);
                return;
            }
            case SPARSE_SWITCH: {
                this.verifySwitch(analyzedInstruction, Format.SparseSwitchData);
                return;
            }
            case CMPL_FLOAT: 
            case CMPG_FLOAT: {
                this.verifyFloatWideCmp(analyzedInstruction, Primitive32BitCategories);
                return;
            }
            case CMPL_DOUBLE: 
            case CMPG_DOUBLE: 
            case CMP_LONG: {
                this.verifyFloatWideCmp(analyzedInstruction, WideLowCategories);
                return;
            }
            case IF_EQ: 
            case IF_NE: {
                this.verifyIfEqNe(analyzedInstruction);
                return;
            }
            case IF_LT: 
            case IF_GE: 
            case IF_GT: 
            case IF_LE: {
                this.verifyIf(analyzedInstruction);
                return;
            }
            case IF_EQZ: 
            case IF_NEZ: {
                this.verifyIfEqzNez(analyzedInstruction);
                return;
            }
            case IF_LTZ: 
            case IF_GEZ: 
            case IF_GTZ: 
            case IF_LEZ: {
                this.verifyIfz(analyzedInstruction);
                return;
            }
            case AGET: {
                this.verify32BitPrimitiveAget(analyzedInstruction, RegisterType.Category.Integer);
                return;
            }
            case AGET_BOOLEAN: {
                this.verify32BitPrimitiveAget(analyzedInstruction, RegisterType.Category.Boolean);
                return;
            }
            case AGET_BYTE: {
                this.verify32BitPrimitiveAget(analyzedInstruction, RegisterType.Category.Byte);
                return;
            }
            case AGET_CHAR: {
                this.verify32BitPrimitiveAget(analyzedInstruction, RegisterType.Category.Char);
                return;
            }
            case AGET_SHORT: {
                this.verify32BitPrimitiveAget(analyzedInstruction, RegisterType.Category.Short);
                return;
            }
            case AGET_WIDE: {
                this.verifyAgetWide(analyzedInstruction);
                return;
            }
            case AGET_OBJECT: {
                this.verifyAgetObject(analyzedInstruction);
                return;
            }
            case APUT: {
                this.verify32BitPrimitiveAput(analyzedInstruction, RegisterType.Category.Integer);
                return;
            }
            case APUT_BOOLEAN: {
                this.verify32BitPrimitiveAput(analyzedInstruction, RegisterType.Category.Boolean);
                return;
            }
            case APUT_BYTE: {
                this.verify32BitPrimitiveAput(analyzedInstruction, RegisterType.Category.Byte);
                return;
            }
            case APUT_CHAR: {
                this.verify32BitPrimitiveAput(analyzedInstruction, RegisterType.Category.Char);
                return;
            }
            case APUT_SHORT: {
                this.verify32BitPrimitiveAput(analyzedInstruction, RegisterType.Category.Short);
                return;
            }
            case APUT_WIDE: {
                this.verifyAputWide(analyzedInstruction);
                return;
            }
            case APUT_OBJECT: {
                this.verifyAputObject(analyzedInstruction);
                return;
            }
            case IGET: {
                this.verify32BitPrimitiveIget(analyzedInstruction, RegisterType.Category.Integer);
                return;
            }
            case IGET_BOOLEAN: {
                this.verify32BitPrimitiveIget(analyzedInstruction, RegisterType.Category.Boolean);
                return;
            }
            case IGET_BYTE: {
                this.verify32BitPrimitiveIget(analyzedInstruction, RegisterType.Category.Byte);
                return;
            }
            case IGET_CHAR: {
                this.verify32BitPrimitiveIget(analyzedInstruction, RegisterType.Category.Char);
                return;
            }
            case IGET_SHORT: {
                this.verify32BitPrimitiveIget(analyzedInstruction, RegisterType.Category.Short);
                return;
            }
            case IGET_WIDE: {
                this.verifyIgetWide(analyzedInstruction);
                return;
            }
            case IGET_OBJECT: {
                this.verifyIgetObject(analyzedInstruction);
                return;
            }
            case IPUT: {
                this.verify32BitPrimitiveIput(analyzedInstruction, RegisterType.Category.Integer);
                return;
            }
            case IPUT_BOOLEAN: {
                this.verify32BitPrimitiveIput(analyzedInstruction, RegisterType.Category.Boolean);
                return;
            }
            case IPUT_BYTE: {
                this.verify32BitPrimitiveIput(analyzedInstruction, RegisterType.Category.Byte);
                return;
            }
            case IPUT_CHAR: {
                this.verify32BitPrimitiveIput(analyzedInstruction, RegisterType.Category.Char);
                return;
            }
            case IPUT_SHORT: {
                this.verify32BitPrimitiveIput(analyzedInstruction, RegisterType.Category.Short);
                return;
            }
            case IPUT_WIDE: {
                this.verifyIputWide(analyzedInstruction);
                return;
            }
            case IPUT_OBJECT: {
                this.verifyIputObject(analyzedInstruction);
                return;
            }
            case SGET: {
                this.verify32BitPrimitiveSget(analyzedInstruction, RegisterType.Category.Integer);
                return;
            }
            case SGET_BOOLEAN: {
                this.verify32BitPrimitiveSget(analyzedInstruction, RegisterType.Category.Boolean);
                return;
            }
            case SGET_BYTE: {
                this.verify32BitPrimitiveSget(analyzedInstruction, RegisterType.Category.Byte);
                return;
            }
            case SGET_CHAR: {
                this.verify32BitPrimitiveSget(analyzedInstruction, RegisterType.Category.Char);
                return;
            }
            case SGET_SHORT: {
                this.verify32BitPrimitiveSget(analyzedInstruction, RegisterType.Category.Short);
                return;
            }
            case SGET_WIDE: {
                this.verifySgetWide(analyzedInstruction);
                return;
            }
            case SGET_OBJECT: {
                this.verifySgetObject(analyzedInstruction);
                return;
            }
            case SPUT: {
                this.verify32BitPrimitiveSput(analyzedInstruction, RegisterType.Category.Integer);
                return;
            }
            case SPUT_BOOLEAN: {
                this.verify32BitPrimitiveSput(analyzedInstruction, RegisterType.Category.Boolean);
                return;
            }
            case SPUT_BYTE: {
                this.verify32BitPrimitiveSput(analyzedInstruction, RegisterType.Category.Byte);
                return;
            }
            case SPUT_CHAR: {
                this.verify32BitPrimitiveSput(analyzedInstruction, RegisterType.Category.Char);
                return;
            }
            case SPUT_SHORT: {
                this.verify32BitPrimitiveSput(analyzedInstruction, RegisterType.Category.Short);
                return;
            }
            case SPUT_WIDE: {
                this.verifySputWide(analyzedInstruction);
                return;
            }
            case SPUT_OBJECT: {
                this.verifySputObject(analyzedInstruction);
                return;
            }
            case INVOKE_VIRTUAL: {
                this.verifyInvoke(analyzedInstruction, 1);
                return;
            }
            case INVOKE_SUPER: {
                this.verifyInvoke(analyzedInstruction, 2);
                return;
            }
            case INVOKE_DIRECT: {
                this.verifyInvoke(analyzedInstruction, 4);
                return;
            }
            case INVOKE_STATIC: {
                this.verifyInvoke(analyzedInstruction, 16);
                return;
            }
            case INVOKE_INTERFACE: {
                this.verifyInvoke(analyzedInstruction, 8);
                return;
            }
            case INVOKE_VIRTUAL_RANGE: {
                this.verifyInvokeRange(analyzedInstruction, 1);
                return;
            }
            case INVOKE_SUPER_RANGE: {
                this.verifyInvokeRange(analyzedInstruction, 2);
                return;
            }
            case INVOKE_DIRECT_RANGE: {
                this.verifyInvokeRange(analyzedInstruction, 4);
                return;
            }
            case INVOKE_STATIC_RANGE: {
                this.verifyInvokeRange(analyzedInstruction, 16);
                return;
            }
            case INVOKE_INTERFACE_RANGE: {
                this.verifyInvokeRange(analyzedInstruction, 8);
                return;
            }
            case NEG_INT: 
            case NOT_INT: {
                this.verifyUnaryOp(analyzedInstruction, Primitive32BitCategories);
                return;
            }
            case NEG_LONG: 
            case NOT_LONG: {
                this.verifyUnaryOp(analyzedInstruction, WideLowCategories);
                return;
            }
            case NEG_FLOAT: {
                this.verifyUnaryOp(analyzedInstruction, Primitive32BitCategories);
                return;
            }
            case NEG_DOUBLE: {
                this.verifyUnaryOp(analyzedInstruction, WideLowCategories);
                return;
            }
            case INT_TO_LONG: {
                this.verifyUnaryOp(analyzedInstruction, Primitive32BitCategories);
                return;
            }
            case INT_TO_FLOAT: {
                this.verifyUnaryOp(analyzedInstruction, Primitive32BitCategories);
                return;
            }
            case INT_TO_DOUBLE: {
                this.verifyUnaryOp(analyzedInstruction, Primitive32BitCategories);
                return;
            }
            case LONG_TO_INT: 
            case DOUBLE_TO_INT: {
                this.verifyUnaryOp(analyzedInstruction, WideLowCategories);
                return;
            }
            case LONG_TO_FLOAT: 
            case DOUBLE_TO_FLOAT: {
                this.verifyUnaryOp(analyzedInstruction, WideLowCategories);
                return;
            }
            case LONG_TO_DOUBLE: {
                this.verifyUnaryOp(analyzedInstruction, WideLowCategories);
                return;
            }
            case FLOAT_TO_INT: {
                this.verifyUnaryOp(analyzedInstruction, Primitive32BitCategories);
                return;
            }
            case FLOAT_TO_LONG: {
                this.verifyUnaryOp(analyzedInstruction, Primitive32BitCategories);
                return;
            }
            case FLOAT_TO_DOUBLE: {
                this.verifyUnaryOp(analyzedInstruction, Primitive32BitCategories);
                return;
            }
            case DOUBLE_TO_LONG: {
                this.verifyUnaryOp(analyzedInstruction, WideLowCategories);
                return;
            }
            case INT_TO_BYTE: {
                this.verifyUnaryOp(analyzedInstruction, Primitive32BitCategories);
                return;
            }
            case INT_TO_CHAR: {
                this.verifyUnaryOp(analyzedInstruction, Primitive32BitCategories);
                return;
            }
            case INT_TO_SHORT: {
                this.verifyUnaryOp(analyzedInstruction, Primitive32BitCategories);
                return;
            }
            case ADD_INT: 
            case SUB_INT: 
            case MUL_INT: 
            case DIV_INT: 
            case REM_INT: 
            case SHL_INT: 
            case SHR_INT: 
            case USHR_INT: 
            case AND_INT: 
            case OR_INT: 
            case XOR_INT: {
                this.verifyBinaryOp(analyzedInstruction, Primitive32BitCategories, Primitive32BitCategories);
                return;
            }
            case ADD_LONG: 
            case SUB_LONG: 
            case MUL_LONG: 
            case DIV_LONG: 
            case REM_LONG: 
            case AND_LONG: 
            case OR_LONG: 
            case XOR_LONG: {
                this.verifyBinaryOp(analyzedInstruction, WideLowCategories, WideLowCategories);
                return;
            }
            case SHL_LONG: 
            case SHR_LONG: 
            case USHR_LONG: {
                this.verifyBinaryOp(analyzedInstruction, WideLowCategories, Primitive32BitCategories);
                return;
            }
            case ADD_FLOAT: 
            case SUB_FLOAT: 
            case MUL_FLOAT: 
            case DIV_FLOAT: 
            case REM_FLOAT: {
                this.verifyBinaryOp(analyzedInstruction, Primitive32BitCategories, Primitive32BitCategories);
                return;
            }
            case ADD_DOUBLE: 
            case SUB_DOUBLE: 
            case MUL_DOUBLE: 
            case DIV_DOUBLE: 
            case REM_DOUBLE: {
                this.verifyBinaryOp(analyzedInstruction, WideLowCategories, WideLowCategories);
                return;
            }
            case ADD_INT_2ADDR: 
            case SUB_INT_2ADDR: 
            case MUL_INT_2ADDR: 
            case DIV_INT_2ADDR: 
            case REM_INT_2ADDR: 
            case SHL_INT_2ADDR: 
            case SHR_INT_2ADDR: 
            case USHR_INT_2ADDR: 
            case AND_INT_2ADDR: 
            case OR_INT_2ADDR: 
            case XOR_INT_2ADDR: {
                this.verifyBinary2AddrOp(analyzedInstruction, Primitive32BitCategories, Primitive32BitCategories);
                return;
            }
            case ADD_LONG_2ADDR: 
            case SUB_LONG_2ADDR: 
            case MUL_LONG_2ADDR: 
            case DIV_LONG_2ADDR: 
            case REM_LONG_2ADDR: 
            case AND_LONG_2ADDR: 
            case OR_LONG_2ADDR: 
            case XOR_LONG_2ADDR: {
                this.verifyBinary2AddrOp(analyzedInstruction, WideLowCategories, WideLowCategories);
                return;
            }
            case SHL_LONG_2ADDR: 
            case SHR_LONG_2ADDR: 
            case USHR_LONG_2ADDR: {
                this.verifyBinary2AddrOp(analyzedInstruction, WideLowCategories, Primitive32BitCategories);
                return;
            }
            case ADD_FLOAT_2ADDR: 
            case SUB_FLOAT_2ADDR: 
            case MUL_FLOAT_2ADDR: 
            case DIV_FLOAT_2ADDR: 
            case REM_FLOAT_2ADDR: {
                this.verifyBinary2AddrOp(analyzedInstruction, Primitive32BitCategories, Primitive32BitCategories);
                return;
            }
            case ADD_DOUBLE_2ADDR: 
            case SUB_DOUBLE_2ADDR: 
            case MUL_DOUBLE_2ADDR: 
            case DIV_DOUBLE_2ADDR: 
            case REM_DOUBLE_2ADDR: {
                this.verifyBinary2AddrOp(analyzedInstruction, WideLowCategories, WideLowCategories);
                return;
            }
            case ADD_INT_LIT16: 
            case RSUB_INT: 
            case MUL_INT_LIT16: 
            case DIV_INT_LIT16: 
            case REM_INT_LIT16: {
                this.verifyLiteralBinaryOp(analyzedInstruction);
                return;
            }
            case AND_INT_LIT16: 
            case OR_INT_LIT16: 
            case XOR_INT_LIT16: {
                this.verifyLiteralBinaryOp(analyzedInstruction);
                return;
            }
            case ADD_INT_LIT8: 
            case RSUB_INT_LIT8: 
            case MUL_INT_LIT8: 
            case DIV_INT_LIT8: 
            case REM_INT_LIT8: 
            case SHL_INT_LIT8: {
                this.verifyLiteralBinaryOp(analyzedInstruction);
                return;
            }
            case AND_INT_LIT8: 
            case OR_INT_LIT8: 
            case XOR_INT_LIT8: {
                this.verifyLiteralBinaryOp(analyzedInstruction);
                return;
            }
            case SHR_INT_LIT8: {
                this.verifyLiteralBinaryOp(analyzedInstruction);
                return;
            }
            case USHR_INT_LIT8: {
                this.verifyLiteralBinaryOp(analyzedInstruction);
                return;
            }
        }
        assert (false);
    }

    private void analyzeMove(AnalyzedInstruction analyzedInstruction) {
        TwoRegisterInstruction instruction = (TwoRegisterInstruction)((Object)analyzedInstruction.instruction);
        RegisterType sourceRegisterType = analyzedInstruction.getPreInstructionRegisterType(instruction.getRegisterB());
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, sourceRegisterType);
    }

    private void verifyMove(AnalyzedInstruction analyzedInstruction, EnumSet validCategories) {
        TwoRegisterInstruction instruction = (TwoRegisterInstruction)((Object)analyzedInstruction.instruction);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, instruction.getRegisterB(), validCategories);
    }

    private void analyzeMoveResult(AnalyzedInstruction analyzedInstruction) {
        RegisterType resultRegisterType;
        AnalyzedInstruction previousInstruction = this.instructions.valueAt(analyzedInstruction.instructionIndex - 1);
        if (!previousInstruction.instruction.opcode.setsResult()) {
            throw new ValidationException(analyzedInstruction.instruction.opcode.name + " must occur after an " + "invoke-*/fill-new-array instruction");
        }
        InstructionWithReference invokeInstruction = (InstructionWithReference)previousInstruction.instruction;
        Item item = invokeInstruction.getReferencedItem();
        if (item.getItemType() == ItemType.TYPE_METHOD_ID_ITEM) {
            resultRegisterType = RegisterType.getRegisterTypeForTypeIdItem(((MethodIdItem)item).getPrototype().getReturnType());
        } else {
            assert (item.getItemType() == ItemType.TYPE_TYPE_ID_ITEM);
            resultRegisterType = RegisterType.getRegisterTypeForTypeIdItem((TypeIdItem)item);
        }
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, resultRegisterType);
    }

    private void verifyMoveResult(AnalyzedInstruction analyzedInstruction, EnumSet<RegisterType.Category> allowedCategories) {
        RegisterType resultRegisterType;
        if (analyzedInstruction.instructionIndex == 0) {
            throw new ValidationException(analyzedInstruction.instruction.opcode.name + " cannot be the first " + "instruction in a method. It must occur after an invoke-*/fill-new-array instruction");
        }
        AnalyzedInstruction previousInstruction = this.instructions.valueAt(analyzedInstruction.instructionIndex - 1);
        if (!previousInstruction.instruction.opcode.setsResult()) {
            throw new ValidationException(analyzedInstruction.instruction.opcode.name + " must occur after an " + "invoke-*/fill-new-array instruction");
        }
        InstructionWithReference invokeInstruction = (InstructionWithReference)previousInstruction.getInstruction();
        Item item = invokeInstruction.getReferencedItem();
        if (item instanceof MethodIdItem) {
            resultRegisterType = RegisterType.getRegisterTypeForTypeIdItem(((MethodIdItem)item).getPrototype().getReturnType());
        } else {
            assert (item instanceof TypeIdItem);
            resultRegisterType = RegisterType.getRegisterTypeForTypeIdItem((TypeIdItem)item);
        }
        if (!allowedCategories.contains((Object)resultRegisterType.category)) {
            throw new ValidationException(String.format("Wrong move-result* instruction for return value %s", resultRegisterType.toString()));
        }
    }

    private void analyzeMoveException(AnalyzedInstruction analyzedInstruction) {
        CodeItem.TryItem[] tries = this.encodedMethod.codeItem.getTries();
        int instructionAddress = this.getInstructionAddress(analyzedInstruction);
        if (tries == null) {
            throw new ValidationException("move-exception must be the first instruction in an exception handler block");
        }
        RegisterType exceptionType = null;
        for (CodeItem.TryItem tryItem : this.encodedMethod.codeItem.getTries()) {
            if (tryItem.encodedCatchHandler.getCatchAllHandlerAddress() == instructionAddress) {
                exceptionType = RegisterType.getRegisterType(RegisterType.Category.Reference, ClassPath.getClassDef("Ljava/lang/Throwable;"));
                break;
            }
            for (CodeItem.EncodedTypeAddrPair handler : tryItem.encodedCatchHandler.handlers) {
                if (handler.getHandlerAddress() != instructionAddress) continue;
                exceptionType = RegisterType.getRegisterTypeForTypeIdItem(handler.exceptionType).merge(exceptionType);
            }
        }
        if (exceptionType == null) {
            throw new ValidationException("move-exception must be the first instruction in an exception handler block");
        }
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, exceptionType);
    }

    private void verifyMoveException(AnalyzedInstruction analyzedInstruction) {
        CodeItem.TryItem[] tries = this.encodedMethod.codeItem.getTries();
        int instructionAddress = this.getInstructionAddress(analyzedInstruction);
        if (tries == null) {
            throw new ValidationException("move-exception must be the first instruction in an exception handler block");
        }
        RegisterType exceptionType = null;
        for (CodeItem.TryItem tryItem : this.encodedMethod.codeItem.getTries()) {
            if (tryItem.encodedCatchHandler.getCatchAllHandlerAddress() == instructionAddress) {
                exceptionType = RegisterType.getRegisterType(RegisterType.Category.Reference, ClassPath.getClassDef("Ljava/lang/Throwable;"));
                break;
            }
            for (CodeItem.EncodedTypeAddrPair handler : tryItem.encodedCatchHandler.handlers) {
                if (handler.getHandlerAddress() != instructionAddress) continue;
                exceptionType = RegisterType.getRegisterTypeForTypeIdItem(handler.exceptionType).merge(exceptionType);
            }
        }
        if (exceptionType == null) {
            throw new ValidationException("move-exception must be the first instruction in an exception handler block");
        }
        if (exceptionType.category != RegisterType.Category.Reference) {
            throw new ValidationException(String.format("Exception type %s is not a reference type", exceptionType.toString()));
        }
    }

    private void verifyReturnVoid(AnalyzedInstruction analyzedInstruction) {
        TypeIdItem returnType = this.encodedMethod.method.getPrototype().getReturnType();
        if (returnType.getTypeDescriptor().charAt(0) != 'V') {
            throw new ValidationException("Cannot use return-void with a non-void return type (" + returnType.getTypeDescriptor() + ")");
        }
    }

    private void verifyReturn(AnalyzedInstruction analyzedInstruction, EnumSet validCategories) {
        SingleRegisterInstruction instruction = (SingleRegisterInstruction)((Object)analyzedInstruction.instruction);
        int returnRegister = instruction.getRegisterA();
        RegisterType returnRegisterType = MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, returnRegister, validCategories);
        TypeIdItem returnType = this.encodedMethod.method.getPrototype().getReturnType();
        if (returnType.getTypeDescriptor().charAt(0) == 'V') {
            throw new ValidationException("Cannot use return with a void return type. Use return-void instead");
        }
        RegisterType methodReturnRegisterType = RegisterType.getRegisterTypeForTypeIdItem(returnType);
        if (!validCategories.contains((Object)methodReturnRegisterType.category)) {
            throw new ValidationException(String.format("Cannot use %s with return type %s", analyzedInstruction.instruction.opcode.name, returnType.getTypeDescriptor()));
        }
        if (validCategories == ReferenceCategories) {
            if (methodReturnRegisterType.type.isInterface()) {
                if (returnRegisterType.category != RegisterType.Category.Null && !returnRegisterType.type.implementsInterface(methodReturnRegisterType.type)) {
                    // empty if block
                }
            } else if (returnRegisterType.category == RegisterType.Category.Reference && !returnRegisterType.type.extendsClass(methodReturnRegisterType.type)) {
                throw new ValidationException(String.format("The return value in register v%d (%s) is not compatible with the method's return type %s", returnRegister, returnRegisterType.type.getClassType(), methodReturnRegisterType.type.getClassType()));
            }
        }
    }

    private void analyzeConst(AnalyzedInstruction analyzedInstruction) {
        LiteralInstruction instruction = (LiteralInstruction)((Object)analyzedInstruction.instruction);
        RegisterType newDestinationRegisterType = RegisterType.getRegisterTypeForLiteral(instruction.getLiteral());
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, newDestinationRegisterType);
    }

    private void analyzeConstHigh16(AnalyzedInstruction analyzedInstruction) {
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.getRegisterType(RegisterType.Category.Integer, null));
    }

    private void analyzeWideConst(AnalyzedInstruction analyzedInstruction) {
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.getRegisterType(RegisterType.Category.LongLo, null));
    }

    private void analyzeConstString(AnalyzedInstruction analyzedInstruction) {
        ClassPath.ClassDef stringClassDef = ClassPath.getClassDef("Ljava/lang/String;");
        RegisterType stringType = RegisterType.getRegisterType(RegisterType.Category.Reference, stringClassDef);
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, stringType);
    }

    private void analyzeConstClass(AnalyzedInstruction analyzedInstruction) {
        ClassPath.ClassDef classClassDef = ClassPath.getClassDef("Ljava/lang/Class;");
        RegisterType classType = RegisterType.getRegisterType(RegisterType.Category.Reference, classClassDef);
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, classType);
    }

    private void verifyConstClass(AnalyzedInstruction analyzedInstruction) {
        ClassPath.ClassDef classClassDef = ClassPath.getClassDef("Ljava/lang/Class;");
        RegisterType classType = RegisterType.getRegisterType(RegisterType.Category.Reference, classClassDef);
        InstructionWithReference instruction = (InstructionWithReference)analyzedInstruction.instruction;
        Item item = instruction.getReferencedItem();
        assert (item.getItemType() == ItemType.TYPE_TYPE_ID_ITEM);
        ClassPath.getClassDef((TypeIdItem)item);
    }

    private void verifyMonitor(AnalyzedInstruction analyzedInstruction) {
        SingleRegisterInstruction instruction = (SingleRegisterInstruction)((Object)analyzedInstruction.instruction);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, instruction.getRegisterA(), ReferenceCategories);
    }

    private void analyzeCheckCast(AnalyzedInstruction analyzedInstruction) {
        InstructionWithReference instruction = (InstructionWithReference)analyzedInstruction.instruction;
        Item item = instruction.getReferencedItem();
        assert (item.getItemType() == ItemType.TYPE_TYPE_ID_ITEM);
        RegisterType castRegisterType = RegisterType.getRegisterTypeForTypeIdItem((TypeIdItem)item);
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, castRegisterType);
    }

    private void verifyCheckCast(AnalyzedInstruction analyzedInstruction) {
        Object instruction = (SingleRegisterInstruction)((Object)analyzedInstruction.instruction);
        RegisterType registerType = MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, instruction.getRegisterA(), ReferenceCategories);
        instruction = (InstructionWithReference)analyzedInstruction.instruction;
        Item item = ((InstructionWithReference)instruction).getReferencedItem();
        assert (item.getItemType() == ItemType.TYPE_TYPE_ID_ITEM);
        RegisterType castRegisterType = RegisterType.getRegisterTypeForTypeIdItem((TypeIdItem)item);
        if (castRegisterType.category != RegisterType.Category.Reference) {
            // empty if block
        }
    }

    private void analyzeInstanceOf(AnalyzedInstruction analyzedInstruction) {
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.getRegisterType(RegisterType.Category.Boolean, null));
    }

    private void verifyInstanceOf(AnalyzedInstruction analyzedInstruction) {
        Object instruction = (TwoRegisterInstruction)((Object)analyzedInstruction.instruction);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, instruction.getRegisterB(), ReferenceCategories);
        instruction = (InstructionWithReference)analyzedInstruction.instruction;
        Item item = ((InstructionWithReference)instruction).getReferencedItem();
        assert (item.getItemType() == ItemType.TYPE_TYPE_ID_ITEM);
        RegisterType registerType = RegisterType.getRegisterTypeForTypeIdItem((TypeIdItem)item);
        if (registerType.category != RegisterType.Category.Reference) {
            throw new ValidationException(String.format("Cannot use instance-of with a non-reference type %s", registerType.toString()));
        }
    }

    private void analyzeArrayLength(AnalyzedInstruction analyzedInstruction) {
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.getRegisterType(RegisterType.Category.Integer, null));
    }

    private void verifyArrayLength(AnalyzedInstruction analyzedInstruction) {
        TwoRegisterInstruction instruction = (TwoRegisterInstruction)((Object)analyzedInstruction.instruction);
        int arrayRegisterNumber = instruction.getRegisterB();
        RegisterType arrayRegisterType = MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, arrayRegisterNumber, ReferenceCategories);
        if (arrayRegisterType.type != null) {
            if (arrayRegisterType.type.getClassType().charAt(0) != '[') {
                throw new ValidationException(String.format("Cannot use array-length with non-array type %s", arrayRegisterType.type.getClassType()));
            }
            assert (arrayRegisterType.type instanceof ClassPath.ArrayClassDef);
        }
    }

    private void analyzeNewInstance(AnalyzedInstruction analyzedInstruction) {
        InstructionWithReference instruction = (InstructionWithReference)analyzedInstruction.instruction;
        int register = ((SingleRegisterInstruction)((Object)analyzedInstruction.instruction)).getRegisterA();
        RegisterType destRegisterType = analyzedInstruction.getPostInstructionRegisterType(register);
        if (destRegisterType.category != RegisterType.Category.Unknown) {
            assert (destRegisterType.category == RegisterType.Category.UninitRef);
            return;
        }
        Item item = instruction.getReferencedItem();
        assert (item.getItemType() == ItemType.TYPE_TYPE_ID_ITEM);
        RegisterType classType = RegisterType.getRegisterTypeForTypeIdItem((TypeIdItem)item);
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.getUnitializedReference(classType.type));
    }

    private void verifyNewInstance(AnalyzedInstruction analyzedInstruction) {
        InstructionWithReference instruction = (InstructionWithReference)analyzedInstruction.instruction;
        int register = ((SingleRegisterInstruction)((Object)analyzedInstruction.instruction)).getRegisterA();
        RegisterType destRegisterType = analyzedInstruction.postRegisterMap[register];
        if (destRegisterType.category != RegisterType.Category.Unknown) {
            assert (destRegisterType.category == RegisterType.Category.UninitRef);
            for (int i = 0; i < analyzedInstruction.postRegisterMap.length; ++i) {
                if (i == register || analyzedInstruction.getPreInstructionRegisterType(i) != destRegisterType) continue;
                throw new ValidationException(String.format("Register v%d contains an uninitialized reference that was created by this new-instance instruction.", i));
            }
            return;
        }
        Item item = instruction.getReferencedItem();
        assert (item.getItemType() == ItemType.TYPE_TYPE_ID_ITEM);
        RegisterType classType = RegisterType.getRegisterTypeForTypeIdItem((TypeIdItem)item);
        if (classType.category != RegisterType.Category.Reference) {
            throw new ValidationException(String.format("Cannot use new-instance with a non-reference type %s", classType.toString()));
        }
        if (((TypeIdItem)item).getTypeDescriptor().charAt(0) == '[') {
            throw new ValidationException("Cannot use array type \"" + ((TypeIdItem)item).getTypeDescriptor() + "\" with new-instance. Use new-array instead.");
        }
    }

    private void analyzeNewArray(AnalyzedInstruction analyzedInstruction) {
        InstructionWithReference instruction = (InstructionWithReference)analyzedInstruction.instruction;
        Item item = instruction.getReferencedItem();
        assert (item.getItemType() == ItemType.TYPE_TYPE_ID_ITEM);
        RegisterType arrayType = RegisterType.getRegisterTypeForTypeIdItem((TypeIdItem)item);
        assert (arrayType.type instanceof ClassPath.ArrayClassDef);
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, arrayType);
    }

    private void verifyNewArray(AnalyzedInstruction analyzedInstruction) {
        Object instruction = (TwoRegisterInstruction)((Object)analyzedInstruction.instruction);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, instruction.getRegisterB(), Primitive32BitCategories);
        instruction = (InstructionWithReference)analyzedInstruction.instruction;
        Item item = ((InstructionWithReference)instruction).getReferencedItem();
        assert (item.getItemType() == ItemType.TYPE_TYPE_ID_ITEM);
        RegisterType arrayType = RegisterType.getRegisterTypeForTypeIdItem((TypeIdItem)item);
        assert (arrayType.type instanceof ClassPath.ArrayClassDef);
        if (arrayType.category != RegisterType.Category.Reference) {
            throw new ValidationException(String.format("Cannot use new-array with a non-reference type %s", arrayType.toString()));
        }
        if (arrayType.type.getClassType().charAt(0) != '[') {
            throw new ValidationException("Cannot use non-array type \"" + arrayType.type.getClassType() + "\" with new-array. Use new-instance instead.");
        }
    }

    private void verifyFilledNewArrayCommon(AnalyzedInstruction analyzedInstruction, RegisterIterator registerIterator) {
        InstructionWithReference instruction = (InstructionWithReference)analyzedInstruction.instruction;
        Item item = instruction.getReferencedItem();
        assert (item.getItemType() == ItemType.TYPE_TYPE_ID_ITEM);
        ClassPath.ClassDef classDef = ClassPath.getClassDef((TypeIdItem)item);
        if (classDef.getClassType().charAt(0) != '[') {
            throw new ValidationException("Cannot use non-array type \"" + classDef.getClassType() + "\" with new-array. Use new-instance instead.");
        }
        ClassPath.ArrayClassDef arrayClassDef = (ClassPath.ArrayClassDef)classDef;
        RegisterType arrayType = RegisterType.getRegisterType(RegisterType.Category.Reference, classDef);
        RegisterType arrayImmediateElementType = RegisterType.getRegisterTypeForType(arrayClassDef.getImmediateElementClass().getClassType());
        String baseElementType = arrayClassDef.getBaseElementClass().getClassType();
        if (baseElementType.charAt(0) == 'J' || baseElementType.charAt(0) == 'D') {
            throw new ValidationException("Cannot use filled-new-array to create an array of wide values (long or double)");
        }
        do {
            int register = registerIterator.getRegister();
            RegisterType elementType = analyzedInstruction.getPreInstructionRegisterType(register);
            assert (elementType != null);
            if (elementType.canBeAssignedTo(arrayImmediateElementType)) continue;
            throw new ValidationException("Register v" + Integer.toString(register) + " is of type " + elementType.toString() + " and is incompatible with the array type " + arrayType.type.getClassType());
        } while (registerIterator.moveNext());
    }

    private void verifyFilledNewArray(AnalyzedInstruction analyzedInstruction) {
        FiveRegisterInstruction instruction = (FiveRegisterInstruction)((Object)analyzedInstruction.instruction);
        this.verifyFilledNewArrayCommon(analyzedInstruction, new Format35cRegisterIterator(instruction));
    }

    private void verifyFilledNewArrayRange(AnalyzedInstruction analyzedInstruction) {
        RegisterRangeInstruction instruction = (RegisterRangeInstruction)((Object)analyzedInstruction.instruction);
        if (instruction.getStartRegister() + instruction.getRegCount() >= 65536) {
            throw new ValidationException(String.format("Invalid register range {v%d .. v%d}. The ending register is larger than the largest allowed register of v65535.", instruction.getStartRegister(), instruction.getStartRegister() + instruction.getRegCount() - 1));
        }
        this.verifyFilledNewArrayCommon(analyzedInstruction, new Format3rcRegisterIterator(instruction));
    }

    private void verifyFillArrayData(AnalyzedInstruction analyzedInstruction) {
        int elementWidth;
        SingleRegisterInstruction instruction = (SingleRegisterInstruction)((Object)analyzedInstruction.instruction);
        int register = instruction.getRegisterA();
        RegisterType registerType = analyzedInstruction.getPreInstructionRegisterType(register);
        assert (registerType != null);
        if (registerType.category == RegisterType.Category.Null) {
            return;
        }
        if (registerType.category != RegisterType.Category.Reference) {
            throw new ValidationException(String.format("Cannot use fill-array-data with non-array register v%d of type %s", register, registerType.toString()));
        }
        assert (registerType.type instanceof ClassPath.ArrayClassDef);
        ClassPath.ArrayClassDef arrayClassDef = (ClassPath.ArrayClassDef)registerType.type;
        if (arrayClassDef.getArrayDimensions() != 1) {
            throw new ValidationException(String.format("Cannot use fill-array-data with array type %s. It can only be used with a one-dimensional array of primitives.", arrayClassDef.getClassType()));
        }
        switch (arrayClassDef.getBaseElementClass().getClassType().charAt(0)) {
            case 'B': 
            case 'Z': {
                elementWidth = 1;
                break;
            }
            case 'C': 
            case 'S': {
                elementWidth = 2;
                break;
            }
            case 'F': 
            case 'I': {
                elementWidth = 4;
                break;
            }
            case 'D': 
            case 'J': {
                elementWidth = 8;
                break;
            }
            default: {
                throw new ValidationException(String.format("Cannot use fill-array-data with array type %s. It can only be used with a one-dimensional array of primitives.", arrayClassDef.getClassType()));
            }
        }
        int arrayDataAddressOffset = ((OffsetInstruction)((Object)analyzedInstruction.instruction)).getTargetAddressOffset();
        int arrayDataCodeAddress = this.getInstructionAddress(analyzedInstruction) + arrayDataAddressOffset;
        AnalyzedInstruction arrayDataInstruction = this.instructions.get(arrayDataCodeAddress);
        if (arrayDataInstruction == null || arrayDataInstruction.instruction.getFormat() != Format.ArrayData) {
            throw new ValidationException(String.format("Could not find an array data structure at code address 0x%x", arrayDataCodeAddress));
        }
        ArrayDataPseudoInstruction arrayDataPseudoInstruction = (ArrayDataPseudoInstruction)arrayDataInstruction.instruction;
        if (elementWidth != arrayDataPseudoInstruction.getElementWidth()) {
            throw new ValidationException(String.format("The array data at code address 0x%x does not have the correct element width for array type %s. Expecting element width %d, got element width %d.", arrayDataCodeAddress, arrayClassDef.getClassType(), elementWidth, arrayDataPseudoInstruction.getElementWidth()));
        }
    }

    private void verifyThrow(AnalyzedInstruction analyzedInstruction) {
        int register = ((SingleRegisterInstruction)((Object)analyzedInstruction.instruction)).getRegisterA();
        RegisterType registerType = analyzedInstruction.getPreInstructionRegisterType(register);
        assert (registerType != null);
        if (registerType.category == RegisterType.Category.Null) {
            return;
        }
        if (registerType.category != RegisterType.Category.Reference) {
            throw new ValidationException(String.format("Cannot use throw with non-reference type %s in register v%d", registerType.toString(), register));
        }
        assert (registerType.type != null);
        if (!registerType.type.extendsClass(ClassPath.getClassDef("Ljava/lang/Throwable;"))) {
            throw new ValidationException(String.format("Cannot use throw with non-throwable type %s in register v%d", registerType.type.getClassType(), register));
        }
    }

    private void analyzeArrayDataOrSwitch(AnalyzedInstruction analyzedInstruction) {
        int dataAddressOffset = ((OffsetInstruction)((Object)analyzedInstruction.instruction)).getTargetAddressOffset();
        int dataCodeAddress = this.getInstructionAddress(analyzedInstruction) + dataAddressOffset;
        AnalyzedInstruction dataAnalyzedInstruction = this.instructions.get(dataCodeAddress);
        if (dataAnalyzedInstruction != null) {
            dataAnalyzedInstruction.dead = false;
            AnalyzedInstruction priorInstruction = this.instructions.valueAt(dataAnalyzedInstruction.getInstructionIndex() - 1);
            if (priorInstruction.getInstruction().opcode == Opcode.NOP && !priorInstruction.getInstruction().getFormat().variableSizeFormat) {
                priorInstruction.dead = false;
            }
        }
    }

    private void verifySwitch(AnalyzedInstruction analyzedInstruction, Format expectedSwitchDataFormat) {
        int register = ((SingleRegisterInstruction)((Object)analyzedInstruction.instruction)).getRegisterA();
        int switchCodeAddressOffset = ((OffsetInstruction)((Object)analyzedInstruction.instruction)).getTargetAddressOffset();
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, register, Primitive32BitCategories);
        int switchDataCodeAddress = this.getInstructionAddress(analyzedInstruction) + switchCodeAddressOffset;
        AnalyzedInstruction switchDataAnalyzedInstruction = this.instructions.get(switchDataCodeAddress);
        if (switchDataAnalyzedInstruction == null || switchDataAnalyzedInstruction.instruction.getFormat() != expectedSwitchDataFormat) {
            throw new ValidationException(String.format("There is no %s structure at code address 0x%x", expectedSwitchDataFormat.name(), switchDataCodeAddress));
        }
    }

    private void analyzeFloatWideCmp(AnalyzedInstruction analyzedInstruction) {
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.getRegisterType(RegisterType.Category.Byte, null));
    }

    private void verifyFloatWideCmp(AnalyzedInstruction analyzedInstruction, EnumSet validCategories) {
        ThreeRegisterInstruction instruction = (ThreeRegisterInstruction)((Object)analyzedInstruction.instruction);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, instruction.getRegisterB(), validCategories);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, instruction.getRegisterC(), validCategories);
    }

    private void verifyIfEqNe(AnalyzedInstruction analyzedInstruction) {
        TwoRegisterInstruction instruction = (TwoRegisterInstruction)((Object)analyzedInstruction.instruction);
        RegisterType registerType1 = analyzedInstruction.getPreInstructionRegisterType(instruction.getRegisterA());
        assert (registerType1 != null);
        RegisterType registerType2 = analyzedInstruction.getPreInstructionRegisterType(instruction.getRegisterB());
        assert (registerType2 != null);
        if (!(ReferenceCategories.contains((Object)registerType1.category) && ReferenceCategories.contains((Object)registerType2.category) || Primitive32BitCategories.contains((Object)registerType1.category) && Primitive32BitCategories.contains((Object)registerType2.category))) {
            throw new ValidationException(String.format("%s cannot be used on registers of dissimilar types %s and %s. They must both be a reference type or a primitive 32 bit type.", analyzedInstruction.instruction.opcode.name, registerType1.toString(), registerType2.toString()));
        }
    }

    private void verifyIf(AnalyzedInstruction analyzedInstruction) {
        TwoRegisterInstruction instruction = (TwoRegisterInstruction)((Object)analyzedInstruction.instruction);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, instruction.getRegisterA(), Primitive32BitCategories);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, instruction.getRegisterB(), Primitive32BitCategories);
    }

    private void verifyIfEqzNez(AnalyzedInstruction analyzedInstruction) {
        SingleRegisterInstruction instruction = (SingleRegisterInstruction)((Object)analyzedInstruction.instruction);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, instruction.getRegisterA(), ReferenceAndPrimitive32BitCategories);
    }

    private void verifyIfz(AnalyzedInstruction analyzedInstruction) {
        SingleRegisterInstruction instruction = (SingleRegisterInstruction)((Object)analyzedInstruction.instruction);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, instruction.getRegisterA(), Primitive32BitCategories);
    }

    private void analyze32BitPrimitiveAget(AnalyzedInstruction analyzedInstruction, RegisterType.Category instructionCategory) {
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.getRegisterType(instructionCategory, null));
    }

    private void verify32BitPrimitiveAget(AnalyzedInstruction analyzedInstruction, RegisterType.Category instructionCategory) {
        ThreeRegisterInstruction instruction = (ThreeRegisterInstruction)((Object)analyzedInstruction.instruction);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, instruction.getRegisterC(), Primitive32BitCategories);
        RegisterType arrayRegisterType = analyzedInstruction.getPreInstructionRegisterType(instruction.getRegisterB());
        assert (arrayRegisterType != null);
        if (arrayRegisterType.category != RegisterType.Category.Null) {
            if (arrayRegisterType.category != RegisterType.Category.Reference) {
                throw new ValidationException(String.format("Cannot use %s with non-array type %s", analyzedInstruction.instruction.opcode.name, arrayRegisterType.category.toString()));
            }
            assert (arrayRegisterType.type != null);
            if (arrayRegisterType.type.getClassType().charAt(0) != '[') {
                throw new ValidationException(String.format("Cannot use %s with non-array type %s", analyzedInstruction.instruction.opcode.name, arrayRegisterType.type.getClassType()));
            }
            assert (arrayRegisterType.type instanceof ClassPath.ArrayClassDef);
            ClassPath.ArrayClassDef arrayClassDef = (ClassPath.ArrayClassDef)arrayRegisterType.type;
            if (arrayClassDef.getArrayDimensions() != 1) {
                throw new ValidationException(String.format("Cannot use %s with multi-dimensional array type %s", analyzedInstruction.instruction.opcode.name, arrayRegisterType.type.getClassType()));
            }
            RegisterType arrayBaseType = RegisterType.getRegisterTypeForType(arrayClassDef.getBaseElementClass().getClassType());
            if (!MethodAnalyzer.checkArrayFieldAssignment(arrayBaseType.category, instructionCategory)) {
                throw new ValidationException(String.format("Cannot use %s with array type %s. Incorrect array type for the instruction.", analyzedInstruction.instruction.opcode.name, arrayRegisterType.type.getClassType()));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void analyzeAgetWide(AnalyzedInstruction analyzedInstruction) {
        ThreeRegisterInstruction instruction = (ThreeRegisterInstruction)((Object)analyzedInstruction.instruction);
        RegisterType arrayRegisterType = analyzedInstruction.getPreInstructionRegisterType(instruction.getRegisterB());
        assert (arrayRegisterType != null);
        if (arrayRegisterType.category != RegisterType.Category.Null) {
            assert (arrayRegisterType.type != null);
            if (arrayRegisterType.type.getClassType().charAt(0) != '[') {
                throw new ValidationException(String.format("Cannot use aget-wide with non-array type %s", arrayRegisterType.type.getClassType()));
            }
            assert (arrayRegisterType.type instanceof ClassPath.ArrayClassDef);
            ClassPath.ArrayClassDef arrayClassDef = (ClassPath.ArrayClassDef)arrayRegisterType.type;
            char arrayBaseType = arrayClassDef.getBaseElementClass().getClassType().charAt(0);
            if (arrayBaseType == 'J') {
                this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.getRegisterType(RegisterType.Category.LongLo, null));
                return;
            } else {
                if (arrayBaseType != 'D') throw new ValidationException(String.format("Cannot use aget-wide with array type %s. Incorrect array type for the instruction.", arrayRegisterType.type.getClassType()));
                this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.getRegisterType(RegisterType.Category.DoubleLo, null));
            }
            return;
        } else {
            this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.getRegisterType(RegisterType.Category.LongLo, null));
        }
    }

    private void verifyAgetWide(AnalyzedInstruction analyzedInstruction) {
        ThreeRegisterInstruction instruction = (ThreeRegisterInstruction)((Object)analyzedInstruction.instruction);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, instruction.getRegisterC(), Primitive32BitCategories);
        RegisterType arrayRegisterType = analyzedInstruction.getPreInstructionRegisterType(instruction.getRegisterB());
        assert (arrayRegisterType != null);
        if (arrayRegisterType.category != RegisterType.Category.Null) {
            if (arrayRegisterType.category != RegisterType.Category.Reference) {
                throw new ValidationException(String.format("Cannot use aget-wide with non-array type %s", arrayRegisterType.category.toString()));
            }
            assert (arrayRegisterType.type != null);
            if (arrayRegisterType.type.getClassType().charAt(0) != '[') {
                throw new ValidationException(String.format("Cannot use aget-wide with non-array type %s", arrayRegisterType.type.getClassType()));
            }
            assert (arrayRegisterType.type instanceof ClassPath.ArrayClassDef);
            ClassPath.ArrayClassDef arrayClassDef = (ClassPath.ArrayClassDef)arrayRegisterType.type;
            if (arrayClassDef.getArrayDimensions() != 1) {
                throw new ValidationException(String.format("Cannot use aget-wide with multi-dimensional array type %s", arrayRegisterType.type.getClassType()));
            }
            char arrayBaseType = arrayClassDef.getBaseElementClass().getClassType().charAt(0);
            if (arrayBaseType != 'J' && arrayBaseType != 'D') {
                throw new ValidationException(String.format("Cannot use aget-wide with array type %s. Incorrect array type for the instruction.", arrayRegisterType.type.getClassType()));
            }
        }
    }

    private void analyzeAgetObject(AnalyzedInstruction analyzedInstruction) {
        ThreeRegisterInstruction instruction = (ThreeRegisterInstruction)((Object)analyzedInstruction.instruction);
        RegisterType arrayRegisterType = analyzedInstruction.getPreInstructionRegisterType(instruction.getRegisterB());
        assert (arrayRegisterType != null);
        if (arrayRegisterType.category != RegisterType.Category.Null) {
            assert (arrayRegisterType.type != null);
            if (arrayRegisterType.type.getClassType().charAt(0) != '[') {
                throw new ValidationException(String.format("Cannot use aget-object with non-array type %s", arrayRegisterType.type.getClassType()));
            }
            assert (arrayRegisterType.type instanceof ClassPath.ArrayClassDef);
            ClassPath.ArrayClassDef arrayClassDef = (ClassPath.ArrayClassDef)arrayRegisterType.type;
            ClassPath.ClassDef elementClassDef = arrayClassDef.getImmediateElementClass();
            char elementTypePrefix = elementClassDef.getClassType().charAt(0);
            if (elementTypePrefix != 'L' && elementTypePrefix != '[') {
                throw new ValidationException(String.format("Cannot use aget-object with array type %s. Incorrect array type for the instruction.", arrayRegisterType.type.getClassType()));
            }
            this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.getRegisterType(RegisterType.Category.Reference, elementClassDef));
        } else {
            this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.getRegisterType(RegisterType.Category.Null, null));
        }
    }

    private void verifyAgetObject(AnalyzedInstruction analyzedInstruction) {
        ThreeRegisterInstruction instruction = (ThreeRegisterInstruction)((Object)analyzedInstruction.instruction);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, instruction.getRegisterC(), Primitive32BitCategories);
        RegisterType arrayRegisterType = analyzedInstruction.getPreInstructionRegisterType(instruction.getRegisterB());
        assert (arrayRegisterType != null);
        if (arrayRegisterType.category != RegisterType.Category.Null) {
            if (arrayRegisterType.category != RegisterType.Category.Reference) {
                throw new ValidationException(String.format("Cannot use aget-object with non-array type %s", arrayRegisterType.category.toString()));
            }
            assert (arrayRegisterType.type != null);
            if (arrayRegisterType.type.getClassType().charAt(0) != '[') {
                throw new ValidationException(String.format("Cannot use aget-object with non-array type %s", arrayRegisterType.type.getClassType()));
            }
            assert (arrayRegisterType.type instanceof ClassPath.ArrayClassDef);
            ClassPath.ArrayClassDef arrayClassDef = (ClassPath.ArrayClassDef)arrayRegisterType.type;
            ClassPath.ClassDef elementClassDef = arrayClassDef.getImmediateElementClass();
            char elementTypePrefix = elementClassDef.getClassType().charAt(0);
            if (elementTypePrefix != 'L' && elementTypePrefix != '[') {
                throw new ValidationException(String.format("Cannot use aget-object with array type %s. Incorrect array type for the instruction.", arrayRegisterType.type.getClassType()));
            }
        }
    }

    private void verify32BitPrimitiveAput(AnalyzedInstruction analyzedInstruction, RegisterType.Category instructionCategory) {
        ThreeRegisterInstruction instruction = (ThreeRegisterInstruction)((Object)analyzedInstruction.instruction);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, instruction.getRegisterC(), Primitive32BitCategories);
        RegisterType sourceRegisterType = analyzedInstruction.getPreInstructionRegisterType(instruction.getRegisterA());
        assert (sourceRegisterType != null);
        RegisterType instructionRegisterType = RegisterType.getRegisterType(instructionCategory, null);
        if (!sourceRegisterType.canBeAssignedTo(instructionRegisterType)) {
            throw new ValidationException(String.format("Cannot use %s with source register type %s.", analyzedInstruction.instruction.opcode.name, sourceRegisterType.toString()));
        }
        RegisterType arrayRegisterType = analyzedInstruction.getPreInstructionRegisterType(instruction.getRegisterB());
        assert (arrayRegisterType != null);
        if (arrayRegisterType.category != RegisterType.Category.Null) {
            if (arrayRegisterType.category != RegisterType.Category.Reference) {
                throw new ValidationException(String.format("Cannot use %s with non-array type %s", analyzedInstruction.instruction.opcode.name, arrayRegisterType.category.toString()));
            }
            assert (arrayRegisterType.type != null);
            if (arrayRegisterType.type.getClassType().charAt(0) != '[') {
                throw new ValidationException(String.format("Cannot use %s with non-array type %s", analyzedInstruction.instruction.opcode.name, arrayRegisterType.type.getClassType()));
            }
            assert (arrayRegisterType.type instanceof ClassPath.ArrayClassDef);
            ClassPath.ArrayClassDef arrayClassDef = (ClassPath.ArrayClassDef)arrayRegisterType.type;
            if (arrayClassDef.getArrayDimensions() != 1) {
                throw new ValidationException(String.format("Cannot use %s with multi-dimensional array type %s", analyzedInstruction.instruction.opcode.name, arrayRegisterType.type.getClassType()));
            }
            RegisterType arrayBaseType = RegisterType.getRegisterTypeForType(arrayClassDef.getBaseElementClass().getClassType());
            if (!MethodAnalyzer.checkArrayFieldAssignment(arrayBaseType.category, instructionCategory)) {
                throw new ValidationException(String.format("Cannot use %s with array type %s. Incorrect array type for the instruction.", analyzedInstruction.instruction.opcode.name, arrayRegisterType.type.getClassType()));
            }
        }
    }

    private void verifyAputWide(AnalyzedInstruction analyzedInstruction) {
        ThreeRegisterInstruction instruction = (ThreeRegisterInstruction)((Object)analyzedInstruction.instruction);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, instruction.getRegisterC(), Primitive32BitCategories);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, instruction.getRegisterA(), WideLowCategories);
        RegisterType arrayRegisterType = analyzedInstruction.getPreInstructionRegisterType(instruction.getRegisterB());
        assert (arrayRegisterType != null);
        if (arrayRegisterType.category != RegisterType.Category.Null) {
            if (arrayRegisterType.category != RegisterType.Category.Reference) {
                throw new ValidationException(String.format("Cannot use aput-wide with non-array type %s", arrayRegisterType.category.toString()));
            }
            assert (arrayRegisterType.type != null);
            if (arrayRegisterType.type.getClassType().charAt(0) != '[') {
                throw new ValidationException(String.format("Cannot use aput-wide with non-array type %s", arrayRegisterType.type.getClassType()));
            }
            assert (arrayRegisterType.type instanceof ClassPath.ArrayClassDef);
            ClassPath.ArrayClassDef arrayClassDef = (ClassPath.ArrayClassDef)arrayRegisterType.type;
            if (arrayClassDef.getArrayDimensions() != 1) {
                throw new ValidationException(String.format("Cannot use aput-wide with multi-dimensional array type %s", arrayRegisterType.type.getClassType()));
            }
            char arrayBaseType = arrayClassDef.getBaseElementClass().getClassType().charAt(0);
            if (arrayBaseType != 'J' && arrayBaseType != 'D') {
                throw new ValidationException(String.format("Cannot use aput-wide with array type %s. Incorrect array type for the instruction.", arrayRegisterType.type.getClassType()));
            }
        }
    }

    private void verifyAputObject(AnalyzedInstruction analyzedInstruction) {
        ThreeRegisterInstruction instruction = (ThreeRegisterInstruction)((Object)analyzedInstruction.instruction);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, instruction.getRegisterC(), Primitive32BitCategories);
        RegisterType sourceRegisterType = analyzedInstruction.getPreInstructionRegisterType(instruction.getRegisterA());
        assert (sourceRegisterType != null);
        RegisterType arrayRegisterType = analyzedInstruction.getPreInstructionRegisterType(instruction.getRegisterB());
        assert (arrayRegisterType != null);
        if (arrayRegisterType.category != RegisterType.Category.Null) {
            if (arrayRegisterType.category != RegisterType.Category.Reference) {
                throw new ValidationException(String.format("Cannot use aget-object with non-array type %s", arrayRegisterType.category.toString()));
            }
            assert (arrayRegisterType.type != null);
            if (arrayRegisterType.type.getClassType().charAt(0) != '[') {
                throw new ValidationException(String.format("Cannot use aget-object with non-array type %s", arrayRegisterType.type.getClassType()));
            }
            assert (arrayRegisterType.type instanceof ClassPath.ArrayClassDef);
            ClassPath.ArrayClassDef arrayClassDef = (ClassPath.ArrayClassDef)arrayRegisterType.type;
            ClassPath.ClassDef elementClassDef = arrayClassDef.getImmediateElementClass();
            char elementTypePrefix = elementClassDef.getClassType().charAt(0);
            if (elementTypePrefix != 'L' && elementTypePrefix != '[') {
                throw new ValidationException(String.format("Cannot use aget-object with array type %s. Incorrect array type for the instruction.", arrayRegisterType.type.getClassType()));
            }
        }
    }

    private void analyze32BitPrimitiveIget(AnalyzedInstruction analyzedInstruction, RegisterType.Category instructionCategory) {
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.getRegisterType(instructionCategory, null));
    }

    private void verify32BitPrimitiveIget(AnalyzedInstruction analyzedInstruction, RegisterType.Category instructionCategory) {
        TwoRegisterInstruction instruction = (TwoRegisterInstruction)((Object)analyzedInstruction.instruction);
        RegisterType objectRegisterType = MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, instruction.getRegisterB(), ReferenceOrUninitThisCategories);
        Item referencedItem = ((InstructionWithReference)analyzedInstruction.instruction).getReferencedItem();
        assert (referencedItem instanceof FieldIdItem);
        FieldIdItem field = (FieldIdItem)referencedItem;
        if (objectRegisterType.category != RegisterType.Category.Null && !objectRegisterType.type.extendsClass(ClassPath.getClassDef(field.getContainingClass()))) {
            throw new ValidationException(String.format("Cannot access field %s through type %s", field.getFieldString(), objectRegisterType.type.getClassType()));
        }
        RegisterType fieldType = RegisterType.getRegisterTypeForTypeIdItem(field.getFieldType());
        if (!MethodAnalyzer.checkArrayFieldAssignment(fieldType.category, instructionCategory)) {
            throw new ValidationException(String.format("Cannot use %s with field %s. Incorrect field type for the instruction.", analyzedInstruction.instruction.opcode.name, field.getFieldString()));
        }
    }

    private void analyzeIgetWideObject(AnalyzedInstruction analyzedInstruction) {
        TwoRegisterInstruction instruction = (TwoRegisterInstruction)((Object)analyzedInstruction.instruction);
        Item referencedItem = ((InstructionWithReference)analyzedInstruction.instruction).getReferencedItem();
        assert (referencedItem instanceof FieldIdItem);
        FieldIdItem field = (FieldIdItem)referencedItem;
        RegisterType fieldType = RegisterType.getRegisterTypeForTypeIdItem(field.getFieldType());
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, fieldType);
    }

    private void verifyIgetWide(AnalyzedInstruction analyzedInstruction) {
        TwoRegisterInstruction instruction = (TwoRegisterInstruction)((Object)analyzedInstruction.instruction);
        RegisterType objectRegisterType = MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, instruction.getRegisterB(), ReferenceOrUninitThisCategories);
        Item referencedItem = ((InstructionWithReference)analyzedInstruction.instruction).getReferencedItem();
        assert (referencedItem instanceof FieldIdItem);
        FieldIdItem field = (FieldIdItem)referencedItem;
        if (objectRegisterType.category != RegisterType.Category.Null && !objectRegisterType.type.extendsClass(ClassPath.getClassDef(field.getContainingClass()))) {
            throw new ValidationException(String.format("Cannot access field %s through type %s", field.getFieldString(), objectRegisterType.type.getClassType()));
        }
        RegisterType fieldType = RegisterType.getRegisterTypeForTypeIdItem(field.getFieldType());
        if (!WideLowCategories.contains((Object)fieldType.category)) {
            throw new ValidationException(String.format("Cannot use %s with field %s. Incorrect field type for the instruction.", analyzedInstruction.instruction.opcode.name, field.getFieldString()));
        }
    }

    private void verifyIgetObject(AnalyzedInstruction analyzedInstruction) {
        TwoRegisterInstruction instruction = (TwoRegisterInstruction)((Object)analyzedInstruction.instruction);
        RegisterType objectRegisterType = MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, instruction.getRegisterB(), ReferenceOrUninitThisCategories);
        Item referencedItem = ((InstructionWithReference)analyzedInstruction.instruction).getReferencedItem();
        assert (referencedItem instanceof FieldIdItem);
        FieldIdItem field = (FieldIdItem)referencedItem;
        if (objectRegisterType.category != RegisterType.Category.Null && !objectRegisterType.type.extendsClass(ClassPath.getClassDef(field.getContainingClass()))) {
            throw new ValidationException(String.format("Cannot access field %s through type %s", field.getFieldString(), objectRegisterType.type.getClassType()));
        }
        RegisterType fieldType = RegisterType.getRegisterTypeForTypeIdItem(field.getFieldType());
        if (fieldType.category != RegisterType.Category.Reference) {
            throw new ValidationException(String.format("Cannot use %s with field %s. Incorrect field type for the instruction.", analyzedInstruction.instruction.opcode.name, field.getFieldString()));
        }
    }

    private void verify32BitPrimitiveIput(AnalyzedInstruction analyzedInstruction, RegisterType.Category instructionCategory) {
        RegisterType instructionRegisterType;
        TwoRegisterInstruction instruction = (TwoRegisterInstruction)((Object)analyzedInstruction.instruction);
        RegisterType objectRegisterType = MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, instruction.getRegisterB(), ReferenceOrUninitThisCategories);
        RegisterType sourceRegisterType = analyzedInstruction.getPreInstructionRegisterType(instruction.getRegisterA());
        assert (sourceRegisterType != null);
        if (sourceRegisterType.category == RegisterType.Category.Byte && instructionCategory == RegisterType.Category.Boolean) {
            sourceRegisterType = RegisterType.getRegisterType(RegisterType.Category.Boolean, null);
        }
        if (!sourceRegisterType.canBeAssignedTo(instructionRegisterType = RegisterType.getRegisterType(instructionCategory, null))) {
            throw new ValidationException(String.format("Cannot use %s with source register type %s.", analyzedInstruction.instruction.opcode.name, sourceRegisterType.toString()));
        }
        Item referencedItem = ((InstructionWithReference)analyzedInstruction.instruction).getReferencedItem();
        assert (referencedItem instanceof FieldIdItem);
        FieldIdItem field = (FieldIdItem)referencedItem;
        if (objectRegisterType.category != RegisterType.Category.Null && !objectRegisterType.type.extendsClass(ClassPath.getClassDef(field.getContainingClass()))) {
            throw new ValidationException(String.format("Cannot access field %s through type %s", field.getFieldString(), objectRegisterType.type.getClassType()));
        }
        RegisterType fieldType = RegisterType.getRegisterTypeForTypeIdItem(field.getFieldType());
        if (!MethodAnalyzer.checkArrayFieldAssignment(fieldType.category, instructionCategory)) {
            throw new ValidationException(String.format("Cannot use %s with field %s. Incorrect field type for the instruction.", analyzedInstruction.instruction.opcode.name, field.getFieldString()));
        }
    }

    private void verifyIputWide(AnalyzedInstruction analyzedInstruction) {
        TwoRegisterInstruction instruction = (TwoRegisterInstruction)((Object)analyzedInstruction.instruction);
        RegisterType objectRegisterType = MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, instruction.getRegisterB(), ReferenceOrUninitThisCategories);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, instruction.getRegisterA(), WideLowCategories);
        Item referencedItem = ((InstructionWithReference)analyzedInstruction.instruction).getReferencedItem();
        assert (referencedItem instanceof FieldIdItem);
        FieldIdItem field = (FieldIdItem)referencedItem;
        if (objectRegisterType.category != RegisterType.Category.Null && !objectRegisterType.type.extendsClass(ClassPath.getClassDef(field.getContainingClass()))) {
            throw new ValidationException(String.format("Cannot access field %s through type %s", field.getFieldString(), objectRegisterType.type.getClassType()));
        }
        RegisterType fieldType = RegisterType.getRegisterTypeForTypeIdItem(field.getFieldType());
        if (!WideLowCategories.contains((Object)fieldType.category)) {
            throw new ValidationException(String.format("Cannot use %s with field %s. Incorrect field type for the instruction.", analyzedInstruction.instruction.opcode.name, field.getFieldString()));
        }
    }

    private void verifyIputObject(AnalyzedInstruction analyzedInstruction) {
        TwoRegisterInstruction instruction = (TwoRegisterInstruction)((Object)analyzedInstruction.instruction);
        RegisterType objectRegisterType = MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, instruction.getRegisterB(), ReferenceOrUninitThisCategories);
        RegisterType sourceRegisterType = MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, instruction.getRegisterA(), ReferenceCategories);
        Item referencedItem = ((InstructionWithReference)analyzedInstruction.instruction).getReferencedItem();
        assert (referencedItem instanceof FieldIdItem);
        FieldIdItem field = (FieldIdItem)referencedItem;
        if (objectRegisterType.category != RegisterType.Category.Null && !objectRegisterType.type.extendsClass(ClassPath.getClassDef(field.getContainingClass()))) {
            throw new ValidationException(String.format("Cannot access field %s through type %s", field.getFieldString(), objectRegisterType.type.getClassType()));
        }
        RegisterType fieldType = RegisterType.getRegisterTypeForTypeIdItem(field.getFieldType());
        if (fieldType.category != RegisterType.Category.Reference) {
            throw new ValidationException(String.format("Cannot use %s with field %s. Incorrect field type for the instruction.", analyzedInstruction.instruction.opcode.name, field.getFieldString()));
        }
        if (sourceRegisterType.category != RegisterType.Category.Null && !fieldType.type.isInterface() && !sourceRegisterType.type.extendsClass(fieldType.type)) {
            throw new ValidationException(String.format("Cannot store a value of type %s into a field of type %s", sourceRegisterType.type.getClassType(), fieldType.type.getClassType()));
        }
    }

    private void analyze32BitPrimitiveSget(AnalyzedInstruction analyzedInstruction, RegisterType.Category instructionCategory) {
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.getRegisterType(instructionCategory, null));
    }

    private void verify32BitPrimitiveSget(AnalyzedInstruction analyzedInstruction, RegisterType.Category instructionCategory) {
        Item referencedItem = ((InstructionWithReference)analyzedInstruction.instruction).getReferencedItem();
        assert (referencedItem instanceof FieldIdItem);
        FieldIdItem field = (FieldIdItem)referencedItem;
        RegisterType fieldType = RegisterType.getRegisterTypeForTypeIdItem(field.getFieldType());
        if (!MethodAnalyzer.checkArrayFieldAssignment(fieldType.category, instructionCategory)) {
            throw new ValidationException(String.format("Cannot use %s with field %s. Incorrect field type for the instruction.", analyzedInstruction.instruction.opcode.name, field.getFieldString()));
        }
    }

    private void analyzeSgetWideObject(AnalyzedInstruction analyzedInstruction) {
        Item referencedItem = ((InstructionWithReference)analyzedInstruction.instruction).getReferencedItem();
        assert (referencedItem instanceof FieldIdItem);
        FieldIdItem field = (FieldIdItem)referencedItem;
        RegisterType fieldType = RegisterType.getRegisterTypeForTypeIdItem(field.getFieldType());
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, fieldType);
    }

    private void verifySgetWide(AnalyzedInstruction analyzedInstruction) {
        Item referencedItem = ((InstructionWithReference)analyzedInstruction.instruction).getReferencedItem();
        assert (referencedItem instanceof FieldIdItem);
        FieldIdItem field = (FieldIdItem)referencedItem;
        RegisterType fieldType = RegisterType.getRegisterTypeForTypeIdItem(field.getFieldType());
        if (fieldType.category != RegisterType.Category.LongLo && fieldType.category != RegisterType.Category.DoubleLo) {
            throw new ValidationException(String.format("Cannot use %s with field %s. Incorrect field type for the instruction.", analyzedInstruction.instruction.opcode.name, field.getFieldString()));
        }
    }

    private void verifySgetObject(AnalyzedInstruction analyzedInstruction) {
        Item referencedItem = ((InstructionWithReference)analyzedInstruction.instruction).getReferencedItem();
        assert (referencedItem instanceof FieldIdItem);
        FieldIdItem field = (FieldIdItem)referencedItem;
        RegisterType fieldType = RegisterType.getRegisterTypeForTypeIdItem(field.getFieldType());
        if (fieldType.category != RegisterType.Category.Reference) {
            throw new ValidationException(String.format("Cannot use %s with field %s. Incorrect field type for the instruction.", analyzedInstruction.instruction.opcode.name, field.getFieldString()));
        }
    }

    private void verify32BitPrimitiveSput(AnalyzedInstruction analyzedInstruction, RegisterType.Category instructionCategory) {
        RegisterType instructionRegisterType;
        SingleRegisterInstruction instruction = (SingleRegisterInstruction)((Object)analyzedInstruction.instruction);
        RegisterType sourceRegisterType = analyzedInstruction.getPreInstructionRegisterType(instruction.getRegisterA());
        assert (sourceRegisterType != null);
        if (sourceRegisterType.category == RegisterType.Category.Byte && instructionCategory == RegisterType.Category.Boolean) {
            sourceRegisterType = RegisterType.getRegisterType(RegisterType.Category.Boolean, null);
        }
        if (!sourceRegisterType.canBeAssignedTo(instructionRegisterType = RegisterType.getRegisterType(instructionCategory, null))) {
            throw new ValidationException(String.format("Cannot use %s with source register type %s.", analyzedInstruction.instruction.opcode.name, sourceRegisterType.toString()));
        }
        Item referencedItem = ((InstructionWithReference)analyzedInstruction.instruction).getReferencedItem();
        assert (referencedItem instanceof FieldIdItem);
        FieldIdItem field = (FieldIdItem)referencedItem;
        RegisterType fieldType = RegisterType.getRegisterTypeForTypeIdItem(field.getFieldType());
        if (!MethodAnalyzer.checkArrayFieldAssignment(fieldType.category, instructionCategory)) {
            throw new ValidationException(String.format("Cannot use %s with field %s. Incorrect field type for the instruction.", analyzedInstruction.instruction.opcode.name, field.getFieldString()));
        }
    }

    private void verifySputWide(AnalyzedInstruction analyzedInstruction) {
        SingleRegisterInstruction instruction = (SingleRegisterInstruction)((Object)analyzedInstruction.instruction);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, instruction.getRegisterA(), WideLowCategories);
        Item referencedItem = ((InstructionWithReference)analyzedInstruction.instruction).getReferencedItem();
        assert (referencedItem instanceof FieldIdItem);
        FieldIdItem field = (FieldIdItem)referencedItem;
        RegisterType fieldType = RegisterType.getRegisterTypeForTypeIdItem(field.getFieldType());
        if (!WideLowCategories.contains((Object)fieldType.category)) {
            throw new ValidationException(String.format("Cannot use %s with field %s. Incorrect field type for the instruction.", analyzedInstruction.instruction.opcode.name, field.getFieldString()));
        }
    }

    private void verifySputObject(AnalyzedInstruction analyzedInstruction) {
        SingleRegisterInstruction instruction = (SingleRegisterInstruction)((Object)analyzedInstruction.instruction);
        RegisterType sourceRegisterType = MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, instruction.getRegisterA(), ReferenceCategories);
        Item referencedItem = ((InstructionWithReference)analyzedInstruction.instruction).getReferencedItem();
        assert (referencedItem instanceof FieldIdItem);
        FieldIdItem field = (FieldIdItem)referencedItem;
        RegisterType fieldType = RegisterType.getRegisterTypeForTypeIdItem(field.getFieldType());
        if (fieldType.category != RegisterType.Category.Reference) {
            throw new ValidationException(String.format("Cannot use %s with field %s. Incorrect field type for the instruction.", analyzedInstruction.instruction.opcode.name, field.getFieldString()));
        }
        if (sourceRegisterType.category != RegisterType.Category.Null && !fieldType.type.isInterface() && !sourceRegisterType.type.extendsClass(fieldType.type)) {
            throw new ValidationException(String.format("Cannot store a value of type %s into a field of type %s", sourceRegisterType.type.getClassType(), fieldType.type.getClassType()));
        }
    }

    private void analyzeInvokeDirect(AnalyzedInstruction analyzedInstruction) {
        FiveRegisterInstruction instruction = (FiveRegisterInstruction)((Object)analyzedInstruction.instruction);
        this.analyzeInvokeDirectCommon(analyzedInstruction, new Format35cRegisterIterator(instruction));
    }

    private void verifyInvoke(AnalyzedInstruction analyzedInstruction, int invokeType) {
        FiveRegisterInstruction instruction = (FiveRegisterInstruction)((Object)analyzedInstruction.instruction);
        this.verifyInvokeCommon(analyzedInstruction, false, invokeType, new Format35cRegisterIterator(instruction));
    }

    private void analyzeInvokeDirectRange(AnalyzedInstruction analyzedInstruction) {
        RegisterRangeInstruction instruction = (RegisterRangeInstruction)((Object)analyzedInstruction.instruction);
        this.analyzeInvokeDirectCommon(analyzedInstruction, new Format3rcRegisterIterator(instruction));
    }

    private void verifyInvokeRange(AnalyzedInstruction analyzedInstruction, int invokeType) {
        RegisterRangeInstruction instruction = (RegisterRangeInstruction)((Object)analyzedInstruction.instruction);
        this.verifyInvokeCommon(analyzedInstruction, true, invokeType, new Format3rcRegisterIterator(instruction));
    }

    private void analyzeInvokeDirectCommon(AnalyzedInstruction analyzedInstruction, RegisterIterator registers) {
        InstructionWithReference instruction = (InstructionWithReference)analyzedInstruction.instruction;
        Item item = instruction.getReferencedItem();
        assert (item.getItemType() == ItemType.TYPE_METHOD_ID_ITEM);
        MethodIdItem methodIdItem = (MethodIdItem)item;
        if (!methodIdItem.getMethodName().getStringValue().equals("<init>")) {
            return;
        }
        int objectRegister = registers.getRegister();
        RegisterType objectRegisterType = analyzedInstruction.getPreInstructionRegisterType(objectRegister);
        assert (objectRegisterType != null);
        if (objectRegisterType.category != RegisterType.Category.UninitRef && objectRegisterType.category != RegisterType.Category.UninitThis) {
            return;
        }
        this.setPostRegisterTypeAndPropagateChanges(analyzedInstruction, objectRegister, RegisterType.getRegisterType(RegisterType.Category.Reference, objectRegisterType.type));
        for (int i = 0; i < analyzedInstruction.postRegisterMap.length; ++i) {
            RegisterType postInstructionRegisterType = analyzedInstruction.postRegisterMap[i];
            if (postInstructionRegisterType.category != RegisterType.Category.Unknown) continue;
            RegisterType preInstructionRegisterType = analyzedInstruction.getPreInstructionRegisterType(i);
            if (preInstructionRegisterType.category != RegisterType.Category.UninitRef && preInstructionRegisterType.category != RegisterType.Category.UninitThis) continue;
            RegisterType registerType = preInstructionRegisterType == objectRegisterType ? analyzedInstruction.postRegisterMap[objectRegister] : preInstructionRegisterType;
            this.setPostRegisterTypeAndPropagateChanges(analyzedInstruction, i, registerType);
        }
    }

    private void verifyInvokeCommon(AnalyzedInstruction analyzedInstruction, boolean isRange, int invokeType, RegisterIterator registers) {
        InstructionWithReference instruction = (InstructionWithReference)analyzedInstruction.instruction;
        Item item = instruction.getReferencedItem();
        assert (item.getItemType() == ItemType.TYPE_METHOD_ID_ITEM);
        MethodIdItem methodIdItem = (MethodIdItem)item;
        TypeIdItem methodClass = methodIdItem.getContainingClass();
        boolean isInit = false;
        if (methodIdItem.getMethodName().getStringValue().charAt(0) == '<') {
            if ((invokeType & 4) != 0) {
                isInit = true;
            } else {
                throw new ValidationException(String.format("Cannot call constructor %s with %s", methodIdItem.getMethodString(), analyzedInstruction.instruction.opcode.name));
            }
        }
        ClassPath.ClassDef methodClassDef = ClassPath.getClassDef(methodClass);
        if ((invokeType & 8) != 0) {
            if (!methodClassDef.isInterface()) {
                throw new ValidationException(String.format("Cannot call method %s with %s. %s is not an interface class.", methodIdItem.getMethodString(), analyzedInstruction.instruction.opcode.name, methodClassDef.getClassType()));
            }
        } else if (methodClassDef.isInterface()) {
            throw new ValidationException(String.format("Cannot call method %s with %s. %s is an interface class. Use invoke-interface or invoke-interface/range instead.", methodIdItem.getMethodString(), analyzedInstruction.instruction.opcode.name, methodClassDef.getClassType()));
        }
        if ((invokeType & 2) != 0) {
            ClassPath.ClassDef currentMethodClassDef = ClassPath.getClassDef(this.encodedMethod.method.getContainingClass());
            if (currentMethodClassDef.getSuperclass() == null) {
                throw new ValidationException(String.format("Cannot call method %s with %s. %s has no superclass", methodIdItem.getMethodString(), analyzedInstruction.instruction.opcode.name, methodClassDef.getSuperclass().getClassType()));
            }
            if (!currentMethodClassDef.getSuperclass().extendsClass(methodClassDef)) {
                throw new ValidationException(String.format("Cannot call method %s with %s. %s is not an ancestor of the current class %s", methodIdItem.getMethodString(), analyzedInstruction.instruction.opcode.name, methodClass.getTypeDescriptor(), this.encodedMethod.method.getContainingClass().getTypeDescriptor()));
            }
            if (!currentMethodClassDef.getSuperclass().hasVirtualMethod(methodIdItem.getVirtualMethodString())) {
                throw new ValidationException(String.format("Cannot call method %s with %s. The superclass %s hasno such method", methodIdItem.getMethodString(), analyzedInstruction.instruction.opcode.name, methodClassDef.getSuperclass().getClassType()));
            }
        }
        assert (isRange || registers.getCount() <= 5);
        TypeListItem typeListItem = methodIdItem.getPrototype().getParameters();
        int methodParameterRegisterCount = typeListItem == null ? 0 : typeListItem.getRegisterCount();
        if ((invokeType & 0x10) == 0) {
            ++methodParameterRegisterCount;
        }
        if (methodParameterRegisterCount != registers.getCount()) {
            throw new ValidationException(String.format("The number of registers does not match the number of parameters for method %s. Expecting %d registers, got %d.", methodIdItem.getMethodString(), methodParameterRegisterCount + 1, registers.getCount()));
        }
        RegisterType objectRegisterType = null;
        int objectRegister = 0;
        if ((invokeType & 0x10) == 0) {
            objectRegister = registers.getRegister();
            registers.moveNext();
            objectRegisterType = analyzedInstruction.getPreInstructionRegisterType(objectRegister);
            assert (objectRegisterType != null);
            if (objectRegisterType.category == RegisterType.Category.UninitRef || objectRegisterType.category == RegisterType.Category.UninitThis) {
                if (!isInit) {
                    throw new ValidationException(String.format("Cannot invoke non-<init> method %s on uninitialized reference type %s", methodIdItem.getMethodString(), objectRegisterType.type.getClassType()));
                }
            } else if (objectRegisterType.category == RegisterType.Category.Reference) {
                if (isInit) {
                    throw new ValidationException(String.format("Cannot invoke %s on initialized reference type %s", methodIdItem.getMethodString(), objectRegisterType.type.getClassType()));
                }
            } else if (objectRegisterType.category == RegisterType.Category.Null) {
                if (isInit) {
                    throw new ValidationException(String.format("Cannot invoke %s on a null reference", methodIdItem.getMethodString()));
                }
            } else {
                throw new ValidationException(String.format("Cannot invoke %s on non-reference type %s", methodIdItem.getMethodString(), objectRegisterType.toString()));
            }
            if (isInit && objectRegisterType.type.getSuperclass() == methodClassDef && !this.encodedMethod.method.getMethodName().getStringValue().equals("<init>")) {
                throw new ValidationException(String.format("Cannot call %s on type %s. The object type must match the method type exactly", methodIdItem.getMethodString(), objectRegisterType.type.getClassType()));
            }
            if ((invokeType & 8) == 0 && objectRegisterType.category != RegisterType.Category.Null && !objectRegisterType.type.extendsClass(methodClassDef)) {
                throw new ValidationException(String.format("Cannot call method %s on an object of type %s, which does not extend %s.", methodIdItem.getMethodString(), objectRegisterType.type.getClassType(), methodClassDef.getClassType()));
            }
        }
        if (typeListItem != null) {
            List<TypeIdItem> parameterTypes = typeListItem.getTypes();
            int parameterTypeIndex = 0;
            while (!registers.pastEnd()) {
                RegisterType parameterRegisterType;
                assert (parameterTypeIndex < parameterTypes.size());
                RegisterType parameterType = RegisterType.getRegisterTypeForTypeIdItem(parameterTypes.get(parameterTypeIndex));
                int register = registers.getRegister();
                if (WideLowCategories.contains((Object)parameterType.category)) {
                    parameterRegisterType = MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, register, WideLowCategories);
                    if (!registers.moveNext()) {
                        throw new ValidationException(String.format("No 2nd register specified for wide register pair v%d", parameterTypeIndex + 1));
                    }
                    int nextRegister = registers.getRegister();
                    if (nextRegister != register + 1) {
                        throw new ValidationException(String.format("Invalid wide register pair (v%d, v%d). Registers must be consecutive.", register, nextRegister));
                    }
                } else {
                    parameterRegisterType = analyzedInstruction.getPreInstructionRegisterType(register);
                }
                assert (parameterRegisterType != null);
                if (!parameterRegisterType.canBeAssignedTo(parameterType)) {
                    throw new ValidationException(String.format("Invalid register type %s for parameter %d %s.", parameterRegisterType.toString(), parameterTypeIndex + 1, parameterType.toString()));
                }
                ++parameterTypeIndex;
                registers.moveNext();
            }
        }
    }

    private void analyzeUnaryOp(AnalyzedInstruction analyzedInstruction, RegisterType.Category destRegisterCategory) {
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.getRegisterType(destRegisterCategory, null));
    }

    private void verifyUnaryOp(AnalyzedInstruction analyzedInstruction, EnumSet validSourceCategories) {
        TwoRegisterInstruction instruction = (TwoRegisterInstruction)((Object)analyzedInstruction.instruction);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, instruction.getRegisterB(), validSourceCategories);
    }

    private void analyzeBinaryOp(AnalyzedInstruction analyzedInstruction, RegisterType.Category destRegisterCategory, boolean checkForBoolean) {
        if (checkForBoolean) {
            ThreeRegisterInstruction instruction = (ThreeRegisterInstruction)((Object)analyzedInstruction.instruction);
            RegisterType source1RegisterType = analyzedInstruction.getPreInstructionRegisterType(instruction.getRegisterB());
            RegisterType source2RegisterType = analyzedInstruction.getPreInstructionRegisterType(instruction.getRegisterC());
            if (BooleanCategories.contains((Object)source1RegisterType.category) && BooleanCategories.contains((Object)source2RegisterType.category)) {
                destRegisterCategory = RegisterType.Category.Boolean;
            }
        }
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.getRegisterType(destRegisterCategory, null));
    }

    private void verifyBinaryOp(AnalyzedInstruction analyzedInstruction, EnumSet validSource1Categories, EnumSet validSource2Categories) {
        ThreeRegisterInstruction instruction = (ThreeRegisterInstruction)((Object)analyzedInstruction.instruction);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, instruction.getRegisterB(), validSource1Categories);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, instruction.getRegisterC(), validSource2Categories);
    }

    private void analyzeBinary2AddrOp(AnalyzedInstruction analyzedInstruction, RegisterType.Category destRegisterCategory, boolean checkForBoolean) {
        if (checkForBoolean) {
            TwoRegisterInstruction instruction = (TwoRegisterInstruction)((Object)analyzedInstruction.instruction);
            RegisterType source1RegisterType = analyzedInstruction.getPreInstructionRegisterType(instruction.getRegisterA());
            RegisterType source2RegisterType = analyzedInstruction.getPreInstructionRegisterType(instruction.getRegisterB());
            if (BooleanCategories.contains((Object)source1RegisterType.category) && BooleanCategories.contains((Object)source2RegisterType.category)) {
                destRegisterCategory = RegisterType.Category.Boolean;
            }
        }
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.getRegisterType(destRegisterCategory, null));
    }

    private void verifyBinary2AddrOp(AnalyzedInstruction analyzedInstruction, EnumSet validSource1Categories, EnumSet validSource2Categories) {
        TwoRegisterInstruction instruction = (TwoRegisterInstruction)((Object)analyzedInstruction.instruction);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, instruction.getRegisterA(), validSource1Categories);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, instruction.getRegisterB(), validSource2Categories);
    }

    private void analyzeLiteralBinaryOp(AnalyzedInstruction analyzedInstruction, RegisterType.Category destRegisterCategory, boolean checkForBoolean) {
        if (checkForBoolean) {
            long literal;
            TwoRegisterInstruction instruction = (TwoRegisterInstruction)((Object)analyzedInstruction.instruction);
            RegisterType sourceRegisterType = analyzedInstruction.getPreInstructionRegisterType(instruction.getRegisterB());
            if (BooleanCategories.contains((Object)sourceRegisterType.category) && ((literal = ((LiteralInstruction)((Object)analyzedInstruction.instruction)).getLiteral()) == 0L || literal == 1L)) {
                destRegisterCategory = RegisterType.Category.Boolean;
            }
        }
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.getRegisterType(destRegisterCategory, null));
    }

    private void verifyLiteralBinaryOp(AnalyzedInstruction analyzedInstruction) {
        TwoRegisterInstruction instruction = (TwoRegisterInstruction)((Object)analyzedInstruction.instruction);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, instruction.getRegisterB(), Primitive32BitCategories);
    }

    private RegisterType.Category getDestTypeForLiteralShiftRight(AnalyzedInstruction analyzedInstruction, boolean signedShift) {
        TwoRegisterInstruction instruction = (TwoRegisterInstruction)((Object)analyzedInstruction.instruction);
        RegisterType sourceRegisterType = MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, instruction.getRegisterB(), Primitive32BitCategories);
        long literalShift = ((LiteralInstruction)((Object)analyzedInstruction.instruction)).getLiteral();
        if (literalShift == 0L) {
            return sourceRegisterType.category;
        }
        RegisterType.Category destRegisterCategory = !signedShift ? RegisterType.Category.Integer : sourceRegisterType.category;
        if (literalShift >= 32L) {
            return destRegisterCategory;
        }
        switch (sourceRegisterType.category) {
            case Integer: 
            case Float: {
                if (!signedShift) {
                    if (literalShift > 24L) {
                        return RegisterType.Category.PosByte;
                    }
                    if (literalShift < 16L) break;
                    return RegisterType.Category.Char;
                }
                if (literalShift >= 24L) {
                    return RegisterType.Category.Byte;
                }
                if (literalShift < 16L) break;
                return RegisterType.Category.Short;
            }
            case Short: {
                if (!signedShift || literalShift < 8L) break;
                return RegisterType.Category.Byte;
            }
            case PosShort: {
                if (literalShift < 8L) break;
                return RegisterType.Category.PosByte;
            }
            case Char: {
                if (literalShift <= 8L) break;
                return RegisterType.Category.PosByte;
            }
            case Byte: {
                break;
            }
            case PosByte: {
                return RegisterType.Category.PosByte;
            }
            case Null: 
            case One: 
            case Boolean: {
                return RegisterType.Category.Null;
            }
            default: {
                assert (false);
                break;
            }
        }
        return destRegisterCategory;
    }

    private void analyzeExecuteInline(AnalyzedInstruction analyzedInstruction) {
        if (this.deodexUtil == null) {
            throw new ValidationException("Cannot analyze an odexed instruction unless we are deodexing");
        }
        Instruction35ms instruction = (Instruction35ms)analyzedInstruction.instruction;
        int methodIndex = instruction.getMethodIndex();
        DeodexUtil.InlineMethod inlineMethod = this.deodexUtil.lookupInlineMethod(methodIndex);
        MethodIdItem inlineMethodIdItem = inlineMethod.getMethodIdItem();
        if (inlineMethodIdItem == null) {
            throw new ValidationException(String.format("Cannot load inline method with index %d", methodIndex));
        }
        Opcode deodexedOpcode = null;
        switch (inlineMethod.methodType) {
            case 1: {
                deodexedOpcode = Opcode.INVOKE_DIRECT;
                break;
            }
            case 2: {
                deodexedOpcode = Opcode.INVOKE_STATIC;
                break;
            }
            case 0: {
                deodexedOpcode = Opcode.INVOKE_VIRTUAL;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        Instruction35c deodexedInstruction = new Instruction35c(deodexedOpcode, instruction.getRegCount(), instruction.getRegisterD(), instruction.getRegisterE(), instruction.getRegisterF(), instruction.getRegisterG(), instruction.getRegisterA(), inlineMethodIdItem);
        analyzedInstruction.setDeodexedInstruction(deodexedInstruction);
        this.analyzeInstruction(analyzedInstruction);
    }

    private void analyzeExecuteInlineRange(AnalyzedInstruction analyzedInstruction) {
        if (this.deodexUtil == null) {
            throw new ValidationException("Cannot analyze an odexed instruction unless we are deodexing");
        }
        Instruction3rms instruction = (Instruction3rms)analyzedInstruction.instruction;
        int methodIndex = instruction.getMethodIndex();
        DeodexUtil.InlineMethod inlineMethod = this.deodexUtil.lookupInlineMethod(methodIndex);
        MethodIdItem inlineMethodIdItem = inlineMethod.getMethodIdItem();
        if (inlineMethodIdItem == null) {
            throw new ValidationException(String.format("Cannot load inline method with index %d", methodIndex));
        }
        Opcode deodexedOpcode = null;
        switch (inlineMethod.methodType) {
            case 1: {
                deodexedOpcode = Opcode.INVOKE_DIRECT_RANGE;
                break;
            }
            case 2: {
                deodexedOpcode = Opcode.INVOKE_STATIC_RANGE;
                break;
            }
            case 0: {
                deodexedOpcode = Opcode.INVOKE_VIRTUAL_RANGE;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        Instruction3rc deodexedInstruction = new Instruction3rc(deodexedOpcode, instruction.getRegCount(), instruction.getStartRegister(), inlineMethodIdItem);
        analyzedInstruction.setDeodexedInstruction(deodexedInstruction);
        this.analyzeInstruction(analyzedInstruction);
    }

    private void analyzeInvokeDirectEmpty(AnalyzedInstruction analyzedInstruction) {
        Instruction35s instruction = (Instruction35s)analyzedInstruction.instruction;
        Instruction35c deodexedInstruction = new Instruction35c(Opcode.INVOKE_DIRECT, instruction.getRegCount(), instruction.getRegisterD(), instruction.getRegisterE(), instruction.getRegisterF(), instruction.getRegisterG(), instruction.getRegisterA(), instruction.getReferencedItem());
        analyzedInstruction.setDeodexedInstruction(deodexedInstruction);
        this.analyzeInstruction(analyzedInstruction);
    }

    private boolean analyzeIputIgetQuick(AnalyzedInstruction analyzedInstruction, boolean isIput) {
        Instruction22cs instruction = (Instruction22cs)analyzedInstruction.instruction;
        int fieldOffset = instruction.getFieldOffset();
        RegisterType objectRegisterType = MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, instruction.getRegisterB(), ReferenceOrUninitCategories);
        if (objectRegisterType.category == RegisterType.Category.Null) {
            return false;
        }
        FieldIdItem fieldIdItem = this.deodexUtil.lookupField(objectRegisterType.type, fieldOffset);
        if (fieldIdItem == null) {
            throw new ValidationException(String.format("Could not resolve the field in class %s at offset %d", objectRegisterType.type.getClassType(), fieldOffset));
        }
        String fieldType = fieldIdItem.getFieldType().getTypeDescriptor();
        Opcode opcode = MethodAnalyzer.getAndCheckIgetIputOpcodeForType(fieldType, instruction.opcode, isIput);
        Instruction22c deodexedInstruction = new Instruction22c(opcode, (byte)instruction.getRegisterA(), (byte)instruction.getRegisterB(), fieldIdItem);
        analyzedInstruction.setDeodexedInstruction(deodexedInstruction);
        this.analyzeInstruction(analyzedInstruction);
        return true;
    }

    private boolean analyzeInvokeVirtualQuick(AnalyzedInstruction analyzedInstruction, boolean isSuper, boolean isRange) {
        InstructionWithReference deodexedInstruction;
        int objectRegister;
        int methodIndex;
        Instruction instruction;
        if (isRange) {
            instruction = (Instruction3rms)analyzedInstruction.instruction;
            methodIndex = ((Instruction3rms)instruction).getMethodIndex();
            objectRegister = ((Instruction3rms)instruction).getStartRegister();
        } else {
            instruction = (Instruction35ms)analyzedInstruction.instruction;
            methodIndex = ((Instruction35ms)instruction).getMethodIndex();
            objectRegister = ((Instruction35ms)instruction).getRegisterD();
        }
        RegisterType objectRegisterType = MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, objectRegister, ReferenceOrUninitCategories);
        if (objectRegisterType.category == RegisterType.Category.Null) {
            return false;
        }
        MethodIdItem methodIdItem = null;
        if (isSuper) {
            ClassPath.ClassDef classDef = ClassPath.getClassDef(this.encodedMethod.method.getContainingClass(), false);
            assert (classDef != null);
            if (classDef.getSuperclass() != null) {
                methodIdItem = this.deodexUtil.lookupVirtualMethod(classDef.getSuperclass(), methodIndex);
            }
            if (methodIdItem == null) {
                methodIdItem = this.deodexUtil.lookupVirtualMethod(classDef, methodIndex);
            }
        } else {
            methodIdItem = this.deodexUtil.lookupVirtualMethod(objectRegisterType.type, methodIndex);
        }
        if (methodIdItem == null) {
            throw new ValidationException(String.format("Could not resolve the method in class %s at index %d", objectRegisterType.type.getClassType(), methodIndex));
        }
        if (isRange) {
            Instruction3rms instruction2 = (Instruction3rms)analyzedInstruction.instruction;
            Opcode opcode = isSuper ? Opcode.INVOKE_SUPER_RANGE : Opcode.INVOKE_VIRTUAL_RANGE;
            deodexedInstruction = new Instruction3rc(opcode, instruction2.getRegCount(), instruction2.getStartRegister(), methodIdItem);
        } else {
            Instruction35ms instruction3 = (Instruction35ms)analyzedInstruction.instruction;
            Opcode opcode = isSuper ? Opcode.INVOKE_SUPER : Opcode.INVOKE_VIRTUAL;
            deodexedInstruction = new Instruction35c(opcode, instruction3.getRegCount(), instruction3.getRegisterD(), instruction3.getRegisterE(), instruction3.getRegisterF(), instruction3.getRegisterG(), instruction3.getRegisterA(), methodIdItem);
        }
        analyzedInstruction.setDeodexedInstruction(deodexedInstruction);
        this.analyzeInstruction(analyzedInstruction);
        return true;
    }

    private static Opcode getAndCheckIgetIputOpcodeForType(String fieldType, Opcode odexedOpcode, boolean isIput) {
        Opcode opcode;
        Opcode validOdexedOpcode;
        switch (fieldType.charAt(0)) {
            case 'Z': {
                if (isIput) {
                    validOdexedOpcode = Opcode.IPUT_QUICK;
                    opcode = Opcode.IPUT_BOOLEAN;
                    break;
                }
                validOdexedOpcode = Opcode.IGET_QUICK;
                opcode = Opcode.IGET_BOOLEAN;
                break;
            }
            case 'B': {
                if (isIput) {
                    validOdexedOpcode = Opcode.IPUT_QUICK;
                    opcode = Opcode.IPUT_BYTE;
                    break;
                }
                validOdexedOpcode = Opcode.IGET_QUICK;
                opcode = Opcode.IGET_BYTE;
                break;
            }
            case 'S': {
                if (isIput) {
                    validOdexedOpcode = Opcode.IPUT_QUICK;
                    opcode = Opcode.IPUT_SHORT;
                    break;
                }
                validOdexedOpcode = Opcode.IGET_QUICK;
                opcode = Opcode.IGET_SHORT;
                break;
            }
            case 'C': {
                if (isIput) {
                    validOdexedOpcode = Opcode.IPUT_QUICK;
                    opcode = Opcode.IPUT_CHAR;
                    break;
                }
                validOdexedOpcode = Opcode.IGET_QUICK;
                opcode = Opcode.IGET_CHAR;
                break;
            }
            case 'F': 
            case 'I': {
                if (isIput) {
                    validOdexedOpcode = Opcode.IPUT_QUICK;
                    opcode = Opcode.IPUT;
                    break;
                }
                validOdexedOpcode = Opcode.IGET_QUICK;
                opcode = Opcode.IGET;
                break;
            }
            case 'D': 
            case 'J': {
                if (isIput) {
                    validOdexedOpcode = Opcode.IPUT_WIDE_QUICK;
                    opcode = Opcode.IPUT_WIDE;
                    break;
                }
                validOdexedOpcode = Opcode.IGET_WIDE_QUICK;
                opcode = Opcode.IGET_WIDE;
                break;
            }
            case 'L': 
            case '[': {
                if (isIput) {
                    validOdexedOpcode = Opcode.IPUT_OBJECT_QUICK;
                    opcode = Opcode.IPUT_OBJECT;
                    break;
                }
                validOdexedOpcode = Opcode.IGET_OBJECT_QUICK;
                opcode = Opcode.IGET_OBJECT;
                break;
            }
            default: {
                throw new RuntimeException(String.format("Unexpected field type %s for %s: ", fieldType, odexedOpcode.name));
            }
        }
        if (odexedOpcode != validOdexedOpcode) {
            throw new ValidationException(String.format("Incorrect field type \"%s\" for %s", fieldType, odexedOpcode.name));
        }
        return opcode;
    }

    private static boolean checkArrayFieldAssignment(RegisterType.Category arrayFieldCategory, RegisterType.Category instructionCategory) {
        if (arrayFieldCategory == instructionCategory) {
            return true;
        }
        return arrayFieldCategory == RegisterType.Category.Integer && instructionCategory == RegisterType.Category.Float || arrayFieldCategory == RegisterType.Category.Float && instructionCategory == RegisterType.Category.Integer;
    }

    private static RegisterType getAndCheckSourceRegister(AnalyzedInstruction analyzedInstruction, int registerNumber, EnumSet validCategories) {
        assert (registerNumber >= 0 && registerNumber < analyzedInstruction.postRegisterMap.length);
        RegisterType registerType = analyzedInstruction.getPreInstructionRegisterType(registerNumber);
        assert (registerType != null);
        MethodAnalyzer.checkRegister(registerType, registerNumber, validCategories);
        if (validCategories == WideLowCategories) {
            MethodAnalyzer.checkRegister(registerType, registerNumber, WideLowCategories);
            MethodAnalyzer.checkWidePair(registerNumber, analyzedInstruction);
            RegisterType secondRegisterType = analyzedInstruction.getPreInstructionRegisterType(registerNumber + 1);
            assert (secondRegisterType != null);
            MethodAnalyzer.checkRegister(secondRegisterType, registerNumber + 1, WideHighCategories);
        }
        return registerType;
    }

    private static void checkRegister(RegisterType registerType, int registerNumber, EnumSet validCategories) {
        if (!validCategories.contains((Object)registerType.category)) {
            throw new ValidationException(String.format("Invalid register type %s for register v%d.", registerType.toString(), registerNumber));
        }
    }

    private static void checkWidePair(int registerNumber, AnalyzedInstruction analyzedInstruction) {
        if (registerNumber + 1 >= analyzedInstruction.postRegisterMap.length) {
            throw new ValidationException(String.format("v%d cannot be used as the first register in a wide registerpair because it is the last register.", registerNumber));
        }
    }

    private static class Format3rcRegisterIterator
    implements RegisterIterator {
        private final int startRegister;
        private final int registerCount;
        private int currentRegister = 0;

        public Format3rcRegisterIterator(RegisterRangeInstruction instruction) {
            this.startRegister = instruction.getStartRegister();
            this.registerCount = instruction.getRegCount();
        }

        public int getRegister() {
            return this.startRegister + this.currentRegister;
        }

        public boolean moveNext() {
            ++this.currentRegister;
            return !this.pastEnd();
        }

        public int getCount() {
            return this.registerCount;
        }

        public boolean pastEnd() {
            return this.currentRegister >= this.registerCount;
        }
    }

    private static class Format35cRegisterIterator
    implements RegisterIterator {
        private final int registerCount;
        private final int[] registers;
        private int currentRegister = 0;

        public Format35cRegisterIterator(FiveRegisterInstruction instruction) {
            this.registerCount = instruction.getRegCount();
            this.registers = new int[]{instruction.getRegisterD(), instruction.getRegisterE(), instruction.getRegisterF(), instruction.getRegisterG(), instruction.getRegisterA()};
        }

        public int getRegister() {
            return this.registers[this.currentRegister];
        }

        public boolean moveNext() {
            ++this.currentRegister;
            return !this.pastEnd();
        }

        public int getCount() {
            return this.registerCount;
        }

        public boolean pastEnd() {
            return this.currentRegister >= this.registerCount;
        }
    }

    private static interface RegisterIterator {
        public int getRegister();

        public boolean moveNext();

        public int getCount();

        public boolean pastEnd();
    }
}

