/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import java.util.List;
import org.jf.dexlib.AnnotationDirectoryItem;
import org.jf.dexlib.AnnotationItem;
import org.jf.dexlib.AnnotationSetItem;
import org.jf.dexlib.AnnotationSetRefList;
import org.jf.dexlib.ClassDataItem;
import org.jf.dexlib.CodeItem;
import org.jf.dexlib.DebugInfoItem;
import org.jf.dexlib.EncodedArrayItem;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.StringDataItem;
import org.jf.dexlib.TypeListItem;
import org.jf.dexlib.Util.ExceptionWithContext;
import org.jf.dexlib.Util.SparseArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadContext {
    private SparseArray<TypeListItem> typeListItems = new SparseArray(0);
    private SparseArray<AnnotationSetRefList> annotationSetRefLists = new SparseArray(0);
    private SparseArray<AnnotationSetItem> annotationSetItems = new SparseArray(0);
    private SparseArray<ClassDataItem> classDataItems = new SparseArray(0);
    private SparseArray<CodeItem> codeItems = new SparseArray(0);
    private SparseArray<StringDataItem> stringDataItems = new SparseArray(0);
    private SparseArray<DebugInfoItem> debugInfoItems = new SparseArray(0);
    private SparseArray<AnnotationItem> annotationItems = new SparseArray(0);
    private SparseArray<EncodedArrayItem> encodedArrayItems = new SparseArray(0);
    private SparseArray<AnnotationDirectoryItem> annotationDirectoryItems = new SparseArray(0);
    private SparseArray[] itemsByType = new SparseArray[]{null, null, null, null, null, null, this.typeListItems, this.annotationSetRefLists, this.annotationSetItems, this.classDataItems, this.codeItems, this.stringDataItems, this.debugInfoItems, this.annotationItems, this.encodedArrayItems, this.annotationDirectoryItems, null, null};
    private int[] sectionSizes = new int[18];
    private int[] sectionOffsets = new int[18];

    public ReadContext() {
        for (int i = 0; i < 18; ++i) {
            this.sectionSizes[i] = -1;
            this.sectionOffsets[i] = -1;
        }
    }

    public Item getOffsettedItemByOffset(ItemType itemType, int offset) {
        assert (!itemType.isIndexedItem());
        SparseArray sa = this.itemsByType[itemType.SectionIndex];
        Item item = (Item)sa.get(offset);
        if (item == null) {
            throw new ExceptionWithContext(String.format("Could not find the %s item at offset %#x", itemType.TypeName, offset));
        }
        return item;
    }

    public Item getOptionalOffsettedItemByOffset(ItemType itemType, int offset) {
        assert (!itemType.isIndexedItem());
        assert (!itemType.isIndexedItem());
        SparseArray sa = this.itemsByType[itemType.SectionIndex];
        Item item = (Item)sa.get(offset);
        if (item == null && offset != 0) {
            throw new ExceptionWithContext(String.format("Could not find the %s item at offset %#x", itemType.TypeName, offset));
        }
        return item;
    }

    public void addSection(ItemType itemType, int sectionSize, int sectionOffset) {
        int storedSectionSize = this.sectionSizes[itemType.SectionIndex];
        if (storedSectionSize == -1) {
            this.sectionSizes[itemType.SectionIndex] = sectionSize;
        } else if (storedSectionSize != sectionSize) {
            throw new RuntimeException("The section size in the header and map for item type " + (Object)((Object)itemType) + " do not match");
        }
        int storedSectionOffset = this.sectionOffsets[itemType.SectionIndex];
        if (storedSectionOffset == -1) {
            this.sectionOffsets[itemType.SectionIndex] = sectionOffset;
        } else if (storedSectionOffset != sectionOffset) {
            throw new RuntimeException("The section offset in the header and map for item type " + (Object)((Object)itemType) + " do not match");
        }
    }

    public void setItemsForSection(ItemType itemType, List<? extends Item> items) {
        assert (!itemType.isIndexedItem());
        SparseArray sa = this.itemsByType[itemType.SectionIndex];
        sa.ensureCapacity(items.size());
        for (Item item : items) {
            sa.append(item.getOffset(), item);
        }
    }

    public int getSectionSize(ItemType itemType) {
        return this.sectionSizes[itemType.SectionIndex];
    }

    public int getSectionOffset(ItemType itemType) {
        return this.sectionOffsets[itemType.SectionIndex];
    }
}

