/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import android.content.Context;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.ViewGroup;
import com.adobe.air.AndroidActivityWrapper;

public class AIRStage3DSurfaceView
extends SurfaceView
implements SurfaceHolder.Callback {
    private AndroidActivityWrapper mActivityWrapper = null;
    private static final String TAG = "com.adobe.air";
    private long mFPInstance = 0L;
    private boolean mInit = false;
    private boolean mSurfaceValid = false;
    private int mXmin = 0;
    private int mYmin = 0;
    private int mXmax = 16;
    private int mYmax = 16;

    private native void nativeSurfaceCreated(long var1);

    private native void nativeSurfaceChanged(long var1, int var3, int var4);

    private native void nativeSurfaceLost(long var1);

    public AIRStage3DSurfaceView(Context context, AndroidActivityWrapper androidActivityWrapper, long l) {
        super(context);
        this.setFPInstance(context, androidActivityWrapper, l);
        this.setWillNotDraw(false);
        this.setEnabled(true);
        this.setClickable(false);
        this.setFocusable(false);
        this.setFocusableInTouchMode(false);
        this.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        this.getHolder().setFormat(1);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.setZOrderOnTop(false);
        this.mActivityWrapper.registerPlane(this, 6);
    }

    protected void onMeasure(int n, int n2) {
        this.setMeasuredDimension(this.mXmax - this.mXmin, this.mYmax - this.mYmin);
    }

    public void setPlanePosition(int n, int n2, int n3, int n4) {
        this.mXmin = n;
        this.mYmin = n2;
        this.mXmax = n3;
        this.mYmax = n4;
        this.layout(n, n2, n3, n4);
    }

    public boolean setFPInstance(Context context, AndroidActivityWrapper androidActivityWrapper, long l) {
        this.mActivityWrapper = androidActivityWrapper;
        this.mFPInstance = l;
        if (this.mFPInstance != 0L) {
            this.mActivityWrapper.registerPlane(this, 6);
        } else {
            this.mActivityWrapper.unregisterPlane(6);
        }
        return this.mSurfaceValid;
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
        if (this.mFPInstance != 0L) {
            this.nativeSurfaceChanged(this.mFPInstance, n2, n3);
        }
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        this.mSurfaceValid = true;
        if (this.mFPInstance != 0L) {
            this.nativeSurfaceCreated(this.mFPInstance);
        }
        this.mActivityWrapper.planeStepCascade();
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        this.mSurfaceValid = false;
        if (this.mFPInstance != 0L) {
            this.nativeSurfaceLost(this.mFPInstance);
        }
        this.mActivityWrapper.planeBreakCascade();
    }
}

