/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import android.content.res.Configuration;
import android.graphics.ImageFormat;
import android.hardware.Camera;
import android.view.SurfaceHolder;
import com.adobe.air.AndroidActivityWrapper;
import com.adobe.air.AndroidCameraView;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;

public class AndroidCamera {
    private static final String LOG_TAG = "AndroidCamera";
    private static final int CAMERA_POSITION_UNKNOWN = -1;
    private Camera mCamera = null;
    private long mClientId = 0L;
    private int mCameraId = 0;
    private boolean mInitialized = false;
    private boolean mCallbacksRegistered = false;
    private boolean mPreviewSurfaceValid = true;
    private boolean mCapturing = false;
    private AndroidActivityWrapper.StateChangeCallback mActivityStateCB = null;
    private byte[] mCallbackBuffer = null;
    private byte[] mBuffer1 = null;
    private byte[] mBuffer2 = null;
    private static Class<?> sCameraInfoClass = null;
    private static Method sMIDOpen = null;
    private static Method sMIDOpenWithCameraID = null;
    private static Method sMIDGetNumberOfCameras = null;
    private static Method sMIDGetCameraInfo = null;
    private static boolean sAreMultipleCamerasSupportedOnDevice = false;
    private static boolean sAreMultipleCamerasSupportedInitialized = false;

    private native void nativeOnFrameCaptured(long var1, byte[] var3);

    private native void nativeOnCanOpenCamera(long var1);

    private native void nativeOnShouldCloseCamera(long var1);

    public AndroidCamera(long l) {
        this.mClientId = l;
        AndroidCamera.areMultipleCamerasSupportedOnDevice();
    }

    public static boolean areMultipleCamerasSupportedOnDevice() {
        if (sAreMultipleCamerasSupportedInitialized) {
            return sAreMultipleCamerasSupportedOnDevice;
        }
        sAreMultipleCamerasSupportedInitialized = true;
        try {
            sMIDOpenWithCameraID = Camera.class.getMethod("open", Integer.TYPE);
            sMIDGetNumberOfCameras = Camera.class.getDeclaredMethod("getNumberOfCameras", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        try {
            sCameraInfoClass = Class.forName("android.hardware.Camera$CameraInfo");
            sMIDGetCameraInfo = Camera.class.getMethod("getCameraInfo", Integer.TYPE, sCameraInfoClass);
        }
        catch (Exception exception) {
            return false;
        }
        if (sMIDOpenWithCameraID != null && sMIDGetNumberOfCameras != null && sMIDGetCameraInfo != null) {
            sAreMultipleCamerasSupportedOnDevice = true;
        }
        return sAreMultipleCamerasSupportedOnDevice;
    }

    public boolean open(int n) {
        SurfaceHolder surfaceHolder;
        boolean bl;
        block7: {
            if (this.mCamera != null) {
                return true;
            }
            bl = false;
            surfaceHolder = null;
            try {
                AndroidCameraView androidCameraView = AndroidActivityWrapper.GetAndroidActivityWrapper().getCameraView();
                surfaceHolder = androidCameraView.getHolder();
                if (surfaceHolder != null && surfaceHolder.getSurface() != null) {
                    if (sAreMultipleCamerasSupportedOnDevice) {
                        this.mCamera = (Camera)sMIDOpenWithCameraID.invoke(null, n);
                        this.mCameraId = n;
                    } else {
                        this.mCamera = Camera.open();
                        this.mCameraId = 0;
                    }
                    this.mCamera.setPreviewDisplay(surfaceHolder);
                }
            }
            catch (Exception exception) {
                if (this.mCamera == null) break block7;
                this.mCamera.release();
                this.mCamera = null;
            }
        }
        if (this.mCamera != null) {
            surfaceHolder.addCallback((SurfaceHolder.Callback)new PreviewSurfaceCallback());
            bl = true;
        }
        return bl;
    }

    public Camera getCamera() {
        return this.mCamera;
    }

    public int[] getSupportedFps() {
        int[] nArray = new int[]{};
        try {
            Camera.Parameters parameters = this.mCamera.getParameters();
            List list = parameters.getSupportedPreviewFrameRates();
            nArray = new int[list.size()];
            int n = 0;
            for (Integer n2 : list) {
                nArray[n++] = n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nArray;
    }

    public int getCameraPosition() {
        int n = -1;
        if (sAreMultipleCamerasSupportedOnDevice) {
            Object object = null;
            Field field = null;
            if (sCameraInfoClass != null) {
                try {
                    object = sCameraInfoClass.newInstance();
                }
                catch (Exception exception) {
                    return n;
                }
            }
            try {
                sMIDGetCameraInfo.invoke((Object)this.mCamera, this.mCameraId, object);
            }
            catch (Exception exception) {
                return n;
            }
            if (object != null) {
                try {
                    field = object.getClass().getField("facing");
                }
                catch (Exception exception) {
                    return n;
                }
            }
            try {
                n = field.getInt(object);
            }
            catch (Exception exception) {
                return n;
            }
        }
        return n;
    }

    public static int getNumberOfCameras() {
        if (AndroidCamera.areMultipleCamerasSupportedOnDevice()) {
            try {
                return (Integer)sMIDGetNumberOfCameras.invoke(null, (Object[])null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 1;
    }

    public int[] getSupportedFormats() {
        int[] nArray = new int[]{};
        try {
            Camera.Parameters parameters = this.mCamera.getParameters();
            List list = parameters.getSupportedPreviewFormats();
            nArray = new int[list.size()];
            int n = 0;
            for (Integer n2 : list) {
                nArray[n++] = n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nArray;
    }

    public int[] getSupportedVideoSizes() {
        int[] nArray = new int[]{};
        try {
            Camera.Parameters parameters = this.mCamera.getParameters();
            List list = parameters.getSupportedPreviewSizes();
            nArray = new int[list.size() * 2];
            int n = 0;
            for (Camera.Size size : list) {
                nArray[n++] = size.width;
                nArray[n++] = size.height;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nArray;
    }

    public int getCaptureWidth() {
        int n = 0;
        try {
            Camera.Parameters parameters = this.mCamera.getParameters();
            Camera.Size size = parameters.getPreviewSize();
            n = size.width;
        }
        catch (Exception exception) {
            n = 0;
        }
        return n;
    }

    public int getCaptureHeight() {
        int n = 0;
        try {
            Camera.Parameters parameters = this.mCamera.getParameters();
            Camera.Size size = parameters.getPreviewSize();
            n = size.height;
        }
        catch (Exception exception) {
            n = 0;
        }
        return n;
    }

    public int getCaptureFormat() {
        int n = 0;
        try {
            Camera.Parameters parameters = this.mCamera.getParameters();
            n = parameters.getPreviewFormat();
        }
        catch (Exception exception) {
            n = 0;
        }
        return n;
    }

    public boolean setContinuousFocusMode() {
        if (this.mCamera == null) {
            return false;
        }
        boolean bl = false;
        try {
            Camera.Parameters parameters = this.mCamera.getParameters();
            List list = parameters.getSupportedFocusModes();
            if (list.contains("edof")) {
                parameters.setFocusMode("edof");
                this.mCamera.setParameters(parameters);
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public boolean autoFocus() {
        if (this.mCamera == null || !this.mCapturing) {
            return false;
        }
        boolean bl = false;
        try {
            Camera.Parameters parameters = this.mCamera.getParameters();
            String string = parameters.getFocusMode();
            if (string != "fixed" && string != "infinity") {
                this.mCamera.autoFocus(null);
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public boolean startCapture(int n, int n2, int n3, int n4) {
        if (this.mCamera == null) {
            return false;
        }
        boolean bl = false;
        try {
            Camera.Parameters parameters = this.mCamera.getParameters();
            parameters.setPreviewSize(n, n2);
            parameters.setPreviewFrameRate(n3);
            parameters.setPreviewFormat(n4);
            this.mCamera.setParameters(parameters);
            this.mCamera.setPreviewCallbackWithBuffer(new Camera.PreviewCallback(){

                public void onPreviewFrame(byte[] byArray, Camera camera) {
                    try {
                        if (AndroidCamera.this.mClientId != 0L && AndroidCamera.this.mCallbacksRegistered) {
                            AndroidCamera.this.nativeOnFrameCaptured(AndroidCamera.this.mClientId, byArray);
                        }
                        if (AndroidCamera.this.mCallbackBuffer == AndroidCamera.this.mBuffer1) {
                            AndroidCamera.access$302(AndroidCamera.this, AndroidCamera.this.mBuffer2);
                        } else {
                            AndroidCamera.access$302(AndroidCamera.this, AndroidCamera.this.mBuffer1);
                        }
                        AndroidCamera.this.mCamera.addCallbackBuffer(AndroidCamera.this.mCallbackBuffer);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            this.mCamera.startPreview();
            parameters = this.mCamera.getParameters();
            int n5 = parameters.getPreviewSize().width * parameters.getPreviewSize().height * ImageFormat.getBitsPerPixel((int)parameters.getPreviewFormat());
            this.mBuffer1 = new byte[n5];
            this.mBuffer2 = new byte[n5];
            this.mCallbackBuffer = this.mBuffer1;
            this.mCamera.addCallbackBuffer(this.mCallbackBuffer);
            bl = true;
            this.mCapturing = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public void stopCapture() {
        if (this.mCamera != null) {
            this.mCamera.setPreviewCallback(null);
            this.mCamera.stopPreview();
            this.mCallbackBuffer = null;
            this.mBuffer1 = null;
            this.mBuffer2 = null;
        }
        this.mCapturing = false;
    }

    public void close() {
        if (this.mCamera != null) {
            this.stopCapture();
            this.mCamera.release();
            this.mCamera = null;
        }
    }

    public void registerCallbacks(boolean bl) {
        this.mCallbacksRegistered = bl;
        if (bl) {
            if (this.mActivityStateCB == null) {
                this.mActivityStateCB = new AndroidActivityWrapper.StateChangeCallback(){

                    public void onActivityStateChanged(AndroidActivityWrapper.ActivityState activityState) {
                        if (AndroidCamera.this.mClientId != 0L && AndroidCamera.this.mCallbacksRegistered) {
                            if (activityState == AndroidActivityWrapper.ActivityState.RESUMED && AndroidCamera.this.mPreviewSurfaceValid) {
                                AndroidCamera.this.nativeOnCanOpenCamera(AndroidCamera.this.mClientId);
                            } else if (activityState == AndroidActivityWrapper.ActivityState.PAUSED) {
                                AndroidCamera.this.nativeOnShouldCloseCamera(AndroidCamera.this.mClientId);
                            }
                        }
                    }

                    public void onConfigurationChanged(Configuration configuration) {
                    }
                };
            }
            AndroidActivityWrapper.GetAndroidActivityWrapper().addActivityStateChangeListner(this.mActivityStateCB);
        } else {
            if (this.mActivityStateCB != null) {
                AndroidActivityWrapper.GetAndroidActivityWrapper().removeActivityStateChangeListner(this.mActivityStateCB);
            }
            this.mActivityStateCB = null;
        }
    }

    static /* synthetic */ byte[] access$302(AndroidCamera androidCamera, byte[] byArray) {
        androidCamera.mCallbackBuffer = byArray;
        return byArray;
    }

    class PreviewSurfaceCallback
    implements SurfaceHolder.Callback {
        PreviewSurfaceCallback() {
        }

        public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
        }

        public void surfaceCreated(SurfaceHolder surfaceHolder) {
            AndroidCamera.this.mPreviewSurfaceValid = true;
            if (AndroidCamera.this.mClientId != 0L && AndroidCamera.this.mCallbacksRegistered) {
                AndroidCamera.this.nativeOnCanOpenCamera(AndroidCamera.this.mClientId);
            }
        }

        public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
            AndroidCamera.this.mPreviewSurfaceValid = false;
            if (AndroidCamera.this.mClientId != 0L && AndroidCamera.this.mCallbacksRegistered) {
                AndroidCamera.this.nativeOnShouldCloseCamera(AndroidCamera.this.mClientId);
            }
        }
    }
}

