/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.PowerManager;
import com.adobe.air.AndroidActivityWrapper;

public class AndroidIdleState {
    private static final String IDLE_STATE_TAG = "AndroidIdleState";
    public static final int IDLE_STATE_NORMAL = 0;
    public static final int IDLE_STATE_WAKEUP = 1;
    private PowerManager.WakeLock mScreenBrightLock = null;
    private KeyguardManager.KeyguardLock mKeyGuardLock = null;
    private boolean mIsWakeUpLockHeld = false;
    private int mCurrentIdleState = 0;
    private BroadcastReceiver sReceiver = null;
    private boolean sScreenOn = true;
    private static AndroidIdleState mIdleStateManager = null;

    public static AndroidIdleState GetIdleStateManager(Context context) {
        if (mIdleStateManager == null) {
            mIdleStateManager = new AndroidIdleState(context);
        }
        return mIdleStateManager;
    }

    private AndroidIdleState(Context context) {
        if (this.sReceiver == null) {
            try {
                this.sReceiver = new BroadcastReceiver(){

                    public void onReceive(Context context, Intent intent) {
                        boolean bl = true;
                        if (intent.getAction().equals("android.intent.action.SCREEN_OFF")) {
                            bl = false;
                        } else if (intent.getAction().equals("android.intent.action.SCREEN_ON")) {
                            bl = true;
                        }
                        if (AndroidIdleState.this.sScreenOn != bl) {
                            AndroidIdleState.this.sScreenOn = bl;
                            AndroidActivityWrapper androidActivityWrapper = AndroidActivityWrapper.GetAndroidActivityWrapper();
                            androidActivityWrapper.onScreenStateChanged(AndroidIdleState.this.sScreenOn);
                        }
                    }
                };
                IntentFilter intentFilter = new IntentFilter("android.intent.action.SCREEN_ON");
                intentFilter.addAction("android.intent.action.SCREEN_OFF");
                context.registerReceiver(this.sReceiver, intentFilter);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void ChangeIdleState(Context context, int n) {
        block6: {
            try {
                if (n == 0) {
                    this.releaseLock();
                    this.mCurrentIdleState = 0;
                    break block6;
                }
                if (this.mScreenBrightLock == null) {
                    try {
                        PowerManager powerManager = (PowerManager)context.getSystemService("power");
                        this.mScreenBrightLock = powerManager.newWakeLock(0x1000000A, "DoNotDimScreen");
                        KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
                        this.mKeyGuardLock = keyguardManager.newKeyguardLock("DoNotLockKeys");
                    }
                    catch (Exception exception) {
                        this.mScreenBrightLock = null;
                        this.mKeyGuardLock = null;
                        return;
                    }
                }
                this.mCurrentIdleState = 1;
                this.acquireLock();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void acquireLock() {
        try {
            if (this.mCurrentIdleState == 1 && !this.mIsWakeUpLockHeld) {
                this.mScreenBrightLock.acquire();
                this.mKeyGuardLock.disableKeyguard();
                this.mIsWakeUpLockHeld = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void releaseLock() {
        try {
            if (this.mCurrentIdleState == 1 && this.mIsWakeUpLockHeld) {
                this.mScreenBrightLock.release();
                this.mKeyGuardLock.reenableKeyguard();
                this.mIsWakeUpLockHeld = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

