/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import android.text.Editable;
import android.view.View;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputMethodManager;
import com.adobe.air.AIRWindowSurfaceView;

public class AndroidInputConnection
extends BaseInputConnection {
    private final AIRWindowSurfaceView mWindowSurfaceView;
    private ExtractedTextRequest mExtractRequest = null;
    private CharSequence mComposedText = null;
    private ExtractedText mExtractedText = null;

    private native String nativeGetTextBeforeCursor(int var1);

    private native String nativeGetTextAfterCursor(int var1);

    private native void nativeSetSelection(int var1, int var2);

    private native int nativeGetTextBoxMaxChars();

    public AndroidInputConnection(AIRWindowSurfaceView aIRWindowSurfaceView) {
        super((View)aIRWindowSurfaceView, true);
        this.mWindowSurfaceView = aIRWindowSurfaceView;
    }

    public boolean deleteSurroundingText(int n, int n2) {
        int n3;
        for (n3 = 0; n3 < n2; ++n3) {
            this.mWindowSurfaceView.nativeOnKeyListener(0, 22, 0, false, false, false);
            this.mWindowSurfaceView.nativeOnKeyListener(1, 22, 0, false, false, false);
        }
        int n4 = n2 + n;
        for (n3 = 0; n3 < n4; ++n3) {
            this.mWindowSurfaceView.nativeOnKeyListener(0, 67, 0, false, false, false);
            this.mWindowSurfaceView.nativeOnKeyListener(1, 67, 0, false, false, false);
        }
        return true;
    }

    public CharSequence getTextAfterCursor(int n, int n2) {
        return this.nativeGetTextAfterCursor(n);
    }

    public CharSequence getTextBeforeCursor(int n, int n2) {
        return this.nativeGetTextBeforeCursor(n);
    }

    public ExtractedText getExtractedText(ExtractedTextRequest extractedTextRequest, int n) {
        this.mWindowSurfaceView.setInputConnection(this);
        ExtractedText extractedText = this.mWindowSurfaceView.nativeGetTextContent();
        if (extractedText != null && extractedText.text != null) {
            extractedText.partialEndOffset = -1;
            extractedText.partialStartOffset = -1;
            if ((n & 1) != 0) {
                extractedText.startOffset = 0;
                this.mExtractedText = extractedText;
                this.mExtractRequest = extractedTextRequest;
                this.mWindowSurfaceView.nativeShowOriginalRect();
            }
            return extractedText;
        }
        return null;
    }

    public Editable getEditable() {
        return null;
    }

    public boolean performEditorAction(int n) {
        if (n == 6) {
            this.mWindowSurfaceView.showSoftKeyboard(false);
            this.mWindowSurfaceView.nativeDispatchUserTriggeredSkDeactivateEvent();
            return true;
        }
        return false;
    }

    public boolean performContextMenuAction(int n) {
        switch (n) {
            case 16908319: {
                n = 0;
                break;
            }
            case 0x1020020: {
                if (this.mWindowSurfaceView.nativeIsTextSelected()) {
                    n = 1;
                    break;
                }
                n = 2;
                break;
            }
            case 0x1020021: {
                if (this.mWindowSurfaceView.nativeIsTextSelected()) {
                    n = 3;
                    break;
                }
                n = 4;
                break;
            }
            case 0x1020022: {
                n = 5;
                break;
            }
            case 16908324: {
                n = 6;
                break;
            }
            case 16908328: {
                n = 7;
                break;
            }
            case 16908329: {
                n = 8;
                break;
            }
            default: {
                return false;
            }
        }
        return this.mWindowSurfaceView.onTextBoxContextMenuItem(n);
    }

    public boolean setComposingText(CharSequence charSequence, int n) {
        block4: {
            int n2;
            block5: {
                int n3 = this.nativeGetTextBoxMaxChars();
                if (n3 != 0 && charSequence.length() > 0) {
                    int n4;
                    ExtractedText extractedText = this.mWindowSurfaceView.nativeGetTextContent();
                    n2 = n3 - extractedText.text.length() + extractedText.selectionEnd - extractedText.selectionStart;
                    int n5 = 0;
                    if (this.mComposedText != null) {
                        n5 = this.mComposedText.length();
                    }
                    charSequence = (n4 = Math.min(n5 + n2, charSequence.length())) > 0 ? charSequence.subSequence(0, n4) : null;
                }
                if (charSequence == null) break block4;
                this.writeText(charSequence);
                this.mComposedText = charSequence;
                if (n > 0) break block5;
                int n6 = charSequence.length() + Math.abs(n);
                for (n2 = 0; n2 < n6; ++n2) {
                    this.mWindowSurfaceView.nativeOnKeyListener(0, 21, 0, false, false, false);
                    this.mWindowSurfaceView.nativeOnKeyListener(1, 21, 0, false, false, false);
                }
                break block4;
            }
            if (n <= 1) break block4;
            int n7 = n - 1;
            for (n2 = 0; n2 < n7; ++n2) {
                this.mWindowSurfaceView.nativeOnKeyListener(0, 22, 0, false, false, false);
                this.mWindowSurfaceView.nativeOnKeyListener(1, 22, 0, false, false, false);
            }
        }
        return true;
    }

    public boolean finishComposingText() {
        this.mComposedText = null;
        if (this.mWindowSurfaceView.getIsFullScreen() && !this.mWindowSurfaceView.IsSurfaceChangedForSoftKeyboard()) {
            this.mWindowSurfaceView.nativeShowOriginalRect();
        }
        return true;
    }

    public boolean setSelection(int n, int n2) {
        this.nativeSetSelection(n, n2);
        return true;
    }

    public boolean commitText(CharSequence charSequence, int n) {
        this.writeText(charSequence);
        this.mComposedText = null;
        return true;
    }

    private void writeText(CharSequence charSequence) {
        int n;
        int n2 = charSequence.length();
        if (this.mComposedText != null) {
            int n3 = this.mComposedText.length();
            int n4 = Math.min(n2, n3);
            for (n = 0; n < n4 && charSequence.charAt(n) == this.mComposedText.charAt(n); ++n) {
            }
            for (int i = n; i < n3; ++i) {
                this.mWindowSurfaceView.nativeOnKeyListener(0, 67, 0, false, false, false);
                this.mWindowSurfaceView.nativeOnKeyListener(1, 67, 0, false, false, false);
            }
        }
        while (n < n2) {
            this.mWindowSurfaceView.nativeOnKeyListener(0, 0, charSequence.charAt(n), false, false, false);
            this.mWindowSurfaceView.nativeOnKeyListener(1, 0, charSequence.charAt(n), false, false, false);
            ++n;
        }
        this.updateIMEText();
    }

    public void updateIMEText() {
        if (this.mExtractRequest == null) {
            return;
        }
        InputMethodManager inputMethodManager = this.mWindowSurfaceView.getInputMethodManager();
        if (inputMethodManager != null && inputMethodManager.isActive((View)this.mWindowSurfaceView)) {
            ExtractedText extractedText = this.mWindowSurfaceView.nativeGetTextContent();
            boolean bl = ((Object)extractedText.text).toString().equals(((Object)this.mExtractedText.text).toString());
            if (!bl || extractedText.selectionStart != this.mExtractedText.selectionStart || extractedText.selectionEnd != this.mExtractedText.selectionEnd || extractedText.flags != this.mExtractedText.flags) {
                extractedText.startOffset = 0;
                if (bl) {
                    extractedText.partialStartOffset = 0;
                    extractedText.partialEndOffset = 0;
                    extractedText.text = "";
                    this.mExtractedText.flags = extractedText.flags;
                    this.mExtractedText.selectionStart = extractedText.selectionStart;
                    this.mExtractedText.selectionEnd = extractedText.selectionEnd;
                } else {
                    extractedText.partialStartOffset = -1;
                    extractedText.partialEndOffset = -1;
                    this.mExtractedText = extractedText;
                }
                inputMethodManager.updateExtractedText((View)this.mWindowSurfaceView, this.mExtractRequest.token, extractedText);
            }
        }
    }

    public void Reset() {
        this.mComposedText = null;
        this.mExtractRequest = null;
        this.mExtractedText = null;
    }
}

