/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import android.content.Context;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.ViewParent;
import com.adobe.air.AndroidActivityWrapper;
import com.adobe.air.FlashEGL;

public class AndroidVideoSurfaceView
extends SurfaceView
implements SurfaceHolder.Callback {
    private static final String kLogTag = "com.adobe.air AVSV";
    private static final int kDefaultPixelFormat = -3;
    private long mFPInstance = 0L;
    private ViewParent mParent;
    private AndroidActivityWrapper mActivityWrapper;
    private FlashEGL m_videoFlashEGL = null;
    private boolean mIsSurfaceCreated = false;
    private static AndroidVideoSurfaceView gInstance = null;

    protected boolean getSurfaceCreated() {
        return this.mIsSurfaceCreated;
    }

    protected void setSurfaceCreated(boolean bl) {
        this.mIsSurfaceCreated = bl;
    }

    private native void nativeSetIsCreated(long var1);

    private native void nativeSetSurfaceSize(long var1, int var3, int var4);

    private native void nativeSetIsNotCreated(long var1);

    public static AndroidVideoSurfaceView CreateInstance(long l, Context context, AndroidActivityWrapper androidActivityWrapper) {
        Log.d((String)kLogTag, (String)"CreateInstance");
        if (gInstance == null) {
            gInstance = new AndroidVideoSurfaceView(l, context, androidActivityWrapper);
        }
        return gInstance;
    }

    public AndroidVideoSurfaceView(long l, Context context, AndroidActivityWrapper androidActivityWrapper) {
        super(context);
        this.mFPInstance = l;
        this.mActivityWrapper = androidActivityWrapper;
        this.setWillNotDraw(false);
        this.setEnabled(true);
        this.setClickable(false);
        this.setFocusable(false);
        this.setFocusableInTouchMode(false);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.getHolder().setFormat(4);
        this.mActivityWrapper.registerPlane(this, 7);
        this.mActivityWrapper.planeStepCascade();
    }

    public boolean isSurfaceCreated() {
        return this.getSurfaceCreated();
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        Log.d((String)kLogTag, (String)"SurfaceCreated");
        this.setSurfaceCreated(true);
        this.mActivityWrapper.planeStepCascade();
        this.nativeSetIsCreated(this.mFPInstance);
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
        Log.d((String)kLogTag, (String)("SurfaceChanged format: " + n + "; w,h: " + n2 + "," + n3));
        this.nativeSetSurfaceSize(this.mFPInstance, n2, n3);
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        Log.d((String)kLogTag, (String)"SurfaceDestroyed");
        this.setSurfaceCreated(false);
        this.mActivityWrapper.planeBreakCascade();
        this.nativeSetIsNotCreated(this.mFPInstance);
    }

    public FlashEGL getVideoEgl() {
        Log.d((String)kLogTag, (String)"getVideoEgl");
        if (this.m_videoFlashEGL == null) {
            this.m_videoFlashEGL = new FlashEGL();
        }
        Log.d((String)kLogTag, (String)("getVideoEgl  " + this.m_videoFlashEGL));
        return this.m_videoFlashEGL;
    }
}

