/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Picture;
import android.graphics.Rect;
import android.net.Uri;
import android.net.http.SslError;
import android.util.AttributeSet;
import android.util.Base64;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.SslErrorHandler;
import android.webkit.URLUtil;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.AutoCompleteTextView;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.adobe.air.AIRWindowSurfaceView;
import com.adobe.air.AndroidActivityWrapper;
import com.adobe.air.SSLSecurityDialog;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;

public class AndroidWebView
implements AndroidActivityWrapper.StateChangeCallback {
    private static final String LOG_TAG = "AndroidWebView";
    private static final int FOCUS_NONE = 1;
    private static final int FOCUS_UP = 2;
    private static final int FOCUS_DOWN = 3;
    private static final int ERROR_PROTOCOL_UNSUPPORTED = 3229;
    private static final int ERROR_OTHER = 0;
    private long mInternalReference = 0L;
    private Context mContext = AndroidActivityWrapper.GetAndroidActivityWrapper().getActivity();
    private AndroidWebViewImpl mView = new AndroidWebViewImpl(this.mContext);
    private AIRWindowSurfaceView mAIRSurface;
    private RelativeLayout mLayout;
    private Rect mBounds = null;
    private Rect mGlobalBounds = null;
    private WebViewCustomView mCustomViewHolder;
    private String mUrl = null;

    public AndroidWebView() {
        WebSettings webSettings = this.mView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setBuiltInZoomControls(true);
        webSettings.setNeedInitialFocus(true);
        webSettings.setPluginsEnabled(true);
        this.mView.setScrollbarFadingEnabled(true);
        this.mView.setScrollBarStyle(0x2000000);
        final AndroidWebView androidWebView = this;
        this.mView.setWebChromeClient(new WebChromeClient(){
            private ValueCallback<Uri> mUploadMessage;

            public void onShowCustomView(View view, WebChromeClient.CustomViewCallback customViewCallback) {
                if (AndroidWebView.this.mCustomViewHolder == null) {
                    AndroidWebView.this.mCustomViewHolder = new WebViewCustomView();
                }
                AndroidWebView.this.mCustomViewHolder.onShowCustomView(view, customViewCallback);
            }

            public void onHideCustomView() {
                if (AndroidWebView.this.mCustomViewHolder != null) {
                    AndroidWebView.this.mCustomViewHolder.onHideCustomView();
                }
            }

            public void openFileChooser(ValueCallback<Uri> valueCallback) {
                if (this.mUploadMessage != null) {
                    return;
                }
                this.mUploadMessage = valueCallback;
                final AndroidActivityWrapper androidActivityWrapper = AndroidActivityWrapper.GetAndroidActivityWrapper();
                AndroidActivityWrapper.ActivityResultCallback activityResultCallback = new AndroidActivityWrapper.ActivityResultCallback(){

                    public void onActivityResult(int n, int n2, Intent intent) {
                        if (n != 5) {
                            return;
                        }
                        if (mUploadMessage != null) {
                            Uri uri = intent == null || n2 != -1 ? null : intent.getData();
                            mUploadMessage.onReceiveValue((Object)uri);
                            mUploadMessage = null;
                        }
                        androidActivityWrapper.removeActivityResultListener(this);
                    }
                };
                androidActivityWrapper.addActivityResultListener(activityResultCallback);
                Intent intent = new Intent("android.intent.action.GET_CONTENT");
                intent.addCategory("android.intent.category.OPENABLE");
                intent.setType("*/*");
                Activity activity = androidActivityWrapper.getActivity();
                activity.startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)""), 5);
            }
        });
        this.mView.setWebViewClient(new WebViewClient(){
            private String mUrl = null;
            private String mLastPageStartedUrl = null;
            private String mNoCompleteForUrl = null;

            public void onPageStarted(WebView webView, String string, Bitmap bitmap) {
                super.onPageStarted(webView, string, bitmap);
                this.mUrl = string;
                this.mLastPageStartedUrl = string;
            }

            public boolean shouldOverrideUrlLoading(WebView webView, String string) {
                boolean bl = androidWebView.onLocationChanging(string);
                if (bl) {
                    this.mNoCompleteForUrl = string;
                }
                return bl;
            }

            public void onPageFinished(WebView webView, String string) {
                if (string != null && this.mNoCompleteForUrl != null && string.equals(this.mNoCompleteForUrl)) {
                    this.mNoCompleteForUrl = null;
                    return;
                }
                this.mUrl = string;
                androidWebView.onLoadComplete(string);
            }

            public void onReceivedSslError(WebView webView, final SslErrorHandler sslErrorHandler, final SslError sslError) {
                if (this.mUrl == null || sslError.getCertificate() == null) {
                    return;
                }
                final String string = this.mUrl;
                Thread thread = new Thread(){

                    public void run() {
                        boolean bl = false;
                        if (sslError.getCertificate() != null) {
                            SSLSecurityDialog sSLSecurityDialog = new SSLSecurityDialog();
                            sSLSecurityDialog.show(string, sslError.getCertificate());
                            String string2 = sSLSecurityDialog.getUserAction();
                            if (string2.equals("session")) {
                                bl = true;
                            }
                        }
                        if (bl) {
                            sslErrorHandler.proceed();
                        } else {
                            sslErrorHandler.cancel();
                        }
                    }
                };
                thread.start();
            }

            public void doUpdateVisitedHistory(WebView webView, String string, boolean bl) {
                if (this.mLastPageStartedUrl != null && this.mLastPageStartedUrl.equals(string)) {
                    androidWebView.onLocationChange(string);
                }
            }

            public void onReceivedError(WebView webView, int n, String string, String string2) {
                this.mNoCompleteForUrl = string2;
                if (n == -10) {
                    androidWebView.onLoadError(string2, "[" + n + "] " + string + ": " + string2, 3229);
                } else {
                    androidWebView.onLoadError(string2, "[" + n + "] " + string + ": " + string2, 0);
                }
            }
        });
    }

    public void onActivityStateChanged(AndroidActivityWrapper.ActivityState activityState) {
        try {
            Method method = WebView.class.getMethod("isPaused", new Class[0]);
            Method method2 = WebView.class.getMethod("onResume", new Class[0]);
            Method method3 = WebView.class.getMethod("onPause", new Class[0]);
            boolean bl = (Boolean)method.invoke((Object)this.mView, new Object[0]);
            switch (activityState) {
                case RESUMED: {
                    if (!bl) break;
                    method2.invoke((Object)this.mView, new Object[0]);
                    this.mView.resumeTimers();
                    WebView.enablePlatformNotifications();
                    break;
                }
                case PAUSED: {
                    if (bl) break;
                    WebView.disablePlatformNotifications();
                    this.mView.pauseTimers();
                    method3.invoke((Object)this.mView, new Object[0]);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (activityState) {
            case STARTED: {
                if (this.mCustomViewHolder != null) break;
                this.mCustomViewHolder = new WebViewCustomView();
                break;
            }
            case DESTROYED: {
                if (this.mCustomViewHolder == null) break;
                this.mCustomViewHolder.onHideCustomView();
                this.mCustomViewHolder = null;
            }
        }
    }

    public void onConfigurationChanged(Configuration configuration) {
    }

    public void setInternalReference(long l) {
        this.mInternalReference = l;
    }

    public void destroyInternals() {
        this.removedFromStage();
        this.mInternalReference = 0L;
        this.mView.destroy();
        this.mView = null;
    }

    public void stop() {
        this.mView.stopLoading();
    }

    public void reload() {
        this.mView.reload();
    }

    public void goBack() {
        this.mView.goBack();
    }

    public void goForward() {
        this.mView.goForward();
    }

    public boolean canGoBack() {
        return this.mView.canGoBack();
    }

    public boolean canGoForward() {
        return this.mView.canGoForward();
    }

    public void addedToStage(AIRWindowSurfaceView aIRWindowSurfaceView) {
        if (this.mLayout != null) {
            this.removedFromStage();
        }
        this.mAIRSurface = aIRWindowSurfaceView;
        AndroidActivityWrapper androidActivityWrapper = aIRWindowSurfaceView.getActivityWrapper();
        androidActivityWrapper.addActivityStateChangeListner(this);
        this.mLayout = androidActivityWrapper.getOverlaysLayout(true);
        this.mLayout.addView((View)this.mView, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(0, 0));
    }

    public void removedFromStage() {
        if (this.mLayout != null) {
            this.mLayout.removeView((View)this.mView);
            this.mLayout = null;
            AndroidActivityWrapper androidActivityWrapper = this.mAIRSurface.getActivityWrapper();
            androidActivityWrapper.didRemoveOverlay();
            androidActivityWrapper.removeActivityStateChangeListner(this);
            this.mAIRSurface.updateFocusedStageWebView(this, false);
        }
        this.mAIRSurface = null;
    }

    public void setVisibility(boolean bl) {
        int n;
        int n2 = n = bl ? 0 : 4;
        if (this.mView.getVisibility() != n) {
            this.mView.setVisibility(n);
        }
    }

    public long updateViewBoundsWithKeyboard(int n) {
        Rect rect;
        int n2 = 0;
        this.mGlobalBounds = this.mBounds;
        if (this.mAIRSurface != null && this.isInTextEditingMode() && !(rect = new Rect(0, 0, this.mAIRSurface.getVisibleBoundWidth(), this.mAIRSurface.getVisibleBoundHeight())).contains(this.mBounds)) {
            int n3;
            int n4 = Math.min(Math.max(0, this.mBounds.top), n);
            if (n4 == (n3 = Math.min(Math.max(0, this.mBounds.bottom), n))) {
                return 0L;
            }
            int n5 = n3 - rect.bottom;
            if (n5 <= 0) {
                return 0L;
            }
            if (n5 <= n4) {
                n2 = n5;
            } else {
                n2 = n4;
                this.mGlobalBounds = new Rect(this.mBounds);
                this.mGlobalBounds.bottom = rect.bottom + n2;
            }
        }
        this.refreshGlobalBounds();
        return n2;
    }

    public void resetGlobalBounds() {
        this.mGlobalBounds = this.mBounds;
        this.refreshGlobalBounds();
    }

    private void refreshGlobalBounds() {
        if (this.mView == null) {
            return;
        }
        this.mView.post(new Runnable(){

            public void run() {
                if (AndroidWebView.this.mView == null) {
                    return;
                }
                RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(AndroidWebView.this.mGlobalBounds.width(), AndroidWebView.this.mGlobalBounds.height());
                layoutParams.leftMargin = ((AndroidWebView)AndroidWebView.this).mGlobalBounds.left;
                layoutParams.topMargin = ((AndroidWebView)AndroidWebView.this).mGlobalBounds.top;
                AndroidWebView.this.mView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                AndroidWebView.this.mView.requestLayout();
            }
        });
    }

    public void adjustViewBounds(double d, double d2, double d3, double d4) {
        this.mGlobalBounds = this.mBounds = new Rect((int)d, (int)d2, (int)(d + d3), (int)(d2 + d4));
        this.refreshGlobalBounds();
    }

    public void loadString(String string, String string2) {
        try {
            boolean bl;
            byte[] byArray = string.getBytes("utf-8");
            boolean bl2 = bl = byArray.length >= 3 && byArray[0] == 239 && byArray[1] == 187 && byArray[2] == 191;
            if (!bl) {
                byte[] byArray2 = new byte[byArray.length + 3];
                System.arraycopy(byArray, 0, byArray2, 3, byArray.length);
                byArray2[0] = -17;
                byArray2[1] = -69;
                byArray2[2] = -65;
                byArray = byArray2;
            }
            string = Base64.encodeToString((byte[])byArray, (int)0, (int)byArray.length, (int)2);
            this.mView.loadData(string, "text/html", "base64");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void loadURL(String string) {
        if (string == null) {
            return;
        }
        this.mView.loadUrl(string);
    }

    public boolean onLocationChange(String string) {
        if (this.mInternalReference == 0L) {
            return true;
        }
        this.mUrl = string;
        return this.dispatchLocationChange(this.mInternalReference);
    }

    private String decodeURL(String string) {
        String string2 = string;
        try {
            string2 = new String(URLUtil.decode((byte[])string.getBytes()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return string2;
    }

    public boolean onLocationChanging(String string) {
        if (this.mInternalReference == 0L) {
            return true;
        }
        return this.dispatchLocationChanging(this.mInternalReference, this.decodeURL(string));
    }

    public void onLoadComplete(String string) {
        if (this.mInternalReference == 0L) {
            return;
        }
        this.mUrl = string;
        this.dispatchLoadComplete(this.mInternalReference);
    }

    public void onLoadError(String string, String string2, int n) {
        if (this.mInternalReference == 0L) {
            return;
        }
        this.mUrl = string;
        this.dispatchLoadError(this.mInternalReference, string2, n);
    }

    public String getCurrentLocation() {
        String string = this.mUrl;
        string = string == null ? "about:blank" : this.decodeURL(string);
        return string;
    }

    public String getPageTitle() {
        String string = this.mView.getTitle();
        if (string == null) {
            string = "";
        }
        return string;
    }

    public void assignFocus(int n) {
        switch (n) {
            case 1: {
                this.mView.requestFocus();
                break;
            }
            case 2: {
                this.mView.pageUp(true);
                this.mView.requestFocus(33);
                break;
            }
            case 3: {
                this.mView.pageDown(true);
                this.mView.requestFocus(130);
            }
        }
    }

    public void clearFocus() {
        this.mView.clearFocus();
        this.mAIRSurface.requestFocus();
    }

    public void setStageFocus(int n) {
        this.mView.clearFocus();
        this.mAIRSurface.requestFocus(n);
    }

    public Bitmap captureSnapshot(int n, int n2) {
        if (n < 0 || n2 < 0) {
            return null;
        }
        if (n == 0 && n2 == 0) {
            return null;
        }
        Picture picture = null;
        Bitmap.Config config = Bitmap.Config.ARGB_8888;
        Bitmap bitmap = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)config);
        Canvas canvas = new Canvas(bitmap);
        canvas.translate((float)(-this.mView.getScrollX()), (float)(-this.mView.getScrollY()));
        boolean bl = this.mView.isHorizontalScrollBarEnabled();
        boolean bl2 = this.mView.isVerticalScrollBarEnabled();
        this.mView.setHorizontalScrollBarEnabled(false);
        this.mView.setVerticalScrollBarEnabled(false);
        try {
            this.mView.draw(canvas);
        }
        catch (Exception exception) {
            picture = this.mView.capturePicture();
            float f = this.mView.getScale();
            canvas.scale(f, f);
            picture.draw(canvas);
        }
        this.mView.setHorizontalScrollBarEnabled(bl);
        this.mView.setVerticalScrollBarEnabled(bl2);
        canvas = null;
        picture = null;
        return bitmap;
    }

    public boolean isInTextEditingMode() {
        return this.mView.isInTextEditingMode();
    }

    private native boolean dispatchLocationChange(long var1);

    private native boolean dispatchLocationChanging(long var1, String var3);

    private native void dispatchLoadError(long var1, String var3, int var4);

    private native void dispatchLoadComplete(long var1);

    private native void dispatchFocusIn(long var1, int var3);

    private native void dispatchFocusOut(long var1, int var3);

    public class AndroidWebViewImpl
    extends WebView {
        private boolean m_inRequestChildFocus;
        private View m_focusedChildView;
        private boolean m_hasFocus;
        private int mLastFocusDirection;

        public AndroidWebViewImpl(Context context) {
            super(context);
            this.m_inRequestChildFocus = false;
            this.m_focusedChildView = null;
            this.m_hasFocus = false;
            this.mLastFocusDirection = 0;
        }

        public AndroidWebViewImpl(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.m_inRequestChildFocus = false;
            this.m_focusedChildView = null;
            this.m_hasFocus = false;
            this.mLastFocusDirection = 0;
        }

        public AndroidWebViewImpl(Context context, AttributeSet attributeSet, int n) {
            super(context, attributeSet, n);
            this.m_inRequestChildFocus = false;
            this.m_focusedChildView = null;
            this.m_hasFocus = false;
            this.mLastFocusDirection = 0;
        }

        public boolean dispatchTouchEvent(MotionEvent motionEvent) {
            if (!this.m_hasFocus) {
                this.requestFocus();
            }
            return super.dispatchTouchEvent(motionEvent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestChildFocus(View view, View view2) {
            this.m_inRequestChildFocus = true;
            if (!this.m_hasFocus) {
                this.setRealFocus(true);
            }
            try {
                this.m_focusedChildView = view;
                super.requestChildFocus(view, view2);
            }
            finally {
                this.m_inRequestChildFocus = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearChildFocus(View view) {
            this.m_inRequestChildFocus = true;
            try {
                super.clearChildFocus(view);
            }
            finally {
                this.m_inRequestChildFocus = false;
            }
        }

        public void clearFocus() {
            if (this.m_focusedChildView != null) {
                this.m_focusedChildView.clearFocus();
                if (AutoCompleteTextView.class.isInstance(this.m_focusedChildView)) {
                    AndroidWebView.this.mView.removeView(this.m_focusedChildView);
                }
                this.m_focusedChildView = null;
                this.setRealFocus(false);
            } else {
                super.clearFocus();
            }
        }

        private void setRealFocus(boolean bl) {
            super.onFocusChanged(bl, 0, new Rect());
            this.invalidate();
            this.dispatchFocusEvent(bl, 0);
        }

        public boolean isInTextEditingMode() {
            return this.m_hasFocus && (this.m_focusedChildView != null || this.getChildCount() != 0);
        }

        private void dispatchFocusEvent(boolean bl, int n) {
            if (this.m_hasFocus == bl) {
                return;
            }
            this.m_hasFocus = bl;
            AndroidWebView androidWebView = AndroidWebView.this;
            if (androidWebView.mInternalReference == 0L) {
                return;
            }
            if (AndroidWebView.this.mAIRSurface != null) {
                AndroidWebView.this.mAIRSurface.updateFocusedStageWebView(androidWebView, this.m_hasFocus);
            }
            int n2 = 1;
            if ((n & 2) == 2) {
                n2 = 3;
            } else if ((n & 1) == 1) {
                n2 = 2;
            }
            if (bl) {
                androidWebView.dispatchFocusIn(AndroidWebView.this.mInternalReference, n2);
            } else {
                androidWebView.dispatchFocusOut(AndroidWebView.this.mInternalReference, n2);
            }
        }

        protected void onFocusChanged(boolean bl, int n, Rect rect) {
            super.onFocusChanged(bl, n, rect);
            if (this.m_inRequestChildFocus && this.m_focusedChildView != null && this.m_hasFocus) {
                return;
            }
            if (n == 0) {
                n = this.mLastFocusDirection;
            }
            this.mLastFocusDirection = 0;
            this.dispatchFocusEvent(bl, n);
        }

        public boolean dispatchKeyEvent(KeyEvent keyEvent) {
            boolean bl = super.dispatchKeyEvent(keyEvent);
            if (!bl && keyEvent.getAction() == 0) {
                int n = 0;
                if (keyEvent.getKeyCode() == 19) {
                    n = 33;
                } else if (keyEvent.getKeyCode() == 20) {
                    n = 130;
                }
                if (n != 0) {
                    AndroidWebView androidWebView = AndroidWebView.this;
                    this.mLastFocusDirection = n;
                    androidWebView.setStageFocus(n);
                    return true;
                }
            }
            if (!bl) {
                bl = AndroidWebView.this.mAIRSurface.dispatchKeyEvent(keyEvent);
            }
            return bl;
        }
    }

    public class WebViewCustomView {
        private WebChromeClient.CustomViewCallback mCallback;
        private FrameLayout mCustomViewHolder;

        public void onShowCustomView(View view, WebChromeClient.CustomViewCallback customViewCallback) {
            if (this.mCallback != null) {
                customViewCallback.onCustomViewHidden();
                return;
            }
            this.mCallback = customViewCallback;
            View view2 = AndroidActivityWrapper.GetAndroidActivityWrapper().getView();
            view2.setVisibility(8);
            RelativeLayout relativeLayout = AndroidActivityWrapper.GetAndroidActivityWrapper().getOverlaysLayout(false);
            if (relativeLayout != null) {
                relativeLayout.setVisibility(8);
            }
            this.mCustomViewHolder = new FrameLayout(AndroidWebView.this.mContext){

                public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                    if (super.dispatchKeyEvent(keyEvent)) {
                        return true;
                    }
                    if (keyEvent.getAction() == 0 && keyEvent.getKeyCode() == 4) {
                        WebViewCustomView.this.onHideCustomView();
                        return true;
                    }
                    return false;
                }
            };
            this.mCustomViewHolder.setBackgroundColor(-16777216);
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
            ((ViewGroup)view2.getParent()).addView((View)this.mCustomViewHolder, (ViewGroup.LayoutParams)layoutParams);
            FrameLayout.LayoutParams layoutParams2 = new FrameLayout.LayoutParams(-1, -1, 17);
            this.mCustomViewHolder.addView(view, (ViewGroup.LayoutParams)layoutParams2);
            this.mCustomViewHolder.bringToFront();
            this.mCustomViewHolder.requestFocus();
        }

        public void onHideCustomView() {
            if (this.mCallback == null) {
                return;
            }
            View view = AndroidActivityWrapper.GetAndroidActivityWrapper().getView();
            view.setVisibility(0);
            RelativeLayout relativeLayout = AndroidActivityWrapper.GetAndroidActivityWrapper().getOverlaysLayout(false);
            if (relativeLayout != null) {
                relativeLayout.setVisibility(0);
            }
            ((ViewGroup)this.mCustomViewHolder.getParent()).removeView((View)this.mCustomViewHolder);
            this.mCustomViewHolder = null;
            this.mCallback.onCustomViewHidden();
            this.mCallback = null;
        }
    }
}

