/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.os.SystemClock;
import com.adobe.air.AndroidActivityWrapper;

class ConfigDownloadListener {
    private static ConfigDownloadListener sListener = null;
    private long lastPauseTime;
    private static String LOG_TAG = "ConfigDownloadListener";
    private BroadcastReceiver mDownloadConfigRecv = new BroadcastReceiver(){
        private String LOG_TAG = "ConfigDownloadListenerBR";

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("com.adobe.air.DownloadConfigComplete")) {
                Object object;
                boolean bl = false;
                if (this.isInitialStickyBroadcast()) {
                    object = intent.getExtras();
                    if (object != null) {
                        long l = object.getLong("com.adobe.air.DownloadConfigCompleteTime");
                        if (ConfigDownloadListener.this.lastPauseTime < l) {
                            bl = true;
                        }
                    }
                } else {
                    bl = true;
                }
                if (bl && (object = AndroidActivityWrapper.GetAndroidActivityWrapper()) != null) {
                    ((AndroidActivityWrapper)object).applyDownloadedConfig();
                }
            }
        }
    };
    private AndroidActivityWrapper.StateChangeCallback mActivityStateCB = new AndroidActivityWrapper.StateChangeCallback(){

        public void onActivityStateChanged(AndroidActivityWrapper.ActivityState activityState) {
            Activity activity = AndroidActivityWrapper.GetAndroidActivityWrapper().getActivity();
            if (activityState == AndroidActivityWrapper.ActivityState.PAUSED) {
                activity.unregisterReceiver(ConfigDownloadListener.this.mDownloadConfigRecv);
                ConfigDownloadListener.this.lastPauseTime = SystemClock.uptimeMillis();
            } else if (activityState == AndroidActivityWrapper.ActivityState.RESUMED) {
                activity.registerReceiver(ConfigDownloadListener.this.mDownloadConfigRecv, new IntentFilter("com.adobe.air.DownloadConfigComplete"));
            }
        }

        public void onConfigurationChanged(Configuration configuration) {
        }
    };

    private ConfigDownloadListener() {
        this.lastPauseTime = SystemClock.uptimeMillis();
        AndroidActivityWrapper.GetAndroidActivityWrapper().addActivityStateChangeListner(this.mActivityStateCB);
    }

    public static ConfigDownloadListener GetConfigDownloadListener() {
        if (sListener == null) {
            sListener = new ConfigDownloadListener();
        }
        return sListener;
    }
}

