/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.SurfaceHolder;
import com.adobe.air.AIRWindowThreadedSurfaceView;
import com.adobe.air.DrawRequest;

class DrawThread
extends Thread {
    private AIRWindowThreadedSurfaceView mView = null;
    private boolean mRun = false;
    private Handler mHandler = null;
    private Looper mLooper = null;

    public DrawThread(AIRWindowThreadedSurfaceView aIRWindowThreadedSurfaceView, SurfaceHolder surfaceHolder, Context context) {
        this.mView = aIRWindowThreadedSurfaceView;
    }

    public void run() {
        Looper.prepare();
        this.mHandler = new Handler(){

            public void handleMessage(Message message) {
                if (message.what == 1009) {
                    DrawThread.this.draw((DrawRequest)message.obj);
                    ((DrawThread)DrawThread.this).mView.drawSemaphore.release();
                }
            }
        };
        this.mLooper = Looper.myLooper();
        Looper.loop();
    }

    public void requestDraw(int n, int n2, int n3, int n4, Bitmap bitmap) {
        Message message = new Message();
        message.what = 1009;
        message.obj = new DrawRequest(n, n2, n3, n4, bitmap);
        this.mHandler.sendMessage(message);
    }

    public void requestDraw(int n, int n2, int n3, int n4, Bitmap bitmap, int n5, int n6, int n7, int n8, boolean bl, int n9) {
        Message message = new Message();
        message.what = 1009;
        message.obj = new DrawRequest(n, n2, n3, n4, bitmap, n5, n6, n7, n8, bl, n9);
        this.mHandler.sendMessage(message);
    }

    public void setRunning(boolean bl) {
        this.mRun = bl;
        if (!this.mRun) {
            this.mLooper.quit();
        }
    }

    private void draw(DrawRequest drawRequest) {
        if (drawRequest.scale) {
            this.mView.drawScaled(drawRequest.x, drawRequest.y, drawRequest.wd, drawRequest.ht, drawRequest.bm, drawRequest.dstX, drawRequest.dstY, drawRequest.dstWd, drawRequest.dstHt, drawRequest.fullsc, drawRequest.bgColor);
        } else {
            this.mView.draw(drawRequest.x, drawRequest.y, drawRequest.wd, drawRequest.ht, drawRequest.bm);
        }
    }
}

