/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import android.app.Activity;
import android.view.SurfaceView;
import android.view.Window;
import com.adobe.air.AIRStage3DSurfaceView;
import com.adobe.air.AIRWindowSurfaceView;
import com.adobe.air.AndroidVideoSurfaceView;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

public class FlashEGL {
    private static String TAG = "FlashEGL";
    private static int EGL_CONTEXT_CLIENT_VERSION = 12440;
    private static int EGL_OPENGL_ES2_BIT = 4;
    private static int EGL_COVERAGE_BUFFERS_NV = 12512;
    private static int EGL_COVERAGE_SAMPLES_NV = 12513;
    private static int EGL_SWAP_BEHAVIOR = 12435;
    private static int EGL_BUFFER_PRESERVED = 12436;
    private static int DEFAULT_MSAA_SAMPLES = 2;
    private int kSurfaceTypes = 0;
    private int kConfigId = 1;
    private int kRedBits = 2;
    private int kGreenBits = 3;
    private int kBlueBits = 4;
    private int kAlphaBits = 5;
    private int kColorBits = 6;
    private int kDepthBits = 7;
    private int kStencilBits = 8;
    private int kMsaaSamp = 9;
    private int kCsaaSamp = 10;
    private int kSwapPreserve = 11;
    private int kNumElements = 12;
    private static int[] cfgAttrs = new int[]{12339, -1, 12325, -1, 12326, -1, 12352, EGL_OPENGL_ES2_BIT, 12344};
    private static int[] fbWindowSurfaceAttrs = new int[]{EGL_SWAP_BEHAVIOR, EGL_BUFFER_PRESERVED, 12344};
    private static int[] fbPBufferSurfaceAttrs = new int[]{12375, 64, 12374, 64, 12344};
    private EGL10 mEgl = null;
    private EGLDisplay mEglDisplay = EGL10.EGL_NO_DISPLAY;
    private EGLSurface mEglSurface = EGL10.EGL_NO_SURFACE;
    private EGLSurface mEglWindowSurface = EGL10.EGL_NO_SURFACE;
    private EGLSurface mEglPbufferSurface = EGL10.EGL_NO_SURFACE;
    private EGLConfig mEglConfig = null;
    private EGLConfig[] mEglConfigList = null;
    private int[] mEglVersion = null;
    private int mEglConfigCount = 0;
    private int mWindowConfigCount = 0;
    private int mPixmapConfigCount = 0;
    private int mPbufferConfigCount = 0;
    volatile EGLContext mEglContext = EGL10.EGL_NO_CONTEXT;
    private boolean mIsARGBSurface = false;
    private boolean mIsGPUOOM = false;
    private boolean mIsBufferPreserve = false;

    public void FlashEGL() {
        this.mEgl = null;
        this.mEglDisplay = EGL10.EGL_NO_DISPLAY;
        this.mEglConfig = null;
        this.mEglContext = EGL10.EGL_NO_CONTEXT;
        this.mEglSurface = EGL10.EGL_NO_SURFACE;
        this.mEglWindowSurface = EGL10.EGL_NO_SURFACE;
        this.mEglPbufferSurface = EGL10.EGL_NO_SURFACE;
        this.mIsARGBSurface = false;
    }

    private int XX(int n, int n2) {
        return n * this.kNumElements + n2;
    }

    public boolean HasGLContext() {
        return this.mEglContext != EGL10.EGL_NO_CONTEXT;
    }

    public int GetSurfaceWidth() {
        int[] nArray = new int[1];
        this.mEgl.eglQuerySurface(this.mEglDisplay, this.mEglSurface, 12375, nArray);
        return nArray[0];
    }

    public int GetSurfaceHeight() {
        int[] nArray = new int[1];
        this.mEgl.eglQuerySurface(this.mEglDisplay, this.mEglSurface, 12374, nArray);
        return nArray[0];
    }

    public int[] GetNumConfigs() {
        int[] nArray = new int[4];
        int[] nArray2 = new int[1];
        this.mEgl.eglChooseConfig(this.mEglDisplay, cfgAttrs, null, 0, nArray2);
        this.mEglConfigCount = nArray[0] = nArray2[0];
        FlashEGL.cfgAttrs[1] = 4;
        this.mEgl.eglChooseConfig(this.mEglDisplay, cfgAttrs, null, 0, nArray2);
        this.mWindowConfigCount = nArray[1] = nArray2[0];
        FlashEGL.cfgAttrs[1] = 2;
        this.mEgl.eglChooseConfig(this.mEglDisplay, cfgAttrs, null, 0, nArray2);
        this.mPixmapConfigCount = nArray[2] = nArray2[0];
        FlashEGL.cfgAttrs[1] = 1;
        this.mEgl.eglChooseConfig(this.mEglDisplay, cfgAttrs, null, 0, nArray2);
        this.mPbufferConfigCount = nArray[3] = nArray2[0];
        FlashEGL.cfgAttrs[1] = -1;
        return nArray;
    }

    public int[] GetConfigs(boolean bl, boolean bl2) {
        int[] nArray = new int[this.mEglConfigCount * this.kNumElements];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        this.mEglConfigList = new EGLConfig[this.mEglConfigCount];
        this.checkEglError("Before eglChooseConfig");
        this.mEgl.eglChooseConfig(this.mEglDisplay, cfgAttrs, this.mEglConfigList, this.mEglConfigCount, nArray2);
        this.checkEglError("After eglChooseConfig");
        int n = this.mEglConfigCount = nArray2[0];
        for (int i = 0; i < n; ++i) {
            this.mEgl.eglGetConfigAttrib(this.mEglDisplay, this.mEglConfigList[i], 12339, nArray3);
            nArray[this.XX((int)i, (int)this.kSurfaceTypes)] = nArray3[0];
            nArray[this.XX((int)i, (int)this.kConfigId)] = i;
            this.mEgl.eglGetConfigAttrib(this.mEglDisplay, this.mEglConfigList[i], 12324, nArray3);
            nArray[this.XX((int)i, (int)this.kRedBits)] = nArray3[0];
            this.mEgl.eglGetConfigAttrib(this.mEglDisplay, this.mEglConfigList[i], 12323, nArray3);
            nArray[this.XX((int)i, (int)this.kGreenBits)] = nArray3[0];
            this.mEgl.eglGetConfigAttrib(this.mEglDisplay, this.mEglConfigList[i], 12322, nArray3);
            nArray[this.XX((int)i, (int)this.kBlueBits)] = nArray3[0];
            this.mEgl.eglGetConfigAttrib(this.mEglDisplay, this.mEglConfigList[i], 12321, nArray3);
            nArray[this.XX((int)i, (int)this.kAlphaBits)] = nArray3[0];
            this.mEgl.eglGetConfigAttrib(this.mEglDisplay, this.mEglConfigList[i], 12320, nArray3);
            nArray[this.XX((int)i, (int)this.kColorBits)] = nArray3[0];
            this.mEgl.eglGetConfigAttrib(this.mEglDisplay, this.mEglConfigList[i], 12325, nArray3);
            nArray[this.XX((int)i, (int)this.kDepthBits)] = nArray3[0];
            this.mEgl.eglGetConfigAttrib(this.mEglDisplay, this.mEglConfigList[i], 12326, nArray3);
            nArray[this.XX((int)i, (int)this.kStencilBits)] = nArray3[0];
            nArray[this.XX((int)i, (int)this.kCsaaSamp)] = 0;
            nArray[this.XX((int)i, (int)this.kMsaaSamp)] = 0;
            if (bl) {
                this.mEgl.eglGetConfigAttrib(this.mEglDisplay, this.mEglConfigList[i], EGL_COVERAGE_SAMPLES_NV, nArray3);
                if (nArray3[0] != 1) {
                    nArray[this.XX((int)i, (int)this.kCsaaSamp)] = nArray3[0];
                }
            } else {
                this.mEgl.eglGetConfigAttrib(this.mEglDisplay, this.mEglConfigList[i], 12337, nArray3);
                if (nArray3[0] != 1) {
                    nArray[this.XX((int)i, (int)this.kMsaaSamp)] = nArray3[0];
                }
            }
            nArray[this.XX((int)i, (int)this.kSwapPreserve)] = bl2 ? ((this.mEglVersion[0] > 1 || this.mEglVersion[1] > 3) && (nArray[this.XX(i, this.kSurfaceTypes)] & EGL_BUFFER_PRESERVED) != 0 ? 1 : 0) : 0;
        }
        return nArray;
    }

    public void SetConfig(int n) {
        this.mEglConfig = this.mEglConfigList[n];
        int[] nArray = new int[1];
        this.mEgl.eglGetConfigAttrib(this.mEglDisplay, this.mEglConfig, 12324, nArray);
        int n2 = nArray[0];
        this.mEgl.eglGetConfigAttrib(this.mEglDisplay, this.mEglConfig, 12323, nArray);
        int n3 = nArray[0];
        this.mEgl.eglGetConfigAttrib(this.mEglDisplay, this.mEglConfig, 12322, nArray);
        int n4 = nArray[0];
        this.mEgl.eglGetConfigAttrib(this.mEglDisplay, this.mEglConfig, 12321, nArray);
        int n5 = nArray[0];
    }

    public int CreateDummySurfaceAndContext() {
        if (this.mEglDisplay == EGL10.EGL_NO_DISPLAY) {
            return 12296;
        }
        if (this.mEglContext != EGL10.EGL_NO_CONTEXT) {
            if (this.mEglWindowSurface != EGL10.EGL_NO_SURFACE) {
                this.mEgl.eglMakeCurrent(this.mEglDisplay, this.mEglWindowSurface, this.mEglWindowSurface, this.mEglContext);
                return 12288;
            }
            if (this.mEglPbufferSurface != EGL10.EGL_NO_SURFACE) {
                this.mEgl.eglMakeCurrent(this.mEglDisplay, this.mEglPbufferSurface, this.mEglPbufferSurface, this.mEglContext);
                return 12288;
            }
            this.mEgl.eglMakeCurrent(this.mEglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
            this.mEgl.eglDestroyContext(this.mEglDisplay, this.mEglContext);
            this.mEglContext = EGL10.EGL_NO_CONTEXT;
        }
        int[] nArray = new int[1];
        EGLConfig[] eGLConfigArray = new EGLConfig[1];
        FlashEGL.cfgAttrs[1] = 1;
        this.mEgl.eglChooseConfig(this.mEglDisplay, cfgAttrs, eGLConfigArray, 1, nArray);
        FlashEGL.cfgAttrs[1] = -1;
        int n = nArray[0];
        if (n == 0) {
            return 12294;
        }
        int[] nArray2 = new int[]{EGL_CONTEXT_CLIENT_VERSION, 2, 12344};
        this.checkEglError("Before eglCreateContext");
        this.mEglContext = this.mEgl.eglCreateContext(this.mEglDisplay, eGLConfigArray[0], EGL10.EGL_NO_CONTEXT, nArray2);
        this.checkEglError("After eglCreateContext");
        if (this.mEglContext == EGL10.EGL_NO_CONTEXT) {
            return 12294;
        }
        this.checkEglError("Before eglCreatePbufferSurface");
        this.mEglPbufferSurface = this.mEgl.eglCreatePbufferSurface(this.mEglDisplay, eGLConfigArray[0], fbPBufferSurfaceAttrs);
        this.checkEglError("After eglCreatePbufferSurface");
        if (this.mEglPbufferSurface == EGL10.EGL_NO_SURFACE) {
            return 12294;
        }
        this.checkEglError("Before eglMakeCurrent");
        this.mEgl.eglMakeCurrent(this.mEglDisplay, this.mEglPbufferSurface, this.mEglPbufferSurface, this.mEglContext);
        this.checkEglError("After eglMakeCurrent");
        return 12288;
    }

    public int InitEGL() {
        if (this.mEglContext != EGL10.EGL_NO_CONTEXT) {
            return 12288;
        }
        int n = 0;
        this.mEgl = (EGL10)EGLContext.getEGL();
        this.checkEglError("Before eglGetDisplay");
        this.mEglDisplay = this.mEgl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        n = this.checkEglError("After eglGetDisplay");
        if (12288 != n) {
            return n;
        }
        this.mEglVersion = new int[2];
        this.checkEglError("Before eglInitialize");
        this.mEgl.eglInitialize(this.mEglDisplay, this.mEglVersion);
        n = this.checkEglError("After eglInitialize");
        if (12288 != n) {
            return n;
        }
        return 12288;
    }

    public boolean DestroyGLContext() {
        if (this.mEglContext == EGL10.EGL_NO_CONTEXT || this.mEglDisplay == EGL10.EGL_NO_DISPLAY) {
            return false;
        }
        this.checkEglError("Before eglDestroyContext");
        boolean bl = this.mEgl.eglDestroyContext(this.mEglDisplay, this.mEglContext);
        this.checkEglError("After eglDestroyContext");
        this.mEglContext = EGL10.EGL_NO_CONTEXT;
        return bl;
    }

    public int CreateGLContext(boolean bl) {
        if (this.mEglConfig == null) {
            return 12293;
        }
        if (this.mEglContext != EGL10.EGL_NO_CONTEXT && !bl) {
            return 12288;
        }
        int[] nArray = new int[]{EGL_CONTEXT_CLIENT_VERSION, 2, 12344};
        if (bl) {
            EGLContext eGLContext = this.mEglContext;
            this.checkEglError("Before eglCreateContext");
            this.mEglContext = this.mEgl.eglCreateContext(this.mEglDisplay, this.mEglConfig, eGLContext, nArray);
            this.checkEglError("After eglCreateContext");
            this.checkEglError("Before eglDestroyContext");
            this.mEgl.eglDestroyContext(this.mEglDisplay, eGLContext);
            this.checkEglError("After eglDestroyContext");
        } else {
            this.checkEglError("Before eglCreateContext");
            this.mEglContext = this.mEgl.eglCreateContext(this.mEglDisplay, this.mEglConfig, EGL10.EGL_NO_CONTEXT, nArray);
            this.checkEglError("After eglCreateContext");
        }
        if (this.mEglContext == EGL10.EGL_NO_CONTEXT) {
            return 12294;
        }
        if (this.mEglPbufferSurface != EGL10.EGL_NO_SURFACE) {
            this.checkEglError("Before eglMakeCurrent");
            this.mEgl.eglMakeCurrent(this.mEglDisplay, this.mEglPbufferSurface, this.mEglPbufferSurface, this.mEglContext);
            this.checkEglError("After eglMakeCurrent");
        }
        return 12288;
    }

    public void TerminateEGL() {
        if (this.mEgl != null && this.mEglDisplay != EGL10.EGL_NO_DISPLAY) {
            this.mEgl.eglTerminate(this.mEglDisplay);
        }
        this.mEglDisplay = EGL10.EGL_NO_DISPLAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ReleaseGPUResources() {
        if (this.mEglContext == EGL10.EGL_NO_CONTEXT) {
            return;
        }
        this.checkEglError("Before eglMakeCurrent");
        this.mEgl.eglMakeCurrent(this.mEglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
        this.checkEglError("After eglMakeCurrent");
        EGL10 eGL10 = this.mEgl;
        synchronized (eGL10) {
            this.checkEglError("Before eglDestroySurface");
            if (this.mEglWindowSurface != EGL10.EGL_NO_SURFACE) {
                this.mEgl.eglDestroySurface(this.mEglDisplay, this.mEglWindowSurface);
                this.mEglWindowSurface = EGL10.EGL_NO_SURFACE;
            }
            this.checkEglError("After eglDestroySurface (window)");
        }
        if (this.mEglPbufferSurface != EGL10.EGL_NO_SURFACE) {
            this.checkEglError("Before eglDestroySurface (pbuffer)");
            this.mEgl.eglDestroySurface(this.mEglDisplay, this.mEglPbufferSurface);
            this.checkEglError("After eglDestroySurface (pbuffer)");
            this.mEglPbufferSurface = EGL10.EGL_NO_SURFACE;
        }
        this.checkEglError("Before eglDestroyContext");
        this.mEgl.eglDestroyContext(this.mEglDisplay, this.mEglContext);
        this.checkEglError("After eglDestroyContext");
        this.mEglContext = EGL10.EGL_NO_CONTEXT;
        this.mEglSurface = EGL10.EGL_NO_SURFACE;
    }

    public void SwapEGLBuffers() {
        if (12288 != this.MakeGLCurrent()) {
            return;
        }
        this.checkEglError("Before eglSwapBuffers");
        this.mEgl.eglSwapBuffers(this.mEglDisplay, this.mEglSurface);
        this.checkEglError("After eglSwapBuffers");
    }

    public int MakeGLCurrent() {
        if (this.mEglContext == EGL10.EGL_NO_CONTEXT) {
            return 12294;
        }
        if (this.mEglSurface == EGL10.EGL_NO_SURFACE) {
            return 12301;
        }
        if (this.mEglDisplay == EGL10.EGL_NO_DISPLAY) {
            return 12296;
        }
        this.checkEglError("Before eglMakeCurrent");
        this.mEgl.eglMakeCurrent(this.mEglDisplay, this.mEglSurface, this.mEglSurface, this.mEglContext);
        return this.checkEglError("After eglMakeCurrent");
    }

    public int CreateWindowSurface(SurfaceView surfaceView, boolean bl) {
        if (this.mIsGPUOOM) {
            return 12291;
        }
        boolean bl2 = surfaceView instanceof AIRWindowSurfaceView;
        if (!(surfaceView instanceof AndroidVideoSurfaceView || surfaceView instanceof AIRStage3DSurfaceView || bl2)) {
            return 12301;
        }
        if (this.mEglWindowSurface != EGL10.EGL_NO_SURFACE) {
            this.mEglSurface = this.mEglWindowSurface;
            return this.MakeGLCurrent();
        }
        if (bl) {
            this.checkEglError("Before eglCreateWindowSurface");
            this.mEglWindowSurface = this.mEgl.eglCreateWindowSurface(this.mEglDisplay, this.mEglConfig, (Object)surfaceView.getHolder(), fbWindowSurfaceAttrs);
            if (this.mEglWindowSurface == EGL10.EGL_NO_SURFACE) {
                this.checkEglError("After eglCreateWindowSurface");
                bl = false;
            }
        }
        if (this.mEglWindowSurface == EGL10.EGL_NO_SURFACE) {
            this.checkEglError("Before eglCreateWindowSurface");
            this.mEglWindowSurface = this.mEgl.eglCreateWindowSurface(this.mEglDisplay, this.mEglConfig, (Object)surfaceView.getHolder(), null);
            int n = this.checkEglError("After eglCreateWindowSurface");
            if (n != 12288) {
                return n;
            }
        }
        if (this.mEglWindowSurface == EGL10.EGL_NO_SURFACE) {
            return 12301;
        }
        this.mEglSurface = this.mEglWindowSurface;
        if (bl2) {
            ((AIRWindowSurfaceView)surfaceView).setFlashEGL(this);
            Activity activity = ((AIRWindowSurfaceView)surfaceView).getActivityWrapper().getActivity();
            if (activity != null) {
                Window window = activity.getWindow();
                window.setSoftInputMode(34);
            }
        }
        int[] nArray = new int[]{0};
        this.mIsBufferPreserve = false;
        if (bl && this.mEgl.eglQuerySurface(this.mEglDisplay, this.mEglSurface, EGL_SWAP_BEHAVIOR, nArray)) {
            this.mIsBufferPreserve = nArray[0] == EGL_BUFFER_PRESERVED;
        }
        return this.MakeGLCurrent();
    }

    public boolean DestroyWindowSurface() {
        if (this.mEglWindowSurface != EGL10.EGL_NO_SURFACE) {
            this.checkEglError("Before eglMakeCurrent");
            this.mEgl.eglMakeCurrent(this.mEglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
            if (12288 != this.checkEglError("After eglMakeCurrent")) {
                return false;
            }
            this.checkEglError("Before eglDestroySurface (window)");
            this.mEgl.eglDestroySurface(this.mEglDisplay, this.mEglWindowSurface);
            if (12288 != this.checkEglError("After eglDestroySurface (window)")) {
                return false;
            }
            if (this.mEglSurface == this.mEglWindowSurface) {
                this.mEglSurface = EGL10.EGL_NO_SURFACE;
            }
            this.mEglWindowSurface = EGL10.EGL_NO_SURFACE;
            return true;
        }
        return false;
    }

    public boolean IsARGBSurface() {
        return this.mIsARGBSurface;
    }

    public boolean IsBufferPreserve() {
        return this.mIsBufferPreserve;
    }

    private int checkEglError(String string) {
        int n = this.mEgl.eglGetError();
        if (n != 12288 && !this.mIsGPUOOM && n == 12291) {
            int n2;
            if (this.mEglWindowSurface != EGL10.EGL_NO_SURFACE) {
                this.mEgl.eglDestroySurface(this.mEglDisplay, this.mEglWindowSurface);
                n2 = this.mEgl.eglGetError();
                this.mEglWindowSurface = EGL10.EGL_NO_SURFACE;
                this.mEglSurface = EGL10.EGL_NO_SURFACE;
                if (n2 != 12288) {
                    // empty if block
                }
                this.mEglWindowSurface = EGL10.EGL_NO_SURFACE;
                this.mEgl.eglMakeCurrent(this.mEglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
                n2 = this.mEgl.eglGetError();
                if (n2 != 12288) {
                    // empty if block
                }
            }
            if (this.mEglPbufferSurface != EGL10.EGL_NO_SURFACE && this.mEglContext != EGL10.EGL_NO_CONTEXT) {
                this.mEglSurface = this.mEglPbufferSurface;
                this.mEgl.eglMakeCurrent(this.mEglDisplay, this.mEglSurface, this.mEglSurface, this.mEglContext);
                n2 = this.mEgl.eglGetError();
                if (n2 != 12288) {
                    // empty if block
                }
            }
            this.mIsGPUOOM = true;
        }
        return n;
    }
}

