/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.adobe.air.AndroidActivityWrapper;
import com.adobe.air.AndroidLocale;

public final class RemoteDebuggerDialog {
    private final Activity mActivity;

    RemoteDebuggerDialog(Activity activity) {
        this.mActivity = activity;
    }

    public void createAndShowDialog(String string) {
        LinearLayout linearLayout = new LinearLayout((Context)this.mActivity);
        linearLayout.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        linearLayout.setOrientation(1);
        TextView textView = new TextView((Context)this.mActivity);
        String string2 = "";
        if (string.length() > 0) {
            string2 = AndroidLocale.GetLocalizedString(AndroidLocale.STRING_ID.IDA_DEBUGGER_ERROR_MESSAGE).replaceFirst("%1", string) + "\n";
        }
        string2 = string2 + AndroidLocale.GetLocalizedString(AndroidLocale.STRING_ID.IDA_DEBUGGER_ENTERIP_MESSAGE);
        textView.setText((CharSequence)string2);
        textView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        textView.setPadding(20, 20, 20, 20);
        final EditText editText = new EditText((Context)this.mActivity);
        editText.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        editText.setHeight(30);
        editText.setWidth(25);
        linearLayout.addView((View)textView);
        linearLayout.addView((View)editText);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.mActivity);
        builder.setView((View)linearLayout);
        builder.setTitle((CharSequence)"Adobe AIR");
        builder.setPositiveButton((CharSequence)AndroidLocale.GetLocalizedString(AndroidLocale.STRING_ID.IDA_OK), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                String string = editText.getText().toString();
                RemoteDebuggerDialog.this.gotResultFromDialog(true, string);
            }
        });
        builder.setNegativeButton((CharSequence)AndroidLocale.GetLocalizedString(AndroidLocale.STRING_ID.IDA_CANCEL), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                RemoteDebuggerDialog.this.gotResultFromDialog(false, null);
            }
        });
        builder.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialogInterface) {
                RemoteDebuggerDialog.this.gotResultFromDialog(false, null);
            }
        });
        builder.show();
    }

    public void gotResultFromDialog(boolean bl, String string) {
        AndroidActivityWrapper androidActivityWrapper = AndroidActivityWrapper.GetAndroidActivityWrapper();
        androidActivityWrapper.gotResultFromDialog(bl, string);
    }
}

