/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.net.http.SslCertificate;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import com.adobe.air.AndroidActivityWrapper;
import com.adobe.air.AndroidAlertDialog;
import com.adobe.air.Certificate;
import com.adobe.air.utils.Utils;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class SSLSecurityDialog {
    public static final String TAG = SSLSecurityDialog.class.toString();
    private static final String USER_ACTION_TRUST_NONE = "none";
    private static final String USER_ACTION_TRUST_ALWAYS = "always";
    private static final String USER_ACTION_TRUST_SESSION = "session";
    private String m_useraction = null;
    private Lock m_lock = new ReentrantLock();
    private Condition m_condition = this.m_lock.newCondition();

    public String show(String string, byte[] byArray) {
        this.ShowSSLDialog(string, byArray, null, false);
        if (this.m_useraction != null) {
            // empty if block
        }
        return this.m_useraction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ShowSSLDialog(String string, byte[] byArray, SslCertificate sslCertificate, boolean bl) {
        AndroidActivityWrapper androidActivityWrapper = AndroidActivityWrapper.GetAndroidActivityWrapper();
        Activity activity = androidActivityWrapper.getActivity();
        if (activity == null) {
            activity = androidActivityWrapper.WaitForNewActivity();
        }
        final AndroidAlertDialog androidAlertDialog = new AndroidAlertDialog((Context)activity);
        AlertDialog.Builder builder = androidAlertDialog.GetAlertDialogBuilder();
        Context context = androidActivityWrapper.getRuntimeContext();
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        Resources resources = context.getResources();
        View view = Utils.GetLayoutViewFromRuntime("ssl_certificate_warning", resources, layoutInflater);
        if (view != null) {
            String string2;
            Resources resources2 = view.getResources();
            TextView textView = (TextView)Utils.GetWidgetInViewByName("ServerName", resources2, view);
            textView.append((CharSequence)(" " + string));
            Certificate certificate = null;
            if (byArray != null) {
                certificate = new Certificate();
                certificate.setCertificate(byArray);
            } else {
                certificate = new Certificate(sslCertificate);
            }
            String string3 = Utils.GetResourceStringFromRuntime("IDA_CERTIFICATE_DETAILS", resources);
            String string4 = String.format(string3, certificate.getIssuedToCommonName(), certificate.getIssuedToOrganization(), certificate.getIssuedToOrganizationalUnit(), certificate.getIssuedByCommonName(), certificate.getIssuedByOrganization(), certificate.getIssuedByOrganizationalUnit(), certificate.getIssuedOn(), certificate.getExpiresOn());
            TextView textView2 = (TextView)Utils.GetWidgetInViewByName("CertificateDetails", resources2, view);
            textView2.setText((CharSequence)string4, TextView.BufferType.SPANNABLE);
            builder.setView(view);
            if (bl) {
                string2 = Utils.GetResourceStringFromRuntime("IDA_CURL_INTERFACE_ALLSESS", resources);
                builder.setPositiveButton((CharSequence)string2, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int n) {
                        SSLSecurityDialog.this.SetUserAction(SSLSecurityDialog.USER_ACTION_TRUST_ALWAYS);
                    }
                });
            }
            string2 = Utils.GetResourceStringFromRuntime("IDA_CURL_INTERFACE_THISSESS", resources);
            builder.setNeutralButton((CharSequence)string2, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int n) {
                    SSLSecurityDialog.this.SetUserAction(SSLSecurityDialog.USER_ACTION_TRUST_SESSION);
                }
            });
            String string5 = Utils.GetResourceStringFromRuntime("IDA_CURL_INTERFACE_NOSESS", resources);
            builder.setNegativeButton((CharSequence)string5, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int n) {
                    SSLSecurityDialog.this.SetUserAction(SSLSecurityDialog.USER_ACTION_TRUST_NONE);
                }
            });
            builder.setOnKeyListener(new DialogInterface.OnKeyListener(){

                public boolean onKey(DialogInterface dialogInterface, int n, KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 4) {
                        SSLSecurityDialog.this.SetUserAction(SSLSecurityDialog.USER_ACTION_TRUST_NONE);
                    }
                    return false;
                }
            });
            activity.runOnUiThread(new Runnable(){

                public void run() {
                    androidAlertDialog.show();
                }
            });
            this.m_lock.lock();
            try {
                if (this.m_useraction == null) {
                    this.m_condition.await();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.m_lock.unlock();
            }
        }
    }

    private void SetUserAction(String string) {
        this.m_lock.lock();
        this.m_useraction = string;
        this.m_condition.signal();
        this.m_lock.unlock();
    }

    public String show(String string, SslCertificate sslCertificate) {
        this.ShowSSLDialog(string, null, sslCertificate, false);
        if (this.m_useraction != null) {
            // empty if block
        }
        return this.m_useraction;
    }

    public String getUserAction() {
        return this.m_useraction;
    }
}

