/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.location;

import android.location.Location;
import android.location.LocationListener;
import android.os.Bundle;
import com.adobe.air.location.Geolocation;

public class AIRLocationListener
implements LocationListener {
    private Geolocation m_geoObj;
    private static final int TIMEOUT_INTERVAL = 15000;

    public AIRLocationListener(Geolocation geolocation) {
        this.m_geoObj = geolocation;
    }

    public void onLocationChanged(Location location) {
        if (location != null) {
            String string = location.getProvider();
            this.m_geoObj.m_currentTime.setToNow();
            double d = location.getLatitude();
            double d2 = location.getLongitude();
            double d3 = location.getAltitude();
            float f = location.getAccuracy();
            float f2 = location.getAccuracy();
            float f3 = location.getSpeed();
            long l = this.m_geoObj.m_currentTime.toMillis(false);
            if (string.compareTo("gps") == 0) {
                this.m_geoObj.m_ignoreLastGPSValue = false;
                this.m_geoObj.m_gpsLatitude = d;
                this.m_geoObj.m_gpsLongitude = d2;
                this.m_geoObj.m_gpsAltitude = d3;
                this.m_geoObj.m_gpsHorizontalAaccuracy = f;
                this.m_geoObj.m_gpsVerticalAccuracy = f2;
                this.m_geoObj.m_gpsSpeed = f3;
                this.m_geoObj.m_gpsTimestamp = this.m_geoObj.m_currentTime.toMillis(false);
            } else if (string.compareTo("network") == 0) {
                this.m_geoObj.m_networkLatitude = d;
                this.m_geoObj.m_networkLongitude = d2;
                this.m_geoObj.m_networkAltitude = d3;
                this.m_geoObj.m_networkHorizontalAaccuracy = f;
                this.m_geoObj.m_networkVerticalAccuracy = f2;
                this.m_geoObj.m_networkSpeed = f3;
                this.m_geoObj.m_networkTimestamp = this.m_geoObj.m_currentTime.toMillis(false);
                if (!this.m_geoObj.m_ignoreLastGPSValue && this.m_geoObj.m_networkTimestamp - this.m_geoObj.m_gpsTimestamp < 15000L && this.m_geoObj.m_networkHorizontalAaccuracy > this.m_geoObj.m_gpsHorizontalAaccuracy && this.isRegionFullyContained(this.m_geoObj.m_gpsLatitude, this.m_geoObj.m_gpsLongitude, this.m_geoObj.m_gpsHorizontalAaccuracy, this.m_geoObj.m_networkLatitude, this.m_geoObj.m_networkLongitude, this.m_geoObj.m_networkHorizontalAaccuracy)) {
                    return;
                }
                this.m_geoObj.m_ignoreLastGPSValue = true;
            }
            this.m_geoObj.m_latitude = d;
            this.m_geoObj.m_longitude = d2;
            this.m_geoObj.m_altitude = d3;
            this.m_geoObj.m_horizontalAaccuracy = f;
            this.m_geoObj.m_verticalAccuracy = f2;
            this.m_geoObj.m_speed = f3;
            this.m_geoObj.m_timestamp = l;
            if (this.m_geoObj.m_EventSourceExists) {
                this.m_geoObj.updateGeolocationCache(this.m_geoObj.m_objectPointer);
            }
        }
    }

    public void onProviderDisabled(String string) {
        boolean bl = this.m_geoObj.m_isGPSProviderEnabled;
        boolean bl2 = this.m_geoObj.m_isNetworkProviderEnabled;
        if (string.compareTo("gps") == 0) {
            this.m_geoObj.m_isGPSProviderEnabled = false;
        } else if (string.compareTo("network") == 0) {
            this.m_geoObj.m_isNetworkProviderEnabled = false;
        }
        if (bl == this.m_geoObj.m_isGPSProviderEnabled && bl2 == this.m_geoObj.m_isNetworkProviderEnabled) {
            return;
        }
        if (this.m_geoObj.m_EventSourceExists && !this.m_geoObj.m_isGPSProviderEnabled && !this.m_geoObj.m_isNetworkProviderEnabled) {
            this.m_geoObj.setGeolocationStatus(false, this.m_geoObj.m_objectPointer);
        }
    }

    public void onProviderEnabled(String string) {
        boolean bl = this.m_geoObj.m_isGPSProviderEnabled;
        boolean bl2 = this.m_geoObj.m_isNetworkProviderEnabled;
        if (string.compareTo("gps") == 0) {
            this.m_geoObj.m_isGPSProviderEnabled = true;
            if (this.m_geoObj.m_EventSourceExists && !this.m_geoObj.m_isNetworkProviderEnabled && bl != this.m_geoObj.m_isGPSProviderEnabled) {
                this.m_geoObj.setGeolocationStatus(true, this.m_geoObj.m_objectPointer);
            }
        } else if (string.compareTo("network") == 0) {
            this.m_geoObj.m_isNetworkProviderEnabled = true;
            if (this.m_geoObj.m_EventSourceExists && !this.m_geoObj.m_isGPSProviderEnabled && bl2 != this.m_geoObj.m_isNetworkProviderEnabled) {
                this.m_geoObj.setGeolocationStatus(true, this.m_geoObj.m_objectPointer);
            }
        }
    }

    public void onStatusChanged(String string, int n, Bundle bundle) {
    }

    private boolean isRegionFullyContained(double d, double d2, float f, double d3, double d4, float f2) {
        float[] fArray = new float[5];
        Location.distanceBetween((double)d, (double)d2, (double)d3, (double)d4, (float[])fArray);
        float f3 = fArray[0];
        float f4 = Math.abs(f2 - f);
        return f3 <= f4;
    }
}

