/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.content.res.Resources;
import android.os.Environment;
import android.os.Process;
import android.view.LayoutInflater;
import android.view.View;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Scanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static String sRuntimePackageName;

    public static native boolean nativeConnectDebuggerSocket(String var0);

    public static String getRuntimePackageName() {
        return sRuntimePackageName;
    }

    public static void setRuntimePackageName(String string) {
        sRuntimePackageName = string;
    }

    public static boolean hasCaptiveRuntime() {
        return !"com.adobe.air".equals(sRuntimePackageName);
    }

    static void KillProcess() {
        Process.killProcess((int)Process.myPid());
    }

    public static boolean writeStringToFile(String string, String string2) {
        File file = new File(string2);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                return false;
            }
        }
        byte[] byArray = string.getBytes();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ((OutputStream)fileOutputStream).write(byArray, 0, byArray.length);
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public static void writeOut(InputStream inputStream, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        Utils.writeThrough(inputStream, fileOutputStream);
        ((OutputStream)fileOutputStream).close();
    }

    public static void writeThrough(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) != -1) {
            if (outputStream == null) continue;
            outputStream.write(byArray, 0, n);
            outputStream.flush();
        }
    }

    public static void copyTo(File file, File file2) throws IOException {
        if (file.isDirectory()) {
            file2.mkdirs();
            for (File file3 : file.listFiles()) {
                File file4 = new File(file2, file3.getName());
                Utils.copyTo(file3, file4);
            }
        } else {
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            Utils.copyTo(fileInputStream, fileOutputStream);
            ((InputStream)fileInputStream).close();
            ((OutputStream)fileOutputStream).close();
        }
    }

    public static void copyTo(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    public static void writeBufferToFile(StringBuffer stringBuffer, File file) throws IOException {
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(stringBuffer.toString());
        fileWriter.close();
    }

    public static HashMap<String, String> parseKeyValuePairFile(File file, String string) throws FileNotFoundException, IllegalStateException {
        return Utils.parseKeyValuePairFile(new FileInputStream(file), string);
    }

    public static HashMap<String, String> parseKeyValuePairFile(InputStream inputStream, String string) throws IllegalStateException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Scanner scanner = new Scanner(inputStream);
        while (scanner.hasNextLine()) {
            Scanner scanner2 = new Scanner(scanner.nextLine());
            scanner2.useDelimiter(string);
            if (scanner2.hasNext()) {
                String string2 = scanner2.next();
                String string3 = scanner2.next();
                hashMap.put(string2.trim(), string3.trim());
            }
            scanner2.close();
        }
        scanner.close();
        return hashMap;
    }

    public static void writeStringToFile(String string, File file) throws IOException {
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(string);
        fileWriter.close();
    }

    public static String ReplaceTextContentWithStars(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = 42;
        }
        string = new String(cArray);
        return string;
    }

    public static String GetResourceStringFromRuntime(String string, Resources resources) {
        int n = resources.getIdentifier(string, "string", sRuntimePackageName);
        return resources.getString(n);
    }

    public static View GetWidgetInViewByName(String string, Resources resources, View view) {
        int n = resources.getIdentifier(string, "id", sRuntimePackageName);
        return view.findViewById(n);
    }

    public static View GetLayoutViewFromRuntime(String string, Resources resources, LayoutInflater layoutInflater) {
        int n = resources.getIdentifier(string, "layout", sRuntimePackageName);
        if (n != 0) {
            return layoutInflater.inflate(n, null);
        }
        return null;
    }

    public static String GetExternalStorageDirectory() {
        return Environment.getExternalStorageDirectory().getAbsolutePath();
    }

    public static String GetSharedDataDirectory() {
        return Environment.getDataDirectory().getAbsolutePath();
    }

    public static String GetLibCorePath(Context context) {
        return Utils.GetNativeLibraryPath(context, "libCore.so");
    }

    public static String GetNativeLibraryPath(Context context, String string) {
        String string2 = null;
        try {
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(sRuntimePackageName, 0);
            Field field = ApplicationInfo.class.getField("nativeLibraryDir");
            Field field2 = ApplicationInfo.class.getField("sourceDir");
            if (field != null) {
                String string3 = (String)field2.get(applicationInfo);
                if (string3.startsWith("/system/app/")) {
                    string2 = new String("/system/lib/" + string);
                } else {
                    String string4 = (String)field.get(applicationInfo);
                    string2 = string4.concat("/" + string);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string2 == null) {
            string2 = new String("/data/data/" + sRuntimePackageName + "/lib/" + string);
        }
        return string2;
    }

    private static String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            String string = Integer.toHexString(0xFF & byArray[i]);
            if (string.length() == 1) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String GetSigningCertificate(Context context) {
        String string = "";
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 64);
            Signature signature = packageInfo.signatures[0];
            string = Utils.toHexString(signature.toByteArray());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string.toUpperCase();
    }
}

