/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flashplayer;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;

public class HDMIUtils {
    private static final String TAG = "HDMIUtils";
    private static final String EXTRA_HDMI = "hdmi";
    private static final String EXTRA_HDCP = "hdcp";
    private static final String EXTDISP_PUBLIC_STATE = "com.motorola.intent.action.externaldisplaystate";
    private static final String EXTDISP_STATUS_CONNECTION = "com.motorola.intent.action.EXTDISP_STATUS_CONNECTION";
    private static final String EXTDISP_STATUS_DISPLAY = "com.motorola.intent.action.EXTDISP_STATUS_DISPLAY";
    private static final String EXTDISP_STATUS_RESOLUTION = "com.motorola.intent.action.EXTDISP_STATUS_RESOLUTION";
    private static final int TYPE_HDMI = 1;
    private static Object lock = new Object();
    private boolean mHdmiStatusKnown = false;
    private boolean mHdmiOnOff = false;
    private boolean mHdcpOnOff = false;
    private boolean mHdmiConnection = false;
    private Context mContext = null;
    private HdmiBroadcastReceiver mExtConnectionReceiver = null;
    private HdmiServiceConnection mConnection;
    private Binder mDeathWatcher = null;
    private static HDMIUtils mSingleton = null;

    private HDMIUtils(Context context) {
        this.mContext = context;
        this.mHdmiStatusKnown = false;
        this.mHdcpOnOff = false;
        this.mHdmiOnOff = false;
        this.mHdmiConnection = false;
        this.mConnection = new HdmiServiceConnection();
        this.mDeathWatcher = new Binder();
        this.mExtConnectionReceiver = new HdmiBroadcastReceiver();
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(EXTDISP_PUBLIC_STATE);
        intentFilter.addAction(EXTDISP_STATUS_CONNECTION);
        intentFilter.addAction(EXTDISP_STATUS_DISPLAY);
        intentFilter.addAction(EXTDISP_STATUS_RESOLUTION);
        Intent intent = this.mContext.registerReceiver((BroadcastReceiver)this.mExtConnectionReceiver, intentFilter);
    }

    public static void initHelper(Context context) {
        if (mSingleton != null) {
            return;
        }
        mSingleton = new HDMIUtils(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeHelper() {
        if (mSingleton == null) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            if (HDMIUtils.mSingleton.mExtConnectionReceiver != null) {
                HDMIUtils.mSingleton.mContext.unregisterReceiver((BroadcastReceiver)HDMIUtils.mSingleton.mExtConnectionReceiver);
                HDMIUtils.mSingleton.mExtConnectionReceiver = null;
            }
            if (HDMIUtils.mSingleton.mConnection != null) {
                HDMIUtils.mSingleton.mContext.unbindService((ServiceConnection)HDMIUtils.mSingleton.mConnection);
                HDMIUtils.mSingleton.mConnection = null;
            }
            HDMIUtils.mSingleton.mDeathWatcher = null;
        }
        HDMIUtils.mSingleton.mHdmiStatusKnown = false;
        mSingleton = null;
    }

    public boolean isConnected() {
        return this.mHdmiConnection;
    }

    public boolean isHDMIOn() {
        return this.mHdmiOnOff;
    }

    public boolean isHDCPOn() {
        return this.mHdcpOnOff;
    }

    public boolean isHdmiStatusKnown() {
        return this.mHdmiStatusKnown;
    }

    public static int getHDMIState(Context context) {
        HDMIUtils.initHelper(context);
        int n = HDMIState.UNKNOWN.value;
        n = !mSingleton.isHdmiStatusKnown() ? HDMIState.UNKNOWN.value : (mSingleton.isHDCPOn() ? HDMIState.HDCPON.value : (mSingleton.isHDMIOn() ? HDMIState.ON.value : HDMIState.OFF.value));
        return n;
    }

    class HdmiServiceConnection
    implements ServiceConnection {
        HdmiServiceConnection() {
        }

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        }

        public void onServiceDisconnected(ComponentName componentName) {
            HDMIUtils.this.mHdmiStatusKnown = false;
        }
    }

    class HdmiBroadcastReceiver
    extends BroadcastReceiver {
        HdmiBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            Bundle bundle;
            String string = intent.getAction();
            Bundle bundle2 = bundle = intent != null ? intent.getExtras() : null;
            if (string.equals(HDMIUtils.EXTDISP_STATUS_CONNECTION)) {
                boolean bl;
                if (bundle != null && (bl = bundle.getBoolean(HDMIUtils.EXTRA_HDMI)) != HDMIUtils.this.mHdmiConnection) {
                    HDMIUtils.this.mHdmiConnection = bl;
                    HDMIUtils.this.mHdmiStatusKnown = true;
                }
            } else if (string.equals(HDMIUtils.EXTDISP_STATUS_DISPLAY)) {
                boolean bl;
                if (bundle != null && (bl = bundle.getBoolean(HDMIUtils.EXTRA_HDMI)) != HDMIUtils.this.mHdmiOnOff) {
                    HDMIUtils.this.mHdmiOnOff = bl;
                    HDMIUtils.this.mHdmiStatusKnown = true;
                }
            } else if (string.equals(HDMIUtils.EXTDISP_PUBLIC_STATE) && bundle != null) {
                HDMIUtils.this.mHdmiOnOff = bundle.getInt(HDMIUtils.EXTRA_HDMI) == 1;
                HDMIUtils.this.mHdcpOnOff = bundle.getInt(HDMIUtils.EXTRA_HDCP) == 1;
                HDMIUtils.this.mHdmiStatusKnown = true;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum HDMIState {
        UNKNOWN(0),
        OFF(1),
        ON(2),
        HDCPON(3);

        public final int value;

        private HDMIState(int n2) {
            this.value = n2;
        }
    }
}

