/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.util;

import java.util.Random;
import java.util.UUID;

public class UUIDUtils {
    private static Random _weakRand = new Random();
    private static final int MAX_IDS_PER_MILLI = 10000;
    private static long lastUsedTOD = 0L;
    private static int numIdsThisMilli = 0;
    private static final String alphaNum = "0123456789ABCDEF";
    private static final int BITS_PER_DIGIT = 4;
    private static final int BITS_PER_INT = 32;
    private static final int BITS_PER_LONG = 64;
    private static final int DIGITS_PER_INT = 8;
    private static final int DIGITS_PER_LONG = 16;
    private static char[] UPPER_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private UUIDUtils() {
    }

    public static String createUUID() {
        return UUIDUtils.createUUID(true);
    }

    public static String createUUID(boolean secure) {
        return secure ? UUID.randomUUID().toString().toUpperCase() : UUIDUtils.createInsecureUUID();
    }

    public static String fromByteArray(byte[] ba) {
        if (ba == null || ba.length != 16) {
            return null;
        }
        StringBuffer result = new StringBuffer(36);
        for (int i = 0; i < 16; ++i) {
            if (i == 4 || i == 6 || i == 8 || i == 10) {
                result.append('-');
            }
            result.append(UPPER_DIGITS[(ba[i] & 0xF0) >>> 4]);
            result.append(UPPER_DIGITS[ba[i] & 0xF]);
        }
        return result.toString();
    }

    public static boolean isUID(String uid) {
        if (uid == null || uid.length() != 36) {
            return false;
        }
        char[] chars = uid.toCharArray();
        for (int i = 0; i < 36; ++i) {
            char c = chars[i];
            if (!(i == 8 || i == 13 || i == 18 || i == 23 ? c != '-' : c < '0' || c > 'F' || c > '9' && c < 'A')) continue;
            return false;
        }
        return true;
    }

    public static byte[] toByteArray(String uid) {
        if (!UUIDUtils.isUID(uid)) {
            return null;
        }
        byte[] result = new byte[16];
        char[] chars = uid.toCharArray();
        int r = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '-') continue;
            int h1 = Character.digit(chars[i], 16);
            int h2 = Character.digit(chars[++i], 16);
            result[r++] = (byte)((h1 << 4 | h2) & 0xFF);
        }
        return result;
    }

    private static void appendRandomHexChars(int n, Random rand, StringBuffer result) {
        int digitsPerInt = 8;
        while (n > 0) {
            int digitsToUse = Math.min(n, digitsPerInt);
            n -= digitsToUse;
            UUIDUtils.appendHexString(rand.nextInt(), true, digitsToUse, result);
        }
    }

    private static void appendHexString(long value, boolean prependZeroes, int nLeastSignificantDigits, StringBuffer result) {
        int bitsPerDigit = 4;
        long mask = (1L << bitsPerDigit) - 1L;
        if (nLeastSignificantDigits < 16) {
            value &= (1L << bitsPerDigit * nLeastSignificantDigits) - 1L;
        }
        int i = 0;
        long reorderedValue = 0L;
        if (value == 0L) {
            ++i;
        } else {
            do {
                reorderedValue = reorderedValue << bitsPerDigit | value & mask;
                ++i;
            } while ((value >>>= bitsPerDigit) != 0L);
        }
        if (prependZeroes) {
            for (int j = nLeastSignificantDigits - i; j > 0; --j) {
                result.append('0');
            }
        }
        while (i > 0) {
            result.append(alphaNum.charAt((int)(reorderedValue & mask)));
            reorderedValue >>>= bitsPerDigit;
            --i;
        }
    }

    private static String createInsecureUUID() {
        StringBuffer s = new StringBuffer(36);
        UUIDUtils.appendHexString(UUIDUtils.uniqueTOD(), false, 11, s);
        s.append(alphaNum.charAt(_weakRand.nextInt(16) | 8));
        UUIDUtils.appendRandomHexChars(32 - s.length(), _weakRand, s);
        s.insert(8, "-");
        s.insert(13, "-");
        s.insert(18, "-");
        s.insert(23, "-");
        return s.toString();
    }

    private static synchronized long uniqueTOD() {
        long currentTOD = System.currentTimeMillis();
        if (currentTOD < lastUsedTOD) {
            lastUsedTOD = currentTOD;
        }
        if (currentTOD == lastUsedTOD) {
            if (++numIdsThisMilli >= 10000) {
                while (currentTOD == lastUsedTOD) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    currentTOD = System.currentTimeMillis();
                }
                lastUsedTOD = currentTOD;
                numIdsThisMilli = 0;
            }
        } else {
            lastUsedTOD = currentTOD;
            numIdsThisMilli = 0;
        }
        return lastUsedTOD * 10000L + (long)numIdsThisMilli;
    }
}

