/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools.oem;

import flex2.compiler.CompilerSwcContext;
import flex2.compiler.swc.SwcComponent;
import flex2.compiler.util.NameMappings;
import flex2.compiler.util.QName;
import flex2.tools.oem.Component;
import flex2.tools.oem.LibraryInfo;
import flex2.tools.oem.Script;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LibraryInfoImpl
implements LibraryInfo {
    private String[] definitionNames;
    private Map<String, Script> scripts;
    private Map<String, Component> components;
    private NameMappings mappings;
    private Set<String> fileNames;

    LibraryInfoImpl(CompilerSwcContext swcContext, boolean includeBytecodes) {
        int i;
        ArrayList<QName> names = new ArrayList<QName>();
        Iterator<QName> i2 = swcContext.getDefinitionIterator();
        while (i2.hasNext()) {
            names.add(i2.next());
        }
        this.definitionNames = new String[names.size()];
        for (i = 0; i < this.definitionNames.length; ++i) {
            this.definitionNames[i] = ((QName)names.get(i)).toString();
        }
        this.scripts = new TreeMap<String, Script>();
        for (i = 0; i < this.definitionNames.length; ++i) {
            QName def = (QName)names.get(i);
            Script s = swcContext.getScript(def, includeBytecodes);
            this.scripts.put(def.toString(), s);
        }
        this.components = new TreeMap<String, Component>();
        Iterator<SwcComponent> i3 = swcContext.getComponentIterator();
        while (i3.hasNext()) {
            Component c = i3.next();
            this.components.put(c.getClassName(), c);
        }
        this.mappings = swcContext.getNameMappings();
        this.fileNames = new TreeSet<String>(swcContext.getFiles().keySet());
    }

    @Override
    public Component getComponent(String namespaceURI, String name) {
        return this.getComponent(this.mappings.lookupClassName(namespaceURI, name));
    }

    @Override
    public Component getComponent(String definition) {
        return definition != null ? this.components.get(definition) : null;
    }

    @Override
    public Iterator<Component> getComponents() {
        return this.components.values().iterator();
    }

    @Override
    public String[] getDefinitionNames() {
        return this.definitionNames;
    }

    @Override
    public Script getScript(String definition) {
        return this.scripts.get(definition);
    }

    @Override
    public Iterator<Script> getScripts() {
        return this.scripts.values().iterator();
    }

    @Override
    public Iterator<String> getFiles() {
        return this.fileNames.iterator();
    }
}

