////////////////////////////////////////////////////////////////////////////////
//
// ADOBE SYSTEMS INCORPORATED
// Copyright 2007-2010 Adobe Systems Incorporated
// All Rights Reserved.
//
// NOTICE:  Adobe permits you to use, modify, and distribute this file 
// in accordance with the terms of the license agreement accompanying it.
//
////////////////////////////////////////////////////////////////////////////////
package flashx.textLayout.formats
{
    /**
     * Defines values for setting the <code>suffix</code> property of a ListMarkerFormat. 
     *
     *  @playerversion Flash 10
     *  @playerversion AIR 1.5
     *  @langversion 3.0 
     * 
     *  @see ListMarkerFormat#suffix
     */
    public class Suffix
    {
        /** Specifies that the auto suffix is appended to the list marker after the content. 
         *  See <a href="http://www.w3.org/TR/css3-lists/">http://www.w3.org/TR/css3-lists/</a> for the default suffixes.
         * 
         * @playerversion Flash 10
         * @playerversion AIR 1.5
         * @langversion 3.0 
         */
        
        public static const AUTO:String = "auto";
        
        /** Specifies that no suffix is appended to a list marker after the content. 
         *
         * @playerversion Flash 10
         * @playerversion AIR 1.5
         * @langversion 3.0 
         */
        
        public static const NONE:String = "none";
    }
}