////////////////////////////////////////////////////////////////////////////////
//
//  ADOBE SYSTEMS INCORPORATED
//  Copyright 2009 Adobe Systems Incorporated
//  All Rights Reserved.
//
//  NOTICE: Adobe permits you to use, modify, and distribute this file
//  in accordance with the terms of the license agreement accompanying it.
//
////////////////////////////////////////////////////////////////////////////////

package mx.charts.chartClasses
{

/**
 *  A bounded value is used to represent a datapoint
 *  that a chart element intends to render on screen.
 *  ChartElements report BoundedValues, describing their data
 *  to an Axis object. The axis computes autogenerated ranges.
 *  A BoundedValue encapsulates both the value of the datapoint
 *  in a particualr dimension, as well as a margin, in pixels,
 *  that a ChartElement needs above or below the value
 *  in order to render it.
 *  Plots on a plot chart, for example, report their data
 *  with margins to accomodate the size of the plots.
 *  A column chart might report a margin in the Y axis
 *  to accomodate a label rendered above the chart.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 */
public class BoundedValue
{
    include "../../core/Version.as";

	//--------------------------------------------------------------------------
	//
	//  Constructor
	//
	//--------------------------------------------------------------------------

	/**
	 *  Constructor.
	 *
	 *  @param value The value to be rendered.
	 *
	 *  @param lowerMargin The lower margin.
	 *
	 *  @param upperMargin The upper margin.
	 *  
	 *  @langversion 3.0
	 *  @playerversion Flash 9
	 *  @playerversion AIR 1.1
	 *  @productversion Flex 3
	 */
	public function BoundedValue(value:Number,
								 lowerMargin:Number = 0,
								 upperMargin:Number = 0)
	{
		super();

		this.value = value;
		this.lowerMargin = lowerMargin;
		this.upperMargin = upperMargin;
	}

	//--------------------------------------------------------------------------
	//
	//  Properties
	//
	//--------------------------------------------------------------------------

	//----------------------------------
	//  lowerMargin
	//----------------------------------

	[Inspectable(environment="none")]

	/**
	 *  The margin, in pixels, required below the value
	 *  in order to render properly.
	 *  
	 *  @langversion 3.0
	 *  @playerversion Flash 9
	 *  @playerversion AIR 1.1
	 *  @productversion Flex 3
	 */
	public var lowerMargin:Number;

	//----------------------------------
	//  upperMargin
	//----------------------------------

	[Inspectable(environment="none")]

	/** 
	 *  The margin, in pixels, required above the value
	 *  in order to render properly.
	 *  
	 *  @langversion 3.0
	 *  @playerversion Flash 9
	 *  @playerversion AIR 1.1
	 *  @productversion Flex 3
	 */
	public var upperMargin:Number;
	
	//----------------------------------
	//  value
	//----------------------------------

	[Inspectable(environment="none")]

	/**
	 *  The value to be rendered.
	 *  
	 *  @langversion 3.0
	 *  @playerversion Flash 9
	 *  @playerversion AIR 1.1
	 *  @productversion Flex 3
	 */
	public var value:Number;
}

}
