////////////////////////////////////////////////////////////////////////////////
//
//  ADOBE SYSTEMS INCORPORATED
//  Copyright 2006-2007 Adobe Systems Incorporated
//  All Rights Reserved.
//
//  NOTICE: Adobe permits you to use, modify, and distribute this file
//  in accordance with the terms of the license agreement accompanying it.
//
////////////////////////////////////////////////////////////////////////////////

package mx.core
{

import flash.text.Font;

/**
 *  FontAsset is a subclass of the flash.text.Font class 
 *  which represents fonts that you embed in a Flex application.
 *
 *  <p>The font that you embed can be TrueType (TTF) or OpenType (OTF).
 *  You can also embed a system font or a font that is in a SWF file
 *  produced by Flash.
 *  In each of these cases, the MXML compiler autogenerates a class
 *  that extends FontAsset to represent the embedded font.</p>
 *
 *  <p>You do not generally use the FontAsset class directly
 *  when you write a Flex application.
 *  For example, you can embed a font by using the <code>font-face</code> CSS selector
 *  without having to understand that the MXML compiler has created
 *  a subclass of FontAsset for you.</p>
 *
 *  <p>However, it might be useful to understand what is happening
 *  at the ActionScript level.
 *  To embed a font in ActionScript, you declare a variable
 *  of type Class, and put <code>[Embed]</code> metadata on it.
 *  For example, you embed a TTF file like this:</p>
 *
 *  <pre>
 *  [Embed(source="Fancy.ttf", fontName="Fancy")] 
 *  var fancyClass:Class;
 *  </pre>
 *
 *  <p>The MXML compiler transcodes the TTF data
 *  into the font format that the player uses, autogenerates
 *  a subclass of the FontAsset class, and sets your variable
 *  to be a reference to this autogenerated class.
 *  You can then use this class reference to create instances of the
 *  FontAsset by using the <code>new</code> operator, and you can use
 *  APIs of the Font class on them; for example:</p>
 *
 *  <pre>
 *  var fancyFont:FontAsset = FontAsset(new fancyClass());
 *  var hasDigits:Boolean = fancyFont.hasGlyphs("0123456789");
 *  </pre>
 *
 *  <p>However, you rarely need to create FontAsset instances yourself
 *  because you use the <code>fontName</code> that you specify
 *  in the <code>[Embed]</code> metadata to refer to the font; for example,
 *  you set the <code>fontFamily</code> CSS style to the font name
 *  (in this example, <code>"Fancy"</code>), and not to a FontAsset instance such as
 *  <code>fancyFont</code> or to the <code>fancyClass</code>
 *  class reference. For example:</p>
 *
 *  <pre>
 *  &lt;mx:Label text="Thank you for your order." fontFamily="Fancy"/&gt;
 *  </pre>
 *  
 *  @see flash.text.Font
 *  
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 */
public class FontAsset extends Font implements IFlexAsset
{
    include "../core/Version.as";

    //--------------------------------------------------------------------------
    //
    //  Constructor
    //
    //--------------------------------------------------------------------------

    /**
     *  Constructor.
     *  
     *  @langversion 3.0
     *  @playerversion Flash 9
     *  @playerversion AIR 1.1
     *  @productversion Flex 3
     */
    public function FontAsset()
    {
        super();
    }
}

}
