/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.control;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.option.FreeColActionUI;
import net.sf.freecol.client.gui.panel.ChoiceItem;
import net.sf.freecol.client.gui.panel.EndTurnDialog;
import net.sf.freecol.client.networking.Client;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Event;
import net.sf.freecol.common.model.ExportData;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HighScore;
import net.sf.freecol.common.model.IndianNationType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Limit;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Nameable;
import net.sf.freecol.common.model.NationSummary;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.TransactionListener;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.UnitTypeChange;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.networking.AbandonColonyMessage;
import net.sf.freecol.common.networking.AskSkillMessage;
import net.sf.freecol.common.networking.AssignTeacherMessage;
import net.sf.freecol.common.networking.AssignTradeRouteMessage;
import net.sf.freecol.common.networking.AttackMessage;
import net.sf.freecol.common.networking.BuildColonyMessage;
import net.sf.freecol.common.networking.BuyGoodsMessage;
import net.sf.freecol.common.networking.BuyMessage;
import net.sf.freecol.common.networking.BuyPropositionMessage;
import net.sf.freecol.common.networking.CashInTreasureTrainMessage;
import net.sf.freecol.common.networking.ChangeStateMessage;
import net.sf.freecol.common.networking.ChangeWorkImprovementTypeMessage;
import net.sf.freecol.common.networking.ChangeWorkTypeMessage;
import net.sf.freecol.common.networking.ChatMessage;
import net.sf.freecol.common.networking.ClaimLandMessage;
import net.sf.freecol.common.networking.ClearSpecialityMessage;
import net.sf.freecol.common.networking.CloseTransactionMessage;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DeclareIndependenceMessage;
import net.sf.freecol.common.networking.DeclineMoundsMessage;
import net.sf.freecol.common.networking.DeliverGiftMessage;
import net.sf.freecol.common.networking.DemandTributeMessage;
import net.sf.freecol.common.networking.DiplomacyMessage;
import net.sf.freecol.common.networking.DisbandUnitMessage;
import net.sf.freecol.common.networking.DisembarkMessage;
import net.sf.freecol.common.networking.EmbarkMessage;
import net.sf.freecol.common.networking.EmigrateUnitMessage;
import net.sf.freecol.common.networking.EquipUnitMessage;
import net.sf.freecol.common.networking.GetNationSummaryMessage;
import net.sf.freecol.common.networking.GetTransactionMessage;
import net.sf.freecol.common.networking.GoodsForSaleMessage;
import net.sf.freecol.common.networking.InciteMessage;
import net.sf.freecol.common.networking.JoinColonyMessage;
import net.sf.freecol.common.networking.LearnSkillMessage;
import net.sf.freecol.common.networking.LoadCargoMessage;
import net.sf.freecol.common.networking.LootCargoMessage;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.networking.MissionaryMessage;
import net.sf.freecol.common.networking.MoveMessage;
import net.sf.freecol.common.networking.MoveToAmericaMessage;
import net.sf.freecol.common.networking.MoveToEuropeMessage;
import net.sf.freecol.common.networking.NetworkConstants;
import net.sf.freecol.common.networking.NewLandNameMessage;
import net.sf.freecol.common.networking.NewRegionNameMessage;
import net.sf.freecol.common.networking.PayArrearsMessage;
import net.sf.freecol.common.networking.PayForBuildingMessage;
import net.sf.freecol.common.networking.PutOutsideColonyMessage;
import net.sf.freecol.common.networking.RenameMessage;
import net.sf.freecol.common.networking.ScoutIndianSettlementMessage;
import net.sf.freecol.common.networking.SellGoodsMessage;
import net.sf.freecol.common.networking.SellMessage;
import net.sf.freecol.common.networking.SellPropositionMessage;
import net.sf.freecol.common.networking.SetBuildQueueMessage;
import net.sf.freecol.common.networking.SetDestinationMessage;
import net.sf.freecol.common.networking.SetGoodsLevelsMessage;
import net.sf.freecol.common.networking.SetTradeRoutesMessage;
import net.sf.freecol.common.networking.SpySettlementMessage;
import net.sf.freecol.common.networking.StatisticsMessage;
import net.sf.freecol.common.networking.TrainUnitInEuropeMessage;
import net.sf.freecol.common.networking.UnloadCargoMessage;
import net.sf.freecol.common.networking.UpdateCurrentStopMessage;
import net.sf.freecol.common.networking.UpdateTradeRouteMessage;
import net.sf.freecol.common.networking.WorkMessage;
import net.sf.freecol.common.option.BooleanOption;
import net.sf.freecol.server.FreeColServer;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InGameController
implements NetworkConstants {
    private static final Logger logger = Logger.getLogger(InGameController.class.getName());
    private final FreeColClient freeColClient;
    private final short UNIT_LAST_MOVE_DELAY = (short)300;
    private final int MODE_NEXT_ACTIVE_UNIT = 0;
    private final int MODE_EXECUTE_GOTO_ORDERS = 1;
    private final int MODE_END_TURN = 2;
    private int moveMode = 0;
    private int turnsPlayed = 0;
    private File lastSaveGameFile;
    private static FileFilter FSG_FILTER = new FileFilter(){

        public boolean accept(File file) {
            return file.isFile() && file.getName().endsWith(".fsg");
        }
    };
    private HashMap<String, Integer> messagesToIgnore = new HashMap();

    public InGameController(FreeColClient freeColClient) {
        this.freeColClient = freeColClient;
    }

    private Specification getSpecification() {
        return this.freeColClient.getGame().getSpecification();
    }

    private String getSaveGameString(Turn turn) {
        int year = turn.getYear();
        switch (turn.getSeason()) {
            case SPRING: {
                return Integer.toString(year) + "_1_" + Messages.message("spring");
            }
            case AUTUMN: {
                return Integer.toString(year) + "_2_" + Messages.message("autumn");
            }
        }
        return Integer.toString(year);
    }

    public File getLastSaveGameFile() {
        File lastSave = null;
        for (File directory : new File[]{FreeCol.getSaveDirectory(), FreeCol.getAutosaveDirectory()}) {
            for (File savegame : directory.listFiles(FSG_FILTER)) {
                if (lastSave != null && savegame.lastModified() <= lastSave.lastModified()) continue;
                lastSave = savegame;
            }
        }
        return lastSave;
    }

    public boolean quicksaveGame() {
        Game game = this.freeColClient.getGame();
        if (game != null) {
            String gid = Integer.toHexString(game.getUUID().hashCode());
            String filename = "quicksave-" + gid + ".fsg";
            File file = new File(FreeCol.getAutosaveDirectory(), filename);
            return this.saveGame(file);
        }
        return false;
    }

    public boolean quickReload() {
        Canvas canvas = this.freeColClient.getCanvas();
        Game game = this.freeColClient.getGame();
        if (game != null) {
            boolean ok;
            String gid = Integer.toHexString(game.getUUID().hashCode());
            String filename = "quicksave-" + gid + ".fsg";
            File file = new File(FreeCol.getAutosaveDirectory(), filename);
            if (file.isFile() && (ok = true)) {
                this.freeColClient.getConnectController().quitGame(true);
                canvas.removeInGameComponents();
                this.freeColClient.getConnectController().loadGame(file);
                return true;
            }
        }
        return false;
    }

    public boolean saveGame() {
        File file;
        Canvas canvas = this.freeColClient.getCanvas();
        Player player = this.freeColClient.getMyPlayer();
        Game game = this.freeColClient.getGame();
        String gid = Integer.toHexString(game.getUUID().hashCode());
        String fileName = gid + "_" + Messages.message(player.getNationName()) + "_" + this.getSaveGameString(game.getTurn());
        fileName = fileName.replaceAll(" ", "_");
        if (this.freeColClient.canSaveCurrentGame() && (file = canvas.showSaveDialog(FreeCol.getSaveDirectory(), fileName)) != null) {
            FreeCol.setSaveDirectory(file.getParentFile());
            return this.saveGame(file);
        }
        return false;
    }

    public boolean saveGame(File file) {
        Canvas canvas = this.freeColClient.getCanvas();
        FreeColServer server = this.freeColClient.getFreeColServer();
        boolean result = false;
        canvas.showStatusPanel(Messages.message("status.savingGame"));
        try {
            server.setActiveUnit(this.freeColClient.getGUI().getActiveUnit());
            server.saveGame(file, this.freeColClient.getMyPlayer().getName(), this.freeColClient.getClientOptions());
            this.lastSaveGameFile = file;
            canvas.closeStatusPanel();
            result = true;
        }
        catch (IOException e) {
            canvas.errorMessage("couldNotSaveGame");
        }
        canvas.requestFocusInWindow();
        return result;
    }

    public void loadGame() {
        Canvas canvas = this.freeColClient.getCanvas();
        File file = canvas.showLoadDialog(FreeCol.getSaveDirectory());
        if (file == null) {
            return;
        }
        if (!file.isFile()) {
            canvas.errorMessage("fileNotFound");
            return;
        }
        if (!canvas.showConfirmDialog("stopCurrentGame.text", "stopCurrentGame.yes", "stopCurrentGame.no")) {
            return;
        }
        this.freeColClient.getConnectController().quitGame(true);
        canvas.removeInGameComponents();
        this.freeColClient.getConnectController().loadGame(file);
    }

    private boolean askTrivial(String tag) {
        Client client = this.freeColClient.getClient();
        Element element = Message.createNewRootElement(tag);
        if ((element = this.askExpecting(client, element, null)) == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, element);
        return true;
    }

    public void setInDebugMode(boolean debug) {
        FreeCol.setInDebugMode(debug);
        logger.info("Debug mode set to " + debug);
        this.freeColClient.updateMenuBar();
    }

    public void setGameConnected() {
        this.turnsPlayed = 0;
    }

    private boolean requireOurTurn() {
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return false;
        }
        return true;
    }

    private Element askExpecting(Client client, Element element, String tag) {
        Element reply = null;
        try {
            reply = client.ask(element);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Could not send " + element, e);
            return null;
        }
        if (reply == null) {
            logger.warning("Received null reply to " + element);
            return null;
        }
        if ("error".equals(reply.getTagName())) {
            String messageId = reply.getAttribute("messageID");
            String message = reply.getAttribute("message");
            if (messageId != null && message != null && FreeCol.isInDebugMode()) {
                reply.removeAttribute("messageID");
            }
            if (messageId == null && message == null) {
                logger.warning("Received null error response");
            } else {
                logger.warning("Received error response: " + (messageId != null ? messageId : "") + "/" + (message != null ? message : ""));
                Connection conn = client.getConnection();
                this.freeColClient.getInGameInputHandler().handle(conn, reply);
            }
            return null;
        }
        if (tag == null || tag.equals(reply.getTagName())) {
            String sound = reply.getAttribute("sound");
            if (sound != null && !sound.isEmpty()) {
                this.freeColClient.playSound(sound);
            }
            return reply;
        }
        String complaint = "Received reply with tag " + reply.getTagName() + " which should have been " + tag + " to message " + element;
        logger.warning(complaint);
        if (FreeCol.isInDebugMode()) {
            this.freeColClient.getCanvas().errorMessage(null, complaint);
        }
        return null;
    }

    private void autosave_game() {
        Game game = this.freeColClient.getGame();
        if (game == null) {
            return;
        }
        Player player = game.getCurrentPlayer();
        String autosave_text = Messages.message("clientOptions.savegames.autosave.fileprefix");
        String filename = autosave_text + "-" + Messages.message("clientOptions.savegames.autosave.lastturn") + ".fsg";
        String beforeFilename = autosave_text + "-" + Messages.message("clientOptions.savegames.autosave.beforelastturn") + ".fsg";
        File autosaveDir = FreeCol.getAutosaveDirectory();
        File saveGameFile = new File(autosaveDir, filename);
        File beforeSaveFile = new File(autosaveDir, beforeFilename);
        if (saveGameFile.exists()) {
            beforeSaveFile.delete();
            saveGameFile.renameTo(beforeSaveFile);
        }
        this.saveGame(saveGameFile);
        ClientOptions options = this.freeColClient.getClientOptions();
        int savegamePeriod = options.getInteger("model.option.autosavePeriod");
        int turnNumber = game.getTurn().getNumber();
        if (savegamePeriod <= 1 || savegamePeriod != 0 && turnNumber % savegamePeriod == 0) {
            String playernation = player == null ? "" : Messages.message(player.getNation().getNameKey());
            String gid = Integer.toHexString(game.getUUID().hashCode());
            filename = Messages.message("clientOptions.savegames.autosave.fileprefix") + '-' + gid + "_" + playernation + "_" + this.getSaveGameString(game.getTurn()) + ".fsg";
            saveGameFile = new File(autosaveDir, filename);
            this.saveGame(saveGameFile);
        }
    }

    public void setCurrentPlayer(Player player) {
        logger.finest("Entering client setCurrentPlayer: " + player.getName());
        Game game = this.freeColClient.getGame();
        game.setCurrentPlayer(player);
        if (this.freeColClient.getMyPlayer().equals(player) && this.freeColClient.getFreeColServer() != null) {
            if (this.turnsPlayed > 0) {
                this.autosave_game();
            }
            player.invalidateCanSeeTiles();
            if (player.checkEmigrate()) {
                if (player.hasAbility("model.ability.selectRecruit") && player.getEurope().recruitablesDiffer()) {
                    Canvas canvas = this.freeColClient.getCanvas();
                    int index = canvas.showEmigrationPanel(false);
                    this.emigrate(player, index + 1);
                } else {
                    this.emigrate(player, 0);
                }
            }
            if (!this.freeColClient.isSingleplayer()) {
                this.freeColClient.playSound("sound.anthem." + player.getNationID());
            }
            this.displayModelMessages(true);
        }
        logger.finest("Exiting client setCurrentPlayer: " + player.getName());
    }

    private Location operateTradeRoute(Unit unit, List<ModelMessage> messages) {
        Canvas canvas = this.freeColClient.getCanvas();
        TradeRoute.Stop stop = unit.getStop();
        if (!TradeRoute.isStopValid(unit, stop)) {
            String name = unit.getTradeRoute().getName();
            canvas.showInformationMessage((FreeColObject)unit, StringTemplate.template("traderoute.broken").addName("%name%", name));
            this.clearOrders(unit);
            logger.warning("Trade unit " + unit.getId() + " in route " + name + " cannot continue: stop invalid.");
            return null;
        }
        if (unit.getDestination() == null) {
            this.setDestination(unit, stop.getLocation());
        }
        if (stop.getLocation() instanceof Europe && unit.isInEurope() || !(stop.getLocation() instanceof Europe) && unit.getTile() == stop.getLocation().getTile()) {
            if (unit.getInitialMovesLeft() == unit.getMovesLeft()) {
                this.loadUnitAtStop(unit, messages);
                if (!this.askUpdateCurrentStop(unit)) {
                    return null;
                }
            } else if (!(this.unloadUnitAtStop(unit, messages) || this.loadUnitAtStop(unit, messages) || this.askUpdateCurrentStop(unit))) {
                return null;
            }
        }
        return unit.getMovesLeft() > 0 ? unit.getDestination() : null;
    }

    private boolean askUpdateCurrentStop(Unit unit) {
        UpdateCurrentStopMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new UpdateCurrentStopMessage(unit)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    private boolean loadUnitAtStop(Unit unit, List<ModelMessage> messages) {
        TradeRoute.Stop stop = unit.getStop();
        ArrayList<GoodsType> goodsTypesToLoad = new ArrayList<GoodsType>(stop.getCargo());
        boolean ret = false;
        Colony colony = unit.getColony();
        Colony loc = unit.isInEurope() ? unit.getOwner().getEurope() : colony;
        Game game = this.freeColClient.getGame();
        for (Goods goods : unit.getGoodsList()) {
            int present;
            int atStop;
            int index;
            GoodsType type = goods.getType();
            int toLoad = 100 - goods.getAmount();
            if (toLoad <= 0 || (index = goodsTypesToLoad.indexOf(type)) < 0) continue;
            if (unit.isInEurope()) {
                atStop = Integer.MAX_VALUE;
                present = Integer.MAX_VALUE;
            } else {
                present = colony.getGoodsContainer().getGoodsCount(type);
                atStop = colony.getExportAmount(type);
            }
            if (atStop > 0) {
                Goods cargo = new Goods(game, loc, type, Math.min(toLoad, atStop));
                if (this.loadGoods(cargo, unit)) {
                    messages.add(this.getLoadGoodsMessage(unit, type, cargo.getAmount(), present, atStop, toLoad));
                    ret = true;
                }
            } else if (present > 0) {
                messages.add(this.getLoadGoodsMessage(unit, type, 0, present, 0, toLoad));
            }
            goodsTypesToLoad.remove(index);
        }
        for (GoodsType type : goodsTypesToLoad) {
            int present;
            int atStop;
            if (unit.getSpaceLeft() <= 0) break;
            int toLoad = 100;
            if (unit.isInEurope()) {
                atStop = Integer.MAX_VALUE;
                present = Integer.MAX_VALUE;
            } else {
                present = colony.getGoodsContainer().getGoodsCount(type);
                atStop = colony.getExportAmount(type);
            }
            if (atStop > 0) {
                Goods cargo = new Goods(game, loc, type, Math.min(toLoad, atStop));
                if (!this.loadGoods(cargo, unit)) continue;
                messages.add(this.getLoadGoodsMessage(unit, type, cargo.getAmount(), present, atStop, toLoad));
                ret = true;
                continue;
            }
            if (present <= 0) continue;
            messages.add(this.getLoadGoodsMessage(unit, type, 0, present, 0, toLoad));
        }
        return ret;
    }

    private ModelMessage getLoadGoodsMessage(Unit unit, GoodsType type, int amount, int present, int atStop, int toLoad) {
        Player player = unit.getOwner();
        Location loc = unit.getLocation();
        String route = unit.getTradeRoute().getName();
        ModelMessage m = toLoad < atStop ? new ModelMessage(ModelMessage.MessageType.GOODS_MOVEMENT, "traderoute.loadImportLimited", unit).addName("%route%", route).addStringTemplate("%unit%", Messages.getLabel(unit)).addStringTemplate("%location%", loc.getLocationNameFor(player)).addName("%amount%", Integer.toString(amount)).add("%goods%", type.getNameKey()).addName("%more%", Integer.toString(atStop - toLoad)) : (present > atStop && toLoad > atStop ? new ModelMessage(ModelMessage.MessageType.GOODS_MOVEMENT, "traderoute.loadExportLimited", unit).addName("%route%", route).addStringTemplate("%unit%", Messages.getLabel(unit)).addStringTemplate("%location%", loc.getLocationNameFor(player)).addName("%amount%", Integer.toString(amount)).add("%goods%", type.getNameKey()).addName("%more%", Integer.toString(present - atStop)) : new ModelMessage(ModelMessage.MessageType.GOODS_MOVEMENT, "traderoute.load", unit).addName("%route%", route).addStringTemplate("%unit%", Messages.getLabel(unit)).addStringTemplate("%location%", loc.getLocationNameFor(player)).addName("%amount%", Integer.toString(amount)).add("%goods%", type.getNameKey()));
        return m;
    }

    private boolean loadGoods(Goods goods, Unit carrier) {
        ColonyWas colonyWas;
        if (carrier.isInEurope() && goods.getLocation() instanceof Europe) {
            if (!carrier.getOwner().canTrade(goods)) {
                return false;
            }
            return this.buyGoods(goods.getType(), goods.getAmount(), carrier);
        }
        GoodsType type = goods.getType();
        GoodsContainer container = carrier.getGoodsContainer();
        int oldAmount = container.getGoodsCount(type);
        UnitWas unitWas = new UnitWas(carrier);
        Colony colony = carrier.getColony();
        ColonyWas colonyWas2 = colonyWas = colony == null ? null : new ColonyWas(colony);
        if (this.askLoadCargo(goods, carrier) && container.getGoodsCount(type) != oldAmount) {
            if (colonyWas != null) {
                colonyWas.fireChanges();
            }
            unitWas.fireChanges();
            return true;
        }
        return false;
    }

    private boolean askLoadCargo(Goods goods, Unit carrier) {
        LoadCargoMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new LoadCargoMessage(goods, carrier)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    private boolean unloadUnitAtStop(Unit unit, List<ModelMessage> messages) {
        Colony colony = unit.getColony();
        TradeRoute.Stop stop = unit.getStop();
        List<GoodsType> goodsTypesToLoad = stop.getCargo();
        boolean ret = false;
        Game game = this.freeColClient.getGame();
        for (Goods goods : new ArrayList<Goods>(unit.getGoodsList())) {
            Goods cargo;
            GoodsType type = goods.getType();
            if (goodsTypesToLoad.contains(type)) continue;
            int atStop = colony == null ? Integer.MAX_VALUE : colony.getImportAmount(type);
            int toUnload = goods.getAmount();
            if (toUnload > atStop) {
                Canvas canvas = this.freeColClient.getCanvas();
                String locName = colony.getName();
                String overflow = Integer.toString(toUnload - atStop);
                int option = this.freeColClient.getClientOptions().getInteger("model.option.unloadOverflowResponse");
                switch (option) {
                    case 0: {
                        StringTemplate template = StringTemplate.template("traderoute.warehouseCapacity").addStringTemplate("%unit%", Messages.getLabel(unit)).addName("%colony%", locName).addName("%amount%", overflow).add("%goods%", goods.getNameKey());
                        if (canvas.showConfirmDialog(colony.getTile(), template, "yes", "no")) break;
                        toUnload = atStop;
                        break;
                    }
                    case 1: {
                        toUnload = atStop;
                        break;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        logger.warning("Illegal UNLOAD_OVERFLOW_RESPONSE: " + Integer.toString(option));
                    }
                }
            }
            if (!this.unloadGoods(cargo = goods.getAmount() == toUnload ? goods : new Goods(game, unit, type, toUnload), unit, colony)) continue;
            messages.add(this.getUnloadGoodsMessage(unit, type, cargo.getAmount(), atStop, goods.getAmount(), toUnload));
            ret = true;
        }
        return ret;
    }

    private ModelMessage getUnloadGoodsMessage(Unit unit, GoodsType type, int amount, int atStop, int present, int toUnload) {
        String key = null;
        int overflow = 0;
        if (present == toUnload) {
            key = "traderoute.unload";
        } else if (toUnload > atStop) {
            key = "traderoute.overflow";
            overflow = toUnload - atStop;
        } else {
            key = "traderoute.nounload";
            overflow = present - atStop;
        }
        return new ModelMessage(ModelMessage.MessageType.GOODS_MOVEMENT, key, unit).addName("%route%", unit.getTradeRoute().getName()).addStringTemplate("%unit%", Messages.getLabel(unit)).addStringTemplate("%location%", unit.getLocation().getLocationNameFor(unit.getOwner())).addAmount("%amount%", amount).addAmount("%overflow%", overflow).add("%goods%", type.getNameKey());
    }

    private boolean unloadGoods(Goods goods, Unit carrier, Colony colony) {
        if (colony == null && carrier.isInEurope()) {
            return !carrier.getOwner().canTrade(goods) ? false : this.sellGoods(goods);
        }
        GoodsType type = goods.getType();
        GoodsContainer container = carrier.getGoodsContainer();
        int oldAmount = container.getGoodsCount(type);
        ColonyWas colonyWas = colony == null ? null : new ColonyWas(colony);
        UnitWas unitWas = new UnitWas(carrier);
        if (this.askUnloadCargo(goods) && container.getGoodsCount(type) != oldAmount) {
            if (colonyWas != null) {
                colonyWas.fireChanges();
            }
            unitWas.fireChanges();
            return true;
        }
        return false;
    }

    private boolean askUnloadCargo(Goods goods) {
        UnloadCargoMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new UnloadCargoMessage(goods)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    public void moveToDestination(Unit unit) {
        Location destination;
        if (!this.requireOurTurn()) {
            return;
        }
        Player player = this.freeColClient.getMyPlayer();
        ArrayList<ModelMessage> messages = new ArrayList<ModelMessage>();
        GUI gui = this.freeColClient.getGUI();
        gui.setActiveUnit(unit);
        while (unit.getMovesLeft() > 0 && !(unit.getTradeRoute() != null ? (destination = this.operateTradeRoute(unit, messages)) == null || unit.getTile() == destination.getTile() : (destination = unit.getDestination()) == null || (destination instanceof Europe ? unit.isInEurope() : destination.getTile() == null || unit.getTile() == destination.getTile()))) {
            PathNode path;
            PathNode pathNode = path = destination instanceof Europe ? unit.findPathToEurope() : unit.findPath(destination.getTile());
            if (path == null) {
                StringTemplate dest = destination.getLocationNameFor(player);
                this.freeColClient.getCanvas().showInformationMessage((FreeColObject)unit, StringTemplate.template("selectDestination.failed").addStringTemplate("%destination%", dest));
                break;
            }
            if (this.movePath(unit, path)) continue;
            break;
        }
        if (unit.getTradeRoute() == null) {
            Location location = unit.getDestination();
            if (location != null) {
                if (unit.getTile() == null) {
                    if (unit.getLocation() == location) {
                        this.clearGotoOrders(unit);
                    }
                } else if (unit.getTile() == location.getTile()) {
                    this.clearGotoOrders(unit);
                }
            }
            this.checkCashInTreasureTrain(unit);
            if (unit.getMovesLeft() > 0 && unit.getTile() != null && this.freeColClient.getClientOptions().getBoolean("model.option.alwaysCenter")) {
                this.freeColClient.getGUI().setSelectedTile(unit.getTile(), false);
            }
        } else if (this.freeColClient.getClientOptions().getBoolean("model.option.guiShowGoodsMovement")) {
            for (ModelMessage m : messages) {
                unit.getOwner().addModelMessage(m);
            }
        }
    }

    public void moveActiveUnit(Map.Direction direction) {
        if (!this.requireOurTurn()) {
            return;
        }
        Unit unit = this.freeColClient.getGUI().getActiveUnit();
        if (unit != null) {
            this.clearGotoOrders(unit);
            this.move(unit, direction);
        }
    }

    public void selectDestination(Unit unit) {
        Canvas canvas = this.freeColClient.getCanvas();
        Location destination = canvas.showSelectDestinationDialog(unit);
        if (destination == null) {
            return;
        }
        if (this.setDestination(unit, destination) && this.freeColClient.getGame().getCurrentPlayer() == this.freeColClient.getMyPlayer()) {
            if (destination instanceof Europe && unit.getTile() != null && (unit.getTile().canMoveToEurope() || unit.getTile().isAdjacentToMapEdge())) {
                this.moveToEurope(unit);
            } else {
                this.moveToDestination(unit);
            }
        }
    }

    public void declareIndependence() {
        String countryName;
        if (!this.requireOurTurn()) {
            return;
        }
        Canvas canvas = this.freeColClient.getCanvas();
        Player player = this.freeColClient.getMyPlayer();
        Event event = this.getSpecification().getEvent("model.event.declareIndependence");
        for (Limit limit : event.getLimits()) {
            if (limit.evaluate(player)) continue;
            canvas.showInformationMessage(StringTemplate.template(limit.getDescriptionKey()).addAmount("%limit%", limit.getRightHandSide().getValue()));
            return;
        }
        if (player.getNewLandName() == null) {
            return;
        }
        List<String> names = canvas.showConfirmDeclarationDialog();
        if (names == null || names.get(0) == null || names.get(0).length() == 0 || names.get(1) == null || names.get(1).length() == 0) {
            return;
        }
        String nationName = names.get(0);
        if (this.askDeclare(nationName, countryName = names.get(1)) && player.getPlayerType() == Player.PlayerType.REBEL) {
            canvas.showDeclarationDialog();
            this.freeColClient.getActionManager().update();
            this.nextModelMessage();
        }
    }

    private boolean askDeclare(String nation, String country) {
        DeclareIndependenceMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new DeclareIndependenceMessage(nation, country)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    public void sendChat(String message) {
        ChatMessage chatMessage = new ChatMessage(this.freeColClient.getMyPlayer(), message, false);
        this.freeColClient.getClient().sendAndWait(chatMessage.toXMLElement());
    }

    public void rename(Nameable object) {
        Player player = this.freeColClient.getMyPlayer();
        if (!(object instanceof Ownable) || ((Ownable)((Object)object)).getOwner() != player) {
            return;
        }
        Canvas canvas = this.freeColClient.getCanvas();
        String name = null;
        if (object instanceof Colony) {
            Colony colony = (Colony)object;
            name = canvas.showInputDialog(colony.getTile(), StringTemplate.key("renameColony.text"), colony.getName(), "renameColony.yes", "renameColony.no", true);
            if (name == null) {
                return;
            }
            if (colony.getName().equals(name)) {
                return;
            }
            if (player.getSettlement(name) != null) {
                canvas.showInformationMessage((FreeColObject)((Colony)object), StringTemplate.template("nameColony.notUnique").addName("%name%", name));
                return;
            }
        } else if (object instanceof Unit) {
            Unit unit = (Unit)object;
            name = canvas.showInputDialog(unit.getTile(), StringTemplate.key("renameUnit.text"), unit.getName(), "renameUnit.yes", "renameUnit.no", false);
            if (name == null) {
                return;
            }
        } else {
            logger.warning("Tried to rename an unsupported Nameable: " + object.toString());
            return;
        }
        this.askRename((FreeColGameObject)((Object)object), name);
    }

    private boolean askRename(FreeColGameObject object, String name) {
        RenameMessage message = new RenameMessage(object, name);
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, message.toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    public void buildColony() {
        String name;
        if (!this.requireOurTurn()) {
            return;
        }
        Canvas canvas = this.freeColClient.getCanvas();
        Player player = this.freeColClient.getMyPlayer();
        GUI gui = this.freeColClient.getGUI();
        Unit unit = gui.getActiveUnit();
        if (unit == null) {
            return;
        }
        if (!unit.canBuildColony()) {
            canvas.showInformationMessage((FreeColObject)unit, StringTemplate.template("buildColony.badUnit").addName("%unit%", unit.getName()));
            return;
        }
        Tile tile = unit.getTile();
        if (tile.getColony() != null) {
            this.askJoinColony(unit, tile.getColony());
            return;
        }
        if (!player.canAcquireToFoundSettlement(tile)) {
            canvas.showInformationMessage("buildColony.badTile");
            return;
        }
        if (this.freeColClient.getClientOptions().getBoolean("model.option.guiShowColonyWarnings") && !this.showColonyWarnings(tile, unit)) {
            return;
        }
        if (tile.getOwner() != null && tile.getOwner() != player) {
            if (!this.claimTile(player, tile, null, player.getLandPrice(tile), 0)) {
                return;
            }
            if (!player.canClaimToFoundSettlement(tile)) {
                return;
            }
        }
        if ("".equals(name = player.getSettlementName())) {
            player.installSettlementNames(Messages.getSettlementNames(player), null);
            name = player.getSettlementName();
        }
        if ((name = canvas.showInputDialog(tile, StringTemplate.key("nameColony.text"), name, "nameColony.yes", "nameColony.no", true)) == null) {
            return;
        }
        if (player.getSettlement(name) != null) {
            canvas.showInformationMessage((FreeColObject)tile, StringTemplate.template("nameColony.notUnique").addName("%name%", name));
            return;
        }
        if (this.askBuildColony(name, unit) && tile.getSettlement() != null) {
            player.invalidateCanSeeTiles();
            this.freeColClient.playSound("sound.event.buildingComplete");
            gui.setActiveUnit(null);
            gui.setSelectedTile(tile, false);
            ArrayList<Unit> units = new ArrayList<Unit>(tile.getUnitList());
            for (Unit unitInTile : units) {
                this.checkCashInTreasureTrain(unitInTile);
            }
        }
    }

    private boolean showColonyWarnings(Tile tile, Unit unit) {
        boolean landLocked = true;
        boolean ownedByEuropeans = false;
        boolean ownedBySelf = false;
        boolean ownedByIndians = false;
        HashMap<GoodsType, Integer> goodsMap = new HashMap<GoodsType, Integer>();
        for (GoodsType goodsType : this.getSpecification().getGoodsTypeList()) {
            int potential;
            if (goodsType.isFoodType()) {
                potential = 0;
                if (tile.getType().isPrimaryGoodsType(goodsType)) {
                    potential = tile.potential(goodsType, null);
                }
                goodsMap.put(goodsType, new Integer(potential));
                continue;
            }
            if (!goodsType.isBuildingMaterial()) continue;
            while (goodsType.isRefined()) {
                goodsType = goodsType.getRawMaterial();
            }
            potential = 0;
            if (tile.getType().isSecondaryGoodsType(goodsType)) {
                potential = tile.potential(goodsType, null);
            }
            goodsMap.put(goodsType, new Integer(potential));
        }
        block2: for (Tile newTile : tile.getSurroundingTiles(1)) {
            if (!newTile.isLand()) {
                landLocked = false;
            }
            for (Map.Entry entry : goodsMap.entrySet()) {
                entry.setValue((Integer)entry.getValue() + newTile.potential((GoodsType)entry.getKey(), null));
            }
            Player tileOwner = newTile.getOwner();
            if (tileOwner == unit.getOwner()) {
                if (newTile.getOwningSettlement() != null) {
                    ownedBySelf = true;
                    continue;
                }
                for (Tile ownTile : newTile.getSurroundingTiles(1)) {
                    Colony colony = ownTile.getColony();
                    if (colony == null || colony.getOwner() != unit.getOwner()) continue;
                    ownedBySelf = true;
                    continue block2;
                }
                continue;
            }
            if (tileOwner != null && tileOwner.isEuropean()) {
                ownedByEuropeans = true;
                continue;
            }
            if (tileOwner == null) continue;
            ownedByIndians = true;
        }
        int food = 0;
        for (Map.Entry entry : goodsMap.entrySet()) {
            if (!((GoodsType)entry.getKey()).isFoodType()) continue;
            food += ((Integer)entry.getValue()).intValue();
        }
        ArrayList<ModelMessage> messages = new ArrayList<ModelMessage>();
        if (landLocked) {
            messages.add(new ModelMessage(ModelMessage.MessageType.MISSING_GOODS, "buildColony.landLocked", unit, this.getSpecification().getGoodsType("model.goods.fish")));
        }
        if (food < 8) {
            messages.add(new ModelMessage(ModelMessage.MessageType.MISSING_GOODS, "buildColony.noFood", unit, this.getSpecification().getPrimaryFoodType()));
        }
        for (Map.Entry entry : goodsMap.entrySet()) {
            if (((GoodsType)entry.getKey()).isFoodType() || (Integer)entry.getValue() >= 4) continue;
            messages.add(new ModelMessage(ModelMessage.MessageType.MISSING_GOODS, "buildColony.noBuildingMaterials", unit, (FreeColObject)entry.getKey()).add("%goods%", ((GoodsType)entry.getKey()).getNameKey()));
        }
        if (ownedBySelf) {
            messages.add(new ModelMessage(ModelMessage.MessageType.WARNING, "buildColony.ownLand", unit));
        }
        if (ownedByEuropeans) {
            messages.add(new ModelMessage(ModelMessage.MessageType.WARNING, "buildColony.EuropeanLand", unit));
        }
        if (ownedByIndians) {
            messages.add(new ModelMessage(ModelMessage.MessageType.WARNING, "buildColony.IndianLand", unit));
        }
        if (messages.isEmpty()) {
            return true;
        }
        ModelMessage[] modelMessages = messages.toArray(new ModelMessage[messages.size()]);
        return this.freeColClient.getCanvas().showConfirmDialog(unit.getTile(), modelMessages, "buildColony.yes", "buildColony.no");
    }

    private boolean askBuildColony(String name, Unit unit) {
        BuildColonyMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new BuildColonyMessage(name, unit)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    private boolean askJoinColony(Unit unit, Colony colony) {
        JoinColonyMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new JoinColonyMessage(colony, unit)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    public void abandonColony(Colony colony) {
        if (!this.requireOurTurn()) {
            return;
        }
        Player player = this.freeColClient.getMyPlayer();
        if (colony == null || colony.getOwner() != player || colony.getUnitCount() > 0) {
            throw new IllegalStateException("Abandon bogus colony");
        }
        Tile tile = colony.getTile();
        if (this.askAbandonColony(colony) && tile.getSettlement() == null) {
            player.invalidateCanSeeTiles();
            GUI gui = this.freeColClient.getGUI();
            gui.setActiveUnit(null);
            gui.setSelectedTile(tile, false);
        }
    }

    private boolean askAbandonColony(Colony colony) {
        AbandonColonyMessage message = new AbandonColonyMessage(colony);
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, message.toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    public void clearGotoOrders(Unit unit) {
        if (unit != null && unit.getDestination() != null) {
            this.setDestination(unit, null);
        }
    }

    public boolean setDestination(Unit unit, Location destination) {
        if (unit.getTradeRoute() != null) {
            Canvas canvas = this.freeColClient.getCanvas();
            StringTemplate template = StringTemplate.template("traderoute.reassignRoute").addStringTemplate("%unit%", Messages.getLabel(unit)).add("%route%", unit.getTradeRoute().getName());
            if (!canvas.showConfirmDialog(unit.getTile(), template, "yes", "no")) {
                return false;
            }
        }
        return this.askSetDestination(unit, destination) && unit.getDestination() == destination;
    }

    private boolean askSetDestination(Unit unit, Location destination) {
        SetDestinationMessage message = new SetDestinationMessage(unit, destination);
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, message.toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    private void emigrate(Player player, int slot) {
        Europe europe = player.getEurope();
        EuropeWas europeWas = new EuropeWas(europe);
        if (this.askEmigrate(slot)) {
            europeWas.fireChanges();
            this.freeColClient.getCanvas().updateGoldLabel();
        }
    }

    public void recruitUnitInEurope(int index) {
        if (!this.requireOurTurn()) {
            return;
        }
        Player player = this.freeColClient.getMyPlayer();
        if (!player.checkGold(player.getRecruitPrice())) {
            this.freeColClient.getCanvas().errorMessage("notEnoughGold");
            return;
        }
        this.emigrate(player, index + 1);
    }

    private boolean askEmigrate(int slot) {
        EmigrateUnitMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new EmigrateUnitMessage(slot)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    public void move(Unit unit, Map.Direction direction) {
        if (!this.requireOurTurn()) {
            return;
        }
        this.moveDirection(unit, direction, true);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InGameController.this.freeColClient.getActionManager().update();
                InGameController.this.freeColClient.updateMenuBar();
            }
        });
    }

    private boolean movePath(Unit unit, PathNode path) {
        while (path != null) {
            if (unit.getDestination() instanceof Europe && unit.getTile() != null && unit.getTile().isAdjacentToMapEdge()) {
                this.moveToEurope(unit);
                return false;
            }
            if (!this.moveDirection(unit, path.getDirection(), false)) {
                return false;
            }
            path = path.next;
        }
        return true;
    }

    private Settlement getSettlementAt(Tile tile, Map.Direction direction) {
        return tile.getNeighbourOrNull(direction).getSettlement();
    }

    private StringTemplate getNationAt(Tile tile, Map.Direction direction) {
        Tile newTile = tile.getNeighbourOrNull(direction);
        Player player = null;
        player = newTile.getSettlement() != null ? newTile.getSettlement().getOwner() : (newTile.getFirstUnit() != null ? newTile.getFirstUnit().getOwner() : this.freeColClient.getGame().getUnknownEnemy());
        return player.getNationName();
    }

    private boolean moveDirection(Unit unit, Map.Direction direction, boolean interactive) {
        Canvas canvas = this.freeColClient.getCanvas();
        switch (unit.getMoveType(direction)) {
            case MOVE: {
                this.moveMove(unit, direction);
                return unit.getMovesLeft() > 0;
            }
            case MOVE_HIGH_SEAS: {
                if (!interactive && unit.getDestination() instanceof Europe) {
                    this.moveToEurope(unit);
                    return false;
                }
                return this.moveHighSeas(unit, direction);
            }
            case EXPLORE_LOST_CITY_RUMOUR: {
                this.moveExplore(unit, direction);
                return false;
            }
            case ATTACK: {
                this.moveAttack(unit, direction);
                return false;
            }
            case EMBARK: {
                this.moveEmbark(unit, direction);
                return false;
            }
            case ENTER_INDIAN_SETTLEMENT_WITH_FREE_COLONIST: {
                this.moveLearnSkill(unit, direction);
                return false;
            }
            case ENTER_INDIAN_SETTLEMENT_WITH_SCOUT: {
                this.moveScoutIndianSettlement(unit, direction);
                return false;
            }
            case ENTER_INDIAN_SETTLEMENT_WITH_MISSIONARY: {
                this.moveUseMissionary(unit, direction);
                return false;
            }
            case ENTER_FOREIGN_COLONY_WITH_SCOUT: {
                this.moveScoutColony(unit, direction);
                return false;
            }
            case ENTER_SETTLEMENT_WITH_CARRIER_AND_GOODS: {
                this.moveTrade(unit, direction);
                return false;
            }
            case MOVE_NO_ACCESS_BEACHED: {
                if (interactive) {
                    this.freeColClient.playSound("sound.event.illegalMove");
                    StringTemplate nation = this.getNationAt(unit.getTile(), direction);
                    canvas.showInformationMessage((FreeColObject)unit, StringTemplate.template("move.noAccessBeached").addStringTemplate("%nation%", nation));
                }
                return false;
            }
            case MOVE_NO_ACCESS_CONTACT: {
                if (interactive) {
                    this.freeColClient.playSound("sound.event.illegalMove");
                    StringTemplate nation = this.getNationAt(unit.getTile(), direction);
                    canvas.showInformationMessage((FreeColObject)unit, StringTemplate.template("move.noAccessContact").addStringTemplate("%nation%", nation));
                }
                return false;
            }
            case MOVE_NO_ACCESS_LAND: {
                if (!this.moveDisembark(unit, direction) && interactive) {
                    this.freeColClient.playSound("sound.event.illegalMove");
                }
                return false;
            }
            case MOVE_NO_ACCESS_SETTLEMENT: {
                if (interactive) {
                    this.freeColClient.playSound("sound.event.illegalMove");
                    StringTemplate nation = this.getNationAt(unit.getTile(), direction);
                    canvas.showInformationMessage((FreeColObject)unit, StringTemplate.template("move.noAccessSettlement").addStringTemplate("%unit%", Messages.getLabel(unit)).addStringTemplate("%nation%", nation));
                }
                return false;
            }
            case MOVE_NO_ACCESS_SKILL: {
                if (interactive) {
                    this.freeColClient.playSound("sound.event.illegalMove");
                    canvas.showInformationMessage((FreeColObject)unit, StringTemplate.template("move.noAccessSkill").addStringTemplate("%unit%", Messages.getLabel(unit)));
                }
                return false;
            }
            case MOVE_NO_ACCESS_TRADE: {
                if (interactive) {
                    this.freeColClient.playSound("sound.event.illegalMove");
                    StringTemplate nation = this.getNationAt(unit.getTile(), direction);
                    canvas.showInformationMessage((FreeColObject)unit, StringTemplate.template("move.noAccessTrade").addStringTemplate("%nation%", nation));
                }
                return false;
            }
            case MOVE_NO_ACCESS_WAR: {
                if (interactive) {
                    this.freeColClient.playSound("sound.event.illegalMove");
                    StringTemplate nation = this.getNationAt(unit.getTile(), direction);
                    canvas.showInformationMessage((FreeColObject)unit, StringTemplate.template("move.noAccessWar").addStringTemplate("%nation%", nation));
                }
                return false;
            }
            case MOVE_NO_ACCESS_WATER: {
                if (interactive) {
                    this.freeColClient.playSound("sound.event.illegalMove");
                    canvas.showInformationMessage((FreeColObject)unit, StringTemplate.template("move.noAccessWater").addStringTemplate("%unit%", Messages.getLabel(unit)));
                }
                return false;
            }
            case MOVE_NO_ATTACK_MARINE: {
                if (interactive) {
                    this.freeColClient.playSound("sound.event.illegalMove");
                    canvas.showInformationMessage((FreeColObject)unit, StringTemplate.template("move.noAttackWater").addStringTemplate("%unit%", Messages.getLabel(unit)));
                }
                return false;
            }
            case MOVE_NO_MOVES: {
                if (!interactive) {
                    unit.setMovesLeft(0);
                }
                return false;
            }
        }
        if (interactive) {
            this.freeColClient.playSound("sound.event.illegalMove");
        }
        return false;
    }

    private void moveMove(Unit unit, Map.Direction direction) {
        if (unit.canCarryUnits() && unit.getSpaceLeft() > 0 && (unit.getColony() != null || unit.isInEurope())) {
            for (Unit sentry : new ArrayList<Unit>(unit.getLocation().getUnitList())) {
                if (sentry.getState() != Unit.UnitState.SENTRY) continue;
                if (sentry.getSpaceTaken() <= unit.getSpaceLeft()) {
                    this.boardShip(sentry, unit);
                    logger.finest("Unit " + unit.toString() + " loaded sentry " + sentry.toString());
                    continue;
                }
                logger.finest("Unit " + sentry.toString() + " is too big to board " + unit.toString());
            }
        }
        UnitWas unitWas = new UnitWas(unit);
        Element reply = this.askMove(unit, direction);
        if (reply == null) {
            return;
        }
        unitWas.fireChanges();
        Game game = this.freeColClient.getGame();
        final Canvas canvas = this.freeColClient.getCanvas();
        Player player = this.freeColClient.getMyPlayer();
        final Tile tile = unit.getTile();
        if (reply.hasAttribute("slowedBy")) {
            Unit slowedBy = (Unit)game.getFreeColGameObject(reply.getAttribute("slowedBy"));
            StringTemplate enemy = slowedBy.getOwner().getNationName();
            canvas.showInformationMessage((FreeColObject)slowedBy, StringTemplate.template("model.unit.slowed").addStringTemplate("%unit%", Messages.getLabel(unit)).addStringTemplate("%enemyUnit%", Messages.getLabel(slowedBy)).addStringTemplate("%enemyNation%", enemy));
        }
        ModelMessage m = null;
        if (reply.hasAttribute("nameNewLand")) {
            String who;
            String defaultName = reply.getAttribute("nameNewLand");
            String newLandName = canvas.showInputDialog(tile, StringTemplate.key("newLand.text"), defaultName, "newLand.yes", null, true);
            if (newLandName == null) {
                newLandName = defaultName;
            }
            Player welcomer = null;
            boolean accept = false;
            if (reply.hasAttribute("welcome") && game.getFreeColGameObjectSafely(who = reply.getAttribute("welcome")) instanceof Player) {
                welcomer = (Player)game.getFreeColGameObjectSafely(who);
                String messageId = tile.getOwner() == welcomer ? "welcomeOffer.text" : "welcomeSimple.text";
                String camps = reply.getAttribute("camps");
                String type = ((IndianNationType)welcomer.getNationType()).getSettlementTypeKey(true);
                accept = canvas.showConfirmDialog(tile, StringTemplate.template(messageId).addStringTemplate("%nation%", welcomer.getNationName()).addName("%camps%", camps).add("%settlementType%", type), "welcome.yes", "welcome.no");
            }
            Object event = null;
            if (this.askNewLandName(newLandName, welcomer, accept) && newLandName.equals(player.getNewLandName())) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        canvas.showEventPanel(tile, Canvas.EventType.FIRST_LANDING);
                    }
                });
                String key = FreeColActionUI.getHumanKeyStrokeText(this.freeColClient.getActionManager().getFreeColAction("buildColonyAction").getAccelerator());
                m = new ModelMessage(ModelMessage.MessageType.TUTORIAL, "tutorial.buildColony", player).addName("%build_colony_key%", key).add("%build_colony_menu_item%", "buildColonyAction.name").add("%orders_menu_item%", "menuBar.orders");
                player.addModelMessage(m);
            }
        }
        if (reply.hasAttribute("discoverPacific")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    canvas.showEventPanel(tile, Canvas.EventType.DISCOVER_PACIFIC);
                }
            });
        }
        if (reply.hasAttribute("discoverRegion") && reply.hasAttribute("regionType")) {
            String newRegionType = reply.getAttribute("regionType");
            String defaultName = reply.getAttribute("discoverRegion");
            String newRegionName = canvas.showInputDialog(unit.getTile(), StringTemplate.template("nameRegion.text").addName("%name%", newRegionType), defaultName, "ok", null, true);
            if (newRegionName == null || "".equals(newRegionName)) {
                newRegionName = defaultName;
            }
            this.askNewRegionName(newRegionName, unit);
        }
        if (reply.hasAttribute("fountainOfYouth")) {
            final int migrants = Integer.parseInt(reply.getAttribute("fountainOfYouth"));
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    for (int i = 0; i < migrants; ++i) {
                        int index = canvas.showEmigrationPanel(true);
                        InGameController.this.askEmigrate(index + 1);
                    }
                }
            });
        }
        ClientOptions options = this.freeColClient.getClientOptions();
        if (unit.getMovesLeft() <= 0 && options.getBoolean("model.option.unitLastMoveDelay")) {
            canvas.paintImmediately(canvas.getBounds());
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (unit.isDisposed() || this.checkCashInTreasureTrain(unit)) {
            this.nextActiveUnit(tile);
        } else {
            if (tile.getColony() != null && unit.isCarrier() && unit.getTradeRoute() == null && (unit.getDestination() == null || unit.getDestination().getTile() == tile.getTile())) {
                canvas.showColonyPanel(tile.getColony());
            }
            if (unit.getMovesLeft() == 0) {
                this.nextActiveUnit();
            } else {
                this.displayModelMessages(false);
            }
        }
    }

    private Element askMove(Unit unit, Map.Direction direction) {
        MoveMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new MoveMessage(unit, direction)).toXMLElement(), null);
        if (reply == null) {
            return null;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return reply;
    }

    private boolean askNewLandName(String name, Player welcomer, boolean accept) {
        NewLandNameMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new NewLandNameMessage(name, welcomer, accept)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    private boolean askNewRegionName(String name, Unit unit) {
        NewRegionNameMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new NewRegionNameMessage(name, unit)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    private boolean moveHighSeas(Unit unit, Map.Direction direction) {
        Tile oldTile = unit.getTile();
        Tile newTile = oldTile.getNeighbourOrNull(direction);
        Canvas canvas = this.freeColClient.getCanvas();
        if ((newTile == null || !oldTile.canMoveToEurope() && newTile.canMoveToEurope()) && canvas.showConfirmDialog(oldTile, StringTemplate.template("highseas.text").addAmount("%number%", this.getSpecification().getInteger("model.option.turnsToSail")), "highseas.yes", "highseas.no")) {
            this.moveToEurope(unit);
            this.nextActiveUnit();
            return false;
        }
        this.moveMove(unit, direction);
        return true;
    }

    public void moveToAmerica(Unit unit) {
        if (!this.requireOurTurn()) {
            return;
        }
        if (!(unit.getLocation() instanceof Europe)) {
            this.freeColClient.playSound("sound.event.illegalMove");
            return;
        }
        if (this.freeColClient.getClientOptions().getBoolean("model.option.autoloadEmigrants")) {
            int spaceLeft = unit.getSpaceLeft();
            for (Unit u : new ArrayList<Unit>(unit.getLocation().getUnitList())) {
                if (u.isNaval()) continue;
                if (u.getType().getSpaceTaken() > spaceLeft) break;
                this.boardShip(u, unit);
                spaceLeft -= u.getType().getSpaceTaken();
            }
        }
        if (this.askMoveToAmerica(unit)) {
            this.nextActiveUnit();
        }
    }

    private boolean askMoveToAmerica(Unit unit) {
        MoveToAmericaMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new MoveToAmericaMessage(unit)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    public void moveToEurope(Unit unit) {
        if (!this.requireOurTurn()) {
            return;
        }
        if (!unit.canMoveToEurope()) {
            this.freeColClient.playSound("sound.event.illegalMove");
            return;
        }
        if (this.askMoveToEurope(unit)) {
            this.nextActiveUnit();
        }
    }

    private boolean askMoveToEurope(Unit unit) {
        MoveToEuropeMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new MoveToEuropeMessage(unit)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    private void moveExplore(Unit unit, Map.Direction direction) {
        Canvas canvas = this.freeColClient.getCanvas();
        Tile tile = unit.getTile().getNeighbourOrNull(direction);
        if (canvas.showConfirmDialog(unit.getTile(), StringTemplate.key("exploreLostCityRumour.text"), "exploreLostCityRumour.yes", "exploreLostCityRumour.no")) {
            if (tile.getLostCityRumour().getType() == LostCityRumour.RumourType.MOUNDS && !canvas.showConfirmDialog(unit.getTile(), StringTemplate.key("exploreMoundsRumour.text"), "exploreLostCityRumour.yes", "exploreLostCityRumour.no")) {
                this.askDeclineMounds(unit, direction);
            }
            this.moveMove(unit, direction);
        }
    }

    private boolean askDeclineMounds(Unit unit, Map.Direction direction) {
        DeclineMoundsMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new DeclineMoundsMessage(unit, direction)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    private void moveAttack(Unit unit, Map.Direction direction) {
        Canvas canvas = this.freeColClient.getCanvas();
        this.clearGotoOrders(unit);
        Tile tile = unit.getTile();
        Tile target = tile.getNeighbourOrNull(direction);
        IndianSettlement is = target.getIndianSettlement();
        if (is != null && unit.isArmed()) {
            switch (canvas.showArmedUnitIndianSettlementDialog(is)) {
                case CANCEL: {
                    return;
                }
                case INDIAN_SETTLEMENT_ATTACK: {
                    break;
                }
                case INDIAN_SETTLEMENT_TRIBUTE: {
                    this.moveTribute(unit, direction);
                    return;
                }
                default: {
                    logger.warning("showArmedUnitIndianSettlementDialog failure.");
                    return;
                }
            }
        }
        if (this.confirmHostileAction(unit, target) && this.confirmPreCombat(unit, target)) {
            this.attack(unit, direction);
        }
    }

    private void moveTribute(Unit unit, Map.Direction direction) {
        if (this.askDemandTribute(unit, direction)) {
            this.freeColClient.getCanvas().updateGoldLabel();
            this.nextActiveUnit();
        }
    }

    private boolean askDemandTribute(Unit unit, Map.Direction direction) {
        DemandTributeMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new DemandTributeMessage(unit, direction)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    private boolean confirmHostileAction(Unit attacker, Tile target) {
        Player enemy;
        if (attacker.hasAbility("model.ability.piracy")) {
            return true;
        }
        if (target.getSettlement() != null) {
            enemy = target.getSettlement().getOwner();
        } else if (target == attacker.getTile()) {
            enemy = target.getOwner();
            if (enemy == null) {
                return true;
            }
        } else {
            Unit defender = target.getDefendingUnit(attacker);
            if (defender == null) {
                logger.warning("Attacking, but no defender - will try!");
                return true;
            }
            if (defender.hasAbility("model.ability.piracy")) {
                return true;
            }
            enemy = defender.getOwner();
        }
        Canvas canvas = this.freeColClient.getCanvas();
        String messageID = null;
        switch (attacker.getOwner().getStance(enemy)) {
            case WAR: {
                logger.finest("Player at war, no confirmation needed");
                return true;
            }
            case UNCONTACTED: 
            case PEACE: {
                messageID = "model.diplomacy.attack.peace";
                break;
            }
            case CEASE_FIRE: {
                messageID = "model.diplomacy.attack.ceaseFire";
                break;
            }
            case ALLIANCE: {
                messageID = "model.diplomacy.attack.alliance";
            }
        }
        return canvas.showConfirmDialog(attacker.getTile(), StringTemplate.template(messageID).addStringTemplate("%nation%", enemy.getNationName()), "model.diplomacy.attack.confirm", "cancel");
    }

    private boolean confirmPreCombat(Unit attacker, Tile tile) {
        if (this.freeColClient.getClientOptions().getBoolean("model.option.guiShowPreCombat")) {
            Settlement settlement = tile.getSettlement();
            Settlement defender = settlement != null ? settlement : tile.getDefendingUnit(attacker);
            Canvas canvas = this.freeColClient.getCanvas();
            return canvas.showPreCombatDialog(attacker, defender, tile);
        }
        return true;
    }

    private void attack(Unit unit, Map.Direction direction) {
        Canvas canvas = this.freeColClient.getCanvas();
        Unit defender = unit.getTile().getNeighbourOrNull(direction).getDefendingUnit(unit);
        String loot = this.askAttack(unit, direction);
        if ("true".equals(loot)) {
            this.nextModelMessage();
            List<Goods> goods = this.askLoot(unit, defender);
            if (goods != null) {
                goods = canvas.showCaptureGoodsDialog(unit, goods);
                this.askLoot(unit, defender, goods);
            }
        }
        canvas.refresh();
        this.nextActiveUnit();
    }

    private String askAttack(Unit unit, Map.Direction direction) {
        AttackMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new AttackMessage(unit, direction)).toXMLElement(), null);
        if (reply == null) {
            return null;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return reply.getAttribute("loot");
    }

    private List<Goods> askLoot(Unit winner, Unit loser) {
        LootCargoMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new LootCargoMessage(winner, loser.getId(), null)).toXMLElement(), "lootCargo");
        return reply == null ? null : new LootCargoMessage(this.freeColClient.getGame(), reply).getGoods();
    }

    private void askLoot(Unit winner, Unit loser, List<Goods> goods) {
        LootCargoMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new LootCargoMessage(winner, loser.getId(), goods)).toXMLElement(), null);
        if (reply == null) {
            return;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
    }

    private void moveEmbark(Unit unit, Map.Direction direction) {
        this.clearGotoOrders(unit);
        Canvas canvas = this.freeColClient.getCanvas();
        Tile sourceTile = unit.getTile();
        Tile destinationTile = sourceTile.getNeighbourOrNull(direction);
        Unit carrier = null;
        ArrayList choices = new ArrayList();
        for (Unit u : destinationTile.getUnitList()) {
            if (u.getSpaceLeft() < unit.getType().getSpaceTaken()) continue;
            String m = Messages.message(Messages.getLabel(u));
            choices.add(new ChoiceItem<Unit>(m, u));
            carrier = u;
        }
        if (choices.size() == 0) {
            throw new RuntimeException("Unit " + unit.getId() + " found no carrier to embark upon.");
        }
        if (choices.size() != 1 && (carrier = (Unit)canvas.showChoiceDialog(unit.getTile(), Messages.message("embark.text"), Messages.message("embark.cancel"), choices)) == null) {
            return;
        }
        if (this.askEmbark(unit, carrier, direction) && unit.getLocation() == carrier) {
            if (carrier.getMovesLeft() > 0) {
                this.freeColClient.getGUI().setActiveUnit(carrier);
            } else {
                this.nextActiveUnit();
            }
        }
        this.clearGotoOrders(unit);
    }

    private boolean moveDisembark(Unit unit, Map.Direction direction) {
        Tile tile = unit.getTile().getNeighbourOrNull(direction);
        if (tile.getFirstUnit() != null && tile.getFirstUnit().getOwner() != unit.getOwner()) {
            return false;
        }
        ArrayList<Unit> disembarkable = new ArrayList<Unit>();
        unit.setStateToAllChildren(Unit.UnitState.ACTIVE);
        for (Unit u : unit.getUnitList()) {
            if (!u.getMoveType(tile).isProgress()) continue;
            disembarkable.add(u);
        }
        if (disembarkable.size() == 0) {
            return false;
        }
        Canvas canvas = this.freeColClient.getCanvas();
        while (disembarkable.size() > 0) {
            Unit u;
            if (disembarkable.size() == 1) {
                if (!canvas.showConfirmDialog("disembark.text", "yes", "no")) break;
                this.move((Unit)disembarkable.get(0), direction);
                break;
            }
            ArrayList choices = new ArrayList();
            for (Unit dUnit : disembarkable) {
                choices.add(new ChoiceItem<Unit>(Messages.message(Messages.getLabel(dUnit)), dUnit));
            }
            if (disembarkable.size() > 1) {
                choices.add(new ChoiceItem<Unit>(Messages.message("all"), unit));
            }
            if ((u = (Unit)canvas.showChoiceDialog(unit.getTile(), Messages.message("disembark.text"), Messages.message("disembark.cancel"), choices)) == null) break;
            if (u == unit) {
                for (Unit dUnit : disembarkable) {
                    this.move(dUnit, direction);
                }
                disembarkable.clear();
                continue;
            }
            this.move(u, direction);
            disembarkable.remove(u);
        }
        return true;
    }

    private void moveLearnSkill(Unit unit, Map.Direction direction) {
        this.clearGotoOrders(unit);
        if (!this.askSkill(unit, direction)) {
            return;
        }
        Canvas canvas = this.freeColClient.getCanvas();
        IndianSettlement settlement = (IndianSettlement)this.getSettlementAt(unit.getTile(), direction);
        UnitType skill = settlement.getLearnableSkill();
        if (skill == null) {
            canvas.showInformationMessage((FreeColObject)settlement, "indianSettlement.noMoreSkill");
        } else if (!unit.getType().canBeUpgraded(skill, UnitTypeChange.ChangeType.NATIVES)) {
            canvas.showInformationMessage((FreeColObject)settlement, StringTemplate.template("indianSettlement.cantLearnSkill").addStringTemplate("%unit%", Messages.getLabel(unit)).add("%skill%", skill.getNameKey()));
        } else if (canvas.showConfirmDialog(unit.getTile(), StringTemplate.template("learnSkill.text").add("%skill%", skill.getNameKey()), "learnSkill.yes", "learnSkill.no") && this.askLearnSkill(unit, direction)) {
            if (unit.isDisposed()) {
                canvas.showInformationMessage((FreeColObject)settlement, "learnSkill.die");
                this.nextActiveUnit(unit.getTile());
                return;
            }
            if (unit.getType() != skill) {
                canvas.showInformationMessage((FreeColObject)settlement, "learnSkill.leave");
            }
        }
        this.nextActiveUnit();
    }

    private boolean askSkill(Unit unit, Map.Direction direction) {
        AskSkillMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new AskSkillMessage(unit, direction)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    private boolean askLearnSkill(Unit unit, Map.Direction direction) {
        LearnSkillMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new LearnSkillMessage(unit, direction)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    private void moveScoutIndianSettlement(Unit unit, Map.Direction direction) {
        Canvas canvas = this.freeColClient.getCanvas();
        Tile unitTile = unit.getTile();
        Tile tile = unitTile.getNeighbourOrNull(direction);
        IndianSettlement settlement = tile.getIndianSettlement();
        this.clearGotoOrders(unit);
        NationSummary ns = this.getNationSummary(settlement.getOwner());
        String number = ns == null ? "1" : ns.getNumberOfSettlements();
        switch (canvas.showScoutIndianSettlementDialog(settlement, number)) {
            case CANCEL: {
                return;
            }
            case INDIAN_SETTLEMENT_ATTACK: {
                if (this.confirmPreCombat(unit, tile)) {
                    this.attack(unit, direction);
                }
                return;
            }
            case INDIAN_SETTLEMENT_SPEAK: {
                Player player = unit.getOwner();
                int oldGold = player.getGold();
                String result = this.askScoutSpeak(unit, direction);
                if (result == null) {
                    logger.warning("Null result from askScoutSpeak");
                } else {
                    if ("die".equals(result)) {
                        canvas.showInformationMessage((FreeColObject)settlement, "scoutSettlement.speakDie");
                        this.nextActiveUnit(unitTile);
                        return;
                    }
                    if ("expert".equals(result)) {
                        canvas.showInformationMessage((FreeColObject)settlement, StringTemplate.template("scoutSettlement.expertScout").add("%unit%", unit.getType().getNameKey()));
                    } else if ("tales".equals(result)) {
                        canvas.showInformationMessage((FreeColObject)settlement, "scoutSettlement.speakTales");
                    } else if ("beads".equals(result)) {
                        canvas.updateGoldLabel();
                        canvas.showInformationMessage((FreeColObject)settlement, StringTemplate.template("scoutSettlement.speakBeads").addAmount("%amount%", player.getGold() - oldGold));
                    } else if ("nothing".equals(result)) {
                        canvas.showInformationMessage((FreeColObject)settlement, "scoutSettlement.speakNothing");
                    } else {
                        logger.warning("Invalid result from askScoutSpeak: " + result);
                    }
                }
                this.nextActiveUnit();
                break;
            }
            case INDIAN_SETTLEMENT_TRIBUTE: {
                this.moveTribute(unit, direction);
                break;
            }
            default: {
                throw new IllegalArgumentException("showScoutIndianSettlementDialog fail");
            }
        }
    }

    private String askScoutSpeak(Unit unit, Map.Direction direction) {
        ScoutIndianSettlementMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new ScoutIndianSettlementMessage(unit, direction)).toXMLElement(), null);
        if (reply == null) {
            return null;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return reply.getAttribute("result");
    }

    private void moveUseMissionary(Unit unit, Map.Direction direction) {
        Canvas canvas = this.freeColClient.getCanvas();
        IndianSettlement settlement = (IndianSettlement)this.getSettlementAt(unit.getTile(), direction);
        Unit missionary = settlement.getMissionary();
        boolean canEstablish = missionary == null;
        boolean canDenounce = missionary != null && missionary.getOwner() != unit.getOwner();
        this.clearGotoOrders(unit);
        switch (canvas.showUseMissionaryDialog(unit, settlement, canEstablish, canDenounce)) {
            case CANCEL: {
                return;
            }
            case ESTABLISH_MISSION: {
                if (!this.askMissionary(unit, direction, false)) break;
                if (settlement.getMissionary() == unit) {
                    this.freeColClient.playSound("sound.event.missionEstablished");
                }
                this.nextActiveUnit();
                break;
            }
            case DENOUNCE_HERESY: {
                if (!this.askMissionary(unit, direction, true)) break;
                if (settlement.getMissionary() == unit) {
                    this.freeColClient.playSound("sound.event.missionEstablished");
                }
                this.nextModelMessage();
                this.nextActiveUnit();
                break;
            }
            case INCITE_INDIANS: {
                ArrayList<Player> enemies = new ArrayList<Player>(this.freeColClient.getGame().getLiveEuropeanPlayers());
                Player player = this.freeColClient.getMyPlayer();
                enemies.remove(player);
                Player enemy = canvas.showSimpleChoiceDialog(unit.getTile(), "missionarySettlement.inciteQuestion", "missionarySettlement.cancel", enemies);
                if (enemy == null) {
                    return;
                }
                int gold = this.askIncite(unit, direction, enemy, -1);
                if (gold < 0) break;
                if (!player.checkGold(gold)) {
                    canvas.showInformationMessage((FreeColObject)settlement, StringTemplate.template("missionarySettlement.inciteGoldFail").add("%player%", enemy.getName()).addAmount("%amount%", gold));
                    break;
                }
                if (canvas.showConfirmDialog(unit.getTile(), StringTemplate.template("missionarySettlement.inciteConfirm").add("%player%", enemy.getName()).addAmount("%amount%", gold), "yes", "no") && this.askIncite(unit, direction, enemy, gold) > 0) {
                    canvas.updateGoldLabel();
                }
                this.nextActiveUnit();
                break;
            }
            default: {
                logger.warning("showUseMissionaryDialog fail");
            }
        }
    }

    private boolean askMissionary(Unit unit, Map.Direction direction, boolean denounce) {
        MissionaryMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new MissionaryMessage(unit, direction, denounce)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    private int askIncite(Unit unit, Map.Direction direction, Player enemy, int gold) {
        InciteMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new InciteMessage(unit, direction, enemy, gold)).toXMLElement(), null);
        if (reply == null || reply.getAttribute("gold") == null) {
            return -1;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        try {
            return Integer.parseInt(reply.getAttribute("gold"));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private void moveScoutColony(Unit unit, Map.Direction direction) {
        Canvas canvas = this.freeColClient.getCanvas();
        Colony colony = (Colony)this.getSettlementAt(unit.getTile(), direction);
        boolean canNeg = colony.getOwner() != unit.getOwner().getREFPlayer();
        this.clearGotoOrders(unit);
        switch (canvas.showScoutForeignColonyDialog(colony, unit, canNeg)) {
            case CANCEL: {
                break;
            }
            case FOREIGN_COLONY_ATTACK: {
                this.moveAttack(unit, direction);
                break;
            }
            case FOREIGN_COLONY_NEGOTIATE: {
                this.moveTradeColony(unit, direction);
                break;
            }
            case FOREIGN_COLONY_SPY: {
                this.moveSpy(unit, direction);
                break;
            }
            default: {
                throw new IllegalArgumentException("showScoutForeignColonyDialog fail");
            }
        }
    }

    private void moveTradeColony(Unit unit, Map.Direction direction) {
        Settlement settlement = this.getSettlementAt(unit.getTile(), direction);
        if (settlement == null) {
            return;
        }
        if (settlement.getOwner() == unit.getOwner().getREFPlayer()) {
            throw new IllegalStateException("Unit tried to negotiate with REF");
        }
        String nation = Messages.message(settlement.getOwner().getNationName());
        Player player = this.freeColClient.getMyPlayer();
        Client client = this.freeColClient.getClient();
        Canvas canvas = this.freeColClient.getCanvas();
        DiplomaticTrade ourAgreement = null;
        DiplomaticTrade theirAgreement = null;
        Boolean done = false;
        block5: while (!done.booleanValue()) {
            ourAgreement = canvas.showNegotiationDialog(unit, settlement, theirAgreement);
            if (ourAgreement == null) {
                if (theirAgreement == null) break;
                theirAgreement.setStatus(DiplomaticTrade.TradeStatus.REJECT_TRADE);
                client.sendAndWait(new DiplomacyMessage(unit, settlement, theirAgreement).toXMLElement());
                break;
            }
            theirAgreement = this.askDiplomacy(unit, settlement, ourAgreement);
            DiplomaticTrade.TradeStatus status = theirAgreement == null ? DiplomaticTrade.TradeStatus.REJECT_TRADE : theirAgreement.getStatus();
            switch (status) {
                case ACCEPT_TRADE: {
                    canvas.showInformationMessage((FreeColObject)settlement, StringTemplate.template("negotiationDialog.offerAccepted").addName("%nation%", nation));
                    player.invalidateCanSeeTiles();
                    done = true;
                    continue block5;
                }
                case REJECT_TRADE: {
                    canvas.showInformationMessage((FreeColObject)settlement, StringTemplate.template("negotiationDialog.offerRejected").add("%nation%", nation));
                    done = true;
                    continue block5;
                }
                case PROPOSE_TRADE: {
                    continue block5;
                }
            }
            logger.warning("Bogus trade status");
            done = true;
        }
        this.nextActiveUnit();
    }

    private DiplomaticTrade askDiplomacy(Unit unit, Settlement settlement, DiplomaticTrade agreement) {
        Element diplomacy;
        Client client = this.freeColClient.getClient();
        Game game = this.freeColClient.getGame();
        DiplomacyMessage message = new DiplomacyMessage(unit, settlement, agreement);
        Element reply = this.askExpecting(client, message.toXMLElement(), null);
        if (reply == null) {
            return null;
        }
        if (reply.getTagName().equals("diplomacy")) {
            diplomacy = reply;
            reply = null;
        } else {
            diplomacy = Message.getChildElement(reply, "diplomacy");
            if (diplomacy != null) {
                reply.removeChild(diplomacy);
            }
        }
        if (reply != null) {
            Connection conn = client.getConnection();
            this.freeColClient.getInGameInputHandler().handle(conn, reply);
        }
        return diplomacy == null ? null : new DiplomacyMessage(game, diplomacy).getAgreement();
    }

    private void moveSpy(Unit unit, Map.Direction direction) {
        if (this.askSpy(unit, direction)) {
            this.nextActiveUnit();
        }
    }

    private boolean askSpy(Unit unit, Map.Direction direction) {
        SpySettlementMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new SpySettlementMessage(unit, direction)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    private void moveTrade(Unit unit, Map.Direction direction) {
        this.clearGotoOrders(unit);
        Settlement settlement = this.getSettlementAt(unit.getTile(), direction);
        if (settlement instanceof Colony) {
            this.moveTradeColony(unit, direction);
        } else if (settlement instanceof IndianSettlement) {
            this.moveTradeIndianSettlement(unit, direction);
        } else {
            logger.warning("Bogus settlement: " + settlement.getId());
        }
    }

    private void moveTradeIndianSettlement(Unit unit, Map.Direction direction) {
        Map<String, Boolean> session;
        Canvas canvas = this.freeColClient.getCanvas();
        Settlement settlement = this.getSettlementAt(unit.getTile(), direction);
        boolean done = false;
        block6: while (!done && (session = this.askOpenTransactionSession(unit, settlement)) != null) {
            boolean gif;
            boolean buy = session.get("canBuy") != false && unit.getSpaceLeft() > 0;
            boolean sel = session.get("canSell") != false && unit.getGoodsCount() > 0;
            boolean bl = gif = session.get("canGift") != false && unit.getGoodsCount() > 0;
            if (!buy && !sel && !gif) break;
            switch (canvas.showIndianSettlementTradeDialog(settlement, buy, sel, gif)) {
                case CANCEL: {
                    done = true;
                    continue block6;
                }
                case BUY: {
                    this.attemptBuyFromSettlement(unit, settlement);
                    continue block6;
                }
                case SELL: {
                    this.attemptSellToSettlement(unit, settlement);
                    continue block6;
                }
                case GIFT: {
                    this.attemptGiftToSettlement(unit, settlement);
                    continue block6;
                }
            }
            throw new IllegalArgumentException("showIndianSettlementTradeDialog fail");
        }
        this.askCloseTransactionSession(unit, settlement);
        if (unit.getMovesLeft() > 0) {
            this.freeColClient.getGUI().setActiveUnit(unit);
        } else {
            this.nextActiveUnit();
        }
    }

    private Map<String, Boolean> askOpenTransactionSession(Unit unit, Settlement settlement) {
        GetTransactionMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new GetTransactionMessage(unit, settlement)).toXMLElement(), null);
        if (reply == null) {
            return null;
        }
        HashMap<String, Boolean> session = new HashMap<String, Boolean>();
        session.put("canBuy", Boolean.parseBoolean(reply.getAttribute("canBuy")));
        session.put("canSell", Boolean.parseBoolean(reply.getAttribute("canSell")));
        session.put("canGift", Boolean.parseBoolean(reply.getAttribute("canGift")));
        return session;
    }

    private boolean askCloseTransactionSession(Unit unit, Settlement settlement) {
        CloseTransactionMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new CloseTransactionMessage(unit, settlement)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    private void attemptBuyFromSettlement(Unit unit, Settlement settlement) {
        List<Goods> forSale = this.askGoodsForSaleInSettlement(unit, settlement);
        Canvas canvas = this.freeColClient.getCanvas();
        Player player = this.freeColClient.getMyPlayer();
        Goods goods = null;
        if (forSale.isEmpty()) {
            canvas.showInformationMessage((FreeColObject)settlement, "trade.nothingToSell");
            return;
        }
        goods = canvas.showSimpleChoiceDialog(unit.getTile(), "buyProposition.text", "buyProposition.nothing", forSale);
        if (goods != null) {
            int gold = -1;
            block5: while (true) {
                if ((gold = this.askBuyPriceFromSettlement(unit, settlement, goods, gold)) == -1) {
                    canvas.showInformationMessage((FreeColObject)settlement, "trade.noTrade");
                    return;
                }
                if (gold < -1) {
                    return;
                }
                boolean canBuy = player.checkGold(gold);
                switch (canvas.showBuyDialog(unit, settlement, goods, gold, canBuy)) {
                    case CANCEL: {
                        return;
                    }
                    case BUY: {
                        if (this.askBuyFromSettlement(unit, settlement, goods, gold)) {
                            canvas.updateGoldLabel();
                        }
                        return;
                    }
                    case HAGGLE: {
                        gold = gold * 9 / 10;
                        continue block5;
                    }
                }
                break;
            }
            throw new IllegalStateException("showBuyDialog fail");
        }
    }

    private List<Goods> askGoodsForSaleInSettlement(Unit unit, Settlement settlement) {
        GoodsForSaleMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new GoodsForSaleMessage(unit, settlement, null)).toXMLElement(), GoodsForSaleMessage.getXMLElementTagName());
        if (reply == null) {
            return null;
        }
        Game game = this.freeColClient.getGame();
        ArrayList<Goods> goodsOffered = new ArrayList<Goods>();
        NodeList childNodes = reply.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            goodsOffered.add(new Goods(game, (Element)childNodes.item(i)));
        }
        return goodsOffered;
    }

    private int askBuyPriceFromSettlement(Unit unit, Settlement settlement, Goods goods, int gold) {
        BuyPropositionMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new BuyPropositionMessage(unit, settlement, goods, gold)).toXMLElement(), null);
        if (reply == null) {
            return -2;
        }
        try {
            return Integer.parseInt(reply.getAttribute("gold"));
        }
        catch (NumberFormatException e) {
            return -2;
        }
    }

    private boolean askBuyFromSettlement(Unit unit, Settlement settlement, Goods goods, int gold) {
        BuyMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new BuyMessage(unit, settlement, goods, gold)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    private void attemptSellToSettlement(Unit unit, Settlement settlement) {
        Canvas canvas = this.freeColClient.getCanvas();
        Goods goods = null;
        goods = canvas.showSimpleChoiceDialog(unit.getTile(), "sellProposition.text", "sellProposition.nothing", unit.getGoodsList());
        if (goods != null) {
            int gold = -1;
            block6: while (true) {
                if ((gold = this.askSellPriceToSettlement(unit, settlement, goods, gold)) == 0) {
                    canvas.showInformationMessage((FreeColObject)settlement, StringTemplate.template("trade.noNeedForTheGoods").add("%goods%", goods.getNameKey()));
                    return;
                }
                if (gold == -1) {
                    canvas.showInformationMessage((FreeColObject)settlement, "trade.noTrade");
                    return;
                }
                if (gold < -1) {
                    return;
                }
                switch (canvas.showSellDialog(unit, settlement, goods, gold)) {
                    case CANCEL: {
                        return;
                    }
                    case SELL: {
                        if (this.askSellToSettlement(unit, settlement, goods, gold)) {
                            canvas.updateGoldLabel();
                        }
                        return;
                    }
                    case HAGGLE: {
                        gold = gold * 11 / 10;
                        continue block6;
                    }
                    case GIFT: {
                        this.askDeliverGiftToSettlement(unit, settlement, goods);
                        return;
                    }
                }
                break;
            }
            throw new IllegalStateException("showSellDialog fail");
        }
    }

    private int askSellPriceToSettlement(Unit unit, Settlement settlement, Goods goods, int gold) {
        SellPropositionMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new SellPropositionMessage(unit, settlement, goods, gold)).toXMLElement(), null);
        if (reply == null) {
            return -2;
        }
        try {
            return Integer.parseInt(reply.getAttribute("gold"));
        }
        catch (NumberFormatException e) {
            return -2;
        }
    }

    private boolean askSellToSettlement(Unit unit, Settlement settlement, Goods goods, int gold) {
        SellMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new SellMessage(unit, settlement, goods, gold)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    private void attemptGiftToSettlement(Unit unit, Settlement settlement) {
        Canvas canvas = this.freeColClient.getCanvas();
        Goods goods = canvas.showSimpleChoiceDialog(unit.getTile(), "gift.text", "cancel", unit.getGoodsList());
        if (goods != null) {
            this.askDeliverGiftToSettlement(unit, settlement, goods);
        }
    }

    private boolean askDeliverGiftToSettlement(Unit unit, Settlement settlement, Goods goods) {
        DeliverGiftMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new DeliverGiftMessage(unit, settlement, goods)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    public boolean claimLand(Tile tile, Colony colony, int offer) {
        if (!this.requireOurTurn()) {
            return false;
        }
        Player player = this.freeColClient.getMyPlayer();
        int price = (colony != null ? player.canClaimForSettlement(tile) : player.canClaimForImprovement(tile)) ? 0 : player.getLandPrice(tile);
        return this.claimTile(player, tile, colony, price, offer);
    }

    private boolean claimTile(Player player, Tile tile, Colony colony, int price, int offer) {
        Canvas canvas = this.freeColClient.getCanvas();
        Player owner = tile.getOwner();
        if (price < 0) {
            return false;
        }
        if (price > 0) {
            if (offer >= price) {
                price = offer;
            } else if (offer < 0) {
                price = -1;
            } else {
                boolean canAccept = player.checkGold(price);
                switch (canvas.showClaimDialog(tile, player, price, owner, canAccept)) {
                    case CANCEL: {
                        return false;
                    }
                    case ACCEPT: {
                        break;
                    }
                    case STEAL: {
                        price = -1;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("showClaimDialog fail");
                    }
                }
            }
        }
        if (this.askClaimLand(tile, colony, price) && tile.getOwner() == player) {
            canvas.updateGoldLabel();
            return true;
        }
        return false;
    }

    private boolean askClaimLand(Tile tile, Colony colony, int price) {
        ClaimLandMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new ClaimLandMessage(tile, colony, price)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    public boolean checkCashInTreasureTrain(Unit unit) {
        boolean cash;
        if (!(unit.canCarryTreasure() && unit.canCashInTreasureTrain() && this.requireOurTurn())) {
            return false;
        }
        Canvas canvas = this.freeColClient.getCanvas();
        Tile tile = unit.getTile();
        Europe europe = unit.getOwner().getEurope();
        if (europe == null || unit.getLocation() == europe) {
            cash = true;
        } else {
            int fee = this.getSpecification().getInteger("model.option.treasureTransportFee");
            StringTemplate template = fee == 0 ? StringTemplate.template("cashInTreasureTrain.free") : StringTemplate.template("cashInTreasureTrain.pay").addName("%fee%", Integer.toString(fee));
            cash = canvas.showConfirmDialog(unit.getTile(), template, "cashInTreasureTrain.yes", "cashInTreasureTrain.no");
        }
        UnitWas unitWas = new UnitWas(unit);
        if (cash && this.askCashInTreasureTrain(unit) && unit.isDisposed()) {
            this.freeColClient.playSound("sound.event.cashInTreasureTrain");
            unitWas.fireChanges();
            canvas.updateGoldLabel();
            this.nextActiveUnit(tile);
            return true;
        }
        return false;
    }

    private boolean askCashInTreasureTrain(Unit unit) {
        CashInTreasureTrainMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new CashInTreasureTrainMessage(unit)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    public boolean boardShip(Unit unit, Unit carrier) {
        if (!this.requireOurTurn()) {
            return false;
        }
        if (unit == null) {
            logger.warning("unit == null");
            return false;
        }
        if (carrier == null) {
            logger.warning("Trying to load onto a non-existent carrier.");
            return false;
        }
        if (unit.isNaval()) {
            logger.warning("Trying to load a ship onto another carrier.");
            return false;
        }
        if (unit.isInEurope() != carrier.isInEurope() || unit.getTile() != carrier.getTile()) {
            logger.warning("Unit and carrier are not co-located.");
            return false;
        }
        UnitWas unitWas = new UnitWas(unit);
        if (this.askEmbark(unit, carrier, null) && unit.getLocation() == carrier) {
            this.freeColClient.playSound("sound.event.loadCargo");
            unitWas.fireChanges();
            this.nextActiveUnit();
            return true;
        }
        return false;
    }

    private boolean askEmbark(Unit unit, Unit carrier, Map.Direction direction) {
        EmbarkMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new EmbarkMessage(unit, carrier, direction)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    public boolean leaveShip(Unit unit) {
        if (!this.requireOurTurn()) {
            return false;
        }
        if (!(unit.getLocation() instanceof Unit)) {
            logger.warning("Unit " + unit.getId() + " is not on a carrier.");
            return false;
        }
        Unit carrier = (Unit)unit.getLocation();
        UnitWas unitWas = new UnitWas(unit);
        if (this.askDisembark(unit) && unit.getLocation() != carrier) {
            this.checkCashInTreasureTrain(unit);
            unitWas.fireChanges();
            this.nextActiveUnit();
            return true;
        }
        return false;
    }

    private boolean askDisembark(Unit unit) {
        DisembarkMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new DisembarkMessage(unit)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    public void loadCargo(Goods goods, Unit carrier) {
        if (!this.requireOurTurn()) {
            return;
        }
        if (goods == null) {
            throw new IllegalArgumentException("Null goods.");
        }
        if (goods.getAmount() <= 0) {
            throw new IllegalArgumentException("Empty goods.");
        }
        if (carrier == null) {
            throw new IllegalArgumentException("Null carrier.");
        }
        if (!carrier.isInEurope() && carrier.getColony() == null) {
            throw new IllegalArgumentException("Carrier not at colony or Europe.");
        }
        if (this.loadGoods(goods, carrier)) {
            this.freeColClient.playSound("sound.event.loadCargo");
        }
    }

    public void unloadCargo(Goods goods, boolean dump) {
        if (!this.requireOurTurn()) {
            return;
        }
        if (goods == null) {
            throw new IllegalArgumentException("Null goods.");
        }
        if (goods.getAmount() <= 0) {
            throw new IllegalArgumentException("Empty goods.");
        }
        Unit carrier = null;
        if (!(goods.getLocation() instanceof Unit)) {
            throw new IllegalArgumentException("Unload from non-unit.");
        }
        carrier = (Unit)goods.getLocation();
        Colony colony = null;
        if (!carrier.isInEurope()) {
            if (carrier.getTile() == null) {
                throw new IllegalArgumentException("Carrier with null location.");
            }
            colony = carrier.getColony();
            if (!dump && colony == null) {
                throw new IllegalArgumentException("Unload is really a dump.");
            }
        }
        this.unloadGoods(goods, carrier, colony);
    }

    public void unload(Unit unit) {
        block9: {
            List<Goods> goodsList;
            boolean inEurope;
            Player player;
            block8: {
                if (!this.requireOurTurn()) {
                    return;
                }
                if (unit == null) {
                    throw new IllegalArgumentException("Null unit.");
                }
                if (!unit.isCarrier()) {
                    throw new IllegalArgumentException("Unit is not a carrier.");
                }
                player = this.freeColClient.getMyPlayer();
                inEurope = unit.isInEurope();
                if (unit.getColony() == null) break block8;
                for (Unit u : new ArrayList<Unit>(unit.getUnitList())) {
                    this.leaveShip(u);
                }
                for (Goods goods : new ArrayList<Goods>(unit.getGoodsList())) {
                    this.unloadCargo(goods, false);
                }
                break block9;
            }
            if (inEurope) {
                for (Goods goods : new ArrayList<Goods>(unit.getGoodsList())) {
                    if (!player.canTrade(goods)) continue;
                    this.unloadCargo(goods, false);
                }
            }
            if (unit.getGoodsCount() <= 0 || (goodsList = this.freeColClient.getCanvas().showDumpCargoDialog(unit)) == null) break block9;
            for (Goods goods : goodsList) {
                this.unloadCargo(goods, true);
            }
        }
    }

    public boolean buyGoods(GoodsType type, int amount, Unit carrier) {
        Market market;
        if (!this.requireOurTurn()) {
            return false;
        }
        Canvas canvas = this.freeColClient.getCanvas();
        Player player = this.freeColClient.getMyPlayer();
        if (type == null) {
            throw new NullPointerException("Goods type must not be null.");
        }
        if (carrier == null) {
            throw new NullPointerException("Carrier must not be null.");
        }
        if (carrier.getOwner() != player) {
            throw new IllegalArgumentException("Carrier owned by someone else.");
        }
        if (amount <= 0) {
            throw new IllegalArgumentException("Amount must be positive.");
        }
        if (!player.canTrade(type)) {
            throw new IllegalArgumentException("Goods are boycotted.");
        }
        int toBuy = 100;
        if (carrier.getSpaceLeft() <= 0) {
            int partial = carrier.getGoodsContainer().getGoodsCount(type) % 100;
            if (partial == 0) {
                return false;
            }
            toBuy -= partial;
        }
        if (amount < toBuy) {
            toBuy = amount;
        }
        if (!player.checkGold((market = player.getMarket()).getBidPrice(type, toBuy))) {
            canvas.errorMessage("notEnoughGold");
            return false;
        }
        int oldAmount = carrier.getGoodsContainer().getGoodsCount(type);
        int price = market.getCostToBuy(type);
        UnitWas unitWas = new UnitWas(carrier);
        if (this.askBuyGoods(carrier, type, toBuy) && carrier.getGoodsContainer().getGoodsCount(type) != oldAmount) {
            this.freeColClient.playSound("sound.event.loadCargo");
            unitWas.fireChanges();
            for (TransactionListener listener : market.getTransactionListener()) {
                listener.logPurchase(type, toBuy, price);
            }
            canvas.updateGoldLabel();
            return true;
        }
        return false;
    }

    private boolean askBuyGoods(Unit carrier, GoodsType type, int amount) {
        BuyGoodsMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new BuyGoodsMessage(carrier, type, amount)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    public boolean sellGoods(Goods goods) {
        if (!this.requireOurTurn()) {
            return false;
        }
        Player player = this.freeColClient.getMyPlayer();
        if (goods == null) {
            throw new NullPointerException("Goods must not be null.");
        }
        Unit carrier = null;
        if (goods.getLocation() instanceof Unit) {
            carrier = (Unit)goods.getLocation();
        }
        if (carrier == null) {
            throw new IllegalStateException("Goods not on carrier.");
        }
        if (!carrier.isInEurope()) {
            throw new IllegalStateException("Goods not on carrier in Europe.");
        }
        if (!player.canTrade(goods)) {
            throw new IllegalStateException("Goods are boycotted.");
        }
        Market market = player.getMarket();
        GoodsType type = goods.getType();
        int amount = goods.getAmount();
        int price = market.getPaidForSale(type);
        int tax = player.getTax();
        int oldAmount = carrier.getGoodsContainer().getGoodsCount(type);
        UnitWas unitWas = new UnitWas(carrier);
        if (this.askSellGoods(goods, carrier) && carrier.getGoodsContainer().getGoodsCount(type) != oldAmount) {
            this.freeColClient.playSound("sound.event.sellCargo");
            unitWas.fireChanges();
            for (TransactionListener listener : market.getTransactionListener()) {
                listener.logSale(type, amount, price, tax);
            }
            this.freeColClient.getCanvas().updateGoldLabel();
            return true;
        }
        return false;
    }

    private boolean askSellGoods(Goods goods, Unit carrier) {
        SellGoodsMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new SellGoodsMessage(goods, carrier)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    public void clearSpeciality(Unit unit) {
        Tile tile;
        if (!this.requireOurTurn()) {
            return;
        }
        Canvas canvas = this.freeColClient.getCanvas();
        UnitType oldType = unit.getType();
        UnitType newType = oldType.getTargetType(UnitTypeChange.ChangeType.CLEAR_SKILL, unit.getOwner());
        if (newType == null) {
            canvas.showInformationMessage((FreeColObject)unit, StringTemplate.template("clearSpeciality.impossible").addStringTemplate("%unit%", Messages.getLabel(unit)));
            return;
        }
        Tile tile2 = tile = canvas.isShowingSubPanel() ? null : unit.getTile();
        if (!canvas.showConfirmDialog(tile, StringTemplate.template("clearSpeciality.areYouSure").addStringTemplate("%oldUnit%", Messages.getLabel(unit)).add("%unit%", newType.getNameKey()), "yes", "no")) {
            return;
        }
        if (!this.askClearSpeciality(unit) || unit.getType() == newType) {
            // empty if block
        }
        this.nextActiveUnit();
    }

    private boolean askClearSpeciality(Unit unit) {
        ClearSpecialityMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new ClearSpecialityMessage(unit)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    public void disbandActiveUnit() {
        Tile tile;
        if (!this.requireOurTurn()) {
            return;
        }
        GUI gui = this.freeColClient.getGUI();
        Unit unit = gui.getActiveUnit();
        if (unit == null) {
            return;
        }
        Canvas canvas = this.freeColClient.getCanvas();
        Tile tile2 = tile = canvas.isShowingSubPanel() ? null : unit.getTile();
        if (!canvas.showConfirmDialog(tile, StringTemplate.key("disbandUnit.text"), "disbandUnit.yes", "disbandUnit.no")) {
            return;
        }
        if (this.askDisbandUnit(unit)) {
            this.nextActiveUnit();
        }
    }

    private boolean askDisbandUnit(Unit unit) {
        DisbandUnitMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new DisbandUnitMessage(unit)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    public void setGoodsLevels(Colony colony, GoodsType goodsType) {
        this.askSetGoodsLevels(colony, colony.getExportData(goodsType));
    }

    private boolean askSetGoodsLevels(Colony colony, ExportData data) {
        SetGoodsLevelsMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new SetGoodsLevelsMessage(colony, data)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    public void equipUnit(Unit unit, EquipmentType type, int amount) {
        int newAmount;
        if (!this.requireOurTurn() || amount == 0) {
            return;
        }
        Player player = this.freeColClient.getMyPlayer();
        List<AbstractGoods> requiredGoods = type.getGoodsRequired();
        Colony colony = null;
        if (unit.isInEurope()) {
            for (AbstractGoods goods : requiredGoods) {
                GoodsType goodsType = goods.getType();
                if (player.canTrade(goodsType) || this.payArrears(goodsType)) continue;
                return;
            }
        } else {
            colony = unit.getColony();
            if (colony == null) {
                throw new IllegalStateException("Equip unit not in settlement/Europe");
            }
        }
        int oldAmount = unit.getEquipmentCount(type);
        ColonyWas colonyWas = colony == null ? null : new ColonyWas(colony);
        UnitWas unitWas = new UnitWas(unit);
        if (this.askEquipUnit(unit, type, amount) && (newAmount = unit.getEquipmentCount(type)) != oldAmount) {
            unit.firePropertyChange("EQUIPMENT_CHANGE", oldAmount, newAmount);
            if (colonyWas != null) {
                colonyWas.fireChanges();
            }
            unitWas.fireChanges();
            this.freeColClient.getCanvas().updateGoldLabel();
        }
    }

    private boolean askEquipUnit(Unit unit, EquipmentType type, int amount) {
        EquipUnitMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new EquipUnitMessage(unit, type, amount)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    public void work(Unit unit, WorkLocation workLocation) {
        if (!this.requireOurTurn()) {
            return;
        }
        Colony colony = workLocation.getColony();
        if (workLocation instanceof ColonyTile) {
            Tile tile = ((ColonyTile)workLocation).getWorkTile();
            if (tile.hasLostCityRumour()) {
                this.freeColClient.getCanvas().showInformationMessage("tileHasRumour");
                return;
            }
            if (tile.getOwner() != unit.getOwner() && !this.claimLand(tile, colony, 0)) {
                return;
            }
        }
        ColonyWas colonyWas = new ColonyWas(colony);
        UnitWas unitWas = new UnitWas(unit);
        if (this.askWork(unit, workLocation) && unit.getLocation() == workLocation) {
            colonyWas.fireChanges();
            unitWas.fireChanges();
        }
    }

    private boolean askWork(Unit unit, WorkLocation workLocation) {
        WorkMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new WorkMessage(unit, workLocation)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    public boolean putOutsideColony(Unit unit) {
        if (!this.requireOurTurn()) {
            return false;
        }
        Colony colony = unit.getColony();
        if (colony == null) {
            throw new IllegalStateException("Unit is not in colony.");
        }
        if (!colony.canReducePopulation()) {
            return false;
        }
        ColonyWas colonyWas = new ColonyWas(colony);
        UnitWas unitWas = new UnitWas(unit);
        if (this.askPutOutsideColony(unit)) {
            colonyWas.fireChanges();
            unitWas.fireChanges();
            return true;
        }
        return false;
    }

    private boolean askPutOutsideColony(Unit unit) {
        PutOutsideColonyMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new PutOutsideColonyMessage(unit)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    public void changeWorkType(Unit unit, GoodsType workType) {
        if (!this.requireOurTurn()) {
            return;
        }
        UnitWas unitWas = new UnitWas(unit);
        if (this.askChangeWorkType(unit, workType)) {
            unitWas.fireChanges();
        }
    }

    private boolean askChangeWorkType(Unit unit, GoodsType workType) {
        ChangeWorkTypeMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new ChangeWorkTypeMessage(unit, workType)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    public void changeWorkImprovementType(Unit unit, TileImprovementType improvementType) {
        Tile tile;
        if (!this.requireOurTurn()) {
            return;
        }
        if (!unit.checkSetState(Unit.UnitState.IMPROVING) || improvementType.isNatural()) {
            return;
        }
        Player player = this.freeColClient.getMyPlayer();
        if (!(player == (tile = unit.getTile()).getOwner() || this.claimTile(player, tile, null, player.getLandPrice(tile), 0) && player == tile.getOwner())) {
            return;
        }
        if (this.askChangeWorkImprovementType(unit, improvementType)) {
            // empty if block
        }
        this.nextActiveUnit();
    }

    private boolean askChangeWorkImprovementType(Unit unit, TileImprovementType type) {
        ChangeWorkImprovementTypeMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new ChangeWorkImprovementTypeMessage(unit, type)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    public void changeState(Unit unit, Unit.UnitState state) {
        Player enemy;
        Tile tile;
        if (!this.requireOurTurn()) {
            return;
        }
        if (!unit.checkSetState(state)) {
            return;
        }
        Player player = this.freeColClient.getMyPlayer();
        if (state == Unit.UnitState.FORTIFYING && unit.isOffensiveUnit() && !unit.hasAbility("model.ability.piracy") && (tile = unit.getTile()) != null && tile.getOwningSettlement() != null && player != (enemy = tile.getOwningSettlement().getOwner()) && player.getStance(enemy) != Player.Stance.ALLIANCE && !this.confirmHostileAction(unit, tile)) {
            return;
        }
        Canvas canvas = this.freeColClient.getCanvas();
        if (this.askChangeState(unit, state)) {
            if (!(canvas.isShowingSubPanel() || unit.getMovesLeft() != 0 && unit.getState() != Unit.UnitState.SENTRY && unit.getState() != Unit.UnitState.SKIPPED)) {
                this.nextActiveUnit();
            } else {
                canvas.refresh();
            }
        }
    }

    public boolean clearOrders(Unit unit) {
        if (!this.requireOurTurn() || unit == null || !unit.checkSetState(Unit.UnitState.ACTIVE)) {
            return false;
        }
        Canvas canvas = this.freeColClient.getCanvas();
        if (unit.getState() == Unit.UnitState.IMPROVING && !canvas.showConfirmDialog(unit.getTile(), StringTemplate.template("model.unit.confirmCancelWork").addAmount("%turns%", unit.getWorkTurnsLeft()), "yes", "no")) {
            return false;
        }
        this.assignTradeRoute(unit, null);
        this.clearGotoOrders(unit);
        return this.askChangeState(unit, Unit.UnitState.ACTIVE);
    }

    private boolean askChangeState(Unit unit, Unit.UnitState state) {
        ChangeStateMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new ChangeStateMessage(unit, state)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    public void assignTeacher(Unit student, Unit teacher) {
        Player player = this.freeColClient.getMyPlayer();
        if (!(this.requireOurTurn() && student != null && student.getOwner() == player && student.getColony() != null && student.getLocation() instanceof WorkLocation && teacher != null && teacher.getOwner() == player && student.canBeStudent(teacher) && teacher.getColony() != null && student.getColony() == teacher.getColony() && teacher.getColony().canTrain(teacher))) {
            return;
        }
        this.askAssignTeacher(student, teacher);
    }

    private boolean askAssignTeacher(Unit student, Unit teacher) {
        AssignTeacherMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new AssignTeacherMessage(student, teacher)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    public void setBuildQueue(Colony colony, List<BuildableType> buildQueue) {
        if (!this.requireOurTurn()) {
            return;
        }
        ColonyWas colonyWas = new ColonyWas(colony);
        if (this.askSetBuildQueue(colony, buildQueue)) {
            colonyWas.fireChanges();
        }
    }

    private boolean askSetBuildQueue(Colony colony, List<BuildableType> buildQueue) {
        SetBuildQueueMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new SetBuildQueueMessage(colony, buildQueue)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    public void trainUnitInEurope(UnitType unitType) {
        Europe europe;
        if (!this.requireOurTurn()) {
            return;
        }
        Canvas canvas = this.freeColClient.getCanvas();
        Player player = this.freeColClient.getMyPlayer();
        if (!player.checkGold((europe = player.getEurope()).getUnitPrice(unitType))) {
            canvas.errorMessage("notEnoughGold");
            return;
        }
        EuropeWas europeWas = new EuropeWas(europe);
        if (this.askTrainUnitInEurope(unitType)) {
            canvas.updateGoldLabel();
            europeWas.fireChanges();
        }
    }

    private boolean askTrainUnitInEurope(UnitType type) {
        TrainUnitInEuropeMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new TrainUnitInEuropeMessage(type)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    public void payForBuilding(Colony colony) {
        if (!this.requireOurTurn()) {
            return;
        }
        Canvas canvas = this.freeColClient.getCanvas();
        if (!colony.canPayToFinishBuilding()) {
            canvas.errorMessage("notEnoughGold");
            return;
        }
        int price = colony.getPriceForBuilding();
        if (!canvas.showConfirmDialog(null, StringTemplate.template("payForBuilding.text").addAmount("%replace%", price), "payForBuilding.yes", "payForBuilding.no")) {
            return;
        }
        ColonyWas colonyWas = new ColonyWas(colony);
        if (this.askPayForBuilding(colony) && colony.getPriceForBuilding() == 0) {
            colonyWas.fireChanges();
            canvas.updateGoldLabel();
        }
    }

    private boolean askPayForBuilding(Colony colony) {
        PayForBuildingMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new PayForBuildingMessage(colony)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    public boolean payArrears(Goods goods) {
        return this.payArrears(goods.getType());
    }

    public boolean payArrears(GoodsType type) {
        if (!this.requireOurTurn()) {
            return false;
        }
        Canvas canvas = this.freeColClient.getCanvas();
        Player player = this.freeColClient.getMyPlayer();
        int arrears = player.getArrears(type);
        if (arrears <= 0) {
            return false;
        }
        if (!player.checkGold(arrears)) {
            canvas.showInformationMessage(StringTemplate.template("model.europe.cantPayArrears").addAmount("%amount%", arrears));
            return false;
        }
        if (canvas.showConfirmDialog(null, StringTemplate.template("model.europe.payArrears").addAmount("%replace%", arrears), "ok", "cancel") && this.askPayArrears(type) && player.canTrade(type)) {
            canvas.updateGoldLabel();
            return true;
        }
        return false;
    }

    private boolean askPayArrears(GoodsType type) {
        PayArrearsMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new PayArrearsMessage(type)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    public List<AbstractUnit> getREFUnits() {
        if (!this.requireOurTurn()) {
            return Collections.emptyList();
        }
        return this.askGetREFUnits();
    }

    private List<AbstractUnit> askGetREFUnits() {
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, Message.createNewRootElement("getREFUnits"), null);
        if (reply == null) {
            return Collections.emptyList();
        }
        ArrayList<AbstractUnit> result = new ArrayList<AbstractUnit>();
        NodeList childElements = reply.getChildNodes();
        for (int index = 0; index < childElements.getLength(); ++index) {
            AbstractUnit unit = new AbstractUnit();
            unit.readFromXMLElement((Element)childElements.item(index));
            result.add(unit);
        }
        return result;
    }

    public List<HighScore> getHighScores() {
        return this.askGetHighScores();
    }

    private List<HighScore> askGetHighScores() {
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, Message.createNewRootElement("getHighScores"), null);
        if (reply == null) {
            return Collections.emptyList();
        }
        ArrayList<HighScore> result = new ArrayList<HighScore>();
        NodeList childElements = reply.getChildNodes();
        for (int i = 0; i < childElements.getLength(); ++i) {
            try {
                HighScore score = new HighScore((Element)childElements.item(i));
                result.add(score);
                continue;
            }
            catch (XMLStreamException e) {
                logger.warning("Unable to read score element: " + e.getMessage());
            }
        }
        return result;
    }

    public NationSummary getNationSummary(Player player) {
        return this.askNationSummary(player);
    }

    private NationSummary askNationSummary(Player player) {
        GetNationSummaryMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new GetNationSummaryMessage(player)).toXMLElement(), GetNationSummaryMessage.getXMLElementTagName());
        if (reply == null) {
            return null;
        }
        Game game = this.freeColClient.getGame();
        return new GetNationSummaryMessage(game, reply).getNationSummary();
    }

    public StatisticsMessage getServerStatistics() {
        return this.askStatistics();
    }

    private StatisticsMessage askStatistics() {
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, Message.createNewRootElement(StatisticsMessage.getXMLElementTagName()), null);
        if (reply == null) {
            return null;
        }
        return new StatisticsMessage(reply);
    }

    public void assignTradeRoute(Unit unit) {
        Canvas canvas = this.freeColClient.getCanvas();
        TradeRoute oldRoute = unit.getTradeRoute();
        TradeRoute route = canvas.showTradeRouteDialog(unit);
        if (route == null) {
            return;
        }
        route = unit.getTradeRoute();
        if (oldRoute != route) {
            this.assignTradeRoute(unit, route);
        }
    }

    public void assignTradeRoute(Unit unit, TradeRoute tradeRoute) {
        if (this.askAssignTradeRoute(unit, tradeRoute) && (tradeRoute = unit.getTradeRoute()) != null && this.freeColClient.getGame().getCurrentPlayer() == this.freeColClient.getMyPlayer()) {
            this.moveToDestination(unit);
        }
    }

    private boolean askAssignTradeRoute(Unit unit, TradeRoute tradeRoute) {
        AssignTradeRouteMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new AssignTradeRouteMessage(unit, tradeRoute)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    public TradeRoute getNewTradeRoute(Player player) {
        int n = player.getTradeRoutes().size();
        if (this.askGetNewTradeRoute() && player.getTradeRoutes().size() == n + 1) {
            return player.getTradeRoutes().get(n);
        }
        return null;
    }

    private boolean askGetNewTradeRoute() {
        Element element;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, element = Message.createNewRootElement("getNewTradeRoute"), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    public void setTradeRoutes(List<TradeRoute> routes) {
        this.askSetTradeRoutes(routes);
    }

    private boolean askSetTradeRoutes(List<TradeRoute> routes) {
        SetTradeRoutesMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new SetTradeRoutesMessage(routes)).toXMLElement(), null);
        if (reply == null) {
            return false;
        }
        Connection conn = client.getConnection();
        this.freeColClient.getInGameInputHandler().handle(conn, reply);
        return true;
    }

    public void updateTradeRoute(TradeRoute route) {
        this.askUpdateTradeRoute(route);
    }

    private boolean askUpdateTradeRoute(TradeRoute route) {
        UpdateTradeRouteMessage message;
        Client client = this.freeColClient.getClient();
        Element reply = this.askExpecting(client, (message = new UpdateTradeRouteMessage(route)).toXMLElement(), null);
        return reply == null;
    }

    public void endTurn() {
        Canvas canvas;
        if (!this.requireOurTurn()) {
            return;
        }
        ArrayList<Unit> units = new ArrayList<Unit>();
        for (Unit unit : this.freeColClient.getMyPlayer().getUnits()) {
            if (!unit.couldMove()) continue;
            units.add(unit);
        }
        if (units.size() > 0 && !(canvas = this.freeColClient.getCanvas()).showFreeColDialog(new EndTurnDialog(canvas, units)).booleanValue()) {
            return;
        }
        this.moveMode = 2;
        if (!this.doExecuteGotoOrders()) {
            return;
        }
        this.doEndTurn();
    }

    private void doEndTurn() {
        if (this.moveMode < 2) {
            this.moveMode = 2;
        }
        GUI gui = this.freeColClient.getGUI();
        gui.setActiveUnit(null);
        this.askTrivial("endTurn");
        this.moveMode = 0;
        ++this.turnsPlayed;
    }

    public void executeGotoOrders() {
        this.doExecuteGotoOrders();
    }

    private boolean doExecuteGotoOrders() {
        if (this.moveMode < 1) {
            this.moveMode = 1;
        }
        Canvas canvas = this.freeColClient.getCanvas();
        Player player = this.freeColClient.getMyPlayer();
        GUI gui = this.freeColClient.getGUI();
        while (player.hasNextGoingToUnit()) {
            if (canvas.isShowingSubPanel()) {
                canvas.getShowingSubPanel().requestFocus();
                return false;
            }
            Unit unit = player.getNextGoingToUnit();
            gui.setActiveUnit(unit);
            this.moveToDestination(unit);
            unit.setMovesLeft(0);
            this.nextModelMessage();
        }
        return true;
    }

    public void waitActiveUnit() {
        Canvas canvas = this.freeColClient.getCanvas();
        GUI gui = canvas.getGUI();
        gui.setActiveUnit(null);
        this.nextActiveUnit();
    }

    public void skipActiveUnit() {
        this.changeState(this.freeColClient.getGUI().getActiveUnit(), Unit.UnitState.SKIPPED);
    }

    public void nextActiveUnit() {
        this.nextActiveUnit(null);
    }

    public void nextActiveUnit(Tile tile) {
        if (!this.requireOurTurn()) {
            return;
        }
        Canvas canvas = this.freeColClient.getCanvas();
        this.nextModelMessage();
        if (this.moveMode >= 1 && !this.doExecuteGotoOrders()) {
            return;
        }
        Player player = this.freeColClient.getMyPlayer();
        GUI gui = canvas.getGUI();
        Unit unit = gui.getActiveUnit();
        if (unit != null && !unit.isDisposed() && unit.getMovesLeft() > 0 && unit.getState() != Unit.UnitState.SKIPPED) {
            return;
        }
        if (player.hasNextActiveUnit()) {
            gui.setActiveUnit(player.getNextActiveUnit());
            return;
        }
        if (!this.doExecuteGotoOrders()) {
            return;
        }
        gui.setActiveUnit(null);
        ClientOptions options = this.freeColClient.getClientOptions();
        if (this.moveMode >= 2) {
            this.doEndTurn();
        } else if (tile != null) {
            gui.setSelectedTile(tile, false);
        } else if (options.getBoolean("model.option.autoEndTurn")) {
            this.doEndTurn();
        }
    }

    public synchronized void ignoreMessage(ModelMessage message, boolean flag) {
        String otherkey;
        Iterator<String> i$;
        String key = message.getSourceId();
        if (message.getTemplateType() == StringTemplate.TemplateType.TEMPLATE && (i$ = message.getKeys().iterator()).hasNext() && "%goods%".equals(otherkey = i$.next())) {
            key = key + otherkey;
        }
        if (flag) {
            this.startIgnoringMessage(key, this.freeColClient.getGame().getTurn().getNumber());
        } else {
            this.stopIgnoringMessage(key);
        }
    }

    public void nextModelMessage() {
        this.displayModelMessages(false);
    }

    public void displayModelMessages(final boolean allMessages) {
        int thisTurn = this.freeColClient.getGame().getTurn().getNumber();
        final ArrayList<ModelMessage> messageList = new ArrayList<ModelMessage>();
        List<ModelMessage> inputList = allMessages ? this.freeColClient.getMyPlayer().getModelMessages() : this.freeColClient.getMyPlayer().getNewModelMessages();
        for (ModelMessage message : inputList) {
            if (this.shouldAllowMessage(message)) {
                if (message.getMessageType() == ModelMessage.MessageType.WAREHOUSE_CAPACITY) {
                    Integer turn;
                    String key = message.getSourceId();
                    if (message.getTemplateType() == StringTemplate.TemplateType.TEMPLATE) {
                        for (String otherkey : message.getKeys()) {
                            if (!"%goods%".equals(otherkey)) continue;
                            key = key + otherkey;
                            break;
                        }
                    }
                    if ((turn = this.getTurnForMessageIgnored(key)) != null && turn == thisTurn - 1) {
                        this.startIgnoringMessage(key, thisTurn);
                        message.setBeenDisplayed(true);
                        continue;
                    }
                } else if (message.getMessageType() == ModelMessage.MessageType.BUILDING_COMPLETED) {
                    this.freeColClient.playSound("sound.event.buildingComplete");
                }
                messageList.add(message);
            }
            message.setBeenDisplayed(true);
        }
        this.purgeOldMessagesFromMessagesToIgnore(thisTurn);
        final ModelMessage[] messages = messageList.toArray(new ModelMessage[0]);
        Runnable uiTask = new Runnable(){

            public void run() {
                Canvas canvas = InGameController.this.freeColClient.getCanvas();
                if (messageList.size() > 0) {
                    if (allMessages || messageList.size() > 5) {
                        canvas.showReportTurnPanel(messages);
                    } else {
                        canvas.showModelMessages(messages);
                    }
                }
                InGameController.this.freeColClient.getActionManager().update();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            uiTask.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(uiTask);
            }
            catch (InterruptedException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
    }

    private synchronized Integer getTurnForMessageIgnored(String key) {
        return this.messagesToIgnore.get(key);
    }

    private synchronized void startIgnoringMessage(String key, int turn) {
        logger.finer("Ignoring model message with key " + key);
        this.messagesToIgnore.put(key, new Integer(turn));
    }

    private synchronized void stopIgnoringMessage(String key) {
        logger.finer("Removing model message with key " + key + " from ignored messages.");
        this.messagesToIgnore.remove(key);
    }

    private synchronized void purgeOldMessagesFromMessagesToIgnore(int thisTurn) {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        for (Map.Entry<String, Integer> entry : this.messagesToIgnore.entrySet()) {
            if (entry.getValue() >= thisTurn - 1) continue;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Removing old model message with key " + entry.getKey() + " from ignored messages.");
            }
            keysToRemove.add(entry.getKey());
        }
        for (String key : keysToRemove) {
            this.stopIgnoringMessage(key);
        }
    }

    private boolean shouldAllowMessage(ModelMessage message) {
        BooleanOption option = this.freeColClient.getClientOptions().getBooleanOption(message);
        if (option == null) {
            return true;
        }
        return option.getValue();
    }

    private class UnitWas {
        private Unit unit;
        private UnitType type;
        private Unit.Role role;
        private Location loc;
        private GoodsType work;
        private int amount;
        private Colony colony;

        public UnitWas(Unit unit) {
            this.unit = unit;
            this.type = unit.getType();
            this.role = unit.getRole();
            this.loc = unit.getLocation();
            this.work = unit.getWorkType();
            this.amount = this.getAmount(this.loc, this.work);
            this.colony = unit.getColony();
        }

        private int getAmount(Location location, GoodsType goodsType) {
            if (goodsType != null) {
                if (location instanceof Building) {
                    Building building = (Building)location;
                    ProductionInfo info = building.getProductionInfo();
                    return info == null || info.getProduction() == null || info.getProduction().size() == 0 ? 0 : info.getProduction().get(0).getAmount();
                }
                if (location instanceof ColonyTile) {
                    return ((ColonyTile)location).getProductionOf(goodsType);
                }
            }
            return 0;
        }

        private String change(FreeColGameObject fcgo) {
            return fcgo instanceof Tile ? "TILE_UNIT_CHANGE" : (fcgo instanceof Europe ? "unitChange" : (fcgo instanceof ColonyTile ? "UNIT_CHANGE" : (fcgo instanceof Building ? "UNIT_CHANGE" : (fcgo instanceof Unit ? "CARGO_CHANGE" : null))));
        }

        public void fireChanges() {
            UnitType newType = null;
            Unit.Role newRole = null;
            Location newLoc = null;
            GoodsType newWork = null;
            int newAmount = 0;
            if (!this.unit.isDisposed()) {
                newLoc = this.unit.getLocation();
                if (this.colony != null) {
                    newType = this.unit.getType();
                    newRole = this.unit.getRole();
                    newWork = this.unit.getWorkType();
                    int n = newAmount = newWork == null ? 0 : this.getAmount(newLoc, newWork);
                }
            }
            if (this.loc != newLoc) {
                FreeColGameObject oldFcgo = (FreeColGameObject)((Object)this.loc);
                oldFcgo.firePropertyChange(this.change(oldFcgo), this.unit, null);
                if (newLoc != null) {
                    FreeColGameObject newFcgo = (FreeColGameObject)((Object)newLoc);
                    newFcgo.firePropertyChange(this.change(newFcgo), null, this.unit);
                }
            }
            if (this.colony != null) {
                String pc;
                if (this.type != newType && newType != null) {
                    pc = Colony.ColonyChangeEvent.UNIT_TYPE_CHANGE.toString();
                    this.colony.firePropertyChange(pc, this.type, newType);
                } else if (this.role != newRole && newRole != null) {
                    pc = "TILE_UNIT_CHANGE".toString();
                    this.colony.firePropertyChange(pc, this.role.toString(), newRole.toString());
                }
                if (this.work == newWork) {
                    if (this.work != null && this.amount != newAmount) {
                        this.colony.firePropertyChange(this.work.getId(), this.amount, newAmount);
                    }
                } else {
                    if (this.work != null) {
                        this.colony.firePropertyChange(this.work.getId(), this.amount, 0);
                    }
                    if (newWork != null) {
                        this.colony.firePropertyChange(newWork.getId(), 0, newAmount);
                    }
                }
            }
            if (this.unit.getGoodsContainer() != null) {
                this.unit.getGoodsContainer().fireChanges();
            }
        }
    }

    private class EuropeWas {
        private Europe europe;
        private int unitCount;

        public EuropeWas(Europe europe) {
            this.europe = europe;
            this.unitCount = europe.getUnitCount();
        }

        public void fireChanges() {
            int newUnitCount = this.europe.getUnitCount();
            if (newUnitCount != this.unitCount) {
                String pc = "unitChange".toString();
                this.europe.firePropertyChange(pc, this.unitCount, newUnitCount);
            }
        }
    }

    private class ColonyWas {
        private Colony colony;
        private int population;
        private int productionBonus;
        private List<BuildableType> buildQueue;

        public ColonyWas(Colony colony) {
            this.colony = colony;
            this.population = colony.getUnitCount();
            this.productionBonus = colony.getProductionBonus();
            this.buildQueue = new ArrayList<BuildableType>(colony.getBuildQueue());
        }

        public void fireChanges() {
            List<BuildableType> newBuildQueue;
            int newProductionBonus;
            int newPopulation = this.colony.getUnitCount();
            if (newPopulation != this.population) {
                String pc = Colony.ColonyChangeEvent.POPULATION_CHANGE.toString();
                this.colony.firePropertyChange(pc, this.population, newPopulation);
            }
            if ((newProductionBonus = this.colony.getProductionBonus()) != this.productionBonus) {
                String pc = Colony.ColonyChangeEvent.BONUS_CHANGE.toString();
                this.colony.firePropertyChange(pc, this.productionBonus, newProductionBonus);
            }
            if (!((Object)(newBuildQueue = this.colony.getBuildQueue())).equals(this.buildQueue)) {
                String pc = Colony.ColonyChangeEvent.BUILD_QUEUE_CHANGE.toString();
                this.colony.firePropertyChange(pc, this.buildQueue, newBuildQueue);
            }
            this.colony.getGoodsContainer().fireChanges();
        }
    }
}

