/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.FreeColMenuBar;
import net.sf.freecol.client.gui.action.DisplayTileTextAction;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.menu.DebugMenu;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TileImprovementType;

public class InGameMenuBar
extends FreeColMenuBar {
    private static final Logger logger = Logger.getLogger(InGameMenuBar.class.getName());

    public InGameMenuBar(FreeColClient f) {
        super(f);
        this.reset();
    }

    public void reset() {
        this.removeAll();
        this.buildGameMenu();
        this.buildViewMenu();
        this.buildOrdersMenu();
        this.buildReportMenu();
        this.buildColopediaMenu();
        if (FreeCol.isInDebugMode()) {
            this.add(new DebugMenu(this.freeColClient));
        }
        this.update();
    }

    private void buildGameMenu() {
        JMenu menu = new JMenu(Messages.message("menuBar.game"));
        menu.setOpaque(false);
        menu.setMnemonic(71);
        menu.add(this.getMenuItem("newAction"));
        menu.add(this.getMenuItem("openAction"));
        menu.add(this.getMenuItem("saveAction"));
        menu.addSeparator();
        menu.add(this.getMenuItem("preferencesAction"));
        menu.add(this.getMenuItem("reconnectAction"));
        menu.addSeparator();
        menu.add(this.getMenuItem("chatAction"));
        menu.add(this.getMenuItem("declareIndependenceAction"));
        menu.add(this.getMenuItem("endTurnAction"));
        menu.addSeparator();
        menu.add(this.getMenuItem("showMainAction"));
        menu.add(this.getMenuItem("reportHighScoresAction"));
        menu.add(this.getMenuItem("retireAction"));
        menu.add(this.getMenuItem("saveAndQuitAction"));
        menu.add(this.getMenuItem("quitAction"));
        this.add(menu);
    }

    private void buildViewMenu() {
        JMenu menu = new JMenu(Messages.message("menuBar.view"));
        menu.setOpaque(false);
        menu.setMnemonic(86);
        menu.add(this.getCheckBoxMenuItem("mapControlsAction"));
        menu.add(this.getCheckBoxMenuItem("displayGridAction"));
        menu.add(this.getCheckBoxMenuItem("displayBordersAction"));
        menu.add(this.getMenuItem("toggleViewModeAction"));
        menu.add(this.getCheckBoxMenuItem("changeWindowedModeAction"));
        menu.addSeparator();
        ButtonGroup group = new ButtonGroup();
        for (DisplayTileTextAction.DisplayText type : DisplayTileTextAction.DisplayText.values()) {
            menu.add(this.getRadioButtonMenuItem("displayTileTextAction." + (Object)((Object)type), group));
        }
        menu.addSeparator();
        menu.add(this.getMenuItem("zoomInAction"));
        menu.add(this.getMenuItem("zoomOutAction"));
        menu.add(this.getMenuItem("centerAction"));
        menu.add(this.getMenuItem("tilePopupAction"));
        menu.addSeparator();
        menu.add(this.getMenuItem("europeAction"));
        menu.add(this.getMenuItem("tradeRouteAction"));
        menu.add(this.getMenuItem("findSettlementAction"));
        this.add(menu);
    }

    private void buildOrdersMenu() {
        JMenu menu = new JMenu(Messages.message("menuBar.orders"));
        menu.setOpaque(false);
        menu.setMnemonic(79);
        menu.add(this.getMenuItem("sentryAction"));
        menu.add(this.getMenuItem("fortifyAction"));
        menu.addSeparator();
        menu.add(this.getMenuItem("gotoAction"));
        menu.add(this.getMenuItem("gotoTileAction"));
        menu.add(this.getMenuItem("executeGotoOrdersAction"));
        menu.add(this.getMenuItem("assignTradeRouteAction"));
        menu.addSeparator();
        menu.add(this.getMenuItem("buildColonyAction"));
        for (TileImprovementType type : this.freeColClient.getGame().getSpecification().getTileImprovementTypeList()) {
            if (type.isNatural()) continue;
            menu.add(this.getMenuItem(type.getShortId() + "Action"));
        }
        menu.addSeparator();
        menu.add(this.getMenuItem("loadAction"));
        menu.add(this.getMenuItem("unloadAction"));
        menu.addSeparator();
        menu.add(this.getMenuItem("waitAction"));
        menu.add(this.getMenuItem("skipUnitAction"));
        menu.add(this.getMenuItem("changeAction"));
        menu.addSeparator();
        menu.add(this.getMenuItem("clearOrdersAction"));
        menu.add(this.getMenuItem("renameAction"));
        menu.add(this.getMenuItem("disbandUnitAction"));
        this.add(menu);
    }

    private void buildReportMenu() {
        JMenu menu = new JMenu(Messages.message("menuBar.report"));
        menu.setOpaque(false);
        menu.setMnemonic(82);
        menu.add(this.getMenuItem("reportReligionAction"));
        menu.add(this.getMenuItem("reportLabourAction"));
        menu.add(this.getMenuItem("reportColonyAction"));
        menu.add(this.getMenuItem("reportForeignAction"));
        menu.add(this.getMenuItem("reportIndianAction"));
        menu.add(this.getMenuItem("reportCongressAction"));
        menu.add(this.getMenuItem("reportMilitaryAction"));
        menu.add(this.getMenuItem("reportNavalAction"));
        menu.add(this.getMenuItem("reportTradeAction"));
        menu.add(this.getMenuItem("reportTurnAction"));
        menu.add(this.getMenuItem("reportRequirementsAction"));
        menu.add(this.getMenuItem("reportCargoAction"));
        menu.add(this.getMenuItem("reportExplorationAction"));
        menu.add(this.getMenuItem("reportHistoryAction"));
        menu.add(this.getMenuItem("reportProductionAction"));
        menu.add(this.getMenuItem("reportEducationAction"));
        menu.add(this.getMenuItem("difficultyAction"));
        menu.add(this.getMenuItem("gameOptionsAction"));
        menu.add(this.getMenuItem("mapGeneratorOptionsAction"));
        this.add(menu);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.freeColClient != null && this.freeColClient.getMyPlayer() != null) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            int gold = this.freeColClient.getMyPlayer().getGold();
            String displayString = Messages.message(StringTemplate.template("menuBar.statusLine").addAmount("%gold%", gold).addAmount("%tax%", this.freeColClient.getMyPlayer().getTax()).addAmount("%score%", this.freeColClient.getMyPlayer().getScore()).addStringTemplate("%year%", this.freeColClient.getGame().getTurn().getLabel()));
            Rectangle2D displayStringBounds = g2d.getFontMetrics().getStringBounds(displayString, g);
            int y = 15 + this.getInsets().top;
            g2d.drawString(displayString, this.getWidth() - 10 - (int)displayStringBounds.getWidth(), y);
        }
    }
}

