/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.animation;

import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.animation.Animations;
import net.sf.freecol.client.gui.animation.UnitImageAnimation;
import net.sf.freecol.common.io.sza.SimpleZippedAnimation;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.resources.ResourceManager;

final class UnitAttackAnimation {
    private final Canvas canvas;
    private final Unit attacker;
    private final Unit defender;
    private final boolean success;

    public UnitAttackAnimation(Canvas canvas, Unit attacker, Unit defender, boolean success) {
        this.canvas = canvas;
        this.attacker = attacker;
        this.defender = defender;
        this.success = success;
    }

    private SimpleZippedAnimation getAnimation(Canvas canvas, Unit unit, Map.Direction direction) {
        float scale = canvas.getGUI().getMapScale();
        String roleStr = unit.getRole() == Unit.Role.DEFAULT ? "" : "." + unit.getRole().getId();
        String startStr = unit.getType().getId() + roleStr + ".attack.";
        String specialId = startStr + direction.toString().toLowerCase() + ".animation";
        SimpleZippedAnimation sza = ResourceManager.getSimpleZippedAnimation(specialId, scale);
        if (sza == null) {
            String genericDirection;
            switch (direction) {
                case SW: 
                case W: 
                case NW: {
                    genericDirection = "w";
                    break;
                }
                default: {
                    genericDirection = "e";
                }
            }
            String genericId = startStr + genericDirection + ".animation";
            sza = ResourceManager.getSimpleZippedAnimation(genericId, scale);
        }
        return sza;
    }

    public void animate() {
        SimpleZippedAnimation sza;
        Map map = this.attacker.getGame().getMap();
        Map.Direction direction = map.getDirection(this.attacker.getTile(), this.defender.getTile());
        if (Animations.getAnimationSpeed(this.canvas, this.attacker) > 0 && (sza = this.getAnimation(this.canvas, this.attacker, direction)) != null) {
            new UnitImageAnimation(this.canvas, this.attacker, sza).animate();
        }
        if (!this.success && Animations.getAnimationSpeed(this.canvas, this.defender) > 0 && (sza = this.getAnimation(this.canvas, this.defender, direction = direction.getReverseDirection())) != null) {
            new UnitImageAnimation(this.canvas, this.defender, sza).animate();
        }
    }
}

