/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import net.sf.freecol.client.gui.action.FreeColAction;
import net.sf.freecol.client.gui.option.OptionGroupUI;
import net.sf.freecol.client.gui.option.OptionUpdater;

public final class FreeColActionUI
extends JPanel
implements OptionUpdater,
ActionListener {
    private static final Logger logger = Logger.getLogger(FreeColActionUI.class.getName());
    private final FreeColAction option;
    private final OptionGroupUI optionGroupUI;
    private KeyStroke keyStroke;
    private JButton recordButton;
    private JButton removeButton;
    private BlinkingLabel bl;

    public FreeColActionUI(FreeColAction option, OptionGroupUI optionGroupUI) {
        super(new BorderLayout());
        this.option = option;
        this.optionGroupUI = optionGroupUI;
        this.keyStroke = option.getAccelerator();
        String name = option.getName();
        String description = option.getShortDescription();
        JLabel label = new JLabel(name, 2);
        label.setToolTipText(description != null ? description : name);
        this.add((Component)label, "Center");
        JPanel p1 = new JPanel(new FlowLayout(2));
        p1.setOpaque(false);
        this.bl = new BlinkingLabel();
        p1.add(this.bl);
        this.recordButton = new JButton(FreeColActionUI.getRecordImage());
        this.recordButton.addActionListener(this);
        p1.add(this.recordButton);
        this.removeButton = new JButton(FreeColActionUI.getRemoveImage());
        this.removeButton.addActionListener(this);
        p1.add(this.removeButton);
        this.add((Component)p1, "East");
        this.setOpaque(false);
    }

    public void rollback() {
    }

    public void unregister() {
    }

    public static ImageIcon getRecordImage() {
        BufferedImage bi = new BufferedImage(9, 9, 2);
        Graphics2D g = bi.createGraphics();
        g.setColor(Color.RED);
        g.fillOval(0, 0, 9, 9);
        g.setColor(Color.BLACK);
        g.drawOval(0, 0, 9, 9);
        return new ImageIcon(bi);
    }

    public static ImageIcon getRemoveImage() {
        BufferedImage bi = new BufferedImage(9, 9, 2);
        Graphics2D g = bi.createGraphics();
        g.setColor(Color.BLACK);
        g.drawLine(1, 0, 8, 7);
        g.drawLine(0, 1, 7, 8);
        g.drawLine(7, 0, 0, 7);
        g.drawLine(9, 0, 0, 9);
        g.setColor(Color.RED);
        g.drawLine(0, 0, 8, 8);
        g.drawLine(8, 0, 0, 8);
        return new ImageIcon(bi);
    }

    public static String getHumanKeyStrokeText(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return " ";
        }
        String s = KeyEvent.getKeyModifiersText(keyStroke.getModifiers());
        if (!s.equals("")) {
            s = s + "+";
        }
        return s + KeyEvent.getKeyText(keyStroke.getKeyCode());
    }

    public void removeKeyStroke(KeyStroke k) {
        if (k != null && this.keyStroke != null && k.getKeyCode() == this.keyStroke.getKeyCode() && k.getModifiers() == this.keyStroke.getModifiers()) {
            this.keyStroke = null;
            this.bl.setText(" ");
        }
    }

    public void updateOption() {
        this.option.setAccelerator(this.keyStroke);
    }

    public void reset() {
        this.keyStroke = this.option.getAccelerator();
        this.bl.setText(FreeColActionUI.getHumanKeyStrokeText(this.keyStroke));
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.recordButton) {
            this.bl.startBlinking();
            this.bl.requestFocus();
        } else if (evt.getSource() == this.removeButton) {
            this.bl.stopBlinking();
            this.bl.setText(" ");
            this.keyStroke = null;
        }
    }

    class BlinkingLabel
    extends JLabel
    implements ActionListener,
    KeyListener,
    MouseListener {
        private Timer blinkingTimer;
        private boolean blinkOn;

        BlinkingLabel() {
            super(FreeColActionUI.getHumanKeyStrokeText(FreeColActionUI.this.keyStroke), 0);
            this.blinkingTimer = new Timer(500, this);
            this.blinkOn = false;
            this.setOpaque(false);
            this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.addKeyListener(this);
            this.addMouseListener(this);
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() > 1) {
                this.startBlinking();
                this.requestFocus();
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public Dimension getMinimumSize() {
            return new Dimension(80, super.getMinimumSize().height);
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public void startBlinking() {
            this.blinkingTimer.start();
        }

        public void stopBlinking() {
            this.blinkingTimer.stop();
            this.setOpaque(false);
            this.repaint();
        }

        public void actionPerformed(ActionEvent evt) {
            if (!this.hasFocus()) {
                this.stopBlinking();
            }
            if (this.blinkOn) {
                this.setOpaque(false);
                this.blinkOn = false;
                this.repaint();
            } else {
                this.setOpaque(true);
                this.setBackground(Color.RED);
                this.blinkOn = true;
                this.repaint();
            }
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            KeyStroke ks = KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers());
            FreeColActionUI.this.optionGroupUI.removeKeyStroke(ks);
            FreeColActionUI.this.keyStroke = ks;
            this.stopBlinking();
            this.setText(FreeColActionUI.getHumanKeyStrokeText(FreeColActionUI.this.keyStroke));
            FreeColActionUI.this.recordButton.requestFocus();
        }
    }
}

