/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfirmDeclarationDialog
extends FreeColDialog<List<String>> {
    private JTextField nationField;
    private JTextField countryField;
    private static final Logger logger = Logger.getLogger(ConfirmDeclarationDialog.class.getName());

    public ConfirmDeclarationDialog(Canvas parent) {
        super(parent);
        Player player = this.getMyPlayer();
        StringTemplate nation = StringTemplate.template("declareIndependence.defaultNation").addStringTemplate("%nation%", player.getNationName());
        this.nationField = new JTextField(Messages.message(nation), 20);
        StringTemplate country = StringTemplate.template("declareIndependence.defaultCountry").add("%nation%", player.getNewLandName());
        this.countryField = new JTextField(Messages.message(country), 20);
        this.okButton.setText(Messages.message("declareIndependence.areYouSure.yes"));
        this.cancelButton.setText(Messages.message("declareIndependence.areYouSure.no"));
        this.setLayout((LayoutManager)new MigLayout("wrap 1", "", ""));
        StringTemplate sure = StringTemplate.template("declareIndependence.areYouSure.text").add("%monarch%", player.getMonarch().getNameKey());
        this.add(ConfirmDeclarationDialog.getDefaultTextArea(Messages.message(sure)));
        this.add(ConfirmDeclarationDialog.getDefaultTextArea(Messages.message("declareIndependence.enterCountry")));
        this.add(this.countryField);
        this.add(ConfirmDeclarationDialog.getDefaultTextArea(Messages.message("declareIndependence.enterNation")));
        this.add(this.nationField);
        this.add((Component)this.okButton, "newline 20, split 2, tag ok");
        this.add((Component)this.cancelButton, "tag cancel");
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if ("OK".equals(command)) {
            ArrayList<String> result = new ArrayList<String>();
            result.add(this.nationField.getText().replaceAll("[^\\s\\w]", ""));
            result.add(this.countryField.getText());
            this.setResponse(result);
        } else {
            super.actionPerformed(event);
        }
    }
}

