/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.client.gui.panel.UnitLabel;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreCombatDialog
extends FreeColDialog<Boolean> {
    public PreCombatDialog(Canvas parent, FreeColGameObject attacker, FreeColGameObject defender) {
        super(parent);
        JLabel defenderLabel;
        String defenderName;
        UnitLabel attackerLabel;
        String attackerName;
        Unit attackerUnit;
        CombatModel combatModel = attacker.getGame().getCombatModel();
        Set<Modifier> offence = this.sortModifiers(combatModel.getOffensiveModifiers(attacker, defender));
        Set<Modifier> defence = this.sortModifiers(combatModel.getDefensiveModifiers(attacker, defender));
        this.setLayout((LayoutManager)new MigLayout("wrap 6", "[sg label]20[sg value, right]1px[sg percent]40[sg label]20[sg value, right]1px[sg percent]", ""));
        if (combatModel.combatIsAttack(attacker, defender)) {
            attackerUnit = (Unit)attacker;
            Unit defenderUnit = (Unit)defender;
            attackerName = Messages.message(StringTemplate.template("model.unit.nationUnit").addStringTemplate("%nation%", attackerUnit.getOwner().getNationName()).addStringTemplate("%unit%", attackerUnit.getLabel()));
            attackerLabel = new UnitLabel(attackerUnit, parent, false, true);
            defenderName = Messages.message(StringTemplate.template("model.unit.nationUnit").addStringTemplate("%nation%", defenderUnit.getOwner().getNationName()).addStringTemplate("%unit%", defenderUnit.getLabel()));
            defenderLabel = new UnitLabel(defenderUnit, parent, false, true);
        } else if (combatModel.combatIsSettlementAttack(attacker, defender)) {
            attackerUnit = (Unit)attacker;
            Settlement settlement = (Settlement)defender;
            attackerName = Messages.message(StringTemplate.template("model.unit.nationUnit").addStringTemplate("%nation%", attackerUnit.getOwner().getNationName()).addStringTemplate("%unit%", attackerUnit.getLabel()));
            attackerLabel = new UnitLabel(attackerUnit, parent, false, true);
            defenderName = settlement.getName();
            defenderLabel = new JLabel(parent.getImageIcon(settlement, false));
        } else {
            throw new IllegalStateException("Bogus attack");
        }
        this.add((Component)new JLabel(attackerName), "span 3, align center");
        this.add((Component)new JLabel(defenderName), "span 3, align center");
        this.add((Component)attackerLabel, "span 3, align center");
        this.add((Component)defenderLabel, "span 3, align center");
        this.add((Component)new JSeparator(0), "newline, span 3, growx");
        this.add((Component)new JSeparator(0), "span 3, growx");
        Iterator<Modifier> offenceModifiers = offence.iterator();
        Iterator<Modifier> defenceModifiers = defence.iterator();
        while (offenceModifiers.hasNext() || defenceModifiers.hasNext()) {
            int skip = 0;
            boolean hasOffence = offenceModifiers.hasNext();
            if (hasOffence) {
                if (!this.addModifier(offenceModifiers.next(), true, 0)) {
                    skip = 1;
                }
            } else {
                skip = 3;
            }
            if (!defenceModifiers.hasNext()) continue;
            this.addModifier(defenceModifiers.next(), !hasOffence, skip);
        }
        Font bigFont = this.getFont().deriveFont(1, 20.0f);
        float offenceResult = FeatureContainer.applyModifierSet(0.0f, attacker.getGame().getTurn(), offence);
        JLabel finalOffenceLabel = new JLabel(Messages.message("model.source.finalResult.name"));
        finalOffenceLabel.setFont(bigFont);
        this.add((Component)new JSeparator(0), "newline, span 3, growx");
        this.add((Component)new JSeparator(0), "span 3, growx");
        this.add(finalOffenceLabel);
        JLabel finalOffenceResult = new JLabel(PreCombatDialog.getModifierFormat().format(offenceResult));
        finalOffenceResult.setFont(bigFont);
        this.add(finalOffenceResult);
        float defenceResult = FeatureContainer.applyModifierSet(0.0f, attacker.getGame().getTurn(), defence);
        JLabel finalDefenceLabel = new JLabel(Messages.message("model.source.finalResult.name"));
        finalDefenceLabel.setFont(bigFont);
        this.add((Component)finalDefenceLabel, "skip");
        JLabel finalDefenceResult = new JLabel(PreCombatDialog.getModifierFormat().format(defenceResult));
        if (defenceResult == Float.MIN_VALUE) {
            finalDefenceResult.setText("???");
        }
        finalDefenceResult.setFont(bigFont);
        this.add(finalDefenceResult);
        this.add((Component)this.okButton, "newline 20, span, split 2, tag ok");
        this.add((Component)this.cancelButton, "tag cancel");
        this.setSize(this.getPreferredSize());
    }

    private boolean addModifier(Modifier modifier, boolean newline, int skip) {
        String constraint = null;
        if (newline) {
            constraint = "newline";
        }
        if (skip > 0) {
            constraint = constraint == null ? "skip " + skip : constraint + ", skip " + skip;
        }
        FreeColGameObjectType source = modifier.getSource();
        String sourceName = "???";
        if (source != null) {
            sourceName = Messages.message(source.getNameKey());
        }
        this.add((Component)new JLabel(sourceName), constraint);
        String bonus = PreCombatDialog.getModifierFormat().format(modifier.getValue());
        boolean percent = false;
        switch (modifier.getType()) {
            case ADDITIVE: {
                if (!(modifier.getValue() > 0.0f)) break;
                bonus = "+" + bonus;
                break;
            }
            case PERCENTAGE: {
                if (modifier.getValue() > 0.0f) {
                    bonus = "+" + bonus;
                }
                percent = true;
                break;
            }
            case MULTIPLICATIVE: {
                bonus = "\u00d7" + bonus;
                break;
            }
        }
        this.add(new JLabel(bonus));
        if (percent) {
            this.add(new JLabel("%"));
        }
        return percent;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if ("OK".equals(command)) {
            this.setResponse(Boolean.TRUE);
        } else if ("CANCEL".equals(command)) {
            this.setResponse(Boolean.FALSE);
        } else {
            super.actionPerformed(event);
        }
    }
}

