/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ProductionLabel;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.client.gui.panel.UnitLabel;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.resources.ResourceManager;

public final class ReportColonyPanel
extends ReportPanel {
    private static final int COLONISTS_PER_ROW = 16;
    private static final int UNITS_PER_ROW = 12;
    private static final int GOODS_PER_ROW = 12;
    private static final int BUILDINGS_PER_ROW = 8;
    private List<Colony> colonies;

    public ReportColonyPanel(Canvas parent) {
        super(parent, Messages.message("reportColonyAction.name"));
        Player player = this.getMyPlayer();
        this.colonies = player.getColonies();
        Collections.sort(this.colonies, this.getClient().getClientOptions().getColonyComparator());
        this.reportPanel.setLayout((LayoutManager)new MigLayout("fill"));
        for (Colony colony : this.colonies) {
            UnitLabel unitLabel;
            int index;
            JButton button = ReportColonyPanel.getLinkButton(colony.getName(), null, colony.getId());
            button.addActionListener(this);
            this.reportPanel.add((Component)button, "newline 20, split 2");
            this.reportPanel.add((Component)new JSeparator(0), "growx");
            List<Unit> unitList = colony.getUnitList();
            Collections.sort(unitList, ReportColonyPanel.getUnitTypeComparator());
            for (index = 0; index < unitList.size(); ++index) {
                unitLabel = new UnitLabel(unitList.get(index), this.getCanvas(), true, true);
                if (index % 16 == 0) {
                    this.reportPanel.add((Component)unitLabel, "newline, split 16");
                    continue;
                }
                this.reportPanel.add(unitLabel);
            }
            unitList = colony.getTile().getUnitList();
            Collections.sort(unitList, ReportColonyPanel.getUnitTypeComparator());
            for (index = 0; index < unitList.size(); ++index) {
                unitLabel = new UnitLabel(unitList.get(index), this.getCanvas(), true, true);
                if (index % 12 == 0) {
                    this.reportPanel.add((Component)unitLabel, "newline, split 12");
                    continue;
                }
                this.reportPanel.add(unitLabel);
            }
            GoodsType horses = this.getSpecification().getGoodsType("model.goods.horses");
            int count = 0;
            for (GoodsType goodsType : this.getSpecification().getGoodsTypeList()) {
                int newValue = colony.getNetProductionOf(goodsType);
                int stockValue = colony.getGoodsCount(goodsType);
                if (newValue == 0 && stockValue <= 0) continue;
                Building building = colony.getBuildingForProducing(goodsType);
                ProductionLabel productionLabel = new ProductionLabel(goodsType, newValue, this.getCanvas());
                if (building != null) {
                    productionLabel.setMaximumProduction(building.getMaximumProduction());
                }
                if (goodsType == horses) {
                    productionLabel.setMaxGoodsIcons(1);
                }
                productionLabel.setStockNumber(stockValue);
                if (count % 12 == 0) {
                    this.reportPanel.add((Component)productionLabel, "newline, split 12");
                } else {
                    this.reportPanel.add(productionLabel);
                }
                ++count;
            }
            List<Building> buildingList = colony.getBuildings();
            Collections.sort(buildingList);
            for (int index2 = 0; index2 < buildingList.size(); ++index2) {
                Building building = buildingList.get(index2);
                JLabel buildingLabel = new JLabel(new ImageIcon(ResourceManager.getImage(building.getType().getId() + ".image", 0.66)));
                buildingLabel.setToolTipText(Messages.message(building.getNameKey()));
                if (index2 % 8 == 0) {
                    this.reportPanel.add((Component)buildingLabel, "newline, split 8");
                    continue;
                }
                this.reportPanel.add(buildingLabel);
            }
            BuildableType currentType = colony.getCurrentlyBuilding();
            if (currentType == null) continue;
            JLabel buildableLabel = new JLabel(new ImageIcon(ResourceManager.getImage(currentType.getId() + ".image", 0.66)));
            buildableLabel.setToolTipText(Messages.message(StringTemplate.template("colonyPanel.currentlyBuilding").add("%buildable%", currentType.getNameKey())));
            buildableLabel.setIcon(buildableLabel.getDisabledIcon());
            this.reportPanel.add(buildableLabel);
        }
    }
}

