/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Image;
import java.awt.LayoutManager;
import java.util.EnumMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColProgressBar;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.resources.ResourceManager;

public final class ReportContinentalCongressPanel
extends ReportPanel {
    static final String title = Messages.message("reportCongressAction.name");
    static final String none = Messages.message("report.continentalCongress.none");

    public ReportContinentalCongressPanel(Canvas parent) {
        super(parent, title);
        JTabbedPane tabs = new JTabbedPane(1);
        tabs.setOpaque(false);
        Player player = this.getMyPlayer();
        JPanel recruitingPanel = new JPanel((LayoutManager)new MigLayout("center, wrap 1"));
        if (player.getCurrentFather() == null) {
            recruitingPanel.add((Component)new JLabel(none), "wrap 20");
        } else {
            FoundingFather father = player.getCurrentFather();
            JLabel currentFatherLabel = new JLabel(Messages.message(father.getNameKey()), new ImageIcon(this.getLibrary().getFoundingFatherImage(father)), 0);
            currentFatherLabel.setToolTipText(Messages.message(father.getDescriptionKey()));
            currentFatherLabel.setVerticalTextPosition(1);
            currentFatherLabel.setHorizontalTextPosition(0);
            recruitingPanel.add(currentFatherLabel);
            GoodsType bellsType = this.getSpecification().getGoodsType("model.goods.bells");
            FreeColProgressBar progressBar = new FreeColProgressBar(this.getCanvas(), bellsType);
            int total = 0;
            for (Colony colony : player.getColonies()) {
                total += colony.getNetProductionOf(bellsType);
            }
            int bells = player.getLiberty();
            int required = player.getTotalFoundingFatherCost();
            progressBar.update(0, required, bells, total);
            recruitingPanel.add((Component)progressBar, "wrap 20");
        }
        tabs.addTab(Messages.message("report.continentalCongress.recruiting"), null, recruitingPanel, null);
        EnumMap<FoundingFather.FoundingFatherType, JPanel> panels = new EnumMap<FoundingFather.FoundingFatherType, JPanel>(FoundingFather.FoundingFatherType.class);
        for (FoundingFather.FoundingFatherType type : FoundingFather.FoundingFatherType.values()) {
            JPanel panel = new JPanel((LayoutManager)new MigLayout("wrap 2, flowy", "[center]"));
            panels.put(type, panel);
            JScrollPane scrollPane = new JScrollPane(panel, 20, 30);
            tabs.addTab(Messages.message(FoundingFather.getTypeKey(type)), null, scrollPane, null);
        }
        for (FoundingFather father : this.getSpecification().getFoundingFathers()) {
            JPanel panel = (JPanel)panels.get((Object)father.getType());
            Image image = player.hasFather(father) ? this.getLibrary().getFoundingFatherImage(father) : ResourceManager.getGrayscaleImage(father.getId() + ".image", 1.0);
            panel.add(new JLabel(new ImageIcon(image)));
            JButton button = ReportContinentalCongressPanel.getLinkButton(Messages.message(father.getNameKey()), null, father.getId());
            button.addActionListener(this);
            panel.add(button);
        }
        this.setMainComponent(tabs);
    }
}

