/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ReportLabourDetailPanel;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;

public final class ReportLabourPanel
extends ReportPanel
implements ActionListener {
    private TypeCountMap<UnitType> unitCount;
    private TypeCountMap<UnitType> unitAtSea;
    private TypeCountMap<UnitType> unitOnLand;
    private TypeCountMap<UnitType> unitInEurope;
    private Map<UnitType, Map<Colony, Integer>> unitLocations;
    private List<Colony> colonies = this.getMyPlayer().getColonies();

    public ReportLabourPanel(Canvas parent) {
        super(parent, Messages.message("reportLabourAction.name"));
        this.gatherData();
        this.displayData();
    }

    public void gatherData() {
        this.unitCount = new TypeCountMap();
        this.unitAtSea = new TypeCountMap();
        this.unitOnLand = new TypeCountMap();
        this.unitInEurope = new TypeCountMap();
        this.unitLocations = new HashMap<UnitType, Map<Colony, Integer>>();
        for (UnitType type : this.getSpecification().getUnitTypeList()) {
            this.unitLocations.put(type, new HashMap());
        }
        Collections.sort(this.colonies, this.getClient().getClientOptions().getColonyComparator());
        Iterator<Unit> units = this.getMyPlayer().getUnitIterator();
        while (units.hasNext()) {
            Unit unit = units.next();
            UnitType type = unit.getType();
            Location location = unit.getLocation();
            this.unitCount.incrementCount(type, 1);
            if (location instanceof WorkLocation) {
                this.incrementColonyCount(((WorkLocation)location).getColony(), type);
                continue;
            }
            if (location instanceof Europe) {
                this.unitInEurope.incrementCount(type, 1);
                continue;
            }
            if (location instanceof Tile && ((Tile)location).getSettlement() != null) {
                this.incrementColonyCount((Colony)((Tile)location).getSettlement(), type);
                continue;
            }
            if (location instanceof Unit) {
                this.unitAtSea.incrementCount(type, 1);
                continue;
            }
            this.unitOnLand.incrementCount(type, 1);
        }
    }

    private void incrementColonyCount(Colony colony, UnitType type) {
        Integer count = this.unitLocations.get(type).get(colony);
        if (count == null) {
            this.unitLocations.get(type).put(colony, new Integer(1));
        } else {
            this.unitLocations.get(type).put(colony, new Integer(count + 1));
        }
    }

    public void displayData() {
        List<UnitType> unitTypes = this.getSpecification().getUnitTypeList();
        ArrayList<UnitType> colonists = new ArrayList<UnitType>();
        for (UnitType unitType : unitTypes) {
            if (!unitType.hasSkill()) continue;
            colonists.add(unitType);
        }
        this.reportPanel.setLayout((LayoutManager)new MigLayout("wrap 6", "[]30[]30[]", ""));
        for (UnitType unitType : colonists) {
            Unit.Role role = Unit.Role.DEFAULT;
            if (unitType.hasAbility("model.ability.expertPioneer")) {
                role = Unit.Role.PIONEER;
            } else if (unitType.hasAbility("model.ability.expertMissionary")) {
                role = Unit.Role.MISSIONARY;
            }
            int unitTypeCount = this.unitCount.getCount(unitType);
            if (unitTypeCount == 0) {
                this.reportPanel.add(this.createUnitTypeLabel(unitType, role, 0));
                JLabel unitName = this.localizedLabel(unitType.getNameKey());
                unitName.setForeground(Color.GRAY);
                this.reportPanel.add(unitName);
                continue;
            }
            this.reportPanel.add(this.createUnitTypeLabel(unitType, role, unitTypeCount));
            JButton linkButton = ReportLabourPanel.getLinkButton(Messages.message(unitType.getNameKey()), null, unitType.getId());
            linkButton.addActionListener(this);
            this.reportPanel.add(linkButton);
        }
    }

    private JPanel createUnitDetails(UnitType unitType, ReportLabourDetailPanel report) {
        JLabel countLabel;
        JPanel detailPanel = new JPanel((LayoutManager)new MigLayout("wrap 7", "[]30[][]30[][]30[][]", ""));
        detailPanel.setOpaque(false);
        Unit.Role role = Unit.Role.DEFAULT;
        if (unitType.hasAbility("model.ability.expertPioneer")) {
            role = Unit.Role.PIONEER;
        } else if (unitType.hasAbility("model.ability.expertMissionary")) {
            role = Unit.Role.MISSIONARY;
        }
        detailPanel.add((Component)new JLabel(this.getLibrary().getUnitImageIcon(unitType, role)), "spany");
        detailPanel.add(this.localizedLabel(unitType.getNameKey()));
        detailPanel.add((Component)new JLabel(String.valueOf(this.unitCount.getCount(unitType))), "wrap 10");
        boolean canTrain = false;
        for (Colony colony : this.colonies) {
            if (this.unitLocations.get(unitType).get(colony) == null) continue;
            String colonyName = colony.getName();
            if (colony.canTrain(unitType)) {
                canTrain = true;
                colonyName = colonyName + "*";
            }
            JButton colonyButton = ReportLabourPanel.getLinkButton(colonyName, null, colony.getId());
            colonyButton.addActionListener(report);
            detailPanel.add(colonyButton);
            JLabel countLabel2 = new JLabel(this.unitLocations.get(unitType).get(colony).toString());
            countLabel2.setForeground(LINK_COLOR);
            detailPanel.add(countLabel2);
        }
        if (this.unitInEurope.getCount(unitType) > 0) {
            JButton europeButton = ReportLabourPanel.getLinkButton(Messages.message(this.getMyPlayer().getEurope().getNameKey()), null, this.getMyPlayer().getEurope().getId());
            europeButton.addActionListener(report);
            detailPanel.add(europeButton);
            countLabel = new JLabel(String.valueOf(this.unitInEurope.getCount(unitType)));
            countLabel.setForeground(LINK_COLOR);
            detailPanel.add(countLabel);
        }
        if (this.unitOnLand.getCount(unitType) > 0) {
            JLabel onLandLabel = new JLabel(Messages.message("report.onLand"));
            detailPanel.add(onLandLabel);
            countLabel = new JLabel(String.valueOf(this.unitOnLand.getCount(unitType)));
            detailPanel.add(countLabel);
        }
        if (this.unitAtSea.getCount(unitType) > 0) {
            JLabel atSeaLabel = new JLabel(Messages.message("report.atSea"));
            detailPanel.add(atSeaLabel);
            countLabel = new JLabel(String.valueOf(this.unitAtSea.getCount(unitType)));
            detailPanel.add(countLabel);
        }
        if (canTrain) {
            detailPanel.add((Component)new JLabel(Messages.message("report.labour.canTrain")), "newline 20, span");
        }
        return detailPanel;
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if ("OK".equals(command)) {
            super.actionPerformed(event);
        } else {
            UnitType unitType = this.getSpecification().getUnitType(command);
            ReportLabourDetailPanel details = new ReportLabourDetailPanel(this.getCanvas());
            details.setDetailPanel(this.createUnitDetails(unitType, details));
            this.getCanvas().addAsFrame(details);
            details.requestFocus();
        }
    }
}

