/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;

public final class ReportRequirementsPanel
extends ReportPanel {
    private List<Colony> colonies;
    private Map<Colony, TypeCountMap<UnitType>> unitCount = new HashMap<Colony, TypeCountMap<UnitType>>();
    private Map<Colony, Set<UnitType>> canTrain = new HashMap<Colony, Set<UnitType>>();

    public ReportRequirementsPanel(Canvas parent) {
        super(parent, Messages.message("reportRequirementsAction.name"));
        Player player = this.getMyPlayer();
        this.colonies = player.getColonies();
        Collections.sort(this.colonies, this.getClient().getClientOptions().getColonyComparator());
        JTextPane textPane = ReportRequirementsPanel.getDefaultTextPane();
        StyledDocument doc = textPane.getStyledDocument();
        for (Colony colony : this.colonies) {
            TypeCountMap<UnitType> newUnitCount = new TypeCountMap<UnitType>();
            HashSet<UnitType> newCanTrain = new HashSet<UnitType>();
            for (Unit unit : colony.getUnitList()) {
                newUnitCount.incrementCount(unit.getType(), 1);
                if (!colony.canTrain(unit.getType())) continue;
                newCanTrain.add(unit.getType());
            }
            this.unitCount.put(colony, newUnitCount);
            this.canTrain.put(colony, newCanTrain);
        }
        for (Colony colony : this.colonies) {
            try {
                if (doc.getLength() > 0) {
                    doc.insertString(doc.getLength(), "\n\n", doc.getStyle("regular"));
                }
                StyleConstants.setComponent(doc.getStyle("button"), this.createColonyButton(colony, true));
                doc.insertString(doc.getLength(), " ", doc.getStyle("button"));
            }
            catch (Exception e) {
                logger.warning(e.toString());
            }
            HashSet<UnitType> missingExpertWarning = new HashSet<UnitType>();
            HashSet<UnitType> badAssignmentWarning = new HashSet<UnitType>();
            HashSet<GoodsType> productionWarning = new HashSet<GoodsType>();
            for (Unit expert : colony.getUnitList()) {
                if (expert.getSkillLevel() <= 0) continue;
                GoodsType production = expert.getWorkType();
                GoodsType expertise = expert.getType().getExpertProduction();
                if (production == null || expertise == null || production == expertise) continue;
                for (Unit nonExpert : colony.getUnitList()) {
                    if (nonExpert.getWorkType() != expertise || nonExpert.getType() == expert.getType()) continue;
                    int expertProductionNow = 0;
                    int nonExpertProductionNow = 0;
                    int expertProductionPotential = 0;
                    int nonExpertProductionPotential = 0;
                    if (expert.getWorkTile() != null) {
                        expertProductionNow = expert.getWorkTile().getProductionOf(expert, expertise);
                        nonExpertProductionPotential = expert.getWorkTile().getProductionOf(nonExpert, expertise);
                    } else if (expert.getWorkBuilding() != null) {
                        expertProductionNow = expert.getWorkBuilding().getUnitProductivity(expert);
                        nonExpertProductionPotential = expert.getWorkBuilding().getUnitProductivity(nonExpert);
                    }
                    if (nonExpert.getWorkTile() != null) {
                        nonExpertProductionNow = nonExpert.getWorkTile().getProductionOf(nonExpert, expertise);
                        expertProductionPotential = nonExpert.getWorkTile().getProductionOf(expert, expertise);
                    } else if (nonExpert.getWorkBuilding() != null) {
                        nonExpertProductionNow = nonExpert.getWorkBuilding().getUnitProductivity(nonExpert);
                        expertProductionPotential = nonExpert.getWorkBuilding().getUnitProductivity(expert);
                    }
                    if (expertProductionNow + nonExpertProductionNow >= expertProductionPotential + nonExpertProductionPotential || badAssignmentWarning.contains(expert)) continue;
                    this.addBadAssignmentWarning(doc, colony, expert, nonExpert);
                    badAssignmentWarning.add(expert.getType());
                }
            }
            for (ColonyTile colonyTile : colony.getColonyTiles()) {
                Unit unit = colonyTile.getUnit();
                if (unit == null) continue;
                GoodsType workType = unit.getWorkType();
                UnitType expert = this.getSpecification().getExpertForProducing(workType);
                if (this.unitCount.get(colony).getCount(expert) != 0 || missingExpertWarning.contains(expert)) continue;
                this.addExpertWarning(doc, colony, workType, expert);
                missingExpertWarning.add(expert);
            }
            for (Building building : colony.getBuildings()) {
                GoodsType goodsType = building.getGoodsOutputType();
                UnitType expert = building.getExpertUnitType();
                if (goodsType != null && expert != null && building.getFirstUnit() != null && !missingExpertWarning.contains(expert) && this.unitCount.get(colony).getCount(expert) == 0) {
                    this.addExpertWarning(doc, colony, goodsType, expert);
                    missingExpertWarning.add(expert);
                }
                if (goodsType == null || building.getProductionInfo().hasMaximumProduction() || productionWarning.contains(goodsType)) continue;
                this.addProductionWarning(doc, colony, goodsType, building.getGoodsInputType());
                productionWarning.add(goodsType);
            }
            if (missingExpertWarning.isEmpty() && badAssignmentWarning.isEmpty() && productionWarning.isEmpty()) {
                try {
                    doc.insertString(doc.getLength(), "\n\n" + Messages.message("report.requirements.met"), doc.getStyle("regular"));
                }
                catch (Exception e) {
                    logger.warning(e.toString());
                }
            }
            int width = ((JViewport)this.reportPanel.getParent()).getWidth();
            this.reportPanel.setLayout((LayoutManager)new MigLayout("width " + width + "!"));
            this.reportPanel.add(textPane);
        }
        textPane.setCaretPosition(0);
    }

    private void addBadAssignmentWarning(StyledDocument doc, Colony colony, Unit expert, Unit nonExpert) {
        GoodsType expertGoods = expert.getWorkType();
        GoodsType nonExpertGoods = nonExpert.getWorkType();
        String colonyName = colony.getName();
        String expertName = Messages.message(expert.getType().getNameKey());
        String nonExpertName = Messages.message(nonExpert.getType().getNameKey());
        String expertProductionName = Messages.message(expertGoods.getWorkingAsKey());
        String nonExpertProductionName = Messages.message(nonExpertGoods.getWorkingAsKey());
        String newMessage = Messages.message(StringTemplate.template("report.requirements.badAssignment").addName("%colony%", colonyName).addName("%expert%", expertName).addName("%expertWork%", expertProductionName).addName("%nonExpert%", nonExpertName).addName("%nonExpertWork%", nonExpertProductionName));
        try {
            doc.insertString(doc.getLength(), "\n\n" + newMessage, doc.getStyle("regular"));
        }
        catch (Exception e) {
            logger.warning(e.toString());
        }
    }

    private void addExpertWarning(StyledDocument doc, Colony c, GoodsType goodsType, UnitType workType) {
        String newMessage = Messages.message(StringTemplate.template("report.requirements.noExpert").addName("%colony%", c.getName()).addName("%goods%", goodsType).addName("%unit%", workType));
        try {
            Colony colony;
            doc.insertString(doc.getLength(), "\n\n" + newMessage, doc.getStyle("regular"));
            ArrayList<Colony> misusedExperts = new ArrayList<Colony>();
            ArrayList<Colony> severalExperts = new ArrayList<Colony>();
            ArrayList<Colony> canTrainExperts = new ArrayList<Colony>();
            for (Colony colony2 : this.colonies) {
                for (Unit unit : colony2.getUnitList()) {
                    GoodsType expertise = unit.getType().getExpertProduction();
                    if (unit.getSkillLevel() <= 0 || expertise != goodsType || expertise == unit.getWorkType()) continue;
                    misusedExperts.add(colony2);
                }
                if (this.unitCount.get(colony2).getCount(workType) > 1) {
                    severalExperts.add(colony2);
                }
                if (!this.canTrain.get(colony2).contains(workType)) continue;
                canTrainExperts.add(colony2);
            }
            if (!misusedExperts.isEmpty()) {
                doc.insertString(doc.getLength(), "\n" + Messages.message(StringTemplate.template("report.requirements.misusedExperts").addName("%unit%", workType).add("%work%", goodsType.getWorkingAsKey())) + " ", doc.getStyle("regular"));
                int lastExpertsIndex = misusedExperts.size() - 1;
                for (int index = 0; index <= lastExpertsIndex; ++index) {
                    colony = (Colony)misusedExperts.get(index);
                    StyleConstants.setComponent(doc.getStyle("button"), this.createColonyButton(colony, false));
                    doc.insertString(doc.getLength(), " ", doc.getStyle("button"));
                    if (index == lastExpertsIndex) continue;
                    doc.insertString(doc.getLength(), ", ", doc.getStyle("regular"));
                }
            }
            if (!severalExperts.isEmpty()) {
                doc.insertString(doc.getLength(), "\n" + Messages.message(StringTemplate.template("report.requirements.severalExperts").addName("%unit%", workType)) + " ", doc.getStyle("regular"));
                int lastExpertsIndex = severalExperts.size() - 1;
                for (int index = 0; index <= lastExpertsIndex; ++index) {
                    colony = (Colony)severalExperts.get(index);
                    StyleConstants.setComponent(doc.getStyle("button"), this.createColonyButton(colony, false));
                    doc.insertString(doc.getLength(), " ", doc.getStyle("button"));
                    if (index == lastExpertsIndex) continue;
                    doc.insertString(doc.getLength(), ", ", doc.getStyle("regular"));
                }
            }
            if (!canTrainExperts.isEmpty()) {
                doc.insertString(doc.getLength(), "\n" + Messages.message(StringTemplate.template("report.requirements.canTrainExperts").addName("%unit%", workType)) + " ", doc.getStyle("regular"));
                int lastExpertsIndex = canTrainExperts.size() - 1;
                for (int index = 0; index <= lastExpertsIndex; ++index) {
                    colony = (Colony)canTrainExperts.get(index);
                    StyleConstants.setComponent(doc.getStyle("button"), this.createColonyButton(colony, false));
                    doc.insertString(doc.getLength(), " ", doc.getStyle("button"));
                    if (index == lastExpertsIndex) continue;
                    doc.insertString(doc.getLength(), ", ", doc.getStyle("regular"));
                }
            }
        }
        catch (Exception e) {
            logger.warning(e.toString());
        }
    }

    private void addProductionWarning(StyledDocument doc, Colony colony, GoodsType output, GoodsType input) {
        String colonyName = colony.getName();
        String newMessage = Messages.message(StringTemplate.template("report.requirements.missingGoods").addName("%colony%", colonyName).add("%goods%", output.getNameKey()).add("%input%", input.getNameKey()));
        try {
            doc.insertString(doc.getLength(), "\n\n" + newMessage, doc.getStyle("regular"));
            ArrayList<Colony> withSurplus = new ArrayList<Colony>();
            ArrayList<Integer> theSurplus = new ArrayList<Integer>();
            for (Colony col : this.colonies) {
                int amount = colony.getAdjustedNetProductionOf(input);
                if (amount <= 0) continue;
                withSurplus.add(col);
                theSurplus.add(amount);
            }
            if (!withSurplus.isEmpty()) {
                String amount;
                doc.insertString(doc.getLength(), "\n" + Messages.message(StringTemplate.template("report.requirements.surplus").add("%goods%", input.getNameKey())) + " ", doc.getStyle("regular"));
                for (int index = 0; index < withSurplus.size() - 1; ++index) {
                    amount = " (" + theSurplus.get(index) + ")";
                    StyleConstants.setComponent(doc.getStyle("button"), this.createColonyButton((Colony)withSurplus.get(index), amount, false));
                    doc.insertString(doc.getLength(), " ", doc.getStyle("button"));
                    doc.insertString(doc.getLength(), ", ", doc.getStyle("regular"));
                }
                Colony lastColony = (Colony)withSurplus.get(withSurplus.size() - 1);
                amount = " (" + theSurplus.get(theSurplus.size() - 1) + ")";
                StyleConstants.setComponent(doc.getStyle("button"), this.createColonyButton(lastColony, amount, false));
                doc.insertString(doc.getLength(), " ", doc.getStyle("button"));
            }
        }
        catch (Exception e) {
            logger.warning(e.toString());
        }
    }

    private JButton createColonyButton(Colony colony, boolean headline) {
        return this.createColonyButton(colony, "", headline);
    }

    private JButton createColonyButton(Colony colony, String info, boolean headline) {
        JButton button = ReportRequirementsPanel.getLinkButton(colony.getName() + info, null, colony.getId());
        if (headline) {
            button.setFont(smallHeaderFont);
        }
        button.addActionListener(this);
        return button;
    }
}

