/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.EuropePanel;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TrainDialog
extends FreeColDialog<Integer>
implements ActionListener {
    private static final Logger logger = Logger.getLogger(TrainDialog.class.getName());
    private final JLabel question;
    private final List<UnitType> trainableUnits = new ArrayList<UnitType>();
    private final Comparator<UnitType> unitPriceComparator;

    public TrainDialog(Canvas parent, EuropePanel.EuropeAction europeAction) {
        super(parent);
        this.okButton.setText(Messages.message("trainDialog.done"));
        final Europe europe = this.getMyPlayer().getEurope();
        this.unitPriceComparator = new Comparator<UnitType>(){

            @Override
            public int compare(UnitType type1, UnitType type2) {
                return europe.getUnitPrice(type1) - europe.getUnitPrice(type2);
            }
        };
        switch (europeAction) {
            case TRAIN: {
                this.trainableUnits.addAll(this.getSpecification().getUnitTypesTrainedInEurope());
                this.question = new JLabel(Messages.message("trainDialog.clickOn"));
                this.setLayout((LayoutManager)new MigLayout("wrap 3", "[sg]", ""));
                break;
            }
            default: {
                this.trainableUnits.addAll(this.getSpecification().getUnitTypesPurchasedInEurope());
                this.question = new JLabel(Messages.message("purchaseDialog.clickOn"));
                this.setLayout((LayoutManager)new MigLayout("wrap 2", "[sg]", ""));
            }
        }
    }

    @Override
    public void initialize() {
        this.removeAll();
        this.add((Component)this.question, "span, wrap 20");
        Player player = this.getMyPlayer();
        Europe europe = player.getEurope();
        Collections.sort(this.trainableUnits, this.unitPriceComparator);
        for (UnitType unitType : this.trainableUnits) {
            int price = europe.getUnitPrice(unitType);
            JButton newButton = new JButton();
            newButton.setLayout((LayoutManager)new MigLayout("wrap 2", "[60]", "[30][30]"));
            ImageIcon unitIcon = this.getLibrary().getUnitImageIcon(unitType, Unit.Role.DEFAULT, !player.checkGold(price), 0.66);
            JLabel unitName = this.localizedLabel(unitType.getNameKey());
            JLabel unitPrice = this.localizedLabel(StringTemplate.template("goldAmount").addAmount("%amount%", price));
            if (!player.checkGold(price)) {
                unitName.setEnabled(false);
                unitPrice.setEnabled(false);
                newButton.setEnabled(false);
            }
            newButton.add((Component)new JLabel(unitIcon), "span 1 2");
            newButton.add(unitName);
            newButton.add(unitPrice);
            newButton.setActionCommand(unitType.getId());
            newButton.addActionListener(this);
            TrainDialog.enterPressesWhenFocused(newButton);
            this.add((Component)newButton, "grow");
        }
        this.add((Component)this.okButton, "newline 20, span, tag ok");
        this.setSize(this.getPreferredSize());
        this.revalidate();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if ("OK".equals(command)) {
            this.setResponse(new Integer(-1));
        } else {
            UnitType unitType = this.getSpecification().getUnitType(command);
            this.getController().trainUnitInEurope(unitType);
            this.initialize();
        }
    }
}

