/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.ReportHighScoresPanel;
import net.sf.freecol.common.resources.ResourceManager;

public final class VictoryPanel
extends FreeColPanel {
    private static final Logger logger = Logger.getLogger(VictoryPanel.class.getName());
    private static final String CONTINUE = "CONTINUE";
    private JButton continueButton = new JButton(Messages.message("victory.continue"));

    public VictoryPanel(Canvas parent) {
        super(parent);
        this.okButton.setText(Messages.message("victory.yes"));
        this.setLayout((LayoutManager)new MigLayout("wrap 1", "", ""));
        this.add((Component)VictoryPanel.getDefaultHeader(Messages.message("victory.text")), "align center, wrap 20");
        Image tempImage = ResourceManager.getImage("VictoryImage");
        if (tempImage != null) {
            this.add((Component)new JLabel(new ImageIcon(tempImage)), "align center");
        }
        this.continueButton.setActionCommand(CONTINUE);
        this.continueButton.addActionListener(this);
        VictoryPanel.enterPressesWhenFocused(this.continueButton);
        if (parent.getClient().isSingleplayer()) {
            this.add((Component)this.okButton, "newline 20, split 2, tag ok");
            this.add(this.continueButton);
        } else {
            this.add((Component)this.okButton, "newline 20, tag ok");
        }
        this.setSize(this.getPreferredSize());
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        Canvas canvas = this.getCanvas();
        if ("OK".equals(command)) {
            boolean high = this.getClient().retire();
            canvas.showPanel(new ReportHighScoresPanel(canvas), false);
            canvas.showInformationMessage(high ? "highscores.yes" : "highscores.no");
            this.getClient().quit();
        } else {
            this.getClient().continuePlaying();
            canvas.remove(this);
        }
    }
}

