/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.UnitType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BuildingType
extends BuildableType
implements Comparable<BuildingType> {
    private int level = 1;
    private int workPlaces = 3;
    private int basicProduction = 3;
    private int minSkill = Integer.MIN_VALUE;
    private int maxSkill = Integer.MAX_VALUE;
    private int upkeep = 0;
    private int priority = 800;
    private GoodsType consumes;
    private GoodsType produces;
    private Modifier productionModifier = null;
    private BuildingType upgradesFrom;
    private BuildingType upgradesTo;

    public BuildingType(String id, Specification specification) {
        super(id, specification);
        this.setModifierIndex(Modifier.BUILDING_PRODUCTION_INDEX);
    }

    public BuildingType getUpgradesFrom() {
        return this.upgradesFrom;
    }

    public BuildingType getUpgradesTo() {
        return this.upgradesTo;
    }

    public BuildingType getFirstLevel() {
        BuildingType buildingType = this;
        while (buildingType.getUpgradesFrom() != null) {
            buildingType = buildingType.getUpgradesFrom();
        }
        return buildingType;
    }

    public int getWorkPlaces() {
        return this.workPlaces;
    }

    public int getBasicProduction() {
        return this.basicProduction;
    }

    public GoodsType getConsumedGoodsType() {
        return this.consumes;
    }

    public GoodsType getProducedGoodsType() {
        return this.produces;
    }

    public int getLevel() {
        return this.level;
    }

    public int getUpkeep() {
        return this.upkeep;
    }

    public int getPriority() {
        return this.priority;
    }

    public FreeColGameObjectType getType() {
        return this;
    }

    public Modifier getProductionModifier() {
        return this.productionModifier;
    }

    @Override
    public int compareTo(BuildingType other) {
        return this.getIndex() - other.getIndex();
    }

    public boolean canAdd(UnitType unitType) {
        return unitType.hasSkill() && unitType.getSkill() >= this.minSkill && unitType.getSkill() <= this.maxSkill;
    }

    public boolean isAutomaticBuild() {
        return !this.needsGoodsToBuild() && this.getUpgradesFrom() == null;
    }

    @Override
    public final int getModifierIndex(Modifier modifier) {
        if (this.produces != null && this.produces.getId().equals(modifier.getId())) {
            return Modifier.AUTO_PRODUCTION_INDEX;
        }
        return this.getModifierIndex();
    }

    @Override
    public void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        String extendString = in.getAttributeValue(null, "extends");
        BuildingType parent = extendString == null ? this : this.getSpecification().getBuildingType(extendString);
        String upgradeString = in.getAttributeValue(null, "upgradesFrom");
        if (upgradeString == null) {
            this.level = 1;
        } else {
            this.upgradesFrom = this.getSpecification().getBuildingType(upgradeString);
            this.upgradesFrom.upgradesTo = this;
            this.level = this.upgradesFrom.level + 1;
        }
        this.setPopulationRequired(this.getAttribute(in, "required-population", parent.getPopulationRequired()));
        this.workPlaces = this.getAttribute(in, "workplaces", parent.workPlaces);
        this.basicProduction = this.getAttribute(in, "basicProduction", parent.basicProduction);
        this.consumes = this.getSpecification().getType(in, "consumes", GoodsType.class, parent.consumes);
        this.produces = this.getSpecification().getType(in, "produces", GoodsType.class, parent.produces);
        if (this.produces != null && this.basicProduction > 0) {
            this.productionModifier = new Modifier(this.produces.getId(), this, this.basicProduction, Modifier.Type.ADDITIVE);
        }
        this.minSkill = this.getAttribute(in, "minSkill", parent.minSkill);
        this.maxSkill = this.getAttribute(in, "maxSkill", parent.maxSkill);
        this.priority = this.getAttribute(in, "priority", parent.priority);
        this.upkeep = this.getAttribute(in, "upkeep", parent.upkeep);
        if (parent != this) {
            this.getFeatureContainer().add(parent.getFeatureContainer());
            if (parent.isAbstractType()) {
                this.getFeatureContainer().replaceSource(parent, this);
            }
        }
    }

    @Override
    public void readChildren(XMLStreamReader in) throws XMLStreamException {
        while (in.nextTag() != 2) {
            this.readChild(in);
        }
    }

    @Override
    public void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, BuildingType.getXMLElementTagName());
    }

    @Override
    public void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        if (this.upgradesFrom != null) {
            out.writeAttribute("upgradesFrom", this.upgradesFrom.getId());
        }
        out.writeAttribute("workplaces", Integer.toString(this.workPlaces));
        out.writeAttribute("basicProduction", Integer.toString(this.basicProduction));
        if (this.minSkill > Integer.MIN_VALUE) {
            out.writeAttribute("minSkill", Integer.toString(this.minSkill));
        }
        if (this.maxSkill < Integer.MAX_VALUE) {
            out.writeAttribute("maxSkill", Integer.toString(this.maxSkill));
        }
        if (this.upkeep > 0) {
            out.writeAttribute("upkeep", Integer.toString(this.upkeep));
        }
        if (this.priority != 800) {
            out.writeAttribute("priority", Integer.toString(this.priority));
        }
        if (this.consumes != null) {
            out.writeAttribute("consumes", this.consumes.getId());
        }
        if (this.produces != null) {
            out.writeAttribute("produces", this.produces.getId());
        }
    }

    public void fixup09x() {
        try {
            if (this.hasAbility("model.ability.autoProduction")) {
                if (!this.hasAbility("model.ability.avoidExcessProduction")) {
                    Ability ability = new Ability("model.ability.avoidExcessProduction");
                    this.addAbility(ability);
                    this.getFeatureContainer().removeModifiers("model.goods.horses");
                    float value = "model.building.country".equals(this.getId()) ? 50.0f : 25.0f;
                    Modifier modifier = new Modifier("model.modifier.breedingDivisor", this, value, Modifier.Type.ADDITIVE);
                    this.addModifier(modifier);
                    this.getSpecification().addModifier(modifier);
                    modifier = new Modifier("model.modifier.breedingFactor", this, 2.0f, Modifier.Type.ADDITIVE);
                    this.addModifier(modifier);
                    this.getSpecification().addModifier(modifier);
                }
                if (this.getModifierSet("model.modifier.consumeOnlySurplusProduction").isEmpty()) {
                    Modifier modifier = new Modifier("model.modifier.consumeOnlySurplusProduction", this, 0.5f, Modifier.Type.MULTIPLICATIVE);
                    this.addModifier(modifier);
                    this.getSpecification().addModifier(modifier);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getXMLElementTagName() {
        return "building-type";
    }
}

