/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Player;
import org.w3c.dom.Element;

public class HighScore
extends FreeColObject {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
    private int independenceTurn = -1;
    private String playerName;
    private String nationID;
    private String nationTypeID;
    private int score;
    private Level level;
    private String nationName;
    private String difficulty;
    private int units;
    private int colonies;
    private String newLandName;
    private Date date;
    private int retirementTurn;

    public HighScore(Player player, Date theDate) {
        this.date = theDate;
        this.retirementTurn = player.getGame().getTurn().getNumber();
        this.score = player.getScore();
        for (Level someLevel : Level.values()) {
            if (this.score < someLevel.getMinimumScore()) continue;
            this.level = someLevel;
            break;
        }
        this.playerName = player.getName();
        this.nationID = player.getNationID();
        this.nationTypeID = player.getNationType().getId();
        this.colonies = player.getColonies().size();
        this.units = player.getUnits().size();
        if (player.getPlayerType() == Player.PlayerType.INDEPENDENT) {
            this.independenceTurn = player.getGame().getTurn().getNumber();
            this.nationName = player.getIndependentNationName();
        } else {
            this.independenceTurn = -1;
        }
        this.difficulty = "model.difficulty.medium";
        this.newLandName = player.getNewLandName();
    }

    public HighScore(XMLStreamReader in) throws XMLStreamException {
        this.readFromXMLImpl(in);
    }

    public HighScore(Element element) throws XMLStreamException {
        this.readFromXMLElement(element);
    }

    public final int getIndependenceTurn() {
        return this.independenceTurn;
    }

    public final void setIndependenceTurn(int newIndependenceTurn) {
        this.independenceTurn = newIndependenceTurn;
    }

    public final int getRetirementTurn() {
        return this.retirementTurn;
    }

    public final void setRetirementTurn(int newRetirementTurn) {
        this.retirementTurn = newRetirementTurn;
    }

    public final String getPlayerName() {
        return this.playerName;
    }

    public final void setPlayerName(String newPlayerName) {
        this.playerName = newPlayerName;
    }

    public final String getNationID() {
        return this.nationID;
    }

    public final void setNationID(String newNationID) {
        this.nationID = newNationID;
    }

    public final String getNationTypeID() {
        return this.nationTypeID;
    }

    public final void setNationTypeID(String newNationTypeID) {
        this.nationTypeID = newNationTypeID;
    }

    public final int getScore() {
        return this.score;
    }

    public final void setScore(int newScore) {
        this.score = newScore;
    }

    public final Level getLevel() {
        return this.level;
    }

    public final void setLevel(Level newLevel) {
        this.level = newLevel;
    }

    public final String getOldNationNameKey() {
        return this.nationID + ".name";
    }

    public final String getNationName() {
        return this.nationName;
    }

    public final void setNationName(String newNationName) {
        this.nationName = newNationName;
    }

    public final String getNewLandName() {
        return this.newLandName;
    }

    public final void setNewLandName(String newNewLandName) {
        this.newLandName = newNewLandName;
    }

    public final String getDifficulty() {
        return this.difficulty;
    }

    public final void setDifficulty(String newDifficulty) {
        this.difficulty = newDifficulty;
    }

    public final int getUnits() {
        return this.units;
    }

    public final void setUnits(int newUnits) {
        this.units = newUnits;
    }

    public final int getColonies() {
        return this.colonies;
    }

    public final void setColonies(int newColonies) {
        this.colonies = newColonies;
    }

    public final Date getDate() {
        return this.date;
    }

    public final void setDate(Date newDate) {
        this.date = newDate;
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(HighScore.getXMLElementTagName());
        out.writeAttribute("date", dateFormat.format(this.date));
        out.writeAttribute("retirementTurn", Integer.toString(this.retirementTurn));
        out.writeAttribute("independenceTurn", Integer.toString(this.independenceTurn));
        out.writeAttribute("playerName", this.playerName);
        out.writeAttribute("nationID", this.nationID);
        out.writeAttribute("nationTypeID", this.nationTypeID);
        out.writeAttribute("score", Integer.toString(this.score));
        out.writeAttribute("level", this.level.toString());
        if (this.nationName != null) {
            out.writeAttribute("nationName", this.nationName);
        }
        if (this.newLandName != null) {
            out.writeAttribute("newLandName", this.newLandName);
        }
        out.writeAttribute("difficulty", this.difficulty);
        out.writeAttribute("units", Integer.toString(this.units));
        out.writeAttribute("colonies", Integer.toString(this.colonies));
        out.writeEndElement();
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        try {
            this.date = dateFormat.parse(this.getAttribute(in, "date", "2008-01-01 00:00:00+0000"));
        }
        catch (Exception e) {
            logger.warning(e.toString());
            this.date = new Date();
        }
        this.retirementTurn = this.getAttribute(in, "retirementTurn", 0);
        this.independenceTurn = this.getAttribute(in, "independenceTurn", 0);
        this.playerName = this.getAttribute(in, "playerName", "");
        this.nationID = this.getAttribute(in, "nationID", "model.nation.dutch");
        this.nationTypeID = this.getAttribute(in, "nationTypeID", "model.nationType.trade");
        this.score = this.getAttribute(in, "score", 0);
        this.level = Enum.valueOf(Level.class, this.getAttribute(in, "level", "PARASITIC_WORM"));
        this.nationName = this.getAttribute(in, "nationName", null);
        this.newLandName = this.getAttribute(in, "newLandName", "New World");
        this.difficulty = this.getAttribute(in, "difficulty", "model.difficulty.medium");
        this.units = this.getAttribute(in, "units", 0);
        this.colonies = this.getAttribute(in, "colonies", 0);
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "highScore";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        CONTINENT(40000),
        COUNTRY(35000),
        STATE(30000),
        CITY(25000),
        MOUNTAIN_RANGE(20000),
        RIVER(15000),
        INSTITUTE(12000),
        UNIVERSITY(10000),
        STREET(8000),
        SCHOOL(7000),
        BIRD_OF_PREY(6000),
        TREE(5000),
        FLOWER(4000),
        RODENT(3200),
        FOUL_SMELLING_PLANT(2400),
        POISONOUS_PLANT(1600),
        SLIME_MOLD_BEETLE(800),
        BLOOD_SUCKING_INSECT(400),
        INFECTIOUS_DISEASE(200),
        PARASITIC_WORM(0);

        private int minimumScore;

        private Level(int minimumScore) {
            this.minimumScore = minimumScore;
        }

        public int getMinimumScore() {
            return this.minimumScore;
        }
    }
}

