/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.PlayerExploredTile;
import net.sf.freecol.common.model.RandomRange;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndianSettlement
extends Settlement {
    private static final Logger logger = Logger.getLogger(IndianSettlement.class.getName());
    public static final int TALES_RADIUS = 6;
    public static final String UNITS_TAG_NAME = "units";
    public static final String OWNED_UNITS_TAG_NAME = "ownedUnits";
    public static final String IS_VISITED_TAG_NAME = "isVisited";
    public static final String ALARM_TAG_NAME = "alarm";
    public static final String MISSIONARY_TAG_NAME = "missionary";
    public static final String WANTED_GOODS_TAG_NAME = "wantedGoods";
    public static final int GOODS_BASE_PRICE = 12;
    public static final int GOODS_CAPACITY = 200;
    public static final int KEEP_RAW_MATERIAL = 50;
    protected UnitType learnableSkill = null;
    protected GoodsType[] wantedGoods = new GoodsType[]{null, null, null};
    protected Set<Player> spokenTo = new HashSet<Player>();
    protected List<Unit> units = Collections.emptyList();
    protected ArrayList<Unit> ownedUnits = new ArrayList();
    protected Unit missionary = null;
    protected int convertProgress = 0;
    protected int lastTribute = 0;
    private Map<Player, Tension> alarm = new HashMap<Player, Tension>();
    private final Comparator<GoodsType> wantedGoodsComparator = new Comparator<GoodsType>(){

        @Override
        public int compare(GoodsType goodsType1, GoodsType goodsType2) {
            return IndianSettlement.this.getPriceToBuy(goodsType2, 100) - IndianSettlement.this.getPriceToBuy(goodsType1, 100);
        }
    };
    private final Comparator<Goods> exportGoodsComparator = new Comparator<Goods>(){

        @Override
        public int compare(Goods goods1, Goods goods2) {
            if (goods2.getAmount() == goods1.getAmount()) {
                return IndianSettlement.this.getPriceToBuy(goods2) - IndianSettlement.this.getPriceToBuy(goods1);
            }
            return goods2.getAmount() - goods1.getAmount();
        }
    };

    protected IndianSettlement() {
    }

    protected IndianSettlement(Game game, Player owner, String name, Tile tile) {
        super(game, owner, name, tile);
    }

    public IndianSettlement(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
    }

    public IndianSettlement(Game game, Element e) {
        super(game, e);
        this.readFromXMLElement(e);
    }

    public IndianSettlement(Game game, String id) {
        super(game, id);
    }

    @Override
    public String getNameFor(Player player) {
        return this.hasContactedSettlement(player) ? this.getName() : "indianSettlement.nameUnknown";
    }

    @Override
    public String getImageKey() {
        return this.getOwner().getNationID() + (this.isCapital() ? ".capital" : ".settlement") + (this.getMissionary() == null ? "" : ".mission") + ".image";
    }

    @Override
    public StringTemplate getLocationName() {
        return StringTemplate.name(this.getName());
    }

    @Override
    public StringTemplate getLocationNameFor(Player player) {
        return StringTemplate.name(this.getNameFor(player));
    }

    public int getLastTribute() {
        return this.lastTribute;
    }

    public void setLastTribute(int lastTribute) {
        this.lastTribute = lastTribute;
    }

    public Tension getAlarm(Player player) {
        return this.alarm.get(player);
    }

    public void setAlarm(Player player, Tension newAlarm) {
        if (player != null && player != this.owner) {
            this.alarm.put(player, newAlarm);
        }
    }

    public void removeAlarm(Player player) {
        if (player != null) {
            this.alarm.remove(player);
        }
    }

    private boolean changeAlarm(Player player, int amount) {
        Tension alarm = this.getAlarm(player);
        Tension.Level oldLevel = alarm.getLevel();
        alarm.modify(amount);
        return oldLevel != alarm.getLevel();
    }

    public String getShortAlarmLevelMessageId(Player player) {
        return !player.hasContacted(this.owner) ? "wary" : (this.hasContactedSettlement(player) ? this.getAlarm(player).toString() : "indianSettlement.tensionUnknown");
    }

    public String getAlarmLevelMessageId(Player player) {
        Tension alarm = this.hasContactedSettlement(player) ? this.getAlarm(player) : new Tension(0);
        return "indianSettlement.alarm." + alarm.toString();
    }

    public boolean hasContactedSettlement(Player player) {
        return this.getAlarm(player) != null;
    }

    public boolean makeContactSettlement(Player player) {
        if (!this.hasContactedSettlement(player)) {
            this.setAlarm(player, new Tension(this.owner.getTension(player).getValue()));
            return true;
        }
        return false;
    }

    public List<FreeColGameObject> modifyAlarm(Player player, int addToAlarm) {
        boolean change = this.makeContactSettlement(player);
        List<FreeColGameObject> modified = this.owner.modifyTension(player, this.isCapital() ? addToAlarm : addToAlarm / 2, this);
        if (change |= this.changeAlarm(player, addToAlarm)) {
            modified.add(this);
        }
        logger.finest("Alarm at " + this.getName() + " toward " + player.getName() + " modified by " + Integer.toString(addToAlarm) + " now = " + Integer.toString(this.getAlarm(player).getValue()));
        return modified;
    }

    @Override
    public boolean propagateAlarm(Player player, int addToAlarm) {
        if (this.hasContactedSettlement(player)) {
            return this.changeAlarm(player, addToAlarm);
        }
        return false;
    }

    public boolean hasSpokenToChief() {
        Iterator<Player> playerIterator = this.spokenTo.iterator();
        while (playerIterator.hasNext()) {
            if (!playerIterator.next().isEuropean()) continue;
            return true;
        }
        return false;
    }

    public boolean hasSpokenToChief(Player player) {
        return this.spokenTo.contains(player);
    }

    public void setSpokenToChief(Player player) {
        if (!this.hasSpokenToChief(player)) {
            this.makeContactSettlement(player);
            this.spokenTo.add(player);
        }
    }

    public boolean allowContact(Unit unit) {
        return unit.getOwner().hasContacted(this.owner) || !unit.isNaval() || unit.getGoodsCount() > 0;
    }

    public void addOwnedUnit(Unit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Parameter 'unit' must not be 'null'.");
        }
        if (!this.ownedUnits.contains(unit)) {
            this.ownedUnits.add(unit);
        }
    }

    public List<Unit> getOwnedUnits() {
        return new ArrayList<Unit>(this.ownedUnits);
    }

    public Iterator<Unit> getOwnedUnitsIterator() {
        return this.ownedUnits.iterator();
    }

    public boolean removeOwnedUnit(Unit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Parameter 'unit' must not be 'null'.");
        }
        return this.ownedUnits.remove(unit);
    }

    public UnitType getLearnableSkill() {
        return this.learnableSkill;
    }

    public Unit getMissionary() {
        return this.missionary;
    }

    public void setMissionary(Unit missionary) {
        this.missionary = missionary;
    }

    public void changeMissionary(Unit missionary) {
        this.setMissionary(missionary);
        this.getTile().updatePlayerExploredTiles();
        if (missionary != null) {
            this.getTile().updatePlayerExploredTile(missionary.getOwner(), true);
        }
    }

    public Unit getMissionary(Player player) {
        return this.missionary == null || this.missionary.getOwner() != player ? null : this.missionary;
    }

    public int getConvertProgress() {
        return this.convertProgress;
    }

    public void setConvertProgress(int progress) {
        this.convertProgress = progress;
    }

    public GoodsType[] getWantedGoods() {
        return this.wantedGoods;
    }

    public void setWantedGoods(int index, GoodsType type) {
        if (0 <= index && index <= 2) {
            this.wantedGoods[index] = type;
        }
    }

    public void setLearnableSkill(UnitType skill) {
        this.learnableSkill = skill;
    }

    @Override
    public void add(Locatable locatable) {
        if (locatable instanceof Unit) {
            if (!this.units.contains(locatable)) {
                Unit indian = (Unit)locatable;
                if (((Object)this.units).equals(Collections.emptyList())) {
                    this.units = new ArrayList<Unit>();
                }
                this.units.add(indian);
                if (indian.getIndianSettlement() == null) {
                    indian.setIndianSettlement(this);
                }
            }
        } else if (locatable instanceof Goods) {
            this.addGoods((Goods)locatable);
        } else {
            logger.warning("Tried to add an unrecognized 'Locatable' to a IndianSettlement.");
        }
    }

    @Override
    public void remove(Locatable locatable) {
        if (locatable instanceof Unit) {
            if (!this.units.remove(locatable)) {
                logger.warning("Failed to remove unit " + ((Unit)locatable).getId() + " from IndianSettlement");
            }
        } else if (locatable instanceof Goods) {
            this.removeGoods((Goods)locatable);
        } else {
            logger.warning("Tried to remove an unrecognized 'Locatable' from a IndianSettlement.");
        }
    }

    @Override
    public Settlement getSettlement() {
        return this;
    }

    @Override
    public Colony getColony() {
        return null;
    }

    @Override
    public int getUnitCount() {
        return this.units.size();
    }

    @Override
    public List<Unit> getUnitList() {
        return this.units;
    }

    @Override
    public Iterator<Unit> getUnitIterator() {
        return this.units.iterator();
    }

    public Unit getFirstUnit() {
        if (this.units.isEmpty()) {
            return null;
        }
        return this.units.get(0);
    }

    public Unit getLastUnit() {
        if (this.units.isEmpty()) {
            return null;
        }
        return this.units.get(this.units.size() - 1);
    }

    @Override
    public Unit getDefendingUnit(Unit attacker) {
        Unit defender = null;
        float defencePower = -1.0f;
        for (Unit nextUnit : this.units) {
            float tmpPower = attacker.getGame().getCombatModel().getDefencePower(attacker, nextUnit);
            if (!(tmpPower > defencePower)) continue;
            defender = nextUnit;
            defencePower = tmpPower;
        }
        return defender;
    }

    @Override
    public RandomRange getPlunderRange(Unit attacker) {
        return this.getType().getPlunderRange(attacker);
    }

    public int getPriceToBuy(Goods goods) {
        return this.getPriceToBuy(goods.getType(), goods.getAmount());
    }

    public int getPriceToBuy(GoodsType type, int amount) {
        if (amount > 100) {
            throw new IllegalArgumentException("Amount > 100");
        }
        int price = 0;
        if (type.isMilitaryGoods()) {
            price = this.getMilitaryGoodsPriceToBuy(type, amount);
        }
        if (price == 0) {
            price = this.getNormalGoodsPriceToBuy(type, amount);
        }
        int wantedBase = 100;
        int wantedBonus = type == this.wantedGoods[0] ? 150 : (type == this.wantedGoods[1] ? 125 : (type == this.wantedGoods[2] ? 110 : 100));
        price = wantedBonus * price / 100;
        logger.finest("Full price(" + amount + " " + type + ")" + " -> " + price);
        return price;
    }

    private int getNormalGoodsPriceToBuy(GoodsType type, int amount) {
        int tradeGoodsAdd = 20;
        int current = this.getGoodsCount(type);
        GoodsType rawType = type.getRawMaterial();
        int add = 0;
        if (rawType != null) {
            int rawProduction = this.getMaximumProduction(rawType);
            add = rawProduction < 5 ? 10 * rawProduction : (rawProduction < 10 ? 5 * rawProduction + 25 : (rawProduction < 20 ? 2 * rawProduction + 55 : 100));
            add = (200 - Math.min(200, current)) * add / 200;
        }
        current += add;
        if (type.isTradeGoods()) {
            current += 20;
        }
        int valued = Math.max(0, Math.min(amount, 200 - current));
        int unitPrice = (12 + this.getType().getTradeBonus()) * (200 - current) / 200;
        if (type.isFarmed()) {
            unitPrice /= 2;
        }
        if (type.isRawBuildingMaterial()) {
            unitPrice /= 2;
        }
        int price = unitPrice < 0 ? 0 : valued * unitPrice;
        logger.finest("Normal price(" + amount + " " + type + ")" + " valued=" + valued + " current=" + this.getGoodsCount(type) + " + " + (current - this.getGoodsCount(type)) + " unitPrice=" + unitPrice + " -> " + price);
        return price;
    }

    private int getRequiredMilitaryGoodsAmount(GoodsType type) {
        Specification spec = this.getSpecification();
        int need = 0;
        int toArm = 0;
        if (type == spec.getGoodsType("model.goods.muskets")) {
            for (Unit u : this.ownedUnits) {
                if (u.isArmed()) continue;
                ++need;
            }
            toArm = spec.getEquipmentType("model.equipment.indian.muskets").getAmountRequiredOf(type);
        } else if (type == spec.getGoodsType("model.goods.horses")) {
            for (Unit u : this.ownedUnits) {
                if (u.isMounted()) continue;
                ++need;
            }
            toArm = spec.getEquipmentType("model.equipment.indian.horses").getAmountRequiredOf(type);
        }
        return need * toArm;
    }

    private int getMilitaryGoodsPriceToBuy(GoodsType type, int amount) {
        int full = 12 + this.getType().getTradeBonus();
        int required = this.getRequiredMilitaryGoodsAmount(type);
        if (required == 0) {
            return 0;
        }
        int valued = Math.max(0, required - this.getGoodsCount(type));
        int price = valued > amount / 2 ? full * amount : valued * full + this.getNormalGoodsPriceToBuy(type, amount - valued);
        logger.finest("Military price(" + amount + " " + type + ")" + " valued=" + valued + " -> " + price);
        return price;
    }

    public int getPriceToSell(Goods goods) {
        return this.getPriceToSell(goods.getType(), goods.getAmount());
    }

    public int getPriceToSell(GoodsType type, int amount) {
        if (amount > 100) {
            throw new IllegalArgumentException("Too many goods");
        }
        int full = 12 + this.getType().getTradeBonus();
        int price = amount + Math.max(0, this.getPriceToBuy(type, amount));
        if (type.isMilitaryGoods() && this.getRequiredMilitaryGoodsAmount(type) > 0) {
            price = Math.max(price, amount * full * 2);
        } else if (type.isTradeGoods()) {
            price = Math.max(price, 150 * amount * full / 100);
        }
        return price;
    }

    public List<Goods> getSellGoods(int limit) {
        List<Goods> settlementGoods = this.getCompactGoods();
        for (Goods goods : settlementGoods) {
            if (goods.getAmount() <= 100) continue;
            goods.setAmount(100);
        }
        Collections.sort(settlementGoods, this.exportGoodsComparator);
        ArrayList<Goods> result = new ArrayList<Goods>();
        int count = 0;
        for (Goods goods : settlementGoods) {
            if (!goods.getType().isNewWorldGoodsType() || goods.getAmount() <= 0) continue;
            result.add(goods);
            if (++count < limit) continue;
            break;
        }
        return result;
    }

    public void tradeGoodsWithSetlement(IndianSettlement settlement) {
        GoodsType armsType = this.getSpecification().getGoodsType("model.goods.muskets");
        GoodsType horsesType = this.getSpecification().getGoodsType("model.goods.horses");
        ArrayList<GoodsType> goodsToTrade = new ArrayList<GoodsType>();
        goodsToTrade.add(armsType);
        goodsToTrade.add(horsesType);
        for (GoodsType goods : goodsToTrade) {
            int goodsInStock = this.getGoodsCount(goods);
            if (goodsInStock <= 50) continue;
            int goodsTraded = goodsInStock / 2;
            settlement.addGoods(goods, goodsTraded);
            this.removeGoods(goods, goodsTraded);
        }
    }

    public int getMaximumProduction(GoodsType goodsType) {
        int amount = 0;
        for (Tile workTile : this.getTile().getSurroundingTiles(this.getRadius())) {
            if (workTile.getOwningSettlement() != null && workTile.getOwningSettlement() != this) continue;
            amount += workTile.potential(goodsType, null);
        }
        return amount;
    }

    public void updateWantedGoods() {
        ArrayList<GoodsType> goodsTypes = new ArrayList<GoodsType>(this.getSpecification().getGoodsTypeList());
        Collections.sort(goodsTypes, this.wantedGoodsComparator);
        int wantedIndex = 0;
        for (GoodsType goodsType : goodsTypes) {
            if (goodsType.isMilitaryGoods() || !goodsType.isStorable()) continue;
            if (wantedIndex >= this.wantedGoods.length) break;
            this.wantedGoods[wantedIndex] = goodsType;
            ++wantedIndex;
        }
    }

    @Override
    public boolean contains(Locatable locatable) {
        if (locatable instanceof Unit) {
            return this.units.contains(locatable);
        }
        return false;
    }

    @Override
    public boolean canAdd(Locatable locatable) {
        return true;
    }

    @Override
    public int getProductionOf(GoodsType type) {
        int potential = 0;
        int tiles = 1;
        for (Tile workTile : this.getOwnedTiles()) {
            if (workTile == this.getTile() || workTile.isOccupied()) continue;
            potential += workTile.potential(type, null);
            ++tiles;
        }
        if (tiles > this.units.size()) {
            potential = (int)((float)potential * ((float)this.units.size() / (float)tiles));
        }
        return potential += this.getTile().potential(type, null);
    }

    @Override
    public int getSoL() {
        return 0;
    }

    public boolean checkForNewMissionaryConvert() {
        if (this.missionary != null && this.getGame().getViewOwner() == null) {
            int increment = 8;
            if (this.missionary.hasAbility("model.ability.expertMissionary")) {
                increment = 13;
            }
            this.convertProgress += (increment += 2 * this.getAlarm(this.missionary.getOwner()).getValue() / 100);
            if (this.convertProgress >= 100 && this.getUnitCount() > 2) {
                this.convertProgress = 0;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<FreeColGameObject> disposeList() {
        while (this.ownedUnits.size() > 0) {
            this.ownedUnits.remove(0).setIndianSettlement(null);
        }
        ArrayList<FreeColGameObject> objects = new ArrayList<FreeColGameObject>();
        while (this.units.size() > 0) {
            objects.addAll(this.units.remove(0).disposeList());
        }
        objects.addAll(super.disposeList());
        return objects;
    }

    @Override
    public void dispose() {
        this.disposeList();
    }

    public void createGoodsContainer() {
        this.goodsContainer = new GoodsContainer(this.getGame(), this);
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        PlayerExploredTile pet;
        boolean full = this.getGame().isClientTrusted() || showAll || player == this.getOwner();
        PlayerExploredTile playerExploredTile = pet = player == null ? null : this.getTile().getPlayerExploredTile(player);
        if (toSavedGame && !showAll) {
            logger.warning("toSavedGame is true, but showAll is false");
        }
        out.writeStartElement(IndianSettlement.getXMLElementTagName());
        super.writeAttributes(out);
        out.writeAttribute("owner", this.owner.getId());
        if (full) {
            out.writeAttribute("lastTribute", Integer.toString(this.lastTribute));
            out.writeAttribute("convertProgress", Integer.toString(this.convertProgress));
            this.writeAttribute(out, "learnableSkill", this.learnableSkill);
            for (int i = 0; i < this.wantedGoods.length; ++i) {
                String tag = WANTED_GOODS_TAG_NAME + Integer.toString(i);
                out.writeAttribute(tag, this.wantedGoods[i].getId());
            }
        } else if (pet != null) {
            this.writeAttribute(out, "learnableSkill", pet.getSkill());
            GoodsType[] wanted = pet.getWantedGoods();
            int j = 0;
            for (int i = 0; i < wanted.length; ++i) {
                if (wanted[i] == null) continue;
                String tag = WANTED_GOODS_TAG_NAME + Integer.toString(j);
                out.writeAttribute(tag, wanted[i].getId());
                ++j;
            }
        }
        this.goodsContainer.toXML(out, player, showAll, toSavedGame);
        if (full) {
            Iterator<Player> playerIterator = this.spokenTo.iterator();
            while (playerIterator.hasNext()) {
                out.writeStartElement(IS_VISITED_TAG_NAME);
                out.writeAttribute("player", playerIterator.next().getId());
                out.writeEndElement();
            }
            for (Map.Entry<Player, Tension> entry : this.alarm.entrySet()) {
                out.writeStartElement(ALARM_TAG_NAME);
                out.writeAttribute("player", entry.getKey().getId());
                out.writeAttribute("value", String.valueOf(entry.getValue().getValue()));
                out.writeEndElement();
            }
            if (this.missionary != null) {
                out.writeStartElement(MISSIONARY_TAG_NAME);
                this.missionary.toXML(out, player, showAll, toSavedGame);
                out.writeEndElement();
            }
            if (!this.units.isEmpty()) {
                out.writeStartElement(UNITS_TAG_NAME);
                for (Unit unit : this.units) {
                    unit.toXML(out, player, showAll, toSavedGame);
                }
                out.writeEndElement();
            }
            for (Unit unit : this.ownedUnits) {
                out.writeStartElement(OWNED_UNITS_TAG_NAME);
                out.writeAttribute("ID", unit.getId());
                out.writeEndElement();
            }
        } else if (pet != null) {
            if (this.hasSpokenToChief(player)) {
                out.writeStartElement(IS_VISITED_TAG_NAME);
                out.writeAttribute("player", player.getId());
                out.writeEndElement();
            }
            if (this.getAlarm(player) != null) {
                out.writeStartElement(ALARM_TAG_NAME);
                out.writeAttribute("player", player.getId());
                out.writeAttribute("value", String.valueOf(this.getAlarm(player).getValue()));
                out.writeEndElement();
            }
            if (pet.getMissionary() != null) {
                out.writeStartElement(MISSIONARY_TAG_NAME);
                pet.getMissionary().toXML(out, player, showAll, toSavedGame);
                out.writeEndElement();
            }
        }
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.owner.addSettlement(this);
        this.ownedUnits.clear();
        for (int i = 0; i < this.wantedGoods.length; ++i) {
            String tag = WANTED_GOODS_TAG_NAME + Integer.toString(i);
            String wantedGoodsId = this.getAttribute(in, tag, null);
            if (wantedGoodsId == null) continue;
            this.wantedGoods[i] = this.getSpecification().getGoodsType(wantedGoodsId);
        }
        this.convertProgress = this.getAttribute(in, "convertProgress", 0);
        this.lastTribute = this.getAttribute(in, "lastTribute", 0);
        this.learnableSkill = this.getSpecification().getType(in, "learnableSkill", UnitType.class, null);
        this.spokenTo.clear();
        this.alarm = new HashMap<Player, Tension>();
        this.missionary = null;
        this.units.clear();
        this.ownedUnits.clear();
        while (in.nextTag() != 2) {
            if (IS_VISITED_TAG_NAME.equals(in.getLocalName())) {
                Player player = (Player)this.getGame().getFreeColGameObject(in.getAttributeValue(null, "player"));
                this.spokenTo.add(player);
                in.nextTag();
                continue;
            }
            if (ALARM_TAG_NAME.equals(in.getLocalName())) {
                Player player = (Player)this.getGame().getFreeColGameObject(in.getAttributeValue(null, "player"));
                this.alarm.put(player, new Tension(this.getAttribute(in, "value", 0)));
                in.nextTag();
                continue;
            }
            if (WANTED_GOODS_TAG_NAME.equals(in.getLocalName())) {
                String[] wantedGoodsID = this.readFromArrayElement(WANTED_GOODS_TAG_NAME, in, new String[0]);
                for (int i = 0; i < wantedGoodsID.length && i != 3; ++i) {
                    this.wantedGoods[i] = this.getSpecification().getGoodsType(wantedGoodsID[i]);
                }
                continue;
            }
            if (MISSIONARY_TAG_NAME.equals(in.getLocalName())) {
                in.nextTag();
                this.missionary = this.updateFreeColGameObject(in, Unit.class);
                in.nextTag();
                continue;
            }
            if (UNITS_TAG_NAME.equals(in.getLocalName())) {
                this.units = new ArrayList<Unit>();
                while (in.nextTag() != 2) {
                    if (!in.getLocalName().equals(Unit.getXMLElementTagName())) continue;
                    Unit unit = this.updateFreeColGameObject(in, Unit.class);
                    if (unit.getLocation() != this) {
                        logger.warning("fixing unit location");
                        unit.setLocation(this);
                    }
                    this.units.add(unit);
                }
                continue;
            }
            if (OWNED_UNITS_TAG_NAME.equals(in.getLocalName())) {
                Unit unit = this.getFreeColGameObject(in, "ID", Unit.class);
                if (unit.getOwner() != null && unit.getOwner() != this.owner) {
                    logger.warning("Error in savegame: unit " + unit.getId() + " does not belong to settlement " + this.getId());
                } else {
                    this.ownedUnits.add(unit);
                    this.owner.setUnit(unit);
                }
                in.nextTag();
                continue;
            }
            if (!in.getLocalName().equals(GoodsContainer.getXMLElementTagName())) continue;
            this.goodsContainer = (GoodsContainer)this.getGame().getFreeColGameObject(in.getAttributeValue(null, "ID"));
            if (this.goodsContainer != null) {
                this.goodsContainer.readFromXML(in);
                continue;
            }
            this.goodsContainer = new GoodsContainer(this.getGame(), (Location)this, in);
        }
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder(this.getName());
        s.append(" at (").append(this.tile.getX()).append(",").append(this.tile.getY()).append(")");
        return s.toString();
    }

    @Override
    protected void toXMLPartialImpl(XMLStreamWriter out, String[] fields) throws XMLStreamException {
        this.toXMLPartialByClass(out, this.getClass(), fields);
    }

    @Override
    protected void readFromXMLPartialImpl(XMLStreamReader in) throws XMLStreamException {
        this.readFromXMLPartialByClass(in, this.getClass());
    }

    public static String getXMLElementTagName() {
        return "indianSettlement";
    }
}

