/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDecider;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.model.pathfinding.GoalDecider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Map
extends FreeColGameObject {
    private static final Logger logger = Logger.getLogger(Map.class.getName());
    public static final int POLAR_HEIGHT = 2;
    public static final int NUMBER_OF_DIRECTIONS = Direction.values().length;
    public static final int COST_INFINITY = Integer.MIN_VALUE;
    private Tile[][] tiles;
    private Layer layer;
    private final java.util.Map<String, Region> regions = new HashMap<String, Region>();

    public Map(Game game, Tile[][] tiles) {
        super(game);
        this.tiles = tiles;
        this.setLayer(Layer.RESOURCES);
    }

    public Map(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
    }

    public Map(Game game, String id) {
        super(game, id);
    }

    public Collection<Region> getRegions() {
        return this.regions.values();
    }

    public final Layer getLayer() {
        return this.layer;
    }

    public final void setLayer(Layer newLayer) {
        this.layer = newLayer;
    }

    public Region getRegion(String id) {
        return this.regions.get(id);
    }

    public Region getRegionByName(String id) {
        for (Region region : this.regions.values()) {
            if (!id.equals(region.getName())) continue;
            return region;
        }
        return null;
    }

    public void setRegion(Region region) {
        this.regions.put(region.getNameKey(), region);
    }

    public boolean isPolar(Tile tile) {
        return tile.getY() <= 2 || tile.getY() >= this.getHeight() - 2 - 1;
    }

    public List<Tile> getClaimableTiles(Player player, Tile centerTile, int radius) {
        ArrayList<Tile> tiles = new ArrayList<Tile>();
        ArrayList<Tile> layer = new ArrayList<Tile>();
        if (player.canClaimToFoundSettlement(centerTile)) {
            layer.add(centerTile);
            for (int r = 1; r <= radius; ++r) {
                ArrayList lastLayer = new ArrayList(layer);
                tiles.addAll(layer);
                layer.clear();
                for (Tile have : lastLayer) {
                    for (Tile next : have.getSurroundingTiles(1)) {
                        if (tiles.contains(next) || !player.canClaimForSettlement(next)) continue;
                        layer.add(next);
                    }
                }
            }
            tiles.addAll(layer);
        }
        return tiles;
    }

    public PathNode findPath(Unit unit, Tile start, Tile end) {
        if (unit == null) {
            throw new IllegalArgumentException("Unit must not be 'null'.");
        }
        return this.findPath(unit, start, end, null, CostDeciders.defaultFor(unit));
    }

    public PathNode findPath(Unit unit, Tile start, Tile end, Unit carrier) {
        if (unit == null) {
            throw new IllegalArgumentException("Unit must not be 'null'.");
        }
        return this.findPath(unit, start, end, carrier, CostDeciders.defaultFor(unit));
    }

    public PathNode findPath(Unit unit, Tile start, Tile end, Unit carrier, CostDecider costDecider) {
        PathNode firstNode;
        Unit currentUnit;
        if (start == null) {
            throw new IllegalArgumentException("Argument 'start' must not be 'null'.");
        }
        if (end == null) {
            throw new IllegalArgumentException("Argument 'end' must not be 'null'.");
        }
        if (start.equals(end)) {
            throw new IllegalArgumentException("start == end");
        }
        if (unit == null) {
            throw new IllegalArgumentException("Argument 'unit' must not be 'null'.");
        }
        Unit unit2 = currentUnit = carrier != null ? carrier : unit;
        if (currentUnit != null) {
            firstNode = new PathNode(start, 0, start.getDistanceTo(end), Direction.N, currentUnit.getMovesLeft(), 0);
            firstNode.setOnCarrier(carrier != null);
        } else {
            firstNode = new PathNode(start, 0, start.getDistanceTo(end), Direction.N, -1, -1);
        }
        HashMap<String, PathNode> openList = new HashMap<String, PathNode>();
        HashMap<String, PathNode> closedList = new HashMap<String, PathNode>();
        PriorityQueue<PathNode> openListQueue = new PriorityQueue<PathNode>(1024, new Comparator<PathNode>(){

            @Override
            public int compare(PathNode o, PathNode p) {
                return o.getF() - p.getF();
            }
        });
        openList.put(firstNode.getTile().getId(), firstNode);
        openListQueue.offer(firstNode);
        while (!openList.isEmpty()) {
            Tile previousTile;
            PathNode currentNode = openListQueue.poll();
            Tile currentTile = currentNode.getTile();
            openList.remove(currentTile.getId());
            closedList.put(currentTile.getId(), currentNode);
            if (currentTile == end) {
                while (currentNode.previous != null) {
                    currentNode.previous.next = currentNode;
                    currentNode = currentNode.previous;
                }
                return currentNode.next;
            }
            Unit unit3 = currentUnit = currentNode.isOnCarrier() ? carrier : unit;
            if (currentNode.previous != null && !currentUnit.getSimpleMoveType(previousTile = currentNode.previous.getTile(), currentTile, false).isProgress()) continue;
            for (Direction direction : Direction.values()) {
                Unit moveUnit;
                Tile newTile = currentTile.getNeighbourOrNull(direction);
                if (newTile == null || currentNode.previous != null && currentNode.previous.getTile() == newTile || closedList.containsKey(newTile.getId())) continue;
                int cost = currentNode.getCost();
                int movesLeft = currentNode.getMovesLeft();
                int turns = currentNode.getTurns();
                boolean onCarrier = currentNode.isOnCarrier();
                if (carrier != null && onCarrier && newTile.isLand() && (newTile.getSettlement() == null || newTile.getSettlement().getOwner() == currentUnit.getOwner())) {
                    moveUnit = unit;
                    movesLeft = unit.getInitialMovesLeft();
                } else {
                    moveUnit = onCarrier ? carrier : unit;
                }
                int extraCost = costDecider.getCost(moveUnit, currentTile, newTile, movesLeft, turns);
                if (extraCost == -1) {
                    if (newTile != end || !moveUnit.getSimpleMoveType(currentTile, newTile, false).isLegal()) continue;
                    cost += moveUnit.getInitialMovesLeft();
                    movesLeft = 0;
                } else {
                    cost += extraCost;
                    movesLeft = costDecider.getMovesLeft();
                    if (costDecider.isNewTurn()) {
                        ++turns;
                    }
                }
                int f = cost + newTile.getDistanceTo(end);
                PathNode successor = (PathNode)openList.get(newTile.getId());
                if (successor != null) {
                    if (successor.getF() <= f) continue;
                    openList.remove(successor.getTile().getId());
                    openListQueue.remove(successor);
                }
                successor = new PathNode(newTile, cost, f, direction, movesLeft, turns);
                successor.previous = currentNode;
                successor.setOnCarrier(carrier != null && moveUnit == carrier);
                openList.put(newTile.getId(), successor);
                openListQueue.offer(successor);
            }
        }
        return null;
    }

    public PathNode search(Unit unit, GoalDecider gd, int maxTurns) {
        return this.search(unit, unit.getTile(), gd, CostDeciders.defaultFor(unit), maxTurns);
    }

    public PathNode search(Unit unit, Tile startTile, GoalDecider gd, int maxTurns) {
        return this.search(unit, startTile, gd, CostDeciders.defaultFor(unit), maxTurns);
    }

    public PathNode search(Unit unit, GoalDecider gd, int maxTurns, Unit carrier) {
        return this.search(unit, unit.getTile(), gd, CostDeciders.defaultFor(unit), maxTurns, carrier);
    }

    public PathNode search(Tile startTile, GoalDecider gd, CostDecider costDecider, int maxTurns) {
        return this.search(null, startTile, gd, costDecider, maxTurns);
    }

    public PathNode search(Unit unit, Tile startTile, GoalDecider gd, CostDecider costDecider, int maxTurns) {
        return this.search(unit, startTile, gd, costDecider, maxTurns, null);
    }

    public PathNode search(Unit unit, Tile startTile, GoalDecider gd, int maxTurns, Unit carrier) {
        return this.search(unit, startTile, gd, CostDeciders.defaultFor(unit), maxTurns, carrier);
    }

    public PathNode search(Unit unit, Tile startTile, GoalDecider gd, CostDecider costDecider, int maxTurns, Unit carrier) {
        PathNode bestTarget;
        if (startTile == null) {
            throw new IllegalArgumentException("startTile must not be 'null'.");
        }
        Unit currentUnit = carrier != null ? carrier : unit;
        HashMap<String, PathNode> openList = new HashMap<String, PathNode>();
        HashMap<String, PathNode> closedList = new HashMap<String, PathNode>();
        PriorityQueue<PathNode> openListQueue = new PriorityQueue<PathNode>(1024, new Comparator<PathNode>(){

            @Override
            public int compare(PathNode o, PathNode p) {
                return o.getCost() - p.getCost();
            }
        });
        PathNode firstNode = new PathNode(startTile, 0, 0, Direction.N, currentUnit != null ? currentUnit.getMovesLeft() : -1, 0);
        firstNode.setOnCarrier(carrier != null);
        openList.put(startTile.getId(), firstNode);
        openListQueue.offer(firstNode);
        while (!openList.isEmpty()) {
            Tile previousTile;
            PathNode currentNode = openListQueue.poll();
            Tile currentTile = currentNode.getTile();
            openList.remove(currentTile.getId());
            closedList.put(currentTile.getId(), currentNode);
            Unit unit2 = currentUnit = currentNode.isOnCarrier() ? carrier : unit;
            if (gd.check(currentUnit, currentNode) && !gd.hasSubGoals() || currentNode.getTurns() > maxTurns) break;
            if (currentUnit != null && currentNode.previous != null && !currentUnit.getSimpleMoveType(previousTile = currentNode.previous.getTile(), currentTile, false).isProgress()) continue;
            for (Direction direction : Direction.values()) {
                PathNode successor;
                Unit moveUnit;
                Tile newTile = currentTile.getNeighbourOrNull(direction);
                if (newTile == null || currentNode.previous != null && currentNode.previous.getTile() == newTile || closedList.containsKey(newTile.getId())) continue;
                int cost = currentNode.getCost();
                int movesLeft = currentNode.getMovesLeft();
                int turns = currentNode.getTurns();
                boolean onCarrier = currentNode.isOnCarrier();
                if (carrier != null && onCarrier && newTile.isLand() && (newTile.getSettlement() == null || newTile.getSettlement().getOwner() == currentUnit.getOwner())) {
                    moveUnit = unit;
                    movesLeft = moveUnit.getInitialMovesLeft();
                } else {
                    moveUnit = onCarrier ? carrier : unit;
                }
                int extraCost = costDecider.getCost(moveUnit, currentTile, newTile, movesLeft, turns);
                if (extraCost == -1) continue;
                cost += extraCost;
                movesLeft = costDecider.getMovesLeft();
                if (costDecider.isNewTurn()) {
                    ++turns;
                }
                if ((successor = (PathNode)openList.get(newTile.getId())) != null) {
                    if (successor.getCost() <= cost) continue;
                    openList.remove(successor.getTile().getId());
                    openListQueue.remove(successor);
                }
                successor = new PathNode(newTile, cost, cost, direction, movesLeft, turns);
                successor.previous = currentNode;
                successor.setOnCarrier(carrier != null && moveUnit == carrier);
                openList.put(newTile.getId(), successor);
                openListQueue.offer(successor);
            }
        }
        if ((bestTarget = gd.getGoal()) != null) {
            while (bestTarget.previous != null) {
                bestTarget.previous.next = bestTarget;
                bestTarget = bestTarget.previous;
            }
            return bestTarget.next;
        }
        return null;
    }

    public PathNode findPathToEurope(Unit unit, Tile start) {
        return this.findPathToEurope(unit, start, CostDeciders.defaultFor(unit));
    }

    public PathNode findPathToEurope(Unit unit, Tile start, CostDecider costDecider) {
        GoalDecider gd = new GoalDecider(){
            private PathNode goal = null;

            public PathNode getGoal() {
                return this.goal;
            }

            public boolean hasSubGoals() {
                return false;
            }

            public boolean check(Unit u, PathNode pathNode) {
                if (pathNode.getTile().canMoveToEurope()) {
                    this.goal = pathNode;
                    return true;
                }
                if (pathNode.getTile().isAdjacentToVerticalMapEdge()) {
                    this.goal = pathNode;
                    return true;
                }
                return false;
            }
        };
        return this.search(unit, start, gd, costDecider, Integer.MAX_VALUE);
    }

    public PathNode findPathToEurope(Tile start) {
        GoalDecider gd = new GoalDecider(){
            private PathNode goal = null;

            public PathNode getGoal() {
                return this.goal;
            }

            public boolean hasSubGoals() {
                return false;
            }

            public boolean check(Unit u, PathNode pathNode) {
                Tile t = pathNode.getTile();
                if (t.canMoveToEurope()) {
                    this.goal = pathNode;
                    return true;
                }
                if (t.isAdjacentToVerticalMapEdge()) {
                    this.goal = pathNode;
                    return true;
                }
                return false;
            }
        };
        CostDecider cd = new CostDecider(){

            public int getCost(Unit unit, Tile oldTile, Tile newTile, int movesLeft, int turns) {
                if (newTile.isLand()) {
                    return -1;
                }
                return 1;
            }

            public int getMovesLeft() {
                return 0;
            }

            public boolean isNewTurn() {
                return false;
            }
        };
        return this.search(start, gd, cd, Integer.MAX_VALUE);
    }

    public boolean isLandWithinDistance(int x, int y, int distance) {
        CircleIterator i = this.getCircleIterator(new Position(x, y), true, distance);
        while (i.hasNext()) {
            if (!this.getTile((Position)i.next()).isLand()) continue;
            return true;
        }
        return false;
    }

    public Tile getTile(Position p) {
        return this.getTile(p.getX(), p.getY());
    }

    public Tile getTile(int x, int y) {
        if (this.isValid(x, y)) {
            return this.tiles[x][y];
        }
        return null;
    }

    public void setTile(Tile tile, int x, int y) {
        this.tiles[x][y] = tile;
    }

    public int getWidth() {
        if (this.tiles == null) {
            return 0;
        }
        return this.tiles.length;
    }

    public int getHeight() {
        if (this.tiles == null) {
            return 0;
        }
        return this.tiles[0].length;
    }

    public Direction getDirection(Tile t1, Tile t2) {
        for (Direction d : Direction.values()) {
            if (t1.getNeighbourOrNull(d) != t2) continue;
            return d;
        }
        return null;
    }

    public WholeMapIterator getWholeMapIterator() {
        return new WholeMapIterator();
    }

    public Iterator<Position> getAdjacentIterator(Position centerPosition) {
        return new AdjacentIterator(centerPosition);
    }

    public Iterator<Position> getBorderAdjacentIterator(Position centerPosition) {
        return new BorderAdjacentIterator(centerPosition);
    }

    public Iterator<Position> getFloodFillIterator(Position centerPosition) {
        return new CircleIterator(centerPosition, true, Integer.MAX_VALUE);
    }

    public CircleIterator getCircleIterator(Position center, boolean isFilled, int radius) {
        return new CircleIterator(center, isFilled, radius);
    }

    public boolean isValid(Position position) {
        return Map.isValid(position.x, position.y, this.getWidth(), this.getHeight());
    }

    public boolean isValid(int x, int y) {
        return Map.isValid(x, y, this.getWidth(), this.getHeight());
    }

    public static boolean isValid(Position position, int width, int height) {
        return Map.isValid(position.x, position.y, width, height);
    }

    public static boolean isValid(int x, int y, int width, int height) {
        return x >= 0 && x < width && y >= 0 && y < height;
    }

    public Position getRandomLandPosition(Random random) {
        int x = this.getWidth() > 10 ? random.nextInt(this.getWidth() - 10) + 5 : random.nextInt(this.getWidth());
        int y = this.getHeight() > 10 ? random.nextInt(this.getHeight() - 10) + 5 : random.nextInt(this.getHeight());
        Position centerPosition = new Position(x, y);
        Iterator<Position> it = this.getFloodFillIterator(centerPosition);
        while (it.hasNext()) {
            Position p = it.next();
            if (!this.getTile(p).isLand()) continue;
            return p;
        }
        return null;
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        out.writeStartElement(Map.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        out.writeAttribute("width", Integer.toString(this.getWidth()));
        out.writeAttribute("height", Integer.toString(this.getHeight()));
        out.writeAttribute("layer", this.layer.toString());
        for (Region region : this.regions.values()) {
            region.toXML(out);
        }
        for (Tile tile : this.getAllTiles()) {
            if (showAll || player.hasExplored(tile)) {
                tile.toXML(out, player, showAll, toSavedGame);
                continue;
            }
            tile.toXMLMinimal(out);
        }
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "ID"));
        this.setLayer(Layer.valueOf(this.getAttribute(in, "layer", "ALL")));
        if (this.tiles == null) {
            int width = Integer.parseInt(in.getAttributeValue(null, "width"));
            int height = Integer.parseInt(in.getAttributeValue(null, "height"));
            this.tiles = new Tile[width][height];
        }
        while (in.nextTag() != 2) {
            if (in.getLocalName().equals(Tile.getXMLElementTagName())) {
                Tile t = this.updateFreeColGameObject(in, Tile.class);
                this.setTile(t, t.getX(), t.getY());
                continue;
            }
            if (in.getLocalName().equals(Region.getXMLElementTagName())) {
                this.setRegion(this.updateFreeColGameObject(in, Region.class));
                continue;
            }
            logger.warning("Unknown tag: " + in.getLocalName() + " loading map");
            in.nextTag();
        }
    }

    public static String getXMLElementTagName() {
        return "map";
    }

    public Iterable<Tile> getAllTiles() {
        return new Iterable<Tile>(){

            @Override
            public Iterator<Tile> iterator() {
                final WholeMapIterator m = Map.this.getWholeMapIterator();
                return new Iterator<Tile>(){

                    @Override
                    public boolean hasNext() {
                        return m.hasNext();
                    }

                    @Override
                    public Tile next() {
                        return Map.this.getTile(m.next());
                    }

                    @Override
                    public void remove() {
                        m.remove();
                    }
                };
            }
        };
    }

    private final class BorderAdjacentIterator
    extends MapIterator {
        private Position basePosition;
        private int index;

        public BorderAdjacentIterator(Position basePosition) {
            this.basePosition = basePosition;
            this.index = 1;
        }

        public boolean hasNext() {
            for (int i = this.index; i < 8; i += 2) {
                Position newPosition = this.basePosition.getAdjacent(this.directions[i]);
                if (!Map.this.isValid(newPosition)) continue;
                return true;
            }
            return false;
        }

        public Position nextPosition() throws NoSuchElementException {
            for (int i = this.index; i < 8; i += 2) {
                Position newPosition = this.basePosition.getAdjacent(this.directions[i]);
                if (!Map.this.isValid(newPosition)) continue;
                this.index = i + 2;
                return newPosition;
            }
            throw new NoSuchElementException("Iterator exhausted");
        }
    }

    public final class CircleIterator
    extends MapIterator {
        private int radius;
        private int currentRadius;
        private Position nextPosition;
        private int n;

        public CircleIterator(Position center, boolean isFilled, int radius) {
            this.nextPosition = null;
            this.radius = radius;
            if (center == null) {
                throw new IllegalArgumentException("center must not be 'null'.");
            }
            this.n = 0;
            if (isFilled || radius == 1) {
                this.nextPosition = center.getAdjacent(Direction.NE);
                this.currentRadius = 1;
            } else {
                this.currentRadius = radius;
                this.nextPosition = center;
                for (int i = 1; i < radius; ++i) {
                    this.nextPosition = this.nextPosition.getAdjacent(Direction.N);
                }
                this.nextPosition = this.nextPosition.getAdjacent(Direction.NE);
            }
            if (!Map.this.isValid(this.nextPosition)) {
                this.determineNextPosition();
            }
        }

        public int getCurrentRadius() {
            return this.currentRadius;
        }

        private void determineNextPosition() {
            boolean positionReturned = this.n != 0;
            do {
                Direction direction;
                ++this.n;
                int width = this.currentRadius * 2;
                if (this.n >= width * 4) {
                    ++this.currentRadius;
                    if (this.currentRadius > this.radius) {
                        this.nextPosition = null;
                        continue;
                    }
                    if (!positionReturned) {
                        this.nextPosition = null;
                        continue;
                    }
                    this.n = 0;
                    positionReturned = false;
                    this.nextPosition = this.nextPosition.getAdjacent(Direction.NE);
                    continue;
                }
                int i = this.n / width;
                switch (i) {
                    case 0: {
                        direction = Direction.SE;
                        break;
                    }
                    case 1: {
                        direction = Direction.SW;
                        break;
                    }
                    case 2: {
                        direction = Direction.NW;
                        break;
                    }
                    case 3: {
                        direction = Direction.NE;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("i=" + i + ", n=" + this.n + ", width=" + width);
                    }
                }
                this.nextPosition = this.nextPosition.getAdjacent(direction);
            } while (this.nextPosition != null && !Map.this.isValid(this.nextPosition));
        }

        public boolean hasNext() {
            return this.nextPosition != null;
        }

        public Position nextPosition() {
            if (this.nextPosition != null) {
                Position p = this.nextPosition;
                this.determineNextPosition();
                return p;
            }
            return null;
        }
    }

    private final class AdjacentIterator
    extends MapIterator {
        private Position basePosition;
        private int x;

        public AdjacentIterator(Position basePosition) {
            this.x = 0;
            this.basePosition = basePosition;
        }

        public boolean hasNext() {
            for (int i = this.x; i < 8; ++i) {
                Position newPosition = this.basePosition.getAdjacent(this.directions[i]);
                if (!Map.this.isValid(newPosition)) continue;
                return true;
            }
            return false;
        }

        public Position nextPosition() throws NoSuchElementException {
            for (int i = this.x; i < 8; ++i) {
                Position newPosition = this.basePosition.getAdjacent(this.directions[i]);
                if (!Map.this.isValid(newPosition)) continue;
                this.x = i + 1;
                return newPosition;
            }
            throw new NoSuchElementException("Iterator exhausted");
        }
    }

    public final class WholeMapIterator
    extends MapIterator {
        private int x;
        private int y;

        public WholeMapIterator() {
            this.x = 0;
            this.y = 0;
        }

        public boolean hasNext() {
            return this.y < Map.this.getHeight();
        }

        public Position nextPosition() throws NoSuchElementException {
            if (this.y < Map.this.getHeight()) {
                Position newPosition = new Position(this.x, this.y);
                ++this.x;
                if (this.x == Map.this.getWidth()) {
                    this.x = 0;
                    ++this.y;
                }
                return newPosition;
            }
            throw new NoSuchElementException("Iterator exhausted");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class MapIterator
    implements Iterator<Position> {
        protected Direction[] directions = Direction.values();

        private MapIterator() {
        }

        public abstract Position nextPosition() throws NoSuchElementException;

        @Override
        public Position next() {
            return this.nextPosition();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class Position {
        public final int x;
        public final int y;

        public Position(int posX, int posY) {
            this.x = posX;
            this.y = posY;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (!(other instanceof Position)) {
                return false;
            }
            return this.x == ((Position)other).x && this.y == ((Position)other).y;
        }

        public int hashCode() {
            return this.x | this.y << 16;
        }

        public String toString() {
            return "(" + this.x + ", " + this.y + ")";
        }

        public Position getAdjacent(Direction direction) {
            int x = this.x + ((this.y & 1) != 0 ? direction.getOddDX() : direction.getEvenDX());
            int y = this.y + ((this.y & 1) != 0 ? direction.getOddDY() : direction.getEvenDY());
            return new Position(x, y);
        }

        public int getDistance(Position position) {
            int ay = this.getY();
            int by = position.getY();
            int r = position.getX() - this.getX() - (ay - by) / 2;
            if (by > ay && ay % 2 == 0 && by % 2 != 0) {
                ++r;
            } else if (by < ay && ay % 2 != 0 && by % 2 == 0) {
                --r;
            }
            return Math.max(Math.abs(ay - by + r), Math.abs(r));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        N(0, -2, 0, -2),
        NE(1, -1, 0, -1),
        E(1, 0, 1, 0),
        SE(1, 1, 0, 1),
        S(0, 2, 0, 2),
        SW(0, 1, -1, 1),
        W(-1, 0, -1, 0),
        NW(0, -1, -1, -1);

        public static final Direction[] longSides;
        private int oddDX;
        private int oddDY;
        private int evenDX;
        private int evenDY;

        private Direction(int oddDX, int oddDY, int evenDX, int evenDY) {
            this.oddDX = oddDX;
            this.oddDY = oddDY;
            this.evenDX = evenDX;
            this.evenDY = evenDY;
        }

        public int getOddDX() {
            return this.oddDX;
        }

        public int getOddDY() {
            return this.oddDY;
        }

        public int getEvenDX() {
            return this.evenDX;
        }

        public int getEvenDY() {
            return this.evenDY;
        }

        public Direction getNextDirection() {
            return Direction.values()[(this.ordinal() + 1) % 8];
        }

        public Direction getPreviousDirection() {
            return Direction.values()[(this.ordinal() + 7) % 8];
        }

        public Direction getReverseDirection() {
            return Direction.values()[(this.ordinal() + 4) % 8];
        }

        public static Direction getRandomDirection(Random random) {
            return Direction.values()[random.nextInt(NUMBER_OF_DIRECTIONS)];
        }

        public static Direction[] getRandomDirectionArray(Random random) {
            Direction[] directions = Direction.values();
            for (int i = 0; i < directions.length; ++i) {
                int i2 = random.nextInt(NUMBER_OF_DIRECTIONS);
                if (i2 == i) continue;
                Direction temp = directions[i2];
                directions[i2] = directions[i];
                directions[i] = temp;
            }
            return directions;
        }

        static {
            longSides = new Direction[]{NE, SE, SW, NW};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Layer {
        NONE,
        LAND,
        TERRAIN,
        RIVERS,
        RESOURCES,
        NATIVES,
        ALL;

    }
}

