/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.MarketData;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.TransactionListener;
import net.sf.freecol.common.util.Utils;
import org.w3c.dom.Element;

public final class Market
extends FreeColGameObject
implements Ownable {
    public static final int MINIMUM_AMOUNT = 100;
    private final Map<GoodsType, MarketData> marketData = new HashMap<GoodsType, MarketData>();
    private Player owner;
    private ArrayList<TransactionListener> transactionListeners = new ArrayList();

    public Market(Game game, Player player) {
        super(game);
        this.owner = player;
        for (GoodsType goodsType : this.getSpecification().getGoodsTypeList()) {
            if (!goodsType.isStorable()) continue;
            this.marketData.put(goodsType, new MarketData(game, goodsType));
        }
    }

    public Market(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
    }

    public Market(Game game, Element e) {
        super(game, e);
        this.readFromXMLElement(e);
    }

    public Market(Game game, String id) {
        super(game, id);
    }

    private void putMarketData(GoodsType goodsType, MarketData data) {
        this.marketData.put(goodsType, data);
    }

    private MarketData requireMarketData(GoodsType goodsType) {
        MarketData data = this.getMarketData(goodsType);
        if (data == null) {
            data = new MarketData(this.getGame(), goodsType);
            this.putMarketData(goodsType, data);
        }
        return data;
    }

    public void randomizeInitialPrice(Random random) {
        for (GoodsType type : this.getGame().getSpecification().getGoodsTypeList()) {
            int add;
            if (!type.isNewWorldGoodsType() && !type.isNewWorldLuxuryType() || (add = Utils.randomInt(null, null, random, 3)) <= 0) continue;
            this.setInitialPrice(type, add + this.getInitialPrice(type));
        }
    }

    public MarketData getMarketData(GoodsType goodsType) {
        return this.marketData.get(goodsType);
    }

    public Player getOwner() {
        return this.owner;
    }

    public void setOwner(Player owner) {
        this.owner = owner;
    }

    public boolean hasBeenTraded(GoodsType type) {
        MarketData data = this.getMarketData(type);
        return data != null && data.getTraded();
    }

    public int getCostToBuy(GoodsType type) {
        MarketData data = this.getMarketData(type);
        return data == null ? 0 : data.getCostToBuy();
    }

    public int getPaidForSale(GoodsType type) {
        MarketData data = this.getMarketData(type);
        return data == null ? 0 : data.getPaidForSale();
    }

    public void addGoodsToMarket(GoodsType goodsType, int amount) {
        MarketData data = this.requireMarketData(goodsType);
        data.setAmountInMarket(Math.max(100, data.getAmountInMarket() + amount));
        data.setTraded(true);
        data.price();
    }

    public int getInitialPrice(GoodsType goodsType) {
        MarketData data = this.requireMarketData(goodsType);
        return data.getInitialPrice();
    }

    public void setInitialPrice(GoodsType goodsType, int amount) {
        MarketData data = this.requireMarketData(goodsType);
        data.setInitialPrice(amount);
    }

    public int getBidPrice(GoodsType type, int amount) {
        MarketData data = this.getMarketData(type);
        return data == null ? 0 : amount * data.getCostToBuy();
    }

    public int getSalePrice(GoodsType type, int amount) {
        MarketData data = this.getMarketData(type);
        return data == null ? 0 : amount * data.getPaidForSale();
    }

    public int getSalePrice(Goods goods) {
        return this.getSalePrice(goods.getType(), goods.getAmount());
    }

    public int getArrears(GoodsType goodsType) {
        MarketData data = this.getMarketData(goodsType);
        return data == null ? 0 : data.getArrears();
    }

    public void setArrears(GoodsType goodsType, int value) {
        MarketData data = this.requireMarketData(goodsType);
        data.setArrears(value);
    }

    public int getSales(GoodsType goodsType) {
        MarketData data = this.getMarketData(goodsType);
        return data == null ? 0 : data.getSales();
    }

    public void modifySales(GoodsType goodsType, int amount) {
        if (amount != 0) {
            MarketData data = this.requireMarketData(goodsType);
            data.setSales(data.getSales() + amount);
            data.setTraded(true);
        }
    }

    public int getIncomeBeforeTaxes(GoodsType goodsType) {
        MarketData data = this.getMarketData(goodsType);
        return data == null ? 0 : data.getIncomeBeforeTaxes();
    }

    public void modifyIncomeBeforeTaxes(GoodsType goodsType, int amount) {
        MarketData data = this.requireMarketData(goodsType);
        data.setIncomeBeforeTaxes(data.getIncomeBeforeTaxes() + amount);
    }

    public int getIncomeAfterTaxes(GoodsType goodsType) {
        MarketData data = this.getMarketData(goodsType);
        return data == null ? 0 : data.getIncomeAfterTaxes();
    }

    public void modifyIncomeAfterTaxes(GoodsType goodsType, int amount) {
        MarketData data = this.requireMarketData(goodsType);
        data.setIncomeAfterTaxes(data.getIncomeAfterTaxes() + amount);
    }

    public int getAmountInMarket(GoodsType goodsType) {
        MarketData data = this.getMarketData(goodsType);
        return data == null ? 0 : data.getAmountInMarket();
    }

    public boolean hasPriceChanged(GoodsType goodsType) {
        MarketData data = this.getMarketData(goodsType);
        return data != null && data.getOldPrice() != 0 && data.getOldPrice() != data.getCostToBuy();
    }

    public void flushPriceChange(GoodsType goodsType) {
        MarketData data = this.getMarketData(goodsType);
        if (data != null) {
            data.setOldPrice(data.getCostToBuy());
        }
    }

    public ModelMessage makePriceChangeMessage(GoodsType goodsType) {
        int newPrice;
        MarketData data = this.getMarketData(goodsType);
        int oldPrice = data.getOldPrice();
        return oldPrice == (newPrice = data.getCostToBuy()) ? null : new ModelMessage(ModelMessage.MessageType.MARKET_PRICES, newPrice > oldPrice ? "model.market.priceIncrease" : "model.market.priceDecrease", this, goodsType).addStringTemplate("%market%", this.owner.getMarketName()).add("%goods%", goodsType.getNameKey()).addAmount("%buy%", newPrice).addAmount("%sell%", data.getPaidForSale());
    }

    public void addTransactionListener(TransactionListener listener) {
        this.transactionListeners.add(listener);
    }

    public void removeTransactionListener(TransactionListener listener) {
        this.transactionListeners.remove(listener);
    }

    public TransactionListener[] getTransactionListener() {
        return this.transactionListeners.toArray(new TransactionListener[0]);
    }

    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        out.writeStartElement(Market.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        out.writeAttribute("owner", this.owner.getId());
        if (player == this.owner || showAll || toSavedGame) {
            for (MarketData data : this.marketData.values()) {
                data.toXML(out, player, showAll, toSavedGame);
            }
        }
        out.writeEndElement();
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        Game game = this.getGame();
        this.setId(in.getAttributeValue(null, "ID"));
        this.owner = this.getFreeColGameObject(in, "owner", Player.class);
        while (in.nextTag() != 2) {
            if (!in.getLocalName().equals(MarketData.getXMLElementTagName())) continue;
            String id = in.getAttributeValue(null, "ID");
            MarketData data = (MarketData)game.getFreeColGameObject(id);
            if (data == null) {
                data = new MarketData(game, in);
            } else {
                data.readFromXML(in);
            }
            this.putMarketData(data.getGoodsType(), data);
        }
    }

    public static String getXMLElementTagName() {
        return "market";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Access {
        EUROPE,
        CUSTOM_HOUSE;

    }
}

