/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class ChangeStateMessage
extends Message {
    private String unitId;
    private String stateString;

    public ChangeStateMessage(Unit unit, Unit.UnitState state) {
        this.unitId = unit.getId();
        this.stateString = String.valueOf((Object)state);
    }

    public ChangeStateMessage(Game game, Element element) {
        this.unitId = element.getAttribute("unit");
        this.stateString = element.getAttribute("state");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Unit.UnitState state;
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = server.getUnitSafely(this.unitId, serverPlayer);
        }
        catch (Exception e) {
            return Message.clientError(e.getMessage());
        }
        try {
            state = Enum.valueOf(Unit.UnitState.class, this.stateString);
        }
        catch (Exception e) {
            return Message.clientError(e.getMessage());
        }
        if (!unit.checkSetState(state)) {
            return Message.clientError("Unit " + this.unitId + " can not set state: " + this.stateString);
        }
        return server.getInGameController().changeState(serverPlayer, unit, state);
    }

    public Element toXMLElement() {
        Element result = ChangeStateMessage.createNewRootElement(ChangeStateMessage.getXMLElementTagName());
        result.setAttribute("unit", this.unitId);
        result.setAttribute("state", this.stateString);
        return result;
    }

    public static String getXMLElementTagName() {
        return "changeState";
    }
}

