/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class ChangeWorkTypeMessage
extends Message {
    private String unitId;
    private String workTypeId;

    public ChangeWorkTypeMessage(Unit unit, GoodsType workType) {
        this.unitId = unit.getId();
        this.workTypeId = workType.getId();
    }

    public ChangeWorkTypeMessage(Game game, Element element) {
        this.unitId = element.getAttribute("unit");
        this.workTypeId = element.getAttribute("workType");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = server.getUnitSafely(this.unitId, serverPlayer);
        }
        catch (Exception e) {
            return Message.clientError(e.getMessage());
        }
        if (unit.getTile() == null) {
            return Message.clientError("Unit is not on the map: " + this.unitId);
        }
        GoodsType type = server.getSpecification().getGoodsType(this.workTypeId);
        if (type == null) {
            return Message.clientError("Not a goods type: " + this.workTypeId);
        }
        return server.getInGameController().changeWorkType(serverPlayer, unit, type);
    }

    public Element toXMLElement() {
        Element result = ChangeWorkTypeMessage.createNewRootElement(ChangeWorkTypeMessage.getXMLElementTagName());
        result.setAttribute("unit", this.unitId);
        result.setAttribute("workType", this.workTypeId);
        return result;
    }

    public static String getXMLElementTagName() {
        return "changeWorkType";
    }
}

