/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class ClearSpecialityMessage
extends Message {
    private String unitId;

    public ClearSpecialityMessage(Unit unit) {
        this.unitId = unit.getId();
    }

    public ClearSpecialityMessage(Game game, Element element) {
        this.unitId = element.getAttribute("unit");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = server.getUnitSafely(this.unitId, serverPlayer);
        }
        catch (Exception e) {
            return Message.clientError(e.getMessage());
        }
        return server.getInGameController().clearSpeciality(serverPlayer, unit);
    }

    public Element toXMLElement() {
        Element result = ClearSpecialityMessage.createNewRootElement(ClearSpecialityMessage.getXMLElementTagName());
        result.setAttribute("unit", this.unitId);
        return result;
    }

    public static String getXMLElementTagName() {
        return "clearSpeciality";
    }
}

