/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class CloseTransactionMessage
extends Message {
    private String unitId;
    private String settlementId;

    public CloseTransactionMessage(Unit unit, Settlement settlement) {
        this.unitId = unit.getId();
        this.settlementId = settlement.getId();
    }

    public CloseTransactionMessage(Game game, Element element) {
        this.unitId = element.getAttribute("unit");
        this.settlementId = element.getAttribute("settlement");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Settlement settlement;
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = server.getUnitSafely(this.unitId, serverPlayer);
        }
        catch (Exception e) {
            return Message.clientError(e.getMessage());
        }
        try {
            settlement = server.getAdjacentSettlementSafely(this.settlementId, unit);
        }
        catch (Exception e) {
            return Message.clientError(e.getMessage());
        }
        return server.getInGameController().closeTransaction(serverPlayer, unit, settlement);
    }

    public Element toXMLElement() {
        Element result = CloseTransactionMessage.createNewRootElement(CloseTransactionMessage.getXMLElementTagName());
        result.setAttribute("unit", this.unitId);
        result.setAttribute("settlement", this.settlementId);
        return result;
    }

    public static String getXMLElementTagName() {
        return "closeTransaction";
    }
}

