/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class EquipUnitMessage
extends Message {
    private String unitId;
    private String typeId;
    private String amountString;

    public EquipUnitMessage(Unit unit, EquipmentType type, int amount) {
        this.unitId = unit.getId();
        this.typeId = type.getId();
        this.amountString = Integer.toString(amount);
    }

    public EquipUnitMessage(Game game, Element element) {
        this.unitId = element.getAttribute("unit");
        this.typeId = element.getAttribute("type");
        this.amountString = element.getAttribute("amount");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        int amount;
        EquipmentType type;
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        ServerGame game = server.getGame();
        try {
            unit = server.getUnitSafely(this.unitId, serverPlayer);
        }
        catch (Exception e) {
            return Message.clientError(e.getMessage());
        }
        if (!unit.isInEurope()) {
            if (unit.getTile() == null) {
                return Message.clientError("Unit is not on the map: " + this.unitId);
            }
            if (unit.getSettlement() == null) {
                return Message.clientError("Unit is not in a settlement: " + this.unitId);
            }
        }
        if ((type = game.getSpecification().getEquipmentType(this.typeId)) == null) {
            return Message.clientError("Bad equipment type: " + this.typeId);
        }
        try {
            amount = Integer.parseInt(this.amountString);
        }
        catch (NumberFormatException e) {
            return Message.clientError("Bad amount: " + this.amountString);
        }
        if (amount == 0) {
            return Message.clientError("Amount must be non-zero: " + this.amountString);
        }
        if (amount > 0) {
            if (!unit.canBeEquippedWith(type)) {
                return Message.clientError("Unable to equip unit " + this.unitId + " with " + this.typeId);
            }
        } else if (-amount > unit.getEquipmentCount(type)) {
            return Message.clientError("Too much to remove (" + -amount + ") of " + this.typeId + " from unit " + this.unitId);
        }
        return server.getInGameController().equipUnit(serverPlayer, unit, type, amount);
    }

    public Element toXMLElement() {
        Element result = EquipUnitMessage.createNewRootElement(EquipUnitMessage.getXMLElementTagName());
        result.setAttribute("unit", this.unitId);
        result.setAttribute("type", this.typeId);
        result.setAttribute("amount", this.amountString);
        return result;
    }

    public static String getXMLElementTagName() {
        return "equipUnit";
    }
}

