/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class InciteMessage
extends Message {
    private String unitId;
    private String directionString;
    private String enemyId;
    private String goldString;

    public InciteMessage(Unit unit, Map.Direction direction, Player enemy, int gold) {
        this.unitId = unit.getId();
        this.directionString = String.valueOf((Object)direction);
        this.enemyId = enemy.getId();
        this.goldString = Integer.toString(gold);
    }

    public InciteMessage(Game game, Element element) {
        this.unitId = element.getAttribute("unitId");
        this.directionString = element.getAttribute("direction");
        this.enemyId = element.getAttribute("enemyId");
        this.goldString = element.getAttribute("gold");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        int gold;
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        ServerGame game = server.getGame();
        try {
            unit = server.getUnitSafely(this.unitId, serverPlayer);
        }
        catch (Exception e) {
            return Message.clientError(e.getMessage());
        }
        if (unit.getTile() == null) {
            return Message.clientError("Unit is not on the map: " + this.unitId);
        }
        Map.Direction direction = Enum.valueOf(Map.Direction.class, this.directionString);
        Tile tile = unit.getTile().getNeighbourOrNull(direction);
        if (tile == null) {
            return Message.clientError("Could not find tile in direction: " + (Object)((Object)direction) + " from unit: " + this.unitId);
        }
        IndianSettlement is = tile.getIndianSettlement();
        if (is == null) {
            return Message.clientError("There is no native settlement at: " + tile.getId());
        }
        if (this.enemyId == null || this.enemyId.length() == 0) {
            return Message.clientError("Empty enemyId.");
        }
        if (!(game.getFreeColGameObjectSafely(this.enemyId) instanceof Player)) {
            return Message.clientError("Not a player: " + this.enemyId);
        }
        Player enemy = (Player)game.getFreeColGameObjectSafely(this.enemyId);
        if (enemy == player) {
            return Message.clientError("Inciting against oneself!");
        }
        if (!enemy.isEuropean()) {
            return Message.clientError("Inciting against non-European!");
        }
        Unit.MoveType type = unit.getMoveType(is.getTile());
        if (type != Unit.MoveType.ENTER_INDIAN_SETTLEMENT_WITH_MISSIONARY) {
            return Message.clientError("Unable to enter " + is.getName() + ": " + type.whyIllegal());
        }
        try {
            gold = Integer.parseInt(this.goldString);
        }
        catch (NumberFormatException e) {
            return Message.clientError("Bad gold: " + this.goldString);
        }
        return server.getInGameController().incite(serverPlayer, unit, is, enemy, gold);
    }

    public Element toXMLElement() {
        Element result = InciteMessage.createNewRootElement(InciteMessage.getXMLElementTagName());
        result.setAttribute("unitId", this.unitId);
        result.setAttribute("direction", this.directionString);
        result.setAttribute("enemyId", this.enemyId);
        result.setAttribute("gold", this.goldString);
        return result;
    }

    public static String getXMLElementTagName() {
        return "incite";
    }
}

