/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class LearnSkillMessage
extends Message {
    private String unitId;
    private String directionString;

    public LearnSkillMessage(Unit unit, Map.Direction direction) {
        this.unitId = unit.getId();
        this.directionString = String.valueOf((Object)direction);
    }

    public LearnSkillMessage(Game game, Element element) {
        this.unitId = element.getAttribute("unitId");
        this.directionString = element.getAttribute("direction");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = server.getUnitSafely(this.unitId, serverPlayer);
        }
        catch (Exception e) {
            return Message.clientError(e.getMessage());
        }
        if (unit.getTile() == null) {
            return Message.clientError("Unit is not on the map: " + this.unitId);
        }
        Map.Direction direction = Enum.valueOf(Map.Direction.class, this.directionString);
        Tile tile = unit.getTile().getNeighbourOrNull(direction);
        if (tile == null) {
            return Message.clientError("Could not find tile in direction: " + (Object)((Object)direction) + " from unit: " + this.unitId);
        }
        IndianSettlement is = tile.getIndianSettlement();
        if (is == null) {
            return Message.clientError("There is no native settlement at: " + tile.getId());
        }
        Unit.MoveType type = unit.getSimpleMoveType(is.getTile());
        if (type != Unit.MoveType.ENTER_INDIAN_SETTLEMENT_WITH_FREE_COLONIST) {
            return Message.clientError("Unable to enter " + is.getName() + ": " + type.whyIllegal());
        }
        return server.getInGameController().learnFromIndianSettlement(serverPlayer, unit, is);
    }

    public Element toXMLElement() {
        Element result = LearnSkillMessage.createNewRootElement(LearnSkillMessage.getXMLElementTagName());
        result.setAttribute("unitId", this.unitId);
        result.setAttribute("direction", this.directionString);
        return result;
    }

    public static String getXMLElementTagName() {
        return "learnSkill";
    }
}

