/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class MoveMessage
extends Message {
    private String unitId;
    private String directionString;

    public MoveMessage(Unit unit, Map.Direction direction) {
        this.unitId = unit.getId();
        this.directionString = String.valueOf((Object)direction);
    }

    public MoveMessage(Game game, Element element) {
        this.unitId = element.getAttribute("unit");
        this.directionString = element.getAttribute("direction");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = server.getUnitSafely(this.unitId, serverPlayer);
        }
        catch (Exception e) {
            return Message.clientError(e.getMessage());
        }
        Tile oldTile = unit.getTile();
        if (oldTile == null) {
            return Message.clientError("Unit is not on the map: " + this.unitId);
        }
        Location oldLocation = unit.getLocation();
        Map.Direction direction = Enum.valueOf(Map.Direction.class, this.directionString);
        Tile newTile = oldTile.getNeighbourOrNull(direction);
        if (newTile == null) {
            return Message.clientError("Could not find tile in direction: " + (Object)((Object)direction) + " from unit: " + this.unitId);
        }
        Unit.MoveType moveType = unit.getMoveType(direction);
        if (!moveType.isProgress()) {
            return Message.clientError("Illegal move for: " + this.unitId + " type: " + (Object)((Object)moveType) + " from: " + oldLocation.getId() + " to: " + newTile.getId());
        }
        return server.getInGameController().move(serverPlayer, unit, newTile);
    }

    public Element toXMLElement() {
        Element result = MoveMessage.createNewRootElement(MoveMessage.getXMLElementTagName());
        result.setAttribute("unit", this.unitId);
        result.setAttribute("direction", this.directionString);
        return result;
    }

    public static String getXMLElementTagName() {
        return "move";
    }
}

