/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class NewLandNameMessage
extends Message {
    private String newLandName;
    private String welcomerId;
    private String acceptString;

    public NewLandNameMessage(String newLandName, Player welcomer, boolean accept) {
        this.newLandName = newLandName;
        this.welcomerId = welcomer == null ? null : welcomer.getId();
        this.acceptString = Boolean.toString(accept);
    }

    public NewLandNameMessage(Game game, Element element) {
        this.newLandName = element.getAttribute("newLandName");
        this.welcomerId = element.hasAttribute("welcomer") ? element.getAttribute("welcomer") : null;
        this.acceptString = element.getAttribute("accept");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        ServerGame game = server.getGame();
        ServerPlayer serverPlayer = server.getPlayer(connection);
        if (this.newLandName == null || this.newLandName.length() == 0) {
            return Message.clientError("Empty new land name");
        }
        ServerPlayer welcomer = null;
        boolean accept = false;
        if (this.welcomerId != null) {
            if (game.getFreeColGameObjectSafely(this.welcomerId) instanceof ServerPlayer) {
                welcomer = (ServerPlayer)game.getFreeColGameObjectSafely(this.welcomerId);
                accept = Boolean.valueOf(this.acceptString);
            } else {
                return Message.clientError("Not a player: " + this.welcomerId);
            }
        }
        return server.getInGameController().setNewLandName(serverPlayer, this.newLandName, welcomer, accept);
    }

    public Element toXMLElement() {
        Element result = NewLandNameMessage.createNewRootElement(NewLandNameMessage.getXMLElementTagName());
        result.setAttribute("newLandName", this.newLandName);
        if (this.welcomerId != null) {
            result.setAttribute("welcomer", this.welcomerId);
        }
        result.setAttribute("accept", this.acceptString);
        return result;
    }

    public static String getXMLElementTagName() {
        return "newLandName";
    }
}

